h27919
s 00116/00000/00000
d D 1.1 82/10/06 14:29:02 jan 1 0
e
u
U
t
T
I 1
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include "../../includes/getdef.h"
#include <sys/stat.h>


/*
Name:
	PARSE subroutine

Function:
	Accepts up to 3 parameters and parses them for list file name,
	date, and authorized user name. Return pointers to the standardized
	date, the full list file path-name, and a passwd structure for the
	specified user. Returns NULL for non-specified parameters.

Algorithm:
	For each parameter passed up to argv[argc] do the following:
	Check for a valid date and set pointer if found. Check for a
	valid user id and set the user passwd struct pointer if found.
	Check for a list file name  in the exec support directory of
	either the  authorized user or the current user. Take into account
	exec/suspenses and exec/dolist directories for list files.

	Calling sequence:

		parse(argc, argv, envp, &date, &user, &file)
		int argc;
		char *argv[], **envp, *date, *file;
		struct passwd *user;

Parameters:
	user specified list file name (no prefix path name)
	date
	authorized user id

Returns:
	parsed parameters

Files and Programs:
	user specified list file        place to store new items

Installation Instructions:
	Compile:  cc -c $EXECDIR/subroutines/parse parse.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Aug 82, Release 7  Version 2, J. Neyer...original version


*/
parse (argc, argv, envp, date, user, file)
int argc;
char *argv[], **envp;
int *date, *user, *file;
{

    static char id[] = "%W% %H%";
    static char date_buf[10];
    char *date_ptr = date_buf;
    static char temp_buf[128];
    char *temp = temp_buf;
    struct passwd *pw;
    struct stat *stat_buf;
    int sure = 0;
    int index, file_index;
    register char *p1, *p2;

    *file = *user = *date = 0;
    for (index = 1; index < argc; index++)      {
	if (!*date && valid_date(argv[index], date_ptr,0))  {   /* Is it the date? */
	    *date = date_ptr;
	    continue;
	}
	if (!*user && (pw = getpwnam(argv[index])) != NULL)  {   /* User? */
	    *user = pw;                            /* Yes */
	    if (!*file)
		continue;
	}
	if (!*file || !sure)     {
	    if (!*user)         {
		p1 = argv[index];                   /* Get just the possible file basename */
		strcpy (temp, findenv("HOME", envp));
	    }
	    else        {
		strcpy (temp, pw->pw_dir);
		if (*file)
		    p1 = argv[file_index];
		else
		    p1 = argv[index];
	    }
	    strcat (temp, "/exec/");
	    p2 = p1;
	    while (*p1) {
		    if (*p1++ == '/')
			    p2 = p1;
	    }
	    if (!strncmp (p2, "sus.", 4))
		strcat(temp, "suspenses/");
	    else
		strcat(temp, "dolist/");
	    strcat(temp, p2);
	    if((stat(temp, stat_buf)) != -1)    {
		if (*user)
		   sure++;
		*file = temp;
		file_index = index;
	    }
	}
    }
    if (*user && !sure)
	*file = 0;
    return;
}
E 1
