/*

Name:
	month_day

Function:
	Given a two digit year and the relative day in the year, month_day should
	determine the numeric value of the month (1-12) and the certain day within
	the month.

Algorithm:
	Checking whether the year is a leap year or not, keep subtracting the number
of days in a whole month starting from January, keeping a counter as to the number
of months skipped, until an incompleted month is encountered.  This value will be the
certain day of the month, where the above counter will be the actual month value.

Parameters:
	1) An integer representing the year.
	2) An integer representing the relative day in the year (1-366).

Returns:
	An integer pointer to a two element array, the first cell containing the
month value, the second containing the day value.

Files and Programs:
	None.

*/


static int      day_tab[2][13] =
{
	{
		0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
	},
	{
		0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
	}
};

int *month_day (year, yearday)
int     year,
        yearday;
{
	static char id[] = "%W% %H%";
	int     i,
	        leap;
	static int      monthday[2];
	leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
	for (i = 1; yearday > day_tab[leap][i]; i++)
		yearday - = day_tab[leap][i];
	monthday[0] = i;
	monthday[1] = yearday;
	return (&monthday);
}
