/*

Name:
	dolist_call

Function:
	Call dolist to sort and display new list file.

Algorithm:
	Set up "system" call to execute dolist.

Parameters:
	list file name pointer
	user id

Returns:
	ENOERR	Normal exit

Files and Programs:
	list file                 place to store list items


*/
#include "../../includes/getdef.h"
#include <stdio.h>
#include "../../includes/error.h"
#include <pwd.h>


dolist_call(file, user)
char *file;
char *user;
{
	static char id[] = "%W% %H%";
	char cmd_buf[CMDLEN],
	    *cmd = cmd_buf;                      /* Holds command for shell */

	strcpy (cmd, "$EXECDIR/dolist ");
	strcat (cmd, file);
	strcat (cmd, " ");
	strcat (cmd, user);
	if ((system(cmd_buf)) != 0)             {                /* Call dolist */
	    fprintf (stderr, "dolist_call: error on system call\n");
	    exit (ESYSTEM);
	}
	return;
}
