/*
 *	vpr
 *	Variable Information Retrieval
 *	State Hygiene Laboratory pseudo database system
 *	index printer - for diagnostic use
 *	by David E. Miran
 *	3/4/82
 */

#include	<stdio.h>
#include	<myio.h>
#include	<time.h>
#include	"vir.h"
#include	"virfiles.h"


int	hfid, pfid, p1fid, p2fid, nfid, n1fid, n2fid, sfid, s1fid, s2fid, dfid, fmtfid;


extern char mget();
extern long tell(), atol(), lseek();
extern char *ctime();


struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - XFILE */
struct	fmt_def fmtdef[MAXFMT];
struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
struct	fdef	fld[MAXFLD];	/* the format field descriptors */
struct	pat_ent	prec;		/* one record from PFILE */
struct	num_ent	nrec;		/* one record from NFILE */
struct	sp_ent	srec;		/* one record from SFILE */
struct fbuf ibuf;	/* miscellanous myio buffer */

char	*fname[]	{
	"-h", "-f", "-fm", "-fld", "-p", "-p1", "-p2",
	"-n", "-n1", "-n2", "-s", "-s1", "-s2",
	0};
extern 	prh(), prf(), prfm(), prp(), prn(), prs(), prfld();
extern  prp1(), prp2(), prn1(), prn2(), prs1(), prs2();
int func[] {
	&prh, &prf, &prfm, &prfld, &prp, &prp1, &prp2,
	&prn, &prn1, &prn2, &prs, &prs1, &prs2,
	0};

char	*motabl[]  {
	"UNKNOWN","CURRENT","NOT CUR","UNKNOWN","HOLES","UNKNOWN",0
		};

long	noff,offset;
long l;

main(argc, argv)
int argc;
char **argv;
{
	register int i, j;
	register char c;

	if ((hfid = open(hfile, 0)) < 0) nofile(hfile);
	if ((pfid = open(pfile, 0)) < 0) nofile(pfile);
	if ((p1fid = open(p1, 0)) < 0) nofile(p1);
	if ((p2fid = open(p2, 0)) < 0) nofile(p2);
	if ((nfid = open(nfile, 0)) < 0) nofile(nfile);
	if ((n1fid = open(n1, 0)) < 0) nofile(n1);
	if ((n2fid = open(n2, 0)) < 0) nofile(n2);
	if ((sfid = open(sfile, 0)) < 0) nofile(sfile);
	if ((s1fid = open(s1, 0)) < 0) nofile(s1);
	if ((s2fid = open(s2, 0)) < 0) nofile(s2);
	if ((fmtfid = open(fmtfile, 0)) < 0) nofile(fmtfile);

	read(hfid, &hrec, sizeof hrec);
	read(hfid, &fmtdef[0], MAXFMT * sizeof (struct fmt_def));
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	read(fmtfid, &fmtinf[0], hrec.numfmt * sizeof (struct fmt_inf));
	read(fmtfid, &fld[0], hrec.nfmtfld*sizeof (struct fdef));
	close(hfid);
	close(fmtfid);
	while (--argc) {
		argv++;
		noff = 0L;
		if (argc > 0) noff = atol(argv[1]);
		if (noff) printf("OFFSET %D\n",noff);
		for (i=0; i<1000; i++) {
			if (fname[i] == 0) break;
			if (strcmp(*argv, fname[i]) == 0) {
				disp(func[i]);
				break;
			}
		}
	}
}

disp(f)
int (*f)();
{
	(*f)();
}

prh()
{
	printf("\nVir Header record\n");
	printf("Index last rebuilt at %s",ctime(&hrec.lastup));
	printf("Files last modified at %s",ctime(&hrec.lastmod));
	printf("Formats last analyzed at %s",ctime(&hrec.fmtime));
	printf("p,n,smaxseq = %D  %D  %D\n",hrec.pmaxseq,hrec.nmaxseq,hrec.smaxseq);
	printf("Highest file number = %u,  Number of files = %d,  Number of formats = %d\n",
		hrec.maxfile,hrec.numfile,hrec.numfmt);
	printf("Highest Patient Number = %D, Number of format fields used = %d\n",hrec.maxpnum,hrec.nfmtfld);
	printf("Highest pnumyr = %D  pnum in yr = %D\n",hrec.pnumyr, hrec.pnumbas);
	printf("autopn = %d, modata = %d, compnum = %d, fldsep = %c, recsep = %c\n",
		hrec.autopn, hrec.modata, hrec.compnum, hrec.fldsep, hrec.recsep);
	printf("intnum = %d, nonspec = %d\n",hrec.intnum,hrec.nonspec);
}
prf()
{
	register int i;
	printf("\nACTIVE FILES\n");
	printf("File number  Format number  File Mode  File Name\n");
	for (i=0; i<hrec.numfile; i++) {
		printf("%11d  %13d  %-11.11s%s\n",filent[i].f_num,filent[i].fmt_cd+1,
			motabl[filent[i].f_mode],filent[i].f_name);
	}
}
prfm()
{
/* information on formats */
register int i;

	printf("\nFORMATS and current associated files\n");
	printf("format name     number  current file    file #  st.fld end.fld num.fld num.chr pnum.fld pnum.yr pnam.fld modes\n");
	for (i=0; i<hrec.numfmt; i++) {
		printf("%-16.16s%6d  %-16.16s%6d%8d%8d%8d%8d%9d%8d%9d    %o\n",
		fmtdef[i].fmt_name,fmtdef[i].fmt_num+1,fmtdef[i].fmt_app,fmtdef[i].fil_num,fmtinf[i].st_fld,
		fmtinf[i].end_fld,fmtinf[i].num_fld,fmtinf[i].num_chr,fmtinf[i].fld_pn,fmtinf[i].fld_pny,fmtinf[i].fld_nam,fmtinf[i].fmt_mod);
	}
}
prfld()
{
/* print information of format fields */
register int i, j;

	i=0;
	if (noff > 0L) i = noff;
	printf("\nFIELD DESCRIPTORS\n");
	printf("fld.num char.pos  size  auto  modes\n");
	for (; i<hrec.nfmtfld; i++) {
		printf("%7d %8d%7d%6d ",i,fld[i].f_pos,fld[i].f_size,fld[i].f_anum);
		j = fld[i].f_flags;
		if (j & LCASE) printf(" LCASE");
		if (j & NUMERIC) printf(" NUM");
		if (j & ALPHA) printf(" ALPHA");
		if (j & REQUIRED) printf(" REQ");
		if (j & DATE) printf(" DATE");
		if (j & LABNUM) printf(" LABNUM");
		if (j & PNAME) printf(" PNAME");
		if (j & DNAME) printf(" DNAME");
		if (j & CITY) printf(" CITY");
		if (j & RANGE) printf(" RANGE");
		if (j & AUTO) printf(" AUTO");
		if (j & SOURCE) printf(" SRC");
		if (j & SPECIMEN) printf(" SPEC");
		if (j & PNUM) printf(" PNUM");
		if (j & PNUMYR) printf(" PNUMYR");
		printf("\n");
	}
}

/* prp, prp1, prp2 - print patient name vs number entries */
prp()
{
	if (noff > 0) {
		offset = noff * sizeof (struct pat_ent);
		lseek(pfid, offset, 0);
	}  else  {
		lseek(pfid, 0L, 0);
	}
	mfinit(&ibuf, pfid);
	printf("\nPatient Name File - PFILE\n");
	printf("patient number    name\n");
	while(mgetrec(&prec, sizeof prec, &ibuf)) {
		printf("%10D  %-14.14s\n",prec.p_num, prec.p_name);
	}
}
prp1()
{
char	pnr[16];
	if (noff > 0) {
		offset = noff * 16L;
		lseek(p1fid, offset, 0);
	}  else  {
		lseek(p1fid, 0L, 0);
	}
	mfinit(&ibuf, p1fid);
	printf("\nPatient Name File - Concentrate 1 - P1\n");
	printf("Patient name\n");
	while(mgetrec(pnr, 16, &ibuf)) {
		printf("%-14.14s\n",pnr);
	}
}
prp2()
{
char	pnr[16];
	if (noff > 0) {
		offset = noff * 16L;
		lseek(p2fid, offset, 0);
	}  else  {
		lseek(p2fid, 0L, 0);
	}
	mfinit(&ibuf, p2fid);
	printf("\nPatient Name File - Concentrate 2 - P2\n");
	printf("Patient name\n");
	while(mgetrec(pnr, 16, &ibuf)) {
		printf("%-14.14s\n",pnr);
	}
}

/* prn, prn1, prn2 - print patient number vs record entries */
prn()
{
register unsigned i;
register int j;
	if (noff > 0) {
		offset = noff * sizeof (struct num_ent);
		lseek(nfid, offset, 0);
	}  else  {
		lseek(nfid, 0L, 0);
	}
	mfinit(&ibuf, nfid);
	printf("\nPatient Number vs Record File - NFILE\n");
	printf("Patient number  file number  file offset   file name\n");
	while(mgetrec(&nrec, sizeof nrec, &ibuf)) {
		i = nrec.nf_num;
		j = lookupn(i);
		printf("%10D      %11u %13D   %s\n",nrec.np_num,i,nrec.f_loc, filent[j].f_name);
	}
}
prn1()
{
	if (noff > 0) {
		offset = noff * 4;  /* sizeof long */
		lseek(n1fid, offset, 0);
	}  else  {
		lseek(n1fid, 0L, 0);
	}
	mfinit(&ibuf, n1fid);
	printf("\nPatient Number vs Record File - Concentrate 1 - N1\n");
	while(mgetrec(&l, 4, &ibuf)) {
		printf("%10D\n",l);
	}
}
prn2()
{
	if (noff > 0) {
		offset = noff * 4;  /* sizeof long */
		lseek(n2fid, offset, 0);
	}  else  {
		lseek(n2fid, 0L, 0);
	}
	mfinit(&ibuf, n2fid);
	printf("\nPatient Number vs Record File - Concentrate 2 - N2\n");
	while(mgetrec(&l, 4, &ibuf)) {
		printf("%10D\n",l);
	}
}

/* prs, prs1, prs2 - print specimen number vs patient number and record files */
prs()
{
register unsigned i;
register int j;
	if (noff > 0) {
		offset = noff * sizeof (struct sp_ent);
		lseek(sfid, offset, 0);
	}  else  {
		lseek(sfid, 0L, 0);
	}
	mfinit(&ibuf, sfid);
	printf("\nSpecimen Number vs Record File - SFILE\n");
	printf("Patient number  spec number  file number  file offset   file name\n");
	while(mgetrec(&srec, sizeof srec, &ibuf)) {
		i = srec.sf_num;
		j = lookupn(i);
		printf("%10D     %11D  %12u %11D   %s\n",
		srec.xp_num, srec.sp_num,i,srec.sf_loc, filent[j].f_name);
	}
}
prs1()
{
	if (noff > 0) {
		offset = noff * 4;  /* sizeof long */
		lseek(s1fid, offset, 0);
	}  else  {
		lseek(s1fid, 0L, 0);
	}
	mfinit(&ibuf, s1fid);
	printf("\nSpecimen Number vs Record File - Concentrate 1 - S1\n");
	while(mgetrec(&l, 4, &ibuf)) {
		printf("%10D\n",l);
	}
}
prs2()
{
	if (noff > 0) {
		offset = noff * 4;  /* sizeof long */
		lseek(s2fid, offset, 0);
	}  else  {
		lseek(s2fid, 0L, 0);
	}
	mfinit(&ibuf, s2fid);
	printf("\nSpecimen Number vs Record File - Concentrate 2 - S2\n");
	while(mgetrec(&l, 4, &ibuf)) {
		printf("%10D\n",l);
	}
}

/*******************************  ncpy  ************************************/
/* copy exactly n characters */
ncpy(to, from, n)
char *to, *from;
int n;
{
	while (n--) *to++ = *from++;
}

/*******************************  nofile   **********************************/

nofile(fn)
char *fn;
{
	printf("vpr: cannot open %s\n",fn);
	exit(1);
}
lookupn(fnum)
unsigned fnum;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (fnum == filent[i].f_num) return(i);
	return(-1);
}
