/* ldform
 * load a format onto a crt screen
 *
 * by David E. Miran, Wisconsin State Hygiene Lab
 * 3/30/83
 */

#include	"vmyio.h"
#include	"vir.h"
/* character sequences for controlling crt terminals

 * form of this collection of items is as follows:
	x - a character pointer which can be pointed at the right string.
	x_l - a variable which can be set to the length of the string.

*/

/* the following sequences are:
	the char pointer variable
	the char count variable
	the character strings for sb2, try, et2, concept 108 terminals
	the corresponding counts
 */

char	*init;			/* init setup of a format */
int	init_l;
char	*initx[]	{
		0,
		"\033E\0\0\0",	/* clear screen - ESC E */
		"\014\0\0\033RP",	/* clear screen, protect mode*/
		"\033\020\0\0\0\033\016\0\0\0\033\01", /* clear, inv scrn, inv char */
		"\033U\033?\014\033I",
			/* prog,home,clr,protect */
		0 };
int	initlx[]  {0,5,6,12,7,0};

char	*strt;			/* start of data field */
int	strt_l;
char	*strtx[]	{
		0,
		"\033_1[\033[",
		" \033RD",
		" [\033\01",
		" [\033D\033i",
		0};
int	strtlx[]	{0, 6, 4, 4, 6, 0};

char	*endf;			/* end of data field */
int	endf_l;
char	*endfx[]	{
		0,
		"\033]]\033_3",
		"\033RP ",
		"\033\01] ",
		"\033I\033d] ",
		0};
int	endflx[]	{0, 6, 4, 4, 6, 0};

char	*fin;			/* end of format loading */
int	fin_l;
char	*finx[]		{
		0,
		"\033W\0\0\033E\0\0\0",
		"\033RP\033W\014",
		"\033\01\033\027\033\020",
		"\033F\033&\033i\033D\033?\033\003\033u\t",
			/* forms,block,prot off,rev vid,home,clrall,user mode */
		0};
int	finlx[]		{0,9,6,6,15,0};

char	*eol;			/* processing at end of format line */
int	eol_l;
char	*eolx[]		{
		0,
		0,
		"\033RP",	/* on try must reset protect */
		0,
		0,
		0 };
int	eollx[]		{ 0,0,3,0,0,0};
/* no end of line processing for other terminals */

char	*cls;			/* clear screen */
int	cls_l;
char	*clsx[]	{
		0,
		"\033E\0\0\0",
		"\014\0\0\0",
		"\033\020\0\0\0",
		"\033?\033\003\t",
		0};
int	clslx[]		{0, 5, 4, 5, 5, 0};
char	*ccls	"\033?\033\003";
int	cclsl	4;

char	*fmto;			/* format off and clear - when all done */
int	fmto_l;
char	*fmtox[]	{
		0,
		"\033X\0\0\033E\0\0\0",
		"\033X\014\0\0\0",
		"\033\027\033\016\0\0\0",
		"\033U\033d\033f\033s\033?\014\033u",
			/* prog,rev vid off,text,scroll,home,clrall,usr */
		0};
int	fmtolx[]	{ 0, 9, 6, 7, 13, 0};

char	*nrec;		/* set up for next record */
int	nrec_l	0;
char	*nrecx[]	{
		0,
		"\033H\033k",	/* go off-line */
		"\033H",
		"\033H",
		"\033?\t",	/* home */
		0};
int	nreclx[]	{0, 4, 2, 2, 3, 0};
char	*cnrec	"\033?";
int	cnrecl	2;

char	*ok;		/* char string to initiate page transmit */
int	ok_l;
char	*okx[]	{
		0,
		"\027",	/* ctrl w */
		"\033Z",	/* esc Z */
		"\033\025",	/* esc ctrl u */
		"\033\004",
		0};
int	oklx[]	{0, 1, 2, 2, 2, 0};

/* char string to initiate a transmit line function */
char	*rdln;
int	rdln_l	0;
char	*rdlnx[]	{
		0,
		0,
		0,
		"\033\032",
		0,
		0};
int	rdlnlx[]	{0, 0, 0, 2, 0, 0};


char	eor;		/* end of record character */
char	eorx[]	{ '\012', ETX, ETX, '\015', ETX, '\0'};
int	warn	1;	/* set if warning about block mode needed */
int	warnx[]	{0, 0, 1, 1, 0, 0};
int	termtype	0;	/* set to terminal type 1=sb2, 2=telry, 3= et2 , 4=concept108 */
int	scrwid		80;	/* screen width */
char	inrdy	ETX;		/* char to wait for which signals page ready */
char	inrdyx[]	{ '\n', '\021', ETX, '\015', ETX, '\0'};
int	lnmode	0;	/* single line availability - 0=not avail, 1= rdln to get, 2=given with transmit request (teleray) */
int	lnmodex[]	{0, 0, 2, 1, 2, 0};
int	dlymode	2;	/* style of output delay
			 * 0= none, 1=sb2 (alternate null and char in raw mode
			 * 2=buffered - timing delay every 20 chars */
int	dlymdx[]	{ 0, 1, 2, 2, 0, 0};

/* block mode for concept 108 */
char	*blkof	"\0\0\0\0\033U\0337\0\0\0\033f\0\0\0\033u\033\003\0\0\0\0\0\0\0\0\0\0";	/* char mode, text mode, clr */
int	blkof_l 30;
char	*blkon	"\0\0\033U\0\0\033&\0\0\033F\0\0\033u\0\0";	/* block mode, forms mode */
int	blkon_l	18;

extern struct	fdef	fld[MAXFLD];	/* the format field descriptors */

ldform(fid, fldloc)
int fid, fldloc;
{
register char ch, nch;
register int i;
int lnum, fnum, curpos, lpos;
int flpos;
struct fbuf ffin, fout;

	flpos = fldloc;
	mfinit(&ffin,fid);
	mfinit(&fout, 1);
	lpos = lnum = curpos = 0;
	fnum = -1;
	mputrec(init, init_l, &fout);
	mflush(&fout);
	if (eol_l) lpos++;  /* init takes 1 char on teleray */
	ch=mget(&ffin);   nch = mget(&ffin);

put_lp:
	if ((ch == ' ') && (nch == '[')) {	/* start of data field */
		mputrec(strt, strt_l, &fout);
		lpos =+ 4;
		for (i=0; i<fld[flpos].f_size; i++) {
			mput(' ',&fout);
			lpos++;
		}
		mputrec(endf, endf_l, &fout);
		flpos++;
		while ((ch = mget(&ffin)) != ']');
		ch = mget(&ffin);
		if (ch == '\n') goto getnc;
		ch = mget(&ffin);
getnc:
		nch = mget(&ffin);
		goto put_lp;
	}
	if (ch == '\n') {
		lnum++;
		if (lnum == PAGELEN) goto endform;
		while (lpos<scrwid) {
			mput(' ', &fout);
			lpos++;
		}
		lpos = 0;
		ch = nch;
		nch = mget(&ffin);
		if ((ch == '\0') || (nch == '\0')) goto endform;
		if (lnum >= PAGELEN) goto endform;
		mputrec(eol, eol_l, &fout);
		if (eol_l) lpos++;
		goto put_lp;
	}
	mput(ch, &fout);
	lpos++;
	ch=nch;
	nch=mget(&ffin);
	if (ch != '\0') goto put_lp;

endform:
	mputrec(fin, fin_l, &fout);
	close(fid);
	mflush(&fout);
	sleep(1);
	return(0);
}

/*******************************  termset  ***********************************/

/* termset - lookup terminal type */
termset(tp)
char tp;
{
char c;
char termrec[4];
struct fbuf fpr;
int fid;
extern int tflag;
extern int popt;
extern char *termfile;

	c = tp;
	if (tp) goto setit; /* explicit specification */
	c = ttyn(0);
	if (c == 'x') goto setit;
	if ((fid = open(termfile, 0)) < 0) {
		printf("Cannot open %s\n", termfile);
		goto setit;
	}
	mfinit(&fpr, fid);
	while (mgetrec(termrec, 4, &fpr)) {
		if (c != termrec[0]) continue;
		goto gotterm;
	}
	close(fid);
	goto setit;
gotterm:
	c = termrec[2];
	close(fid);
setit:
	switch (c) {
		case 't':
			tset(2); break;
		case 'e':
			tset(3); break;
		case 'c':	/* concept 108 */
			tset(4); break;
		default:
			tset(0);
			printf("Printing terminal\n");
			popt = 1;
	}
	tflag++;
}

/* routine to set up codes for various terminal types
 */

tset(t)
register int t;
{
	init = initx[t];
	init_l = initlx[t];
	strt = strtx[t];
	strt_l = strtlx[t];
	endf = endfx[t];
	endf_l = endflx[t];
	fin = finx[t];
	fin_l = finlx[t];
	eol = eolx[t];
	eol_l = eollx[t];
	cls = clsx[t];
	cls_l = clslx[t];
	fmto = fmtox[t];
	fmto_l = fmtolx[t];
	nrec = nrecx[t];
	nrec_l = nreclx[t];
	ok = okx[t];
	ok_l = oklx[t];
	rdln = rdlnx[t];
	rdln_l = rdlnlx[t];
	eor = eorx[t];
	warn = warnx[t];
	inrdy = inrdyx[t];
	lnmode = lnmodex[t];
	dlymode = dlymdx[t];
	termtype = t;
}
