/*
 *	v.cdisp - create and display records for vir
 *	11/30/82
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern int dfid, nfid, sfid;

extern long atol(), lseek();

extern struct	dexhead	hrec;		/* HFILE (header file) */
extern struct	fil_ent	filent[MAXFILE]; /* data file information - XFILE */
extern struct	fmt_def fmtdef[MAXFMT];
extern struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
extern struct	fdef	fld[MAXFLD];	/* the format field descriptors */
extern struct	pat_ent	prec;		/* one record from PFILE */
extern struct	num_ent	snrec;		/* one record from NFILE */
extern struct	sp_ent	srec;		/* one record from SFILE */

extern char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */

/* WORKING SET - current set of records */
extern char	afld[250];	/* source for auto copy fields */
extern int	apnt[10],asize[10];	/* autocopy fields start and size */
extern int	amax;			/* amount of auto copy space used */
extern struct	pat_ent	cur;	/* current patient name and number */
extern int	cur_rcnt;	/* count of records in current set */
extern long	cp_off;			/* patient index offset of current patient */
extern long	 lk_pnum;		/* patient number for lookup */
extern char	lk_pnam[PNSIZE];	/* patient name for lookup */
extern long	lk_spnum;		/* specimen number for lookup */

extern struct {
	struct	num_ent crec_n;
	int	nfmt_num;	/* format associated with this record */
	long	nws_loc;	/* loc of index entry for this record */
	}  crec[MAXREC];	/* pointers to records in working set */
extern int	wsp;		/* points to current record entry during update */

extern struct {
	struct sp_ent cspec_n;
	int sfmt_num;		/* format associated with this record */
	long	sws_loc;	/* loc of index entry for this record */
	} cspec[MAXSPEC];	/* pointers to records via specimen number */

/* RECORD - information on current record being processed */
extern int	cur_type;	/* type of record */
extern int	ltype	;	/* cur_type - 1 */
extern unsigned cur_fnum;	/* file number */
extern long	cur_strt;	/* offset to record start */
extern int	cur_size;	/* current record size (compressed in file) */
extern int	recsize	;	/* current expanded record size */
extern long	new_strt;	/* new offset to record start */
extern int	new_size;	/* new record (compressed) size */
extern long	cur_n;			/* position of descriptor entry in nfile for current record */

/* DISPLAY control variables */
extern int	singpat;	/* set if single patient display */
extern int	wdisp;	/* set if working set display required */
extern int	wsdisp;	/* set if spec nums required for working set */
extern int	byspec;	/* set if display is by specimen number */
extern int	allflag;	/* set if lookup is by spec number, but display is all records */
extern int	fmtlim;	/* set if display limited to selected formats */
extern int	fmtrst[MAXFMT];	/* set if format type selected for display */
extern int	udmode;	/* 0 = display mode, 1 = update mode */

/* LOOKUP - control variables and tables (?2 files) */
extern int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
extern int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
extern long ploc, nloc, sloc;  /* current offsets into index files */
extern long newnloc;

/* STATE - general system and state definitions */
extern int	fmtstate;	/* fmt off (0) or on (1) */
extern int	fdexmod;	/* set if any changes made */
extern int	icnt;	/* size of command line (= recsize) */
extern int	repmode;	/* set if replicate command is in progress */
extern int	filspot;		/* current data file pointer in filent table */
extern int	nfmt;	/* format to load */
extern int	r_only;	/* set if updating not allowed */

extern int	hispd;	/* set if line is 9600 baud */
extern int	auto_on;	/* set if automatic patient numbering is on */

extern char bell[];

/* EXTERNAL - various externally defined items */

extern char eor, inrdy, *ok, *cls, *fmto;
extern int cls_l, fmto_l, ok_l, errno;


/* MISC - miscellaneous variables */

int	nrd;
extern char	rbuf[80];	/* spare line buffer */
extern char	dfile[50];	/* current in use file name */
extern int fcnt, nspecn, specnpos[30], fnn, fsn, fn, fs;
extern long newloc, spn;
extern int	tflag;		/* set after terminal type checked */
extern int sploc, spsize;
extern long errloc;
extern long errpnum;
extern long	errspec;
extern int setid;
extern long MEG;
extern char *gens;
extern long ML;
extern int popt;

/*******************************  create  ***********************************/

/* create new patient records */

create(st)
int st;
{
register int i, j;
register char c;
int k, l, is, m;
long xpn, ypn, ys, fys;


	i = cset(st);
	if (i) return(i);
	fileck(filspot,2);	/* no return if access to file not allowed */
	dfid = open(dfile, 2);
	if (dfid < 0) {
		if ((dfid = creat(dfile,0664)) < 0)
			quitsig(27);
		chown(dfile, setid);
	}
	if (filent[filspot].f_mode != HOLES)
		filent[filspot].f_mode = NOTCUR;
	fdexmod = 1;
	setform(nfmt);
	if (!hrec.intnum) {
		i = fmtinf[ltype].st_fld + fmtinf[ltype].fld_pn;
		fn = fld[i].f_size;  /* patient number field location and size */
		fs = fld[i].f_pos;
	}
	i = fmtinf[ltype].st_fld + fmtinf[ltype].fld_nam;
	fnn = fld[i].f_size;	/* patient name size and location */
	fsn = fld[i].f_pos;
	if (hrec.compnum) {
		i = fmtinf[ltype].fld_pny + fmtinf[ltype].st_fld;
		fys = fld[i].f_pos + fld[i].f_size - 2;
	}

/* build a table of field numbers for specimen numbers */
	nspecn = 0;
	if ((fmtinf[ltype].fmt_mod & SPECIMEN) == 0) goto ckrep;
	i = fmtinf[ltype].st_fld;
	for (j = 0; j<fmtinf[ltype].num_fld; j++) {
		if (fld[i+j].f_flags & SPECIMEN)
			specnpos[nspecn++] = j;
	}

ckrep:
	if (repmode) {	/* set up for autocopy of fields and display */
		if ((fmtinf[ltype].fmt_mod & AUTO) == 0) goto alp; /* none */
		recsize = 0;
		zapn(tbuf,fmtinf[ltype].num_chr, ' ');
		for (l=0; l<fmtinf[ltype].num_fld; l++) { /* find field for autocopy */
			j = l + fmtinf[ltype].st_fld;
			if ((fld[j].f_flags & AUTO) == 0) continue;
			k = fld[j].f_pos;
			i = fld[j].f_anum;
			if (i > 9) continue;
			if (asize[i] <1) continue;
			for (m = 0; m<asize[i]; m++) {
				tbuf[k++] = afld[apnt[i] + m];
				if (k > recsize) recsize = k;
			}
		}
		puff(tbuf);
		recsize = 0;
	}

/* return here for each new record */
alp:
	is = getin(2);
	if (is) goto adone;
	if (!valrec()) goto alp;
	if (repmode) goto alp2;
	if (auto_on && (cur_type == 1)) {
		hrec.maxpnum++;
		if (hrec.compnum) {
			hrec.pnumbas++;
			sprintf(rbuf,gens,hrec.pnumbas);
		} else {
		sprintf(rbuf,gens, hrec.maxpnum);
		}
		/* insert new patient number into record automatically */
		ncpy(&tbuf[fs], rbuf, fn);
	}
	/* track highest patient number */
alp2:
	if (hrec.intnum)
		xpn = ++hrec.maxpnum;
	else {
		ncpyt(rbuf,&tbuf[fs],fn);
		xpn = atol(rbuf);
		if (hrec.compnum) {
			ncpyt(rbuf,&tbuf[fys],2);
			ys = atol(rbuf);
			if (ys > hrec.pnumyr)
				hrec.pnumbas = xpn;
			if (ys >= hrec.pnumyr)
				hrec.pnumyr = ys;
			if (( ys == hrec.pnumyr) && (xpn > hrec.pnumbas))
				hrec.pnumbas = xpn;
			xpn += ys * MEG;
		}
		if (xpn > hrec.maxpnum) hrec.maxpnum = xpn;
	}
	gen_frec();	/* compress tbuf to ibuf */
	cur_size = new_size;
	newloc = lseek(dfid, 0L, 2);
	write(dfid, ibuf, new_size);

/* generate index entries here */

/* patient name vs number entry */
	if (repmode == 1) goto do_n;
	makp(&tbuf[fsn], xpn, ML);

/* patient number vs record entry (file and offset) */

do_n:
	cur_n = lseek(nfid, 0L, 2);
	makn(xpn, cur_fnum, newloc, ML);

/* hard part - make patient number vs specimen number , file number, and offset entries */

	if (nspecn == 0) goto nospec;
	seek(sfid, 0, 2);
	for (i=0; i<nspecn; i++) {
		j = specnpos[i];
		k = j+fmtinf[ltype].st_fld;
		sploc = fld[k].f_pos;
		spsize = fld[k].f_size;
		if (sploc > recsize) break; /* no more specimens */
		ncpyt(rbuf, &tbuf[sploc], spsize);
		spn = atol(rbuf);
		if (spn == 0L) continue;
		maks(spn, xpn, cur_fnum, newloc, ML);
	}
nospec:
	new_strt = cur_strt = newloc;
	setcur();	/* record current record info */

	write(1, bell, 1);
	if (repmode) {
		is = 0;
		goto adone;
	}
	goto alp;
adone:
	close(dfid);
	if (is == 1) return(1);
	else  return(-1);
}

/*********************************  cset  ***********************************/
/* initialization for create/replicate */

cset(st)
int st;
{
register int i, j;
register char c;
	/* first determine in which file to create records */
	st++;
	fcnt = 0;
flp:
	c = tbuf[st++];
	if (( c == ' ') && (fcnt == 0)) goto flp;
	if ((c == ' ') || (c == '\0')) goto gotfile;
	dfile[fcnt++] = c;
	goto flp;
gotfile:
	dfile[fcnt] = '\0';
	if (fcnt == 0) goto c_only;
	if ((fcnt == 1) && (dfile[0] >= '0') && (dfile[0] <= '9')) goto n_only;
	filspot = lookup(dfile);
	if (filspot < 0) {  /* new file - not in index */
		if (hrec.numfmt == 1) {
			nfmt = 1;
			goto asknew;
		}
		if (c == '\0') goto no_fmtn;
flp2:
		c = tbuf[st++];
		if (c == ' ') goto flp2;
		if (c == '\0') goto no_fmtn;
		if ((c < '0') || (c > '9')) goto no_fmtn;
		nfmt = c - '0';
asknew:
		fmtoff();
		printf("create new file %s ? y or n\n",dfile);
		i = getin(0);
		if (i) return(i);
		if (tbuf[0] != 'y') return(-1);
		filspot = addfile(dfile, nfmt-1);
	}
	/* existing file in the index */
	nfmt = filent[filspot].fmt_cd + 1;
	cur_fnum = filent[filspot].f_num;
	return(0);
no_fmtn:
	fmtoff();
	printf("Specify format for new file %s\n",dfile);
	sleep(4);
	return(-1);
n_only:
	nfmt = dfile[0] - '0';
	goto c2;
c_only:
	nfmt = 1;
c2:
	strcpy(dfile, fmtdef[nfmt-1].fmt_app);
	cur_fnum = fmtdef[nfmt - 1].fil_num;
	filspot = lookupn(cur_fnum);
	if (filspot < 0) return(-1);
	return(0);
}

/******************************  display  ************************************/

display(st)
{
	udmode = 0;
	return(udisp(st));
}
update(st)
{
	udmode = 1;
	return(udisp(st));
}

udisp(st)
int st;
{
register int i,j;
register char c;
long k;
unsigned l;
int m, ifmt;
int ij, ix, iy, iz, nspc, rcnt;

	plookp = 0;
	rcnt = allflag = byspec = singpat = wdisp = wsdisp = 0;
/* following display combinations have meaning
 * d name or pnum - display all records for specified patient(s)
 * dx - where x is one or more digits - display only for formats specified
 * dw name or pnum - display working sets for specified patient(s)
 * dws name or pnum - display working sets with specimen numbers
 * ds spnum - display the record(s) for the specimen number
 * dsw spnum - display the working set for the patient with specimen spnum
 * dswa spnum - display all records for the patient with specimen spnum
 * dc - display all records for current patient
 * dwc - display working set for current patient
 */

	for (i=0; i<MAXFMT; i++)  fmtrst[i] = 0;
	fmtlim = 0;
lp:
	st++;
	c = tbuf[st];
	switch (c) {
		case 'w':
			wdisp = 1;
			if (byspec) wsdisp = 1;
			goto lp;
		case 'c':
			singpat = 1;
			if (cur_rcnt) goto dodisp;
			return(0);
		case 's':
			if (wdisp) wsdisp = 1;
			else  byspec = 1;
			goto lp;
		case 'a':
			allflag = 1;
			goto lp;
		case ' ':  goto lpdone;
		default:
			if ((c < '1') || (c > '9')) goto lp;
			i = (c- '1') &0177;
			fmtlim = fmtrst[i] = 1;
			goto lp;
	}
lpdone:
	while (tbuf[st] == ' ') st++;
	if (popt) fmtoff();

/* we have analyzed the command - get the name or number */

	if (byspec) { /* lookup by specimen number */
		lk_spnum = atol(&tbuf[st]);
		slookp = 0;
		while (looks(lk_spnum)) {
			lk_pnum = cur.p_num = srec.xp_num;
			if (wdisp) goto set_p;
			lk_pnam[0] =  cur.p_name[0] = '\0';
			cp_off = -1;
			i = lookupn(srec.sf_num);
			j = filent[i].fmt_cd;
			if (fmtlim && (!fmtrst[j])) continue;
			wsp = -1;  /* not using working set */
			if (udmode) {
				sav();
				i = uprec(srec.sf_num, srec.sf_loc, j, 1);
				rest();
			}  else  {
				i = showrec(srec.sf_num, srec.sf_loc, j);
			}
uplp1:
			if ((i == 1) && (tbuf[1] == 'u')) {
				if (udmode || r_only || tbuf[2] != '\0') return(i);
				sav();
				i = uprec(srec.sf_num, srec.sf_loc, j, 1);
				rest();
				goto uplp1;
			}
			rcnt++;
			if (i == 3) continue;
			if (i) return(i);
		}
		if (!rcnt) {
			lk_pnum = lk_spnum;
			goto norec_n;
		}
		return(-1);
	}

/* normal lookup by patient name or number */
	lk_pnum = atol(&tbuf[st]);
	if (hrec.compnum && (lk_pnum > 0)) { /* composite number generation of year */
		if (lk_pnum < MEG)
			lk_pnum += hrec.pnumyr * MEG;
	}
set_p:
	if (lk_pnum > 0) {
		lk_pnam[0] = '\0';
		loadws(lk_pnum);
		if (!cur_rcnt) goto norec_n;
		singpat = 1;
		cur.p_num = lk_pnum;
		cur.p_name[0] = '\0';
		cp_off = -1;
		goto dodisp;
	}
	i = 0;
lp2:
	c = tbuf[st++];
	if (c == '\0') goto gotname;
	if (st > icnt) goto gotname;
	if ((c >= 'a') && (c <= 'z')) c &= 0137;  /* fold to upper case */
	lk_pnam[i++] = c;
	if (i >= PNSIZE) goto get_pat;
	goto lp2;
gotname:
	lk_pnam[i] = '\0';
get_pat:
	i = loadpat(lk_pnam);
	if (!i) {
		if (!rcnt) goto norec;
		if (popt) return(-1); else return(0);
	}
dodisp:
	if (!cur_rcnt) goto get_pat;
	if ((wdisp) && (!allflag)) goto do_wdisp;
	for (ifmt = 0; ifmt < hrec.numfmt; ifmt++) {
		if (fmtlim && (!fmtrst[ifmt])) continue;
		for (i = 0; i<cur_rcnt; i++) {
			if (crec[i].crec_n.np_num == 0) continue; /* deleted entry */
			if (crec[i].nfmt_num == ifmt) {
				wsp = i;  /* set up working set pointer */
				rcnt++;
				if (udmode) {	/* update */
					sav();
					j = uprec(crec[i].crec_n.nf_num, crec[i].crec_n.f_loc, ifmt, 0);
					rest();
				}  else  {
					/* showrec( file number, location, format */
					j = showrec(crec[i].crec_n.nf_num, crec[i].crec_n.f_loc, ifmt);
				}
uplp2:
				if (j == 1)  switch (tbuf[1]) {
					case 'u':
						if (r_only || udmode || (tbuf[2] != '\0')) return(j);
						sav();
						ncpy(&snrec, &crec[i], sizeof snrec);
						nloc = crec[i].nws_loc;
						j = uprec(crec[i].crec_n.nf_num, crec[i].crec_n.f_loc, ifmt, 0);
						rest();
						goto uplp2;
					case 'n':
						if (singpat) return(0);
						goto get_pat;
					case 'r':
						if (r_only) return(j);
						if (tbuf[2] == 'n') {
							repmode = 2;
							j = create(2);
						} else {
							repmode = 1;
							j = create(1);
						}
						repmode = 0;
						if (j > 0) goto uplp2;
						break;
				}
				if ( j == 3) continue;
				if (j) return(j);
			}
		}
	}
	if (singpat) return(-1);
	goto get_pat;
do_wdisp:
	fmtoff();
	printf("Patient name:  %-14.14s\n",cur.p_name);
	printf("Patient number:  %D\n",cur.p_num);
	printf("Format Name   Format Number   Location   File Name\n");
	for (i=0; i<cur_rcnt; i++) {
		k = crec[i].crec_n.f_loc;
		j = crec[i].nfmt_num;
		l = crec[i].crec_n.nf_num;
		m = lookupn(l);
		printf("%-14.14s%13d%11D   %s\n",fmtdef[j].fmt_name,j+1,k,filent[m].f_name);
		rcnt++;
		if (wsdisp) { /* display with specimen numbers */
			if ((fmtinf[j].fmt_mod & SPECIMEN) == 0) goto no_sp;
			ix = fmtinf[j].st_fld;
			nspc = 0;
			if (getfrec(l, ibuf, k) < 1) {
				printf("Record not accessible\n");
				goto no_sp;
			}
			expand(ibuf, tbuf, j);
			for (iy = 0; iy<fmtinf[j].num_fld; iy++) {
				iz = ix+iy;
				if ((fld[iz].f_flags & SPECIMEN) == 0) continue;
				sploc = fld[iz].f_pos;
				spsize = fld[iz].f_size;
				if (sploc >= recsize) break;
				ncpyt(rbuf,&tbuf[sploc],spsize);
				if (nspc++) printf("     ");
				printf("  %-7.7s",rbuf);
				if (nspc >= 8) {
					printf("\n");
					nspc = 0;
				}
			}
			if (nspc) printf("\n");
			printf("\n");
		}
no_sp:  ;
	}
	i = getin(1);
	if (i) return(i);
	if (singpat) return(0);
	goto get_pat;
norec:
	fmtoff();
	printf("no records found for %-14.14s\n",lk_pnam);
	return(-1);
norec_n:
	fmtoff();
	printf("no records found for %D\n",lk_pnum);
	return(-1);
}

/*******************************  expand  ************************************/

expand(in, out, fmtyp)
char *in, *out;
int fmtyp;
{
register char c;
register int ic, oc;
int i, j, k, st, end;
	st = fmtinf[fmtyp].st_fld;
	end = fmtinf[fmtyp].end_fld;
	ic = oc = 0;
	for (i=st; i< end; i++) {
		for (j=0; j<fld[i].f_size; j++) {
			c = in[ic++];
			if (c == hrec.recsep) goto quitex;
			if (c == hrec.fldsep) {	/* field padding needed */
				for (k=j; k<fld[i].f_size; k++)  {
					out[oc++] = ' ';
					if (oc >= MAXRSIZE) quitsig(34);
				}
				goto quitfl;
			}
			out[oc++] = c;
			if (oc >= MAXRSIZE) quitsig(34);
		}
/* if data is too large gobble excess characters */
goblp:
		if (ic >= MAXRSIZE) quitsig(34);
		c = in[ic++];
		if (c == hrec.fldsep) continue;
		if (c == hrec.recsep) break;
		goto goblp;
quitfl: ;
	}
quitex:
	out[oc] = '\0';
	recsize = oc;
	return;
}
