/*
 * msd column file start end
 * read file and produce a mean and s.d. of numbers in column specified
 * columns are separated by ':' and the first column is 1.
 * only data on lines start through end are included.
 * missing data and data with '*' at the end of the field are skipped.
 *
 * by David E. Miran  9/2/82
 */

#include	<math.h>
#include	<stdio.h>
int fid, col, nrd, iptr, n;
long stline,enline,curline,nskip,nmiss;
char buf[512], lbuf[512];
double sum, sumsq, mean, sd, val, cv;

main(argc,argv)
int argc;
char ** argv;
{
register int i, ic;
extern double fabs(), sqrt();
extern float atof();
extern long atol();
char c;
int dig;
	if (argc < 3) {
		printf("usage:  msd  column file start end\n");
		exit(1);
	}
	col = atoi(argv[1]);
	if ((col <1) || (col > 60)) {
		printf("invalid column %d\n",col);
		exit(1);
	}
	fid = open(argv[2], 0);
	if (fid < 0) {
		printf("cannot open file %s\n",argv[2]);
		exit(1);
	}
	nskip = nmiss = 0;
	curline = stline = 0;
	enline = 1000000;
	if (argc > 3) stline = atol(argv[3]);
	if (argc > 4) enline = atol(argv[4]);
	col--;
	iptr = nrd = 0;
lp:
	if (getline()) goto comp;  /* end of data */
	ic = i = 0;
	for (ic=0; ic<col; ic++)
		while(lbuf[i++] != ':');
	if ((lbuf[i] == ':') || (lbuf[i] == '\0') || (lbuf[i] == '\n')) {
		nmiss++;
		goto lp;
	}
	ic = i;
	dig=0;
	while ((lbuf[ic] != ':') && (lbuf[ic] != '\0') && (lbuf[ic] != '\n')) {
		c = lbuf[ic];
		if ((c >= '0') && (c <= '9')) dig++;
		ic++;
	}
	if (lbuf[ic-1] == '*') {
		nskip++;
		goto lp;
	}
	if (dig == 0) {
		nmiss++;
		goto lp;
	}
	val = atof(&lbuf[i]);
	sum =+ val;
	sumsq =+ val*val;
	n++;
	goto lp;
comp:	/* all data read - compute */
	close(fid);
	if (n<2) {
		printf("too little data\n");
		exit(1);
	}
	mean = sum/n;
	if ((mean < .0000001) && (mean > -0.0000001)) {
		sd = 0.0;
		cv = 0.0;
	} else {
		sd = sqrt(fabs((sumsq - (n * mean * mean))/(n - 1)));
		cv = (sd/mean)*100.0;
	}
	printf("Statistics for column %s of data set %s\n",argv[1], argv[2]);
	if (stline == 0) stline++;
	printf("   from line %D through line %D\n",stline,curline);
	printf("mean        %15.6f\n",mean);
	printf("s.d.        %15.6f\n",sd);
	printf("c.v.        %15.6f\n",cv);
	printf("n           %8d\n",n);
	printf("Sum of X    %15.6f\n",sum);
	printf("Sum of X**2 %15.6f\n",sumsq);
	printf("# missing   %8D\n",nmiss);
	printf("# skipped   %8D\n",nskip);
	exit(0);
}

getline()
{
register int i, cc;
register char ch;
extern char get();

strt:
	i = cc = 0;
clp:
	ch = get();
	if (ch == '\0') return(1);
	lbuf[i++] = ch;
	if (ch == ':') cc++;
	if (ch == '\n') {
		curline++;
		if (curline < stline) goto strt;
		if (curline > enline) {
			curline--;
			return(1);
		}
		if (cc<col) goto strt;  /* too few columns in record */
		lbuf[i] = '\0';  /* for debugging */
		return(0);
	}
	goto clp;
}

char get()
{
	if (iptr == nrd) {
		nrd = read(fid, buf, 512);
		if (nrd < 1) {
			return(0);
		}
		iptr = 0;
	}
	return(buf[iptr++]);
}
