/*
 * fixwtmp [-w wtmp] -o outfile n n n
 *
 * copy the wtmp file removing those entries whose numbers are given.
 * the first entry in the file is 1.
 * the -w option is followed by the name of a file to read, otherwise
 * /usr/adm/wtmp is used
 * the output file must be specified.  Those records removed are listed.
 *
 * by David Miran  6/22/81
 */

#include	<stdio.h>
#include	<myio.h>

struct jb  {
	char	name[8];
	char	jtty;
	char	jfill1;
	long	stime;
	int	jfill2;
	char	proj[4];
};
struct jb jbuf;

struct	{		/* stat call buffer */
	char	sfill1[9];
	char	size0;
	unsigned	size1;
	char	sfill2[24];
	}	sbuf;

long actoff, fsize, fents;
long floc;
int	entnum, fid, iptr, nrd;
int	bufeof;
#define	ENTSIZE	20

char	*wtmp;
char *cp;

#define	NFIX	50	/* maximum number of deletions */
char	*ofile;
int	ofid	0;
int	numpos	0;
long	fpos[NFIX];
struct	fbuf ifin,ifout;
long	inum;

main(argc, argv) 
char **argv;
{
extern char *ctime();
extern long lseek();
extern long atol();
extern fout;
register i;

	wtmp = "/usr/adm/wtmp";
	for (i=1; i<argc; i++)  {
		if (strcmp(argv[i], "-w") == 0) {
			i++;
			wtmp = argv[i];
			continue;
		}
		if (strcmp(argv[i], "-o") == 0) {
			i++;
			ofid++;
			ofile = argv[i];
			continue;
		}
		/* probably a number */
		inum = atol(argv[i]);
		if (inum) {
			fpos[numpos++] = inum;
			continue;
		}
		printf("invalid option %s\n",argv[i]);
		exit(1);
	}
	if ((fid = open(wtmp, 0)) < 0) {
		printf("cannot open %s\n",wtmp);
		goto done;
	}
	if (ofid == 0) {
		printf("No output file specified\n");
		exit(1);
	}
	if ((ofid = creat(ofile,0644)) < 0) {
		printf("cannot create %s\n",ofile);
		exit(1);
	}
	mfinit(&ifin, fid);
	mfinit(&ifout,ofid);
	stat(wtmp,&sbuf);
	fsize = sbuf.size0*65536L + sbuf.size1;
	fents = fsize/ENTSIZE;
	printf("file %s has %D entries\n",wtmp,fents);
rdst:
	printf("ENTRIES REMOVED FROM FILE\n");
	printf(" entry  name     proj tty time\n");
	entnum = bufeof = iptr = nrd = 0;
rdlp:
	if (mgetrec(&jbuf, ENTSIZE, &ifin) == 0) goto done;
	cp = ctime(&jbuf.stime);
	entnum++;
	for (i=0; i<numpos; i++) {
		if (entnum == fpos[i]) goto dopr;
	}
	mputrec(&jbuf, ENTSIZE, &ifout);
	goto rdlp;
dopr:
	printf("%6d  %-8.8s %4.4s  %c  %s",
		entnum, jbuf.name, jbuf.proj, jbuf.jtty, cp);
	goto rdlp;
done:
	close(fid);
	mfclose(&ifout);
	exit(0);
}
