/*
 * mergit [-m] [-ix] [-rx] fmt file file ....
 * merge data records with their data entry format
 * -m option is for modified data format records
 * -ix means item (field) separator is x
 * -rx means record separator is x
 * by David E. Miran
 * 2/5/82
 */

#include	<stdio.h>
#include	<myio.h>

#define		FMSIZE	5000	/* maximum format size in characters */

struct fbuf ibuf, obuf;
char	fm[FMSIZE];
int fid,ofid;
int	fms;	/* actual format size */
char	fldsep	'\'';
char	recsep	'!';
int	rmode	0;

main(argc, argv)
int argc;
char **argv;
{
register char c;
register int fs, fp;
char prc;

arglp:
	argc--;  argv++;
	if (strcmp(*argv, "-m") == 0) {
		fldsep = ':';
		recsep = '\n';
		rmode = 1;
		goto arglp;
	}
	if (strncmp(*argv, "-i", 2) == 0) {
		fldsep = argv[0][2];
		goto arglp;
	}
	if (strncmp(*argv, "-r", 2) == 0) {
		recsep = argv[0][2];
		goto arglp;
	}
	if ((fid = open(*argv, 0)) < 0) {
		fprintf(stderr,"cannot open format file %s\n",*argv);
		exit(1);
	}
	fms = read(fid, fm, FMSIZE);
	if (fms == FMSIZE) {
		fprintf(stderr,"format too large\n");
		exit(1);
	}
	close(fid);
	argc--;  argv++;
	mfinit(&obuf, 1);
	if (argc < 1) {
		fid = 0;
		goto nfile;
	}
opit:
	if ((fid = open(*argv, 0)) < 0) {
		fprintf(stderr,"cannot open file %s\n",*argv);
		mflush(&obuf);
		exit(1);
	}
nfile:
	mfinit(&ibuf, fid);
rstart:
	prc = mget(&ibuf);
	if (ibuf.nrd < 1) goto fdone;
	if ((prc == '\n') && (rmode == 0)) goto rstart;
	fp = 0;	/* position pointer in format */
rloop:	/* loop for each sequence of chars followed by a field */
	while ((c = fm[fp++]) != '[') {	/* scan to [  */
		mput(c, &obuf);
		if (fp >= fms) goto fmdone;
	}
	fs = 0;	/* counter for field size */
	while ((c = fm[fp++]) != ']') fs++;
	mput('[',&obuf);
clp:	/* read field contents from file */
	if (prc) {
		c = prc;
		prc = '\0';
	}  else {
		c = mget(&ibuf);
	}
	if (ibuf.nrd < 1) {
		mputrec("]\n", 2, &ibuf);
		goto fdone;
	}
	if (c == fldsep) goto fillf;
	if ((c == '\n') && (rmode == 0)) goto clp;
	if (c == recsep) goto rdone;
	mput(c, &obuf);
	fs--;
	if (fs > 0) goto clp;
gob:
	c = mget(&ibuf);
	if (c == fldsep) goto fillf;
	if (c == recsep) goto rdone;
	goto gob;
fillf:
	while(fs--) mput(' ', &obuf);
	mput(']',&obuf);
	goto rloop;
rdone:
	if (fs > 0) {
		while (fs--) mput(' ', &obuf);
	}
	mput(']', &obuf);
	mput('\n', &obuf);
	goto rstart;
fmdone:
	while ((c = mget(&ibuf)) != recsep) {
		if (ibuf.nrd < 1) goto fdone;
	}
	goto rstart;
fdone:
	close(fid);
	argc--;
	if (argc < 1) {
		mfclose(&obuf);
		exit(0);
	}
	argv++;
	goto opit;
}
