/*
 * lockchk
 * read a list of files in /etc/locklist and list those that exist.
 * by David E. Miran  Wisconsin State Hygiene Lab
 * version of 8/25/82
 */

#include	"myio.h"

char	*ifile	"/etc/locklist";
char	dfile[100];
int	ifid, dfid;
char 	stbuf[36];
struct	fbuf	f1;


main()
{
int crd;

	if ((ifid = open(ifile, 0)) < 0) {
		printf("cannot open lock files list\n");
		exit(1);
	}
	mfinit(&f1, ifid);
	printf("Make sure that unit 2 is mounted\n");
	printf("The following lock files exist:\n");
	while (mgetlin(dfile,&f1)) {
		if ((dfid = stat(dfile, stbuf)) < 0) continue; /* does not exist */
		printf("%s\n",dfile);
	}
	close(ifid);
	exit(0);
}
