#include "stdtime.h"
#include <math.h>
#include <ctype.h>
#include "constant.h"

#define MAXSTRING 81
#define NULL 0

int strcmp(), strlen(), strncmp(), strncpy(), is_flag(), getargs();
char *findit(), *malloc(), *realloc(), *index();

static char string[MAXSTRING] = {'\0'};

TIME timeparam(param, defalt)
char *param;
TIME defalt;
{
char *gotit;

if (gotit = findit(param)) atodate (gotit);
else if (defalt) date(defalt);
else init_zero(&curtime, sizeof(DATE));

return(curtime._time);
}

char *nameparam(param, defalt)
char *param, *defalt;
{
char *gotit;

if (gotit = findit(param))
	{
	strncpy(string, gotit, MAXSTRING);
	string[MAXSTRING-1] = '\0';
	return(string);
	}
else return(defalt);
}

int is_param(param)
char *param;
{
return(findit(param) != 0);
}

static char *findit(param)
char *param;
{
char **envp, **argv;
int argc, envc, n, i;

getargs(&argc,&argv,&envc,&envp);

if (isdigit(*param))		/* Find the param'th non-flag, non-parameter */
	{ 			/* token on command line		     */
	n = atoi(param);
	for (i=0;i<argc;i++)
		if ((*argv[i] != '-') && !index(argv[i],'='))
			if (!n--) return(argv[i]); 
	}
else
	{
	n = strlen(param);
	for (i=0;i<argc;i++)
		if (strncmp(param,argv[i],n)==0 && argv[i][n] == '=')
			return(&(argv[i][n+1]));
	if (is_flag("e")) 
		for (i=0;i<envc;i++)
			if (strncmp(param,envp[i],n)==0 && envp[i][n] == '=')
				return(&(envp[i][n+1]));
	}
return(NULL);
}

char *findnth(param, nth)
char *param;
int nth;
{
char *list,*comma;

list = findit(param);
while (--nth > 0 && (list>(char *)1)) list = index(list,',')+1;
if (list>(char *)1)
	{
	comma = index(list,',');
	if (comma) *comma = '\0';
	strncpy(string,list,MAXSTRING);
	string[MAXSTRING-1] = '\0';
	if (comma) *comma = ',';
	return(string);
	}
else return(NULL);
}

double nthparam(param, defalt, position)
char *param;
double defalt;
int position;
{
char *gotit;

if (gotit = findnth(param, position)) return(atof(gotit));
else return(defalt);
}

double parameter(param, defalt)
char *param;
double defalt;
{
return(nthparam(param, defalt, 0));
}

double *listparameter(param,endmarker)
char *param;
double endmarker;
{
double *buffer;
int i;

buffer = (double *)malloc((unsigned)(MAXSTRING/2*sizeof(double)));
i=1;
while ((buffer[i-1] = nthparam(param,endmarker,i)) != endmarker) ++i;
if(i==1 && buffer[0]==endmarker)
	return( (double *)0);
return(buffer=(double *)realloc((char *)buffer,(unsigned)(i*sizeof(double))));
}

double *listparam(param)
char *param;
{
return(listparameter(param,MISSING));
}
