/*
Name:
	SUSDAY Calendar System Command

Function:
	Display a suspense file for a given day and user

Algorithm:
	Convert date given to ddmmm format and build the suspense file name.
	Call dolist with these two parameters.

Parameters:
	Date in mm/dd/yy format
	Authorized user  -  default is self

Returns:
	ENOERR	Normal Exit
	ENOENT	Bad home directory or no dolist file

Files and Programs:
	user supplied file              the list file
	/BIN/SORT                       used to sort the list items

Installation Instructions:
	Compile cc -o exec.dir/susday susday.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Aug 82, Release 7 Version 2, J. Neyer...original version


*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "../includes/getdef.h"
#include "../includes/error.h"
#define USAGE "susday: You must enter: susday date <auth_user>\n"

char id[] = "%W% %H%";


main(argc, argv, envp)
int argc;
char *argv[];
char **envp;
{

    char *sus_file;
    char cmd_buf[CMDLEN],
	*cmd = cmd_buf;                      /* Holds command for shell */
    struct stat stat_buf;
    struct passwd *pw;
    char  sus_name[128];
    char date_buf[10],
	*date = date_buf;

    if (argc < 2 || argc > 3)   {
	fprintf(stderr, USAGE);
	exit(EFORM);
    }
    if (argc == 3)      {
	sus_file = sus_name;
	if ((pw = getpwnam(argv[2])) == NULL)   {
	    fprintf(stderr, "susday: cannot find user %s\n", argv[2]);
	    exit(EFORM);
	}
	if ((valid_date(argv[1], date, 0)) == NULL)      {  /* Validate date */
	    fprintf(stderr, "susday: invalid date entered %s\n", argv[1]);
	    exit(EFORM);
	}
	strcat (sus_file, pw->pw_dir);
	strcat (sus_file, "/exec/suspenses/sus.");
	strcat (sus_file , date);
    }
    else
	sus_file = makesus(argv[1], findenv("HOME", envp));
    if ((stat(sus_file, &stat_buf)) == -1)  {
	fprintf(stderr, "susday: no sus_file file for date %s\n", sus_file);
	exit(ENOERR);
    }
    if (argc == 3)
	sprintf (cmd, "%s %s %s", "$EXECDIR/dolist", sus_file, argv[2]);
    else
	sprintf (cmd, "%s %s", "$EXECDIR/dolist", sus_file);
    if ((system(cmd_buf)) != 0)             {                /* Call dolist */
	fprintf (stderr, "susday: error on system call\n");
	exit (ESYSTEM);
    }
}
