h58844
s 00074/00000/00000
d D 1.1 82/10/06 14:29:00 jan 1 0
e
u
U
t
T
I 1
/*
Name:
     new_date

Function:
     Determine the standardized date (ddmmm) for the fifth day from the
     current day

Algorithm:
     Find the current day, month, and year. From that information, determine
     the julian date, add the user supplied increment to it, and then
     standardize the new julain date in the format ddmmm

Parameters:
     date    a pointer to a user supplied buffer for holding the standardized
	     date
     incr    an increment to add to the current date

Returns:
     new date in user supplied buffer

Files and Programs:
     None


*/
#include <time.h>
#include <stdio.h>


char *new_date (incr)
int  incr;                                               /* Increment to current date */
{
   static char id[] = "%W% %H%";
   long tvec;                                          /* Time vector */
   long *ptvec = &tvec;
   struct tm *time_ptr;                                /* Pointer to current date information */
   register int    jdate,                              /* Julian date */
		   year,                               /* Current year */
		   days;                               /* Number of days in the current year */
   char    date[7];
   char    tempdate[7];                                /* Holds the date in julian date format (yyjjj) */
   char *ptdate = tempdate;
   extern struct tm *localtime();
   extern long time();
   extern char *itoa();
   extern char *copy();
   extern int atoi();
   extern char *month_name();
   extern char *julian_date();
   extern char *get_year();

   time (ptvec);                                       /* Find the current date information */
   time_ptr = localtime (ptvec);
   ptdate = copy (itoa (time_ptr->tm_mday), ptdate);
   ptdate = copy (month_name (time_ptr->tm_mon + 1), ptdate);
   year = atoi (get_year ());
   jdate = atoi (julian_date (tempdate, (time_ptr->tm_mon) + 1, year));
						       /* Find the julian date */
   if ((year / 4) * 4 == year && year != 0)            /* Find the number of days in the year */
       days = 366;
   else
       days = 365;
   jdate + = incr;                                     /* Add incr to the current date */
   if (jdate > days)                                   /* Check to see that the new date is not past the end of the year */
       jdate - = days;
   ptdate = tempdate;
   ptdate = copy (itoa (year), ptdate);
   ptdate = copy (itoa (jdate), ptdate);
   if(valid_date (tempdate, date, 1) == NULL)       /* Get the new standardized date, format ddmmm */
	return(NULL);
   else
	return(date);
}
E 1
