h16000
s 00004/00004/00585
d D 1.3 83/02/01 17:12:35 jan 3 2
c date/time format changes
e
s 00003/00001/00586
d D 1.2 82/12/13 13:47:29 anna 2 1
c default year for MMDDYY
e
s 00587/00000/00000
d D 1.1 82/10/06 14:34:26 jan 1 0
e
u
U
t
T
I 1

#define INVAL  00
#define ALPHA  01
#define NUMER  02
#define DELIM  04
#define COLON 010
#define BADTYPE  000
#define YYDDD    010
#define YYMMDD   020
#define MMDDYY   040
#define DDMMMYY  0100
#define ON  1
#define OFF 0
#include <stdio.h>
extern char    *substr ();
/*

Name:
	getdate

Function:
	Given a variety of input, getdate should return a pointer to an ascii
string of the form YYMMDDHHNN, where YY is the year, MM is the month, DD is the
day, HH is the hour (in military time), and NN is the minute.  This form is
compatible to many data processing uses.  

Algorithm:
	Four string buffers are kept, each storing what appears to be a new
field (An alphanumeric month field, a numeric year field, etc.).  Four
indices are incremented to determine the number of characters in each field.
The buffers and their respective indices are referred to by the suffixes 
0-3.  Starting from the beginning of the given parameter string, each
character is analyzed to determine whether it is an alpha, (A-Z or a-z)
numeric, (0-9) or delimiter (space, /, or -).  Any other characters are
invalid.  If the character is an alpha character, the character is placed
in the buffer 3 and its index incremented accordingly.  If the character
is a delimiter that is not preceded by another delimiter, a new field
has been begun so increment an id counter for the numeric fields (day, year,
or perhaps month).  That way the first numeric field will be placed in
buffer 0, the second in buffer 1, and the third numeric field (if any) in buffer2.  The second
and preceding delimiters after a field will have no effect. Any invalid characters will cause
the subroutine to halt and return an error value.

Depending on the indices (the number of characters in each buffer) it is possible
to determine the format of the given data, if it is a valid format.  If not, getdate
will return with an error.  Using a case clause, getdate will perform a
different algorithm for the four different types of valid input (see below).
This is done by building a static string buffer that will be returned.  This
may entail calling a subroutine that determines the integer month from a three
letter string or a subroutine that determines a substring of a larger string.

Parameters:
	A pointer to a string that falls under one of the following formats:
1)	Month Day Year (mmm dd [19]yy).
	a) Day is 1-2 digits.
	b) Month is three character alpha.
	c) Year is 2 or 4 digits.
	d) Delimiters are blanks or commas.
2)	Month Day Year (mm dd yy).
	a) Day is 1-2 digits.
	b) Month is 1-2 digits.
	c) Year is 2 digits.
	d) Delimiters are dashes or slashes.
3)	Day Month Year (dd mmm [19]yy).
	a) Day is 1-2 digits.
	b) Month is 3 character alpha.
	c) Year is 2 or 4 digits.
	d) Delimiters are blanks, commas, or nothing.
4)	Year Month Day (yymmdd).
	a) Year is 2 digits.
	b) Month is 2 digits.
	c) Day is 2 digits.
	d) No delimiters.
5)	Year Day (yyddd).
	a) Year is 2 digits.
	b) Relative Day of year is 3 digits.
	c) No delimiters.

Returns:
	A string pointer to an ascii string of the form YYMMDDHHNN.
	NULL for unrecognized format.

Files and Programs:
	None.

*/
char   *getdate (original)
char   *original;
{
	static char ID[] = "%W% %H%";
	int     firstchar_type;
	int     month;
	int     type;
	char    yearbuf[3];
	char   *year = yearbuf;
	char    relbuf[4];
	char   *relday = relbuf;
	int    *md_ptr;
	static char     finalbuf[20];
	register char  *final = finalbuf;
	char    numer1[20],
	        numer2[10],
	        numer3[10],
	        alpha1[10];
	register char  *num1ptr = numer1;
	register char  *num2ptr = numer2;
	char   *num3ptr = numer3;
	char   *alp1ptr = alpha1;
	int     num1indx,
	        num2indx,
	        num3indx,
	        alp1indx,
	        id,
	        newfield;
	extern int atoi();
	extern char *copy();
	extern char *itoa();
	extern int *month_day();

	id = newfield = 0;
	num1indx = num2indx = num3indx = alp1indx = 0;
	firstchar_type = typeof (*original);
	while (*original) {
		switch (typeof (*original)) {
			case NUMER: 
				if (alp1indx > 1 && newfield == ON && num2indx < 1 && firstchar_type != ALPHA) {
					newfield = OFF;
					id++;
				}
				if (id == 0) {
					num1indx++;
					*num1ptr++ = *original++;
					newfield = ON;
					break;
				}
				if (id == 1) {
					num2indx++;
					*num2ptr++ = *original++;
					newfield = ON;
					break;
				}
				if (id == 2) {
					num3indx++;
					*num3ptr++ = *original++;
					newfield = ON;
					break;
				}
			case ALPHA: 
				alp1indx++;
				*alp1ptr++ = *original++;
				break;
			case DELIM: 
				if (newfield == ON) {
					newfield = OFF;
					id++;
					original++;
					break;
				}
				else {
					*original++;
					break;
				}
			case INVAL: 
			case COLON: 
				return (NULL);
		}
	}
	if (num1indx == 5 && !num2indx && !num3indx && !alp1indx)
		type = YYDDD;
	else
		if (num1indx == 6 && !num2indx && !num3indx && !alp1indx)
			type = YYMMDD;
		else
			if (num1indx >= 1 && num1indx <= 2 && num2indx >= 1 && num2indx <= 2 && num3indx <= 4 && !alp1indx)
I 2
D 3
			|| (num1indx >= 1 && num1indx <= 2 && num2indx >= 1 && num2indx <= 2 && !num3indx)
E 3
E 2
				type = MMDDYY;
			else
				if (num1indx >= 1 && num1indx <= 2 && num2indx >= 2 && num2indx <= 4 && num2indx != 3 && !num3indx && alp1indx == 3)
					type = DDMMMYY;
				else
					return (NULL);
	*num1ptr = *num2ptr = *num3ptr = *alp1ptr = '\0';
	switch (type) {
		case YYDDD: 
			copy (substr (numer1, 1, 2), year);
			copy (substr (numer1, 3, 3), relday);
			md_ptr = month_day ((atoi (year) + 1900), (atoi (relday)));
			final = copy (year, final);
			if (*md_ptr < 10)
				final = copy ("0", final);
			final = copy (itoa (*md_ptr++), final);
			if (*md_ptr < 10)
				final = copy ("0", final);
			final = copy (itoa (*md_ptr), final);
			break;
		case YYMMDD: 
			copy (numer1, finalbuf);
			break;
		case MMDDYY: 
			if (num3indx == 2) {
				*final++ = numer3[0];
				*final++ = numer3[1];
			}
			else
				if (num3indx == 4) {
					*final++ = numer3[2];
					*final++ = numer3[3];
				}
				else
D 2
					return (NULL);
E 2
I 2
D 3
					if (num3indx != 0)
						return (NULL);
E 3
I 3
					 return (NULL);
E 3
E 2
			if (num1indx == 2) {
				*final++ = numer1[0];
				*final++ = numer1[1];
			}
			else {
				*final++ = '0';
				*final++ = numer1[0];
			}
			if (num2indx == 2) {
				*final++ = numer2[0];
				*final++ = numer2[1];
			}
			else {
				*final++ = '0';
				*final++ = numer2[0];
			}
			*final = '\0';
			break;
		case DDMMMYY: 
							/* dd mmm yy or mmm dd yy */
			if (num2indx == 2) {
				*final++ = numer2[0];
				*final++ = numer2[1];
			}
			else
				if (num2indx == 4) {
					*final++ = numer2[2];
					*final++ = numer2[3];
				}
				else
					return (NULL);
			if (!(month = which_month (alpha1)))
				return (NULL);
			if (month < 10)
				*final++ = '0';         /* leading zero */
			final = copy (itoa (month), final);
			if (num1indx == 1) {
				*final++ = '0';
				*final++ = numer1[0];
			}
			else {
				*final++ = numer1[0];
				*final++ = numer1[1];
			}
			*final = '\0';
			break;
	}
	if (verify (finalbuf))
		return (&finalbuf);
	else
		return (NULL);
}
/*

Name:
	substr

Function:
	To return a pointer to a specified substring of a given string.

Algorithm:
	Copy the given string into a temporary buffer.  The address of the temporary
buffer + the cell of the first desired substring - 1 will equal the address of the
desired substring.  Place a null character ("'\0') at the location determined by
adding the length of the desired substring to the beginning address.  Then return
the pointer to the substring determined above.

Parameters:
	1) A pointer to the original string.
	2) An integer representing the beginning character of the substring.
	3) An integer representing the length of the desired substring.

Example:  If "abcdefg" were passed with a beginning cell of 2 with a length
of 3, the result would be "bcd".

Returns:
	A character pointer to the substring.

Files and Programs:
	None.

*/
char   *
        substr (oldstr, first, length)
char   *oldstr;
int     first;
int     length;
{
	static char     tempbuf[20];
	char   *tempptr = tempbuf;

	copy (oldstr, tempbuf);
	*(tempptr + length + first - 1) = '\0';
	return (tempptr + first - 1);
}
/*

Name:
	verify

Function:
	To verify the correctness of the given date, i.e. there is no January
32.

Algorithm:
	Strip off the corresponding year, month, and day integers.  Insure that
the day specified does not exceed the number of days in the month.

Parameters:
	result -- a character pointer to the newly formatted date string.

Returns:
	0	Date out of bounds
	1	Date within bounds

Files and Programs:
	None.


*/
verify (result)
char   *result;
{
	int     year;
	int     month;
	int     day;

	year = atoi (substr (result, 1, 2));
	month = atoi (substr (result, 3, 2));
	day = atoi (substr (result, 5, 2));
	switch (month) {
		case 1: 
		case 3: 
		case 5: 
		case 7: 
		case 8: 
		case 10: 
		case 12: 
			if (day > 31)
				return (0);
			break;
		case 4: 
		case 6: 
		case 9: 
		case 11: 
			if (day > 30)
				return (0);
			break;
		case 2: 
			if ((year % 4 == 0) || !year) {
				if (day > 29)
					return (0);
			}
			else {
				if (day > 28)
					return (0);
			}
			break;
		default: 
			return (0);
	}
	return (1);
}
/*

Name:
	typeof

Function:
	To determine if a character is alpha, numerical, a delimiter, or an invalid
character.

Algorithm:
	A series of if clauses that check if the character is between valid ascii
ranges for letters or numerals, or if it is a ' ', '/', or '-'.  Then return a
type value for each type, including an invalid character type.

Parameters:
	The character to be tested.

Returns:
	A value standing for each possible type of character.

Files and Programs:
	None.

*/
typeof (character)
char    character;
{
	if (character >= 'a' && character <= 'z' ||
			character >= 'A' && character <= 'Z')
		return (ALPHA);
	if (character >= '0' && character <= '9')
		return (NUMER);
	if (character >= ',' && character <= '-')
		return (DELIM);
	if (character == '/')
		return (DELIM);
	if (character == ' ')
		return (DELIM);
	if (character == '.')
		return (DELIM);
	if (character = ':')
		return (COLON);
	return (INVAL);
}
/*

Name:
	which_month

Function:
	To determine the numeric month value (1-12) given an alpha string of
three letters (e.g. NOV, jan).

Algorithm:
	Map all upper case characters in the string, if any, into lower case.
Then do string comparisons with each month name.  Return a 0 if the given
string is not a recognized month.

Parameters:
	A pointer to a three character alphabetic string representing the month.

Returns:
	The numeric value of the month (1-12).
	A 0 (zero) if the string is not a recognized month.

Files and Programs:
	None.

*/
which_month (name)
char   *name;
{
	register char  *p;
	register int    monthnum;
	monthnum = 1;
	for (p = name; *p; p++)
		if (*p >= 'A' && *p <= 'Z')
			*p += 040;
	if (strcmp (name, "jan") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "feb") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "mar") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "apr") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "may") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "jun") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "jul") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "aug") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "sep") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "oct") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "nov") == 0)
		return (monthnum);
	monthnum++;
	if (strcmp (name, "dec") == 0)
		return (monthnum);
	return (0);
}
/*

Name:
	gettime

Function:
	To produce a character string of the form HHNN when passed a variety
of input strings representing the time.

Algorithm:
	Keep two buffers, one for alphabetic values and another for numeric
values.  Determine each character type and place it in the appropriate buffer.
If the character is a delimiter (e.g. a space) or a colon, simply skip it and
examine the next character.  Return with an error on any invalid character.
Convert the numeric buffer into an integer and return with error if it is over
2400.  Extract the hours and minutes from this combination time.  If there
are more than two characters in the alphabetic buffer (representing a.m. or
p.m.) return with error.  If the alphabetic buffer contains two characters,
the first being a 'p', increment the hour value by 12.  If the alphabetic
buffer contains two characters and the hour value is over 12, return with error.
If the alphabetic buffer is empty assume military time and do not modify hour
or minute values.  Build a string with the ascii conversions of these two
values.

Parameters:
	A character pointer representing a raw time format, one of the following:

	1) HH:NN a.m.  -- For morning times.  All spaces, colons, periods are 
	   ignored; order of alpha and numeric fields are irrelevant.  Therefore,
	   am1030 is also a valid parameter.

	2) HH:NN p.m. -- For evening times.

	3) HHNN -- Military 24 hour clock.  Delimiters and colons ignored.
	   This form may not include any alphabetic characters (a.m. or p.m.)

Returns:
	A pointer to a four character string, of the form HHMM.

Files and Programs:
	None.

History:


D 3
*/
E 3
I 3

E 3
char *gettime (rawtime)
char   *rawtime;
{
	static char     hourbuf[5];
	char   *hourptr = hourbuf;
	char    numbuf[10];
	char   *numptr = numbuf;
	char    alphabuf[5];
	char   *alphaptr = alphabuf;
	int     alphaindex  = 0;
	int     comb_time,
	        minutes,
	        hours;
	while (*rawtime)
		switch (typeof (*rawtime)) {
			case NUMER: 
				*numptr++ = *rawtime++;
				break;
			case ALPHA: 
				*alphaptr++ = *rawtime++;
				alphaindex++;
				break;
			case DELIM: 
			case COLON: 
				*rawtime++;
				break;
			default: 
				return (NULL);
		}
	*numptr = *alphaptr = '\0';
	if ((comb_time = atoi (numbuf)) >= 2400)
		return (NULL);
	else {
		hours = comb_time / 100;
		if ((minutes = comb_time - (hours * 100)) >= 60)
			return (NULL);
		if (alphaindex == 2) {
			if (hours > 12)
				return (NULL);
			else {
				if (hours == 12)
					hours = 0;
				if (alphabuf[0] == 'p')
					hours += 12;
			}
		}
		else
			if (alphaindex != 0)
				return (NULL);
		hourptr = copy (itoa (hours), hourptr);
		copy (itoa (minutes), hourptr);
	}
	return (hourbuf);
}
I 3

*/
E 3
E 1
