#
/*
Name:
	PRWIN Table Format Command

Function:
	Receives a table for an appointment or dolist and formats
	it for "tbl".

Algorithm:
	Decide if we're formatting a calendar or dolist table. Then construct
	the appropriate "tbl" commands. Output of prwin should be piped to
	"tbl", "nroff", "col" for formatting.

Parameters:
	fname   File name or "-" for stdin
	ttype   Table type...
		0 = appointment
		1 = dolist

Returns:
	ENOERR	Normal exit

Files and Programs:


History:
	Aug 82, Release 7 Version 2,J, Neyer...original version


*/
#include <stdio.h>
#include "../includes/getdef.h"
#include "../includes/error.h"

main(argc, argv)
int argc;
char *argv[];
{

	char line[CMDLEN];
	FILE *ifp;

	if (argc < 3)   {
		fprintf(stderr, "usage: prwin file/'-' type\n");
		exit(EFORM);
	}
	if (*argv[1] == '-')
		ifp = stdin;
	else
		if((ifp = fopen(*argv[1], "r")) == NULL)        {
			fprintf(stderr, "prwin: cannot open %s\n", *argv[1]);
			exit(EACCES);
		}
	printf(".TS\n");
	printf("tab(:) allbox;\n");
	if (*argv[2] == '0')
		printf("c c c\nl l l .\n");
	else
		printf("c c c c c c c c\nl l l l l l l l.\n");
	while ((fgets(line, MAXAP, ifp)) != NULL)
		printf("%s", line);
	printf(".TE\n");
	fclose(ifp);
}
