.\"		PUBMAC
.\"
.\"	MACROES FOR FORMATTING TEXT
.\"
.\"		Th.A. Zoethout
.\"
.\"	GENERAL PAGE CONTROL MACROES
.\"
.ps 7			\" for troff
.\"
.de TP			\" SET NUMBER OF FREE PAGES
.\"	.TP [$1]
.			\" $1 = number of free pages { 1 }
.			\" initially one free page
.nr TP 1
.if \\n(.$>0 .if \\$1>=0 .nr TP \\$1
.if \\n(nl<0 .Pn
.rm TP
..
.de PL			\" SET VERTICAL SIZES
.\"	.PL [ $1 [ $2 [$3] ] ]
.			\" $1 = paper size { 66 }
.			\" $2 = page size { $1-7 }
.			\" $3 = offset from top of paper { 3 }
.			\" constraints: $2+$3 <= $1
.\" The distance from the foot margin to the bottom of the
.\" paper (\n(Bd) is implicit { \n(PL - \n(Td - \n(Pl }
.ie \\n(.$>0 .nr PL \\$1
.el .nr PL 66
.ie \\n(.$>1 .nr Pl \\$2
.el .nr Pl \\n(PL-7
.if \\n(Pl>\\n(PL .Er F ".PL: page size(\\n(Pl) > paper size(\\n(PL)
.ie \\n(.$>2 .nr Td \\$3
.el .nr Td 3
.nr Bd \\n(PL-\\n(Td-\\n(Pl
.if \\n(Bd<=0 \
.	Er F ".PL: top offset(\\n(Td) + page size(\\n(Pl) > paper size(\\n(PL)
.pl \\n(PLv
.nr Tm \\n(Tdv+\\n(Ttu+\\n(Tsv
.nr Bm \\n(Bsv+\\n(Btu+\\n(Bdv
.ch Bm \\n(.pu-\\n(Bmu
.rr PL
.rr Pl
.rm PL
..
.de LL			\" SET HORIZONTAL SIZES
.\"	.LL [ $1 [$2] ]
.			\" $1 = line length { 66 }
.			\" $2 = footnote line length { $1*10/11 }
.nr LL 66
.if \\n(.$>0 .nr LL \\$1
.ll \\n(LLm
.lt \\n(LLm
.ev 1
.ll \\n(LLm
.lt \\n(LLm
.ev
.ie \\n(.$>1 .nr Lf \\$2
.el .nr Lf \\n(LL*10/11
..
.\"de PO		\" PAGE OFFSET
.\"	.PO [$1]
.			\" $1 = page offset in characters { 1 }
.\"ie \\n(.$>0 .po \\$1m
.\"el .po 1m
.rn po PO
.\".
.\"
.\"	MARGIN TEXT CONTROL
.\"
.de MT			\" MARGIN TEXT SETTINGS
.\"	.MT $1 [$2] [$3]
.			\" $1 = Top or Bottom
.			\" $2 = Even[Odd], All { no title }
.			\" $3 = Vertical spacing to/from text { 2 }
.ds Mc N
.if \&\\$1\&T\& .ds Mc T
.if \&\\$1\&B\& .ds Mc B
.if \&\\*(Mc\&N\& .Er W ".MT: unknown margin type. T assumed
.nr MT 2
.if \&\\*(Mc\&N\& .nr MT 1
.if \&\\*(Mc\&N\& .ds Mc T
.nr \\*(Mcc 0
.if \&\\$2\&E\& .nr \\*(Mcc 1
.if \&\\$2\&O\& .nr \\*(Mcc 1
.if \&\\$2\&A\& .nr \\*(Mcc 2
.if \\n(\\*(Mcc=0 .nr \\*(Mct 0v
.if \\n(\\*(Mcc>0 .nr MT +1
.nr \\*(Mcs 2
.if \\n(\\*(Mcc=0 .nr \\*(Mcs 0
.if \\n(MT<=\\n(.$ .nr \\*(Mcs \\$\\n(MT
.rr MT
.rm Mc
..
.de MS			\" SET MARGIN TEXT FOR TOP OR BOTTOM OF PAGE
.\"	.MS $1 [ $2 [$3] ]
.			\" $1 = Top or Bottom
.			\" $2 = Even pages, Odd pages, All pages { A }
.			\" $3 = vertical spacing to/from text { 2 }
.ds Mc N
.if \&\\$1\&T\& .ds Mc T
.if \&\\$1\&B\& .ds Mc B
.if \&\\*(Mc\&N\& .Er W ".MS: unknown margin type. T assumed
.nr MS 2
.if \&\\*(Mc\&N\& .nr MS 1
.if \&\\*(Mc\&N\& .ds Mc T
.nr \\*(Mcc 0
.if \&\\$\\n(MS\&E\& .nr \\*(Mcc 1
.if \&\\$\\n(MS\&O\& .nr \\*(Mcc 3
.if \&\\$\\n(MS\&A\& .nr \\*(Mcc 2
.if \\n(\\*(Mcc>0 .nr MS +1
.if \\n(\\*(Mcc=0 .nr \\*(Mcc 2
.nr \\*(Mcs 2
.if \\n(MS<=\\n(.$ .nr \\*(Mcs \\$\\n(MS
.ev 1
.ll \\n(LLm
.lt \\n(LLm
.if \\n(\\*(Mcc=1 .di \\*(Mce
.if \\n(\\*(Mcc=2 .di \\*(Mct
.if \\n(\\*(Mcc=3 .di \\*(Mco
.if \\n(\\*(Mcc=3 .nr \\*(Mcc 1
..
.de ME			\" END SPECIFICATION OF TOP/BOTTOM MARGIN TITLE
.\"	.ME
.ie \\n(MS=0 .Er W ".ME: no matching .MS
.el \{\
.br
.di
.cu 0
.ev
.nr \\*(Mct \\n(dn
.nr Tm \\n(Tdv+\\n(Ttu+\\n(Tsv
.nr Bm \\n(Bsv+\\n(Btu+\\n(Bdv
.ch Bm \\n(.pu-\\n(Bmu
.if \\n(Tmu+\\n(Bmu>=\\n(.pu \
.	Er F "top margin size + bottom margin size >= paper size
.rm Mc
.nr MS 0 \}
..
.de PN			\" SET FIRST PAGE NUMBER
.\"	.PN [ $1 [$2] ]
.			\" $1 = number of first page { 1 }
.			\" $2 = pagenumber format { 1 }
.ie \\n(.$>0 .nr PN \\$1
.el .nr PN 1
.ie \\n(.$>1 .ds Pa \\$2
.el .ds Pa 1
.if \\n(nl<0 .Pn
..
.de Pn			\" set page number
.if \\n(TP=0 .if \\n(PN>0 \{\
.pn \\n(PN
.af % \\*(Pa
.rm Pa
.nr PN 0\}
..
.\"
.\"	GLOBAL SIZE CONTROL
.\"
.de VS			\" SET DEFAULT VERTICAL SPACING
.\"	.VS [$1]
.			\" $1 = default vertical spacing { 1 }
.ie \\n(.$>0 .nr VS \\$1
.el .nr VS 1
..
.de ND			\" SET DEFAULT VERTICAL NEED
.\"	.ND [$1]
.			\" $1 = default need { 2 }
.ie \\n(.$>0 .nr ND \\$1
.el .nr ND 2
..
.de IN			\" SET DEFAULT INDENTATION
.\"	.IN [$1]
.			\" $1 = default indent { 3 }
.ie \\n(.$>0 .nr IN \\$1
.el .nr IN 3
..
.\"
.\"	TEXT PROCESSING MODES
.\"
.de AD			\" SET ADJUSTMENT
.\"	.AD [$1]
.			\" $1 = adjustment type L R C B { previous }
.if \&\\$1\&L\& .ad l
.if \&\\$1\&R\& .ad r
.if \&\\$1\&C\& .ad c
.if \&\\$1\&B\& .ad b
.if \&\\$1\&\& .ad
.ev 1
.if \&\\$1\&L\& .ad l
.if \&\\$1\&R\& .ad r
.if \&\\$1\&C\& .ad c
.if \&\\$1\&B\& .ad b
.if \&\\$1\&\& .ad
.ev
..
.de NA			\" NO ADJUSTMENT
.\"	.NA
.			\" .NA = .AD L
.na
.ev 1
.na
.ev
..
.de HY			\" HYPHENATION ON
.\"	.HY
.hy 7
.ev 1
.hy 7
.ev
..
.de NH			\" NO HYPHENATION
.\"	.NH
.nh
.ev 1
.nh
.ev
..
.de HC			\" SET HYPHENATION CHARACTER
.\"	.HC [$1]
.			\" $1 = hyphenation character { \% }
.ie \\n(.$>0 \{\
.ds Hc \\$1
.hc \\$1
.ev 1
.hc \\$1
.ev \}
.el \{\
.ds Hc \%
.hc
.ev 1
.hc
.ev \}
..
.\"
.\"	LOCAL SIZE CONTROL
.\"
.de BP			\" BEGIN PAGE
.rs
.sp 200v
.rs
..
.de N			\" NEW LINE
.\"	.N [$1]
.			\" $1 = preceeding vertical spacing { 0 }
.			\" needs \n(ND+$1 lines on the page
.ti \\n(.iu
.ie \\n(.$>0 .sp \\$1v
.el .br
.ne \\n(ND
.rs
..
.de A			\" NEW ALINEA
.\"	.A [ $1 [$2] ]
.			\" $1 = preceeding vertical spacing { 0 }
.			\" $2 = indent of first text line { \n(IN }
.			\" needs \n(ND+\$1 lines on the page
.ie \\n(.$>0 .sp \\$1v
.el .br
.ne \\n(ND
.ie \\n(.$=2 .ti +\\$2
.el .ti +\\n(IN
.rs
..
.de P			\" NEW PARAGRAPH
.\"	.P [ $1 [$2] ]
.			\" $1 = preceeding vertical spacing { 1 }
.			\" $2 = indent of first line { \n(IN }
.			\" .P $1 $2  =  .A $1 $2
.			\" needs \n(ND+\$1 lines on the page
.if \\n(.$=0 .A 1
.if \\n(.$=1 .A \\$1
.if \\n(.$=2 .A \\$1 \\$2
..
.de NE		\" NEED LINES
.	.NE [$1]
.			\" $1 = number of lines needed on page { \n(ND }
.br
.ie \\n(.$=0 .ne \\n(NDv
.el .ne \\$1v
.rs
..
.\"	DATES
.\"
.de TA			\" SET TAB POSITIONS
.\"	.TA [ $1 ... ]
.			\" $1 ... = tab positions { 9 17 25 33 41 49 57 65 73 }
.if \\n(.$=0 .ta 9 17 25 33 41 49 57 65 73
.if \\n(.$>0 .ta \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
..
.de SP			\" SET UNPADDABLE SPACE CHARACTER
.\"	.SP [$1]
.			\" $1 = unpaddable space character { none }
.			\" initially set to ~
.\\*(Sp
.if \\n(.$>0 .ds Sp "tr \\$1
.if \\n(.$>0 .\\*(Sp
.if \\n(.$>0 .as Sp "\\$1
..
.de IS			\" INDENTATION START
.\"	.IS [ $1 [ $2 [$3] ] ]
.			\" $1 = indent from left margin { \n(IN }
.			\" $2 = indent from right margin { 0 }
.			\" $3 = preceeding vertical spacing { 0 }
.ie \\n(IS>0 .Er W ".IS: nesting not allowed
.el \{\
.if \\n(.$>2 \{\
.sp \\$3v
.rs \}
.nr IE \\n(.l
.if \\n(.$>1 .ll -\\$2m
.nr UN \\n(.i
.if \\n(.$=0 .in +\\n(IN
.if \\n(.$>0 .in +\\$1
.nr IS 1 \}
..
.de UN			\" TEMPORARILY UNDENT
.\"	.UN [$1]
.			\" $1 = undent { \n(UN }
.if \\n(.$=0 .if \\n(IS>0 .ti \\n(UNu
.if \\n(.$=0 .if \\n(IS=0 .Er W ".UN: no matching .IS
.if \\n(.$>0 .if \\$1m>=\\n(.iu .ti 0
.if \\n(.$>0 .if \\$1m<\\n(.iu .ti -\\$1m
..
.de IE			\" INDENTATION END
.\"	.IE [$1]
.			\" $1 = succeeding vertical spacing { 0 }
.ie \\n(IS=0 .Er W ".IE: no matching .IS
.el \{\
.nr IS 0
.in \\n(UNu
.ll \\n(IEu
.if \\n(.$>0 \{\
.sp \\$1v
.rs \}
.rr UN
.rr IE \}
..
.\"
.\"	LOCAL TEXTPROCESSING CONTROL
.\"
.de CS			\" START CENTERED NONFILLED TEXT
.\"	.CS [$1]
.			\" $1 = preceding vertical spacing { 0 }
.nr CS 1
.if \\n(.$>0 .sp \\$1v
.ce 1000
..
.de CE			\" END CENTERED NONFILLED TEXT
.\"	.CE [$1]
.			\" $1 = succeeding vertical spacing
.if \\n(CS=0 .Er W ".CE: no matching .CS
.nr CS 0
.ce 0
.if \\n(.$>0 .sp \\$1v
..
.de C			\" CENTER WORDS
.\"	.C $1 ...
.			\" $1 ... = words to be centered
.if \\n(.$>0 \{\
.Ct \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.ce 1
\&\\*(St
.rm St
.if \\n(CS>0 .ce 1000 \}
..
.de US			\" START UNDERLINED TEXT
.\"	.US [$1]
.			\" $1 = Underl., Continuous underl. (non-filled) { U }
.nr US 2
.if \&\\$1\&C\& .nr US 1
.if \\n(US=1 .cu 1000
.if \\n(US=2 .ul 1000
..
.de UE			\" END UNDERLINED TEXT
.\"	.UE
.if \\n(US=0 .Er W ".UE: no matching .US
.if \\n(US=1 .cu 0
.if \\n(US=2 .ul 0
.nr US 0
..
.de U			\" UNDERLINE WORDS
.\"	.U $1 ...
.			\" $1 ... = words to be underlined
.if \\n(.$>0 .ds St "\\*(Hc\l#\w\&\\$1\&u\(ul#\h#-\w\&\\$1\&u#\\$1
.if \\n(.$>1 .as St " \\*(Hc\l#\w\&\\$2\&u\(ul#\h#-\w\&\\$2\&u#\\$2
.if \\n(.$>2 .as St " \\*(Hc\l#\w\&\\$3\&u\(ul#\h#-\w\&\\$3\&u#\\$3
.if \\n(.$>3 .as St " \\*(Hc\l#\w\&\\$4\&u\(ul#\h#-\w\&\\$4\&u#\\$4
.if \\n(.$>4 .as St " \\*(Hc\l#\w\&\\$5\&u\(ul#\h#-\w\&\\$5\&u#\\$5
.if \\n(.$>5 .as St " \\*(Hc\l#\w\&\\$6\&u\(ul#\h#-\w\&\\$6\&u#\\$6
.if \\n(.$>6 .as St " \\*(Hc\l#\w\&\\$7\&u\(ul#\h#-\w\&\\$7\&u#\\$7
.if \\n(.$>7 .as St " \\*(Hc\l#\w\&\\$8\&u\(ul#\h#-\w\&\\$8\&u#\\$8
.if \\n(.$>8 .as St " \\*(Hc\l#\w\&\\$9\&u\(ul#\h#-\w\&\\$9\&u#\\$9
.if \\n(.$>0 \\*(St
.rm St
..
.de CU			\" CONTINUOUS UNDERLINE WORDS
.\"	.CU $1 ...
.			\" $1 ... = words to be underlined
.if \\n(.$>0 \{\
.Ct \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
\\*(Hc\l#\w\&\\*(St\&u\(ul#\h#-\w\&\\*(St\&u#\\*(St
.rm St \}
..
.de UW			\" UNDERLINE WORD
.\"	.UW [ [$1] ) $2 ( $3 [ $4 [ $5 [ $6 [ $7 [ $8 [$9]]]]]] ]
.			\" $1 = non-underlined prefix
.			\" $2 = word to be underlined
.			\" $3 = non-underlined suffix
.			\" $4 $6 $8 = underlined tail
.			\" $5 $7 $9 = non-underlined tail
.if \\n(.$=1 .ds St "\\*(Hc\l#\w\&\\$1\&u\(ul#\h#-\w\&\\$1\&u#\\$1
.if \\n(.$=2 .ds St "\\*(Hc\l#\w\&\\$1\&u\(ul#\h#-\w\&\\$1\&u#\\$1\\$2
.if \\n(.$>2 .ds St "\\*(Hc\\$1\l#\w\&\\$2\&u\(ul#\h#-\w\&\\$2\&u#\\$2\\$3
.if \\n(.$>3 .as St "\l#\w\&\\$4\&u\(ul#\h#-\w\&\\$4\&u#\\$4
.if \\n(.$>4 .as St "\\$5
.if \\n(.$>5 .as St "\l#\w\&\\$6\&u\(ul#\h#-\w\&\\$6\&u#\\$6
.if \\n(.$>6 .as St "\\$7
.if \\n(.$>7 .as St "\l#\w\&\\$8\&u\(ul#\h#-\w\&\\$8\&u#\\$8
.if \\n(.$>8 .as St "\\$9
.if \\n(.$>0 \\*(St
.rm St
..
.de BS			\" EMBOLDING START
.ie \\n(BS>0 .Er W ".BS: nesting not allowed
.el \{\
.ft B
.nr BS 1 \}
..
.de BE			\" EMBOLDING END
.ie \\n(BS=0 .Er W ".BE: no matching .BS
.el \{\
.ft R
.nr BS 0 \}
..
.de B			\" EMBOLDEN WORDS
.\"	.B $1 ...
.			\" $1 ... = words to be emboldened
.if \\n(.$>0 .ds St "\\*(Hc\\$1\h#2u-\w\&\\$1\&u#\\$1
.if \\n(.$>1 .as St " \\*(Hc\\$2\h#2u-\w\&\\$2\&u#\\$2
.if \\n(.$>2 .as St " \\*(Hc\\$3\h#2u-\w\&\\$3\&u#\\$3
.if \\n(.$>3 .as St " \\*(Hc\\$4\h#2u-\w\&\\$4\&u#\\$4
.if \\n(.$>4 .as St " \\*(Hc\\$5\h#2u-\w\&\\$5\&u#\\$5
.if \\n(.$>5 .as St " \\*(Hc\\$6\h#2u-\w\&\\$6\&u#\\$6
.if \\n(.$>6 .as St " \\*(Hc\\$7\h#2u-\w\&\\$7\&u#\\$7
.if \\n(.$>7 .as St " \\*(Hc\\$8\h#2u-\w\&\\$8\&u#\\$8
.if \\n(.$>8 .as St " \\*(Hc\\$9\h#2u-\w\&\\$9\&u#\\$9
.if \\n(.$>0 \\*(St
.rm St
..
.de BW			\" EMBOLDEN WORD
.\"	.BW [ [$1] ) $2 ( $3 [ $4 [ $5 [ $6 [ $7 [ $8 [$9]]]]]] ]
.			\" $1 = non-emboldened prefix
.			\" $2 = word to be emboldened
.			\" $3 = non-emboldened suffix
.			\" $4 $6 $8 = emboldened tail
.			\" $5 $7 $9 = non-emboldened tail
.if \\n(.$=1 .ds St \\$1\h#2u-\w\&\\$1\&u#\\$1
.if \\n(.$=2 .ds St \\$1\h#2u-\w\&\\$1\&u#\\$1\\$2
.if \\n(.$>2 .ds St \\$1\\$2\h#2u-\w\&\\$2\&u#\\$2\\$3
.if \\n(.$>3 .as St \\$4\h#2u-\w\&\\$4\&u#\\$4
.if \\n(.$>4 .as St \\$5
.if \\n(.$>5 .as St \\$6\h#2u-\w\&\\$6\&u#\\$6
.if \\n(.$>6 .as St \\$7
.if \\n(.$>7 .as St \\$8\h#2u-\w\&\\$8\&u#\\$8
.if \\n(.$>8 .as St \\$9
\\*(Hc\\*(St
.rm St
..
.\"	PAGE CONTROL SUPPORT
.\"
.de Tm			\" top margin trap macro
.ie \\n(Fl=0 .ch Bm \\n(.pu-\\n(Bmu
.el .Ft 		\" process footnote
.ev 1
.sp \\n(Tdv
.if \\n(TP=0 .Mm T
.ev
.if \\n(TP=0 .ns
.\"if \\n(TS>0 .T1	\" process table overflow
..
.de Bm			\" bottom margin trap macro
.ch Id
.if \\n(Fl>0 .Fb	\" process footnotes
.ev 1
.if \\n(TP=0 .Mm B
.ev
.if \\n(TP>0 \{\
.nr TP -1
.if \\n(TP=0 .if \\n(PN=0 .ds Pa 1
.if \\n(TP=0 .if \\n(PN=0 .nr PN 1 \}
.Pn
'bp
.if \\n(Fl>1 'br	\" footnote overflow from last page
..
.de Mm			\" output margin
.			\" $1 = Top, Bottom
.ll \\n(LL
.lt \\n(LL
.nr Mm \\n(.i
.in 0
'nf
.pc %
.if \&\\$1\&B\& .sp \\n(Bsv
.if \\n(\\$1c=1 .if e .\\$1e
.if \\n(\\$1c=2 .\\$1t
.if \\n(\\$1c=1 .if o .\\$1o
.if \&\\$1\&T\& .sp \\n(Tsv
'fi
.in \\n(Mmu
.rr Mm
..
.\"
.\"	PRESET MARGIN TEXTS
.\"
.rn tl TL		\" TITLE REQUEST renamed
.\"
.de Tt			\" title at top of page
.TL \&\&-- % --\&\&
..
.de Te			\" title at top of even page
.TL \&%\&\&\&
..
.de To			\" title at top of odd page
.TL \&\&\&%\&
..
.de Bt			\" title at bottom of page
.TL \&\&-- % --\&\&
..
.de Be			\" title at bottom of even page
.TL \&%\&\&\&
..
.de Bo			\" title at bottom of odd page
.TL \&\&\&%\&
..
.\"
.\"	ERROR MESSAGE MACRO
.\"
.de Er			\" errors
.\"	.Er $1 $2
.			\" $1 = Waring/Fatal
.			\" $2 = error message
.nr Er \\n(nl/40
.tm Error (p=\\n%, l=\\n(Er) \\$2
.lt \\n(.lu+10m
.TL \&\r\&\&+++ Error\&
.lt \\n(LLm
.if \&\\$1\&F\& .br
.if \&\\$1\&F\& .fl
.if \&\\$1\&F\& .ex
.rr Er
..
.\"
.\"	OTHER SERVICE MACROES
.\"
..
.de Cr			\" Check for non-overlapping constructs
.if \\n(PS>0 \{\
.	Er W "Points not closed
.Pe \}
.if \\n(FS>0 \{\
.	Er W "Footnote not closed
.FE \}
.if \\n(DS>0 \{\
.	Er W "Display not closed
.DE \}
.if \\n(IS>0 \{\
.	Er W "Indentation not closed
.IE \}
.if \\n(CS>0 \{\
.	Er W "Centered text not closed
.CE \}
.if \\n(US>0 \{\
.	Er W "Underlined text not closed
.UE \}
.if \\n(BS>0 \{\
.	Er W "Embolded text not closed
.BE \}
.if \\n(RS>0 \{\
.	Er W "Reference not closed
.RE \}
..
.de Ct			\" catenate arguments
.			\" $1 ... = to be glued with unpaddable space
.ds St \\$1
.if \\n(.$>1 .as St \ \\$2
.if \\n(.$>2 .as St \ \\$3
.if \\n(.$>3 .as St \ \\$4
.if \\n(.$>4 .as St \ \\$5
.if \\n(.$>5 .as St \ \\$6
.if \\n(.$>6 .as St \ \\$7
.if \\n(.$>7 .as St \ \\$8
.if \\n(.$>8 .as St \ \\$9
..
.\"
.\"	INITIALIZATION
.\"
.nr PL 66		\" default paper size
.nr Pl \n(PL-7		\" default page length
.pl \n(PL
.nr LL 66		\" default line length
.ll \n(LL
.ev 1
.ll \n(LL
.ev
.nr Td 3		\" offset from top of paper
.nr Bd 4		\" offset from bottom of paper
.nr MS 0		\" margin title setting indicator
.nr Tt 1v		\" length of top title { no title }
.nr Tc 0		\" case of top title { no title }
.nr Ts 2		\" vertical spacing succeeding top title
.nr Bt 1v		\" length of bottom title
.nr Bc 2		\" case of bottom title { ALL }
.nr Bs 2		\" vertical spacing preceeding bottom title
.nr PN 1		\" other pagenumber indicator { first pagenumber = 1 }
.nr TP 1		\" first page is not numbered
.nr VS 1		\" default vertical spacing
.nr ND 2		\" default need
.nr IN 3		\" default indent
.ds Hc \%
.nr IS 0		\" indent indicator
.nr CS 0		\" center indicator
.nr US 0		\" underline indicator
.nr BS 0		\" bold indicator
.nr Tm \n(Tdv+\n(Ttu+\n(Tsv	\" place of first text on page
.wh 0 Tm		\" set top margin trap macro
.nr Bm \n(Bsv+\n(Btu+\n(Bdv	\" place of last text + 1 line on page
.wh \n(.pu-\n(Bmu Bm
.			\" unpaddable space
.ds Sp "tr ~
.tr ~
.as Sp ~
.em Cr			\" check for non-closed constructs at end of input
.\"
.de At			\" parameterpassing macro
.	.At $1...
.if \\n(.$>=1 .as $0 " \\$1
.if \\n(.$>=2 .as $0 " \\$2
.if \\n(.$>=3 .as $0 " \\$3
.if \\n(.$>=4 .as $0 " \\$4
.if \\n(.$>=5 .as $0 " \\$5
.if \\n(.$>=6 .as $0 " \\$6
.if \\n(.$>=7 .as $0 " \\$7
.if \\n(.$>=8 .as $0 " \\$8
.if \\n(.$>=9 .as $0 " \\$9
..
.\"
.\"	CATCH MACROES FOR SECTIONS file /usr/local/lib/pubmac.q1
.\"
.de RP
.ds $0 RP
.so /usr/local/lib/pubmac/tmac.q1
..
.de SN
.ds $0 SN
.At \\$1 \\$2 \\$3 \\$4 \\$5
.so /usr/local/lib/pubmac/tmac.q1
..
.de SM
.ds $0 SM
.At \\$1 \\$2 \\$3 \\$4
.so /usr/local/lib/pubmac/tmac.q1
..
.de S1
.ds $0 S1
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q1
..
.de S2
.ds $0 S2
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q1
..
.de S3
.ds $0 S3
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q1
..
.de S4
.ds $0 S4
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q1
..
.de AP
.ds $0 AP
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q1
..
.\"	CATCH MACROES FOR POINTS file /usr/local/lib/pubmac.q2
.\"
.de PM
.ds $0 PM
.At \\$1
.so /usr/local/lib/pubmac/tmac.q2
..
.de PS
.ds $0 PS
.At \\$1 \\$2 \\$3 \\$4
.so /usr/local/lib/pubmac/tmac.q2
..
.nr PS 0
.\"	CATCH MACROES FOR DISPLAYS file /usr/local/lib/pubmac.q3
.\"
.de DB
.ds $0 DB
.At \\$1
.so /usr/local/lib/pubmac/tmac.q3
..
.de DS
.ds $0 DS
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8
.so /usr/local/lib/pubmac/tmac.q3
..
.nr DS 0
.\"	CATCH MACROES FOR FOOTNOTES file /usr/local/lib/pubmac.q4
.\"
.de FN
.ds $0 FN
.At \\$1 \\$2
.so /usr/local/lib/pubmac/tmac.q4
..
.de FS
.ds $0 FS
.At \\$1 \\$2 \\$3
.so /usr/local/lib/pubmac/tmac.q4
..
.nr FS 0
.nr Fl 0
.nr Lf \n(LL*10/11
.\"	CATCH MACRO FOR EQUATIONS file /usr/local/lib/pubmac.q5
.\"
.de EQ
.ds $0 EQ
.At \\$1 \\$2 \\$3 \\$4
.so /usr/local/lib/pubmac/tmac.q5
..
.\"	CATCH MACROES FOR TABLES file /usr/local/lib/pubmac.q6
.\"
.de TS
.ds $0 TS
.At \\$1 \\$2
.so /usr/local/lib/pubmac/tmac.q6
..
.\"nr TS 0
.\"	CATCH MACROES FOR BIBLIGRAPHIC REFERENCES file /usr/local/lib/pubmac.q7
.\"
.de RS
.ds $0 RS
.At \\$1 \\$2 \\$3
.so /usr/local/lib/pubmac/tmac.q7
..
.de RF
.ds $0 RF
.At \\$1
.so /usr/local/lib/pubmac/tmac.q7
..
.nr RS 0
.\"	CATCH MACROES FOR INDEX REFERENCES file /usr/local/lib/pubmac.q8
.\"
.de IX
.ds $0 IX
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q8
..
.de IW
.ds $0 IW
.At \\$1 \\$2 \\$3
.so /usr/local/lib/pubmac/tmac.q8
..
.de IR
.ds $0 IR
.At \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.so /usr/local/lib/pubmac/tmac.q8
..
