.\"	Copyright 1990 Jeff S. Young
.\"
.\"	Permission is given to copy and distribute for non-profit purposes.
.\"
.TH XMAHJONGG 6 "Contrib" "X Version 11 Release 4"
.SH NAME
xmahjongg \- X11R4 version of the solitaire mahjongg game
.SH SYNOPSIS
.B xmahjongg
[ \fB-b \fI###\fR ] [ \fB-n \fI###\fR ] [ \fB-r\fR ] [ \fB-s\fR ]
[ \fB-d \fIdisplay\fR ] [ \fB-c\fR ] [ \fB-l \fIfile\fR ]
[ \fB-p \fIname@machine\fR ] [ \fI...\fR ] [ \fB-p \fIname@machine\fR ]
.SH DESCRIPTION
.I Mah jongg
is an ancient chinese game usually played by four players with tiles similar
to dominos.  This is an X windows version for the solitaire game originally
seen on the PC and later ported to SunView.  It also has a new tournament 
option.
.SH THEORY OF PLAY
The object of the game is to remove all the tiles from the board.  Tiles are
removed in by matching two identical tiles which have either an open left
edge or open right edge.  The only exception to this rule is that any open
"flower" tile (bamboo, orchid, plum, or chrysanthemum) matches any other 
open "flower" tile and any open "season" tile (spring, summer, autumn, or 
winter) matches any other open "season" tile.
.PP
The display has two distinct areas: the playing field and the control field.
.PP
The bottom area is the playing field.  To remove a pair of tiles, click a mouse
button on a tile (which will light up) and then click a mouse button on the 
matching tile.  At this point, both tiles will disappear from the board.  If 
after selecting the first tile, you decide that you don't wish to play that 
tile, simply reclick the button on the tile.
.PP
The top area is the control field.  The board number and the number of remaining
tiles are on the left side of the board.  The right side has some options 
for controlling the game.  To select an option, click a mouse button on it.
\fI      SAME \fR
Start the same game again.  This option is disabled in tournament mode.
\fI      NEW \fR
Start a new game.
\fI      DONE \fR
Check to see if you missed any matches.  When you think that you don't have any
more matches left, clicking "DONE" will tell you the number of matches which 
you missed.  If you missed some, you can continue play, but your score will
not change.  The "DONE" field stays high-lighted to show that you have already 
tried this option.
\fI      QUIT \fR
Exit the game.
.SH OPTIONS
.IP \fB\-b \fR
Start the game with board number ###. Board numbers range from 1 to 99999.
.IP \fB\-d \fR
Use the given display name instead of the current default.
.IP \fB\-n \fR
Number of games to play in tournament mode.  See below.
.IP \fB\-r\fR
Reverse video mode.
.IP \fB\-s\fR
Setup mode.  See below.
.IP \fB\-c\fR
Color mode based on tile type.  Normally color is based on the level the piece
is on.
.IP \fB\-l\fR
Use a different layout file.  The default is the standard layout in the shape
of a pyramid.
.IP \fB\-p \fR
Set up a tournament with the specified player on the specified machine.
.SH TOURNAMENT MODE
Using the [  \fI -p \fR ] parameter starts a tournament.  In this mode
several players can compete on a series of boards.  The players should agree
in advance on a starting board number.  The default tournament is three games,
although this can be changed with the [ \fI -n \fR ] parameter.  If another
player clicks "DONE" then, their score will be highlighted for that game.
The tournament winner is the player with the lowest total score over the series.
.br
   
.br
Example:
.br
Three users ('abc' on 'xyzzy', 'def' on 'plugh', and 'ghi' on 'plover') wish
to play a 5 game tournament starting with board 12345.
Here are their command lines:
.br
   
.br
      'abc' types:    xmahjongg -b 12345 -n 5 -p def@plugh -p ghi@plover
.br
      'def' types:    xmahjongg -b 12345 -n 5 -p abc@xyzzy -p ghi@plover
.br
      'ghi' types:    xmahjongg -b 12345 -n 5 -p def@plugh -p abc@xyzzy
.br
   
.br
Note that the players can be in any order on the command line and that the
user does not list his/her own name on the command line.
.SH SETUP MODE
Using the [ \fB -s \fR ] parameter allows a user to configure his/her own
layout.  If the [ \fB -l \fR ] parameter is used, then the output is written
into the specified file, else the output is dumped to standard out.  In
setup mode, the left button will create a tile position where specified.  
Any other button will delete the specified tile position.  The "DONE" 
option will dump the layout only if there are no more tiles to place.  The
"NEW" option will clear the board to start designing a new layout.  The
"SAME" option does not do anything.  "QUIT", as usual, quits.  The following
example demonstrates setup mode:
.br

.br
	xmahjongg -s -l test	(this will create a layout called 'test')
.br
	xmahjongg -l ./test	(this will play the just created layout)
.br

.br
.SH FILES
/usr/share/local/X11/lib/xmahjongg contains some layouts.
.SH AUTHOR
Copyright 1990 Jeff S. Young
.br
<jsy@cray.com>
.br

.br
The tiles themselves are copyright 1988 by Mark A. Holm 
<tektronix!tessi!exc!markh>.  His copyright notice is included in the 
source code.
.SH BUGS
Doesn't use the Xdefault information.
.PP
No permanent score file.
.PP
You cannot have the same user name for two different players in a tournament.
.PP
Uses sockets for tournament mode.
.PP
Doesn't read the layout file in setup mode.  
