/*
	This demo program displays a Product Overview for the SUN
	workstation.
	*/
/*---------------------------*/
#include <usercore.h>
	short axl[100], bxl[100], ayl[100], byl[100], na, nb;
	int x0 = 500, y0 = 600;
	float cdx[] = { 2.,3.,4.,3.,2.,1.,0. };
	float cdy[] = { 0.,-1.,-2.,-3.,-4.,-3.,-2. };
	int suncolor();
main()
{
	if (initialize_core( DYNAMICC, SYNCHRONOUS,THREED)) exit(0);
	if (initialize_view_surface( suncolor, FALSE)) exit(1);
	select_view_surface( suncolor);
	set_viewport_2( 0., 1., 0., .75);
	set_window( 0., 1023., 200., 1000.);
	set_output_clipping( TRUE);
	
	create_temporary_segment();
	    set_charprecision( CHARACTER);
	    set_font(3);  set_charsize(30.,30.);
	    set_text_index( 63);
	    move_abs_2( 250., 950.);
	    text("Sun Workstation");
	    draw_boxes();
	    draw_lines();
	    draw_text();
	    features();
	close_temporary_segment();
	sleep( 60);
	}
/*--------------------------------*/
draw_boxes()
{
	set_line_index( 127);
	set_linewidth( .4);
	dbox( 65,500,400,800);		/* boundary */
	dbox( 120,520,70,130);		/* SMD disk controller */
	dbox( 490,520,70,130);		/* 9-track tape controller */
	dbox( 120,715,125,320);		/* Processor */
	dbox( 490,680,70,130);		/* Display controller */
	dbox( 490,790,70,130);		/* Display 1024 by 800 17" landscape */
	dbox( 680,680,70,130);		/* Ethernet controller */
	dbox( 140,740,55,65);		/* 68000 68010 CPU */
	dbox( 240,740,55,65);		/* virtual memory MMU */
	dbox( 340,740,55,65);		/* main memory .5 - 2MB */
	}
/*--------------------------------*/
draw_lines()
{
	set_line_index( 127);
	set_linewidth( .4);
	move_abs_2( 195.,605.); line_abs_2( 195.,636.);		/* SMD */
	move_abs_2( 565.,605.); line_abs_2( 565.,636.);		/* Tape */
	move_abs_2( 282.,640.); line_abs_2( 282.,700.);		/* Proc */
	move_abs_2( 565.,640.); line_abs_2( 565.,665.);		/* Disp cont */
	move_abs_2( 755.,640.); line_abs_2( 755.,665.);		/* Ether cont */
	move_abs_2( 755.,765.); line_abs_2( 755.,796.);		/* Disp */
	move_abs_2( 565.,765.); line_abs_2( 565.,775.);
	move_abs_2( 280.,550.); line_rel_2( 40.,0.);
	move_abs_2( 650.,570.); line_rel_2( 40.,0.);
	move_abs_2( 650.,550.); line_rel_2( 40.,0.);
	set_charprecision( STRING);
	set_font(1);
	set_text_index( 1);
	move_abs_2( 320.,560.); text(" 80 MB Disk");
	move_abs_2( 690.,580.); text(" 1600 bpi Tape");
	move_abs_2( 690.,560.); text(" Archive Tape");
	}
draw_text()
{
	set_charprecision( CHARACTER);
	set_font( ROMAN);  set_charsize( 15.,15.);
	set_text_index( 255);
	move_abs_2( 170.,830.); text("Processor");
	set_text_index( 191);
	set_line_index( 191);
	set_font( SCRIPT);
	set_linewidth( .8);
	move_abs_2( 680.,820.); text("Ethernet");
	move_abs_2( 680.,800.); line_rel_2( 160.,0.);

	move_abs_2( 120.,660.); text("796-Bus");
	move_abs_2( 120.,640.); line_rel_2( 720.,0.);

	set_charprecision( STRING);
	set_font( GREEK);
	set_text_index( 1);
	move_abs_2( 145.,785.); text("68000");
	move_abs_2( 145.,765.); text("68010");
	move_abs_2( 145.,745.); text(" CPU");

	move_abs_2( 135.,570.); text("SMD Disk");
	move_abs_2( 135.,550.); text("Controller");

	move_abs_2( 505.,570.); text(" Tape");
	move_abs_2( 505.,550.); text("Controller");

	move_abs_2( 500.,740.); text("Color");
	move_abs_2( 500.,720.); text("Display");
	move_abs_2( 500.,700.); text("640 x 480");

	move_abs_2( 500.,850.); text("Bitmap");
	move_abs_2( 500.,830.); text("Display");
	move_abs_2( 500.,810.); text("1024 x 800");

	move_abs_2( 690.,730.); text("Ethernet");
	move_abs_2( 690.,710.); text("Controller");

	move_abs_2( 245.,790.); text("virt");
	move_abs_2( 245.,770.); text("memory");
	move_abs_2( 245.,750.); text(" MMU");

	move_abs_2( 345.,790.); text("main");
	move_abs_2( 345.,770.); text("memory");
	move_abs_2( 345.,750.); text("1-2MB");
	}
/*--------------------------------*/
dbox( x,y,h,w) short x,y,h,w;
{
	int i;
	move_abs_2( (float)x, (float)y);
	line_rel_2( 0., (float)h);
	for (i=0; i<7; i++) line_rel_2( -cdy[i],cdx[i]);
	line_rel_2( (float)w, 0.);
	for (i=0; i<7; i++) line_rel_2( cdx[i],cdy[i]);
	line_rel_2( 0.,(float)(-h));
	for (i=0; i<7; i++) line_rel_2( cdy[i],-cdx[i]);
	line_rel_2( (float)(-w),0.);
	for (i=0; i<7; i++) line_rel_2( -cdx[i],-cdy[i]);
	}
/*-----------------------------------*/
features()
{
	set_charprecision( STRING);
	set_font( GREEK);
	set_text_index( 1);
	move_abs_2( 40.,450.);
	text("- Processor        68000/68010, 10MHz");
	move_abs_2( 40.,425.);
	text("- Virtual Memory   2MB per process, 16 processes");
	move_abs_2( 40.,400.);
	text("- Network          10 Mb/sec Ethernet, 3 Mb/sec Ethernet");
	move_abs_2( 40.,375.);
	text("- Software         Berkeley UNIX 4.2 (1Q83), Unisoft V7 UNIX");
	move_abs_2( 40.,350.);
	text("                   CORE Standard Graphics");
	move_abs_2( 40.,325.);
	text("                   VT100/4014 Emulators (PROM)");
	move_abs_2( 40.,300.);
	text("- Peripherals      Color display, SMD disk controller, Mouse");
	}
