
     NAME
          isalpha, isupper, islower, isdigit, isxdigit, isalnum,
          isspace, ispunct, isprint, isgraph, iscntrl, isascii -
          classify characters

     SYNTAX
          #include <ctype.h>

          int isalpha (c)
          int c;

          . . .

     DESCRIPTION
          These macros classify character-coded integer values by
          table lookup.  Each is a predicate returning nonzero for
          true, zero for false.  Isascii is defined on all integer
          values; the rest are defined only where isascii is true and
          on the single non-ASCII value EOF (-1 - see stdio.m).

          isalpha        c is a letter.

          isupper        c is an upper-case letter.

          islower        c is a lower-case letter.

          isdigit        c is a digit [0-9].

          isxdigit       c is a hexadecimal digit [0-9], [A-F] or [a-
                         f].

          isalnum        c is an alphanumeric (letter or digit).

          isspace        c is a space, tab, carriage return, new-line,
                         vertical tab, or form-feed.

          ispunct        c is a punctuation character (neither control
                         nor alphanumeric).

          isprint        c is a printing character, code 040 (space)
                         through 0176 (tilde).

          isgraph        c is a printing character, like isprint
                         except false for space.

          iscntrl        c is a delete character (0177) or an ordinary
                         control character (less than 040).

          isascii        c is an ASCII character, code less than 0200.

     DIAGNOSTICS
          If the argument to any of these macros is not in the domain
          of the function, the result is undefined.

     SEE ALSO
          stdio.m, ascii.m

          (printed 07/29/92 - J B Systems)

