
     Name
          grep - Searches a file for a pattern.

     Syntax
          grep [ -bchlnsvy ] [ expression ] [ files ]

     Description
          Commands of grep search the input files (standard input
          default) for lines matching a pattern. Normally, each
          line found is copied to the standard output. grep patterns
          are limited regular expressions; it uses a compact
          nondeterministic algorithm. The following options are
          recognized:

          -v All lines but those matching are displayed.

          -c Only a count of matching lines is displayed.

          -l Only the names of files with matching lines are
             displayed, separated by newlines.

          -h Prevents the name of the file containing the matching
             line from being appended to that line. Used when
             searching multiple files.

          -n Each line is preceded by its relative line number in
             the file.

          -b Each line is preceded by the block number on which it
             was found.  This is sometimes useful in locating disk
             block numbers by context.

          -s Suppresses error messages produced for nonexistent or
             unreadable files.  Note that the -s option will not
             suppress error messages generated by the -f option.

          -y Turns on matching of letters of either case in the
             input so that case is insignificant.

          -e expression
             Same as a simple expression argument, but useful when
             the expression begins with a dash (-).

          -f file
             The regular expression for grep.

          In all cases, the filename is output if there is more than
          one input file.  Care should be taken when using the
          characters $, *, [, ^, |, (, ), and \ in expression, because
          they are also meaningful to the shell.  It is safest to
          enclose the entire expression argument in single quotation
          marks.

          -    A regular expression followed by a plus sign (+)
               matches one or more occurrences of the regular
               expression.

          -    A regular expression followed by a question mark (?)
               matches 0 or 1 occurrences of the regular expression.

          -    Two regular expressions separated by a vertical bar (|)
               or by a newline match strings that are matched by
               either regular expression.

          -    A regular expression may be enclosed in parentheses ()
               for grouping.

          The order of precedence of operators is [], then *?+, then
          concatenation, then the backslash (\) and the newline.

     See Also
          sed.m, sh.m

     Diagnostics
          Exit status is 0 if any matches are found, 1 if none, 2 for
          syntax errors or inaccessible files.

     Notes
          Lines are limited to 254 characters; longer lines are
          truncated.

          When using grep with the -y option, the search is not made
          totally case insensitive in character ranges specified
          within brackets.

          This command is not usable for lower case searching unless
          the option lower command is issued to TSM when run
          interactively.


          (printed 5/7/94 - J B Systems)

