/* temp.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 * Management of temporary storage
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: temp.c,v 5.5 89/05/12 12:53:05 pcc Rel-3_0 $";
/* static char ID[] = "@(#)temp.c	15.1	of 86/10/25"; */
#endif

#include <cmanifest.h>
#include <bool.h>
#include <instruct.h>
#include <temp.h>
#include <assert.h>
#include <identifier.h>
#include <pcc.h>		/* allocation submodule */

/*
 * Export
 */

/* 
 *	For optimizer created internal (e.g., TNAME, LTEMP) temporaries,
 *	this is the next value to be used as the cookie.
 */

int NextTempId = 0;		/* id cookie for temps */

/*
 *	For LNAMEs (created by PCO or coming from pass 1), this is the
 *	largest cookie so far.  It is initialized in readero to the
 *	largest cookie seen.
 */

int NextLocalId = 0;

/*
 * Import
 */

int TempDebug = 0;

/*
 * Local
 */

#define	TempNameLen	50	/* Max length of a created identifier */

/*
 *	Forward
 */

#define NextCookie(op)	((op) == LNAME) ? NextLocalId : NextTempId

static int
MakeCookie(op)
	Operator op;
{
	if (op == LNAME)
		return NextLocalId++;
	else
		return NextTempId++;
}

/*
 *	Create a variable of type ty.  It is entered in the symbol
 *	table.  The tree is attached, and the name is entered.
 */

Identifier
GetTemp(op, ty, code)
	Operator op;
	TWORD ty;
	char code;		/* part of name, helps in debugging */
{
	char name[TempNameLen];

	(void)sprintf(name,".T%c%x", code, NextCookie(op));
	return GetNamedTemp(op, ty, name);
}

Identifier
GetNamedTemp(op, ty, name)
	Operator op;
	TWORD ty;
	char *name;
{
	TreeNode t;
	Identifier id;

	t = TreeAllocate();

	t->in.type = ty;
	t->in.op = op;
	t->tn.lval = NOOFFSET;
	t->tn.rval = MakeCookie(op);
	id = EnterSymbol(t->in.op, (CONSZ) t->tn.rval, t->tn.type, name, False);
	t->in.identifier = IdText(id);
	SetIdTree(id, t);
	TreeFree(t);
	if( TempDebug )
		printf("Allocate temp %s, id is %d\n", name, id);
	return(id);
}

/*
 * Handling of loop-invariant temporaries
 */

Identifier
GetLTemp(ty)
	TWORD ty;
{
	Identifier entered;

	entered = GetTemp(LTEMP, ty, 'l');
	if( TempDebug ) {
		char * name;

		name = IdText(entered);
		printf("LoopTemp %s created; id is %d\n", name, entered);
	}

	return(entered);
}


/*
 * Force identifier "id" to have a unique offset.  Do this by allocating a
 * new one if necessary.
 */

Boolean
ForceUnique(id)
	Identifier id;
{
	Identifier idlook;
	TreeNode t, tlook;

	t = IdTree(id);
	if( t->in.op != LNAME  &&  t->in.op != REG )
/**/		return True;

	for( idlook = FirstId; idlook <=MaxIdentifier; idlook++ )
	{
		if( idlook == id )
	/**/		continue;

		tlook = IdTree(idlook);
		if( tlook == NULL || tlook->in.op != t->in.op )
	/**/		continue;

		switch(tlook->in.op)
		{
		case LNAME:
			if( t->tn.lval == tlook->tn.lval )
			{
				/* different vars, same offset.  Give this var
				 * a new one.  This bypasses the resource
				 * allocation mechanism.
				 */
				t->tn.lval = NOOFFSET;
				(void) PAlloStack(t);
				PccAdvanceAllocation();
/**/				return True;
			}
			break;

		case REG:
			if( t->tn.rval == tlook->tn.rval )
			{
				/* different vars, same reg.  Cannot make this
				 * unique.  (Well, actually we could if we
				 * were willing to demote the REG to an LNAME.
				 * This could slow the code down, so we prefer
				 * to leave things alone.)
				 */
				return False;
			}
			break;
		}
	}
	return True;
}

