/* target.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	The tables and functions in this file provide information about
 *	the target machine.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: target.c,v 5.5 89/05/12 12:52:56 pcc Rel-3_0 $";
/* static char ID[] = "@(#)target.c	14.9	of 86/12/11"; */
#endif

# include <assert.h>
# include <config.h>
# include <target.h>
# include <pcc.h>
# include <tree.h>
# include <dag.h>
# include <dagsymbol.h>
# include <instruct.h>
# include <dagtree.h>
# include <ops.h>
# include <refcount.h>
# include <erroro.h>

/*
 *	Forward
 */

static Boolean	IsAddrIcon();

/*
 * Some macros to make the code more readable.  Some day we amy want to
 * look past other conversion nodes like IsConversion does.
 */

#define IsREG(d)	Isx(d,REG)
#define IsICON(d)	Isx(d,ICON)
#define IsADDR(d)	Isx(d,ADDR)
#define IsSTADDR(d)	Isx(d,STADDR)
#define Isx(d,x)	((d)->op == (x) || \
			(((d)->op == OCONVLEAF) \
				&& (d)->u.in.left->op == (x)))

#define IsConversion(o)	((o) == OCONVLEAF || (o) == SCONV || (o) == PCONV || \
			 (o) == OCONVTREE)

/*
 *	Cost Calculations
 */

CostType
MachCost(d,ty)
	DAG_Node d;
	TWORD ty;
{
	DAG_Node dleft, dright;
	TWORD tyl;
	TreeNode t;

	switch(d->op)
	{
	case LS:
	case RS:
	case ASG LS:
	case ASG RS:
		/* Shifts by anything but a constant are very expensive */

		if(d->u.in.right->op == ICON)
		{
			t = IdTree(d->u.in.right->leaf_id);
			return 40 + 9 * (t->tn.lval & 0x1f);
		}
		return 450;
		break;

	case SCONV:
	case PCONV:
	case OCONVLEAF:
	case OCONVTREE:
		dleft = d->u.in.left;
		tyl = dleft->type;

		/* HORRIBLE DISGUSTING HACK.  This compiler uses casts
		 * to "long" as a kludge to get unsigned comparisons right.
		 * Disaster results if the optimizer tries to put the result
		 * of such a conversion into a register.  To get around this,
		 * say that such casts have zero cost.
		 */

		if( ty == LONG )
			return 0;

		if( ISPTR(ty) || ty == ULONG )
			ty = UNSIGNED;

		if( ISPTR(tyl) || ty == ULONG )
			tyl = UNSIGNED;

		if( ty == tyl )
			return dleft->cost;

		if( tyl == FLOAT || tyl == DOUBLE )
		{
			if( ty == FLOAT )	/* DOUBLE ->FLOAT */
				return 700 + dleft->cost;
			if( ty == DOUBLE )	/* FLOAT -> DOUBLE */
				return 50 + dleft->cost;
			return 280 + dleft->cost;	/* data dep't */
		}

		switch(ty)
		{
		case FLOAT:
		case DOUBLE:
			return 150 + dleft->cost;

		case UCHAR:
		case USHORT:
			return 18 + dleft->cost;

		case UNSIGNED:
		case INT:
			return dleft->cost;

		case SHORT:
			return 85 + dleft->cost;

		case CHAR:
			return 365 + dleft->cost;	/* REALLY!!! */
		}
		break;

	case PLUS:
	case MINUS:
		dleft = d->u.in.left;
		dright = d->u.in.right;
		if( Is_Addr(dleft) && IsICON(dright) )
				return dleft->cost;
		else
		if( Is_Addr(dright) && IsICON(dleft) )
				return dright->cost;
		break;

	case ICON:
		if( IsSmallIcon(d) )
			return COST_REG;
		return  COST_ICON;

#ifndef MPX
	case TCON:	/* (MEY) add TCON and HCON for Alpha C */
	case HCON:	/* Treat same as small ICON */
		return COST_REG;
#endif

	case UNARY AND:
		dleft = d->u.in.left;
		switch(dleft->op)
		{
		case LNAME:
		case PNAME:
		case LTEMP:
		case TNAME:
			return COST_LADDR;

		case NAME:
		case STATNAME:
			return COST_ADDR;

		case UNARY MUL:
			return dleft->u.in.left->cost;

		default:
			return dleft->cost + COST_REG/2;
		}

	case UNARY MUL:
		if(IsAddressable(d)) 
			return COST_LNAME;

		dleft = d->u.in.left;
		if( dleft->op == UNARY AND)
			return dleft->u.in.left->cost;
		return dleft->cost + COST_REG/2;

	case LT: case ULT:
	case GT: case UGT:
	case LE: case ULE:
	case GE: case UGE:
	case EQ:
	case NE:
	    {
			/*
			 *	This is a bit of a fudge to account
			 *	for:
			 *	1) Compares to 16 bit signed objects are
			 *	the same cost as comparing to zero.
			 *	2) Conversions to long have been given a
			 *	cost of zero; we must recover the cost of
			 *	the expression being converted.
			 */

		CostType lcost, rcost;

		dleft = d->u.in.left;
		dright = d->u.in.right;

		if( dleft->op == SCONV && dleft->type == LONG )
			lcost = dleft->u.in.left->cost;
		else
			lcost = dleft->cost;

		if( dright->op == SCONV && dright->type == LONG )
			rcost = dright->u.in.right->cost;
		else
			rcost = dright->cost;

		if (IsSmallIcon(dright))
/**/			return lcost;
		else
		if (IsSmallIcon(dleft))
/**/			return rcost;

		if( dleft->type == FLOAT ||  dleft->type == DOUBLE ||
		   dright->type == FLOAT || dright->type == DOUBLE )
			return rcost + lcost + 120;
		else
			return rcost + lcost + 18;
	    }
	    /*NOTREACHED*/
	}

	return COST_UNKNOWN;
}

CostType
OpCost(op,type)
	Operator op;
	TWORD type;
{
	CostType cost = 0;

	if( SideEffectOp(op) )
	{
		op = OpMap(op);
	}
	switch(op)
	{
		case REG:
		case TREG:
			cost += COST_REG;
			break;

		case ADDR:
		case STADDR:
#ifndef MPX
		case CADDR:
#endif
			cost += COST_ADDR;
			break;

		case LADDR:
		case PADDR:
			cost += COST_LADDR;
			break;

		case STLABEL:
			cost = 0;
			break;

		case ICON:
#ifndef MPX
		case TCON:	/* (MEY) add TCON and HCON for Alpha C */
		case HCON:
#endif
			cost += COST_ICON;
			break;

		case NAME:
		case STATNAME:
			cost += COST_NAME;
			break;

		case PNAME:
		case LNAME:
		case TNAME:
		case LTEMP:
			if( type == DOUBLE )
				cost += 2 * COST_LNAME;
			else
				cost += COST_LNAME;
			break;

		case FCON:
			cost += COST_NAME;
			break;

		case OCONVTREE:
			break;

		case OCONVLEAF:
		case FORCE:
			cost = 0;
			break;

		case SCONV:
		case PCONV:
			cost += 28;
			break;

			/* UNARY AND and UNARY MUL are a problem.
			 * The address of a local costs more than fetching
			 * it, but the address of a global does not.
			 * We get this right in MachCost(), but here where
			 * we are limited to context, all we can do is guess.
			 */

		case UNARY AND:
			cost += COST_REG/2;
			break;

		case UNARY MUL:
			cost += COST_REG/2;
			break;

		case MUL:
			if( type == DOUBLE || type == FLOAT )
				cost += 190;
			else
				cost += 130;
			break;

		case PLUS:
		case MINUS:
		case EQ:
		case NE:
		case LE:
		case LT:
		case GE:
		case GT:
			if( type == DOUBLE || type == FLOAT )
				cost += 120;
			else
				cost += 18;
			break;

		case UNARY MINUS:
			if( type == DOUBLE || type == FLOAT )
				cost += 28;
			else
				cost += 9;
			break;

		case ULE:
		case ULT:
		case UGE:
		case UGT:
		case AND:
		case OR:
		case ER:
		case ANDAND:
		case OROR:
			cost += 18;
			break;

		case NOT:
		case COMPL:
			cost += 9;
			break;

				/* make calls expensive */
		case CALL:
		case UNARY CALL:
		case FORTCALL:
		case UNARY FORTCALL:
		case STCALL:
		case UNARY STCALL:
			cost = 600;
			break;

		case ASSIGN:
			break;

		case STASG:
			cost += 650;
			break;

		case LEAFNOP:
		case UNARYNOP:
			cost = 0;
			break;

#ifdef GOULD_NP1
		case INV:
			/* INV only supports DOUBLE/FLOAT -- set cost at 
			 * COST(FLOAT DIV) - COST(FLOAT MUL).
			 */
			cost += 540-190;
			break;
#endif /* GOULD_NP1 */

		case MOD:
		case DIV:
			switch(type)
			{
			case UNSIGNED:
			case ULONG:
				cost += 1500;
				break;
			case DOUBLE:
			case FLOAT:
				cost += 540;
				break;
			default:
				cost += 820;
				break;
			}
			break;

		case LS:
		case RS:
			cost += 50;	/* Cost of shift by 1 or 2 */
			break;

		default:
			cost += 36;
			break;
	}
	return cost;
}

/*
 *	LoopWeight returns a measure of the importance of a
 *	calculation as a function of the nesting depth of the loop.
 *	It is in this file to permit it to be adjusted for different
 *	optimizer applications.
 *
 *	Currently, we say a loop executes 4 times, w(d) = 4**d, but
 *	we put a cap on this at d = 6
 */

int
LoopWeight(d)
	int d;
{
	return (d > 6) ? (1 << (2 * 6)) : (1 << (2 * d));
}


/*
 * Determine if a node can be lifted out of a loop past possible guards.
 * To qualify, it must cause no errors.
 */

Boolean
NoErrors(d)
	DAG_Node d;
{
	switch(d->op)
	{
		/* The following might cause floating point exceptions, so
		 * don't lift them if their type is float or double
		 */

	case PLUS:
	case MINUS:
	case MUL:
	case OCONVTREE:
	case OCONVLEAF:
	case SCONV:
	case PCONV:
		return !( d->type == DOUBLE || d->type == FLOAT );

	case UNARY MINUS:
	case EQ:
	case NE:
	case LE:
	case LT:
	case GE:
	case GT:
	case ULE:
	case ULT:
	case UGE:
	case UGT:
	case UNARY AND:
	case AND:
	case OR:
	case ER:
	case LS:
	case RS:
	case NOT:
	case COMPL:
	case UNARYNOP:
	case ADDR:
	case LADDR:
	case PADDR:
	case STADDR:
#ifndef MPX
	case CADDR:
#endif
	case NAME:
	case LNAME:
	case PNAME:
	case TNAME:
	case STATNAME:
	case REG:
	case TREG:
	case LTEMP:
	case ICON:
#ifndef MPX
	case TCON:	/* (MEY) add TCON and HCON for Alpha C */
	case HCON:	
#endif
		return True;
	}
	return False;
}

/*
 * Is this DAG node addressable?  In particular, will it node (+children) be
 * turned into an OREG by pass 2.
 */

Boolean
IsAddressable(d)
	DAG_Node d;
{
	DAG_Node dleft;
	DAG_Node l, r;
	int tl;

	if( d->op == UNARY MUL )
	{
		dleft = d->u.in.left;
		switch( dleft->op )
		{
		case REG:
		case TREG:
		case LADDR:
		case PADDR:
			return True;

		case PLUS:
		case MINUS:
			/* Look for REG +/- ICON.  Life is complicated
			 * by the fact that it is possible to write the
			 * following:
			 *	register double d;
			 *	*((char *)d + 32)
			 * and
			 *	*((int)d + (char *)0x177400)
			 *
			 * The ISPTR check below catches the second case
			 * (which is actually meaningful on a machine with
			 * memory mapped I/O.)  It is not clear that the
			 * first case does anything useful, and we are content
			 * to calculate an incorrect reference count or cost
			 * here rather than spend time trying to catch the
			 * problem.
			 */

			l = dleft->u.in.left;
			r = dleft->u.in.right;
			if( ISPTR(l->type) && IsREG(l) && IsICON(r) )
				return True;
			if( ISPTR(r->type) && IsREG(r) && IsICON(l) )
				return True;

			break;
		}
	}
	return False;	/* Not addressable */
}

/*
 *	Should the reference counts for node "d" or its children be
 *	computed in any machine dependent way?  If so, do it.
 */

Boolean
RefSpecial(d)
	DAG_Node d;
{
	if( d->prev_valid_carrier )
		return True;

	if (callop(d->op)) {
		/*
		 *	Never reference the left side of the call,
		 *	because a call through a register is slower.
		 */

		if (optype(d->op) == BITYPE) {
			d->u.in.right->refs++;
			IncDescendants(d->u.in.right);
		}

		return True;
	}

	switch(d->op)
	{
	case UNARY MUL:
 		if( IsAddressable(d) )
			return True;
		else
		{
			/* Look for *(<expr>+ICON) and
			 * transfer ref made to + node to the <expr> on
			 * its left
			 */
			DAG_Node add = d->u.in.left;
			if( add->op == PLUS &&
				!add->prev_valid_carrier &&
				add->attached == NULL &&
				add->delay_count == 0 &&
				IsAddrIcon(add->u.in.right))
			{
				add->u.in.left->refs++;
				IncDescendants(add->u.in.left);
				return True;
			}
		}
		return False;
		
	case ASG LS:
	case ASG RS:
	case LS:
	case RS:
		/* The ICON on the right of a shift should never appear
		 * as being referenced by the shift
		 */
 		if( !Is_Icon(d->u.in.right) )
		{
			d->u.in.right->refs++;
			IncDescendants(d->u.in.right);
		}
		d->u.in.left->refs++;
		IncDescendants(d->u.in.left);
		return True;

		/* Addition and subtraction of small ICONs (in its various
		 * forms) should not reference the small ICONs
		 */
	case PLUS:
	case MINUS:
		if( !IsSmallIcon(d->u.in.right) )
		{
			d->u.in.right->refs++;
			IncDescendants(d->u.in.right);
		}
		if( !IsSmallIcon(d->u.in.left) )
		{
			d->u.in.left->refs++;
			IncDescendants(d->u.in.left);
		}
		return True;

	case ASG MINUS:
	case ASG PLUS:
	case INCR:
	case DECR:
		if( !IsSmallIcon(d->u.in.right) )
		{
			d->u.in.right->refs++;
			IncDescendants(d->u.in.right);
		}
		d->u.in.left->refs++;
		IncDescendants(d->u.in.left);
		return True;
		break;

	default:
		return False;
	}
	/* NOTREACHED */
}

/*
 *	Is node "d" a "small" ICON?
 */

Boolean
IsSmallIcon(d)
	DAG_Node d;
{
	TreeNode t;

	if (Is_Icon(d)) {
		t = IdTree(d->leaf_id);
		return t->tn.lval <= 32767 && t->tn.lval >= -32768;
	} else
		return False;
}

/*
 *	Is node "d" a "small" icon suitable for use as the offset in an
 *	OREG or an ADDR
 */

static Boolean
IsAddrIcon(d)
	DAG_Node d;
{
	TreeNode t;

	if( IsADDR(d) || IsSTADDR(d) )
		return True;
	else
	if (Is_Icon(d)) {
		t = IdTree(d->leaf_id);
		return t->tn.lval <= 65535 && t->tn.lval >= 0;
	} else
		return False;
}


/*
 *	Code Generation: this routine is called to examine a DAG for
 *	special cases.
 */


static Boolean
CarrierIsRegister(n)
	DAG_Node n;
{
	TreeNode t;

	if (n->carrier != NoId) {
		t = IdTree(n->carrier);
		return (t->in.op == REG || t->in.op == TREG);
	} else
		return False;
/*NOTREACHED*/
}

/*
 *	This looks for special patterns for which the normal code
 *	generation process will produce suboptimal code.
 */

TreeNode
SpecialTree(n)					/* Handle special cases */
	DAG_Node n;
{
	TreeNode t = NULL;
	DAG_Node addr_node, convert_node, icon_node;
	Boolean addr_reg, icon_reg;

	if (IsAddrConst(n)) {		/* A special case */
		if (Is_Addr(n->u.in.left)) {
			addr_node = n->u.in.left;
			icon_node = n->u.in.right;
		} else {
			addr_node = n->u.in.right;
			icon_node = n->u.in.left;
		}
		if (addr_node->op == OCONVLEAF) {
			convert_node = addr_node;
			addr_node = addr_node->u.in.left;
		} else
			convert_node = NULL;

		/*
		 *	We have the pieces.  If exactly one of the addr
		 *	and the icon is in a register, we have to build
		 *	the special tree.
		 */

		addr_reg = CarrierIsRegister(addr_node);
		icon_reg = CarrierIsRegister(icon_node);
		if (addr_reg ^ icon_reg) {	/* Exactly one is register */

			t = TreeAllocate();
			t->in.op = n->op;
			t->in.type = n->type;
			t->tn.identifier = NULL;

			t->in.right = icon_node->e_tree;

			if (!addr_reg) {		/* Normal addr */
				t->in.left = TreeRef(convert_node != NULL ?
						convert_node : addr_node);
			} else
			if (convert_node == NULL) {	/* No OCONVLEAF */
				t->in.left = addr_node->e_tree;
			} else {
				/* addr is reg, and OCONVLEAF ...
			 	 * This construction is a little odd to avoid
				 * problems with storage allocation.  If there
				 * is an OCONVLEAF node, then we may need two
				 * OCONVLEAF nodes: one that points to the
				 * ADDR node and one that points to the
				 * REG node that contains the address.
				 * However, the storage manager assumes that
				 * there will be only one tree node owned by
				 * each DAG node.
				 * Our (temporary) solution is a little hack.
				 * In this case we make copies of all the
				 * tree nodes and generate an entire new
				 * tree.  We then call FinalOpt().  This will
				 * produce a single leaf node that represents
				 * the address, which we can return as the
				 * appropriate tree. (Blech)
 				 */

				t->in.right = CopyTree(t->in.right);

				t->in.left = TreeAllocate();
				t->in.left->in.op = convert_node->op;
				t->in.left->in.type = convert_node->type;
				t->in.left->tn.identifier = NULL;
				t->in.left->in.left = CopyTree(addr_node->e_tree);
				t = FinalOpt(t);
				assert(optype(t->in.op) == LTYPE);
			}
			
		}
		    
	} else
	if (IsShift(n->op) && Is_Icon(n->u.in.right)) {
		/*
		 *	Constant shifts should never reference
		 *	a register on the right!
		 */

		t = TreeAllocate();
		t->in.op = n->op;
		t->in.type = n->type;
		t->tn.identifier = NULL;

		t->in.left = TreeRef(n->u.in.left);
		t->in.right = n->u.in.right->e_tree;
	} else
	if( callop(n->op) )
	{
		/* ensure that calls never have a register on the left
		 * when the address is known
		 */

		DAG_Node left;
		TreeNode tl;
		left = n->u.in.left;
		if( Is_Addr(n->u.in.left) )
		{
			t = TreeAllocate();
			if( n->op == STCALL || n->op == UNARY STCALL )
			{
				*t = *(n->new_tree);
			}
			else
			{
				t->in.op = n->op;
				t->in.type = n->type;
				t->tn.identifier = NULL;
			}

			/* Set up left subtree, if any */
			switch(optype(n->op))
			{
			case UTYPE:
				t->tn.rval = n->u.tn.rval;
				break;

			case BITYPE:
				t->in.right = TreeRef(n->u.in.right);
				break;

			default:
				InternalFault("Impossible optype for callop");
				break;
			}
			tl = left->e_tree;
			if( IsConversion(tl->in.op) )
			{
				/* Yech.  A conversion on the address node.
				 * Allocate a node to hold the child of the
				 * conversion (an address, or Is_Addr() lied).
				 * Then call FinalOpt to paint the conversion
				 * down.
				 */
				tl->in.left = TreeAllocate();
				*(tl->in.left) = *(left->u.in.left->e_tree);
				left->e_tree = tl = FinalOpt(tl);
				assert(optype(tl->in.op)==LTYPE);
			}
			t->in.left = tl;
		}
	}

	return t;
}

/*
 *	Resource Routines
 *
 *	These routines handle the mapping of abstract resources
 *	to the actual machine dependent registers and things.
 */

#define Registers	0
#define Stack		1

/*
 *	This is the transfer vector.  For each resource, it gives
 *	the definition of the abstract operators.  The interface
 *	is provided is by defines.
 */

static Boolean CanBeReg();
static Boolean AllocReg();
static void PromoteReg();
static Boolean CanBeStack();
static Boolean AllocStack();
static void PromoteStack();

AllocXfer ResVector[] = {
				{REG, CanBeReg, AllocReg,
				 CostSaveReg,  PromoteReg},

				{LNAME, CanBeStack, AllocStack,
				 0, PromoteStack}
			};

static Boolean
CanBeReg(id)
	Identifier id;
{
	int ns;		/* Name Space */

	ns = IdOp(id);
	if (ns == LNAME || ns == PNAME ||	/* C */
	    ns == TNAME || ns == LTEMP ||	/* PCO */
	    ns == STATNAME)			/* f77 */
		return (!WasAddressed(id) & cisreg(SymType(id)));
	else
		return False;
}

static Boolean
CanBeStack(id)
	Identifier id;
{
	return True;
}


static Boolean
AllocReg(id)
	Identifier id;
{
	TreeNode t;
	Operator op;

	t = IdTree(id);
	assert(t != NULL);
	op = t->in.op;
	assert(op == TNAME || op == LNAME || op == PNAME || op == LTEMP ||
		op == STATNAME);

	return PAlloReg(t);
}

static Boolean
AllocStack(id)
	Identifier id;
{
	TreeNode t;
	Operator op;

	t = IdTree(id);
	assert(t != NULL);
	op = t->in.op;
	assert(op == TNAME || op == LNAME || op == PNAME || op == LTEMP ||
		op == STATNAME);

	return PAlloStack(t);
}

/* On the Gould, stores are more expensive than fetches */

CostType
ResStoreCost(r, type)
	ResrcIndex r;
	TWORD type;
{
	switch(r)
	{
	case RegResource:
		return COST_REG;
	case StackResource:
		return (type == DOUBLE) ? 70 : 45;
	}
	InternalFault("Bad resource for ResStoreCost()");
	/* NOT REACHED */
}

/*
 *	Parameter Loading
 *
 *	This code is concerned with promoting parameters from memory
 *	into registers.
 */

static void
PromoteReg(params, t, old_off)
	InstrList *params;
	TreeNode t;
	CONSZ old_off;	/* Offset of parameter in stack */
{
	Instruction i, pi, ppi;

	i = CreateInstruction(ParamFetch);
	i->u.pf.reg = t->tn.rval;
	i->u.pf.offset = old_off;
	i->u.pf.type = t->tn.type;

	/* Insert it into the list where it belongs */

	pi = params->first;
	if (pi == NULL) {
		params->first = i;
		params->last  = i;
	} else {
		ppi = NULL;
		while (pi != NULL && i->u.pf.offset > pi->u.pf.offset) {
			ppi = pi;
			pi = pi->next;
		}
		/* pi == NULL or i->offset <= pi->offset */
		i->next = pi;
		if (ppi == NULL)
			params->first = i;
		else
			ppi->next = i;
		if (pi == NULL)
			params->last = i;
	}
}

static void
PromoteStack(params, t, old_lval)
	InstrList *params;
	TreeNode t;
	CONSZ old_lval;
{
	InternalFault("Can't promote param to stack\n");
}

/*	This routine called when a user register variable has been discarded
 *	to delete any parameter fetch that may exist
 */
void
DemoteReg(params, t)
	InstrList *params;
	TreeNode t;
{
	Instruction i;

	assert(t->in.op == REG);

	for( i = params->first; i != NULL; i = i->next )
		if( i->u.pf.reg == t->tn.rval )
	/**/		break;

	if( i != NULL )
	{
		/* Got it! */
		DelInstruction(i, params);
	}
}
