/* prune.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 * DAG pruning
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: prune.c,v 5.5 89/05/12 12:52:24 pcc Rel-3_0 $";
/* static char ID[] = "@(#)prune.c	15.1	of 86/10/10"; */
#endif

/*
 * Export
 */

int PrunDebug = 0;	/* Debugging flag */

/*
 * Import
 */

#include <prune.h>
#include <assert.h>
#include <blocks.h>
#include <dag.h>
#include <dagsymbol.h>
#include <duchain.h>
#include <flow.h>
#include <identifier.h>
#include <longset.h>
#include <ops.h>
#include <temp.h>
#include <erroro.h>

/*
 * Forward
 */

static void PruneLeaf();

/*
 * Remove dead code left by constant folding and/or loop invariance removal
 */


void
PruneDags()
{
	BasicBlock b;
	DAG_Node d;

	for( b = FirstBlock; b != NULL; b = b->next )
	    if( b->reachable )
	    {
		for( d = b->Dag; d != NULL; d = d->next )
		{
			if( d->in_degree == 0 && d->delay_count == 0 )
				PruneTree(d, NotConditional, RecursivePrune);
		}
	    }
}

void
PruneTree(d, Zone, recurse)
	DAG_Node d;	/* Where to start pruning */
	DagCount Zone;	/* If != NotConditional, lowest zone to prune */
	Boolean recurse;/* Should we recurse? */
{
	AttachedID aid;
	Boolean SafeToPrune;	/* Can this node be safely pruned? (no side
				 * effects) */
	Boolean PruneAnyway;	/* Should this node be pruned even if it has
				 * side effects? */

	if( d->in_degree == 0 && d->delay_count == 0 )
	{
		/* At this point, we know that the node is not used anywhere.
		 * If there is a temp attached, delete it.
		 */

		aid = d->attached;
		if( aid != NULL && IsTemp(aid->id) )
		{
			DeleteID(aid->id, d, True);
			aid = d->attached;
			d->carrier = NoId;
			d->prev_valid_carrier = False;
			d->carrier_required = False;
		}

		PruneAnyway = Zone != NotConditional && d->in_cond >= Zone;
		SafeToPrune = !Forced(d->op) && d->op != QUEST &&
			      d->op!= ANDAND && d->op != OROR &&
			      d->op != COMOP;

		if( aid == NULL && d->op!=LEAFNOP &&
		    (SafeToPrune || PruneAnyway))
		{
			switch( optype(d->op) )
			{
			case BITYPE:
				d->u.in.right->in_degree--;
				if(recurse)
					PruneTree(d->u.in.right, Zone, RecursivePrune);
				d->u.in.left->in_degree--;
				if(recurse)
					PruneTree(d->u.in.left, Zone, RecursivePrune);
				break;
			case UTYPE:
				d->u.in.left->in_degree--;
				if(recurse)
					PruneTree(d->u.in.left, Zone, RecursivePrune);
				break;
			case LTYPE:
				PruneLeaf(d);
				break;
			default:
				InternalFault("Bad optype for op: %d in node %d\n",
							d->op, d->order);
			}

			if( PrunDebug )
			 	printf("Making node %s(%x) a no-op\n",
					opst[d->op], d);

			d->op = LEAFNOP;
			d->carrier = NoId;
			d->prev_valid_carrier = False;
			d->carrier_required = False;
			d->in_cond = NotConditional;
		}
	}
}

static void
PruneLeaf(d)
	DAG_Node d;
{
	int i;
	Identifier id;
	BasicBlock b;
	LongSet DUTmpSet, suses;

	id = d->leaf_id;

	if( id != NoId  &&  (suses = GetUses(id)) != NULL)
	{
		DUTmpSet = CreateSet((int)(MaxIdentifier+1));

		assert(d->FGindex != NullFlow);
		b = FlowGraph[d->FGindex].block;
		assert(b != NULL && b->du.PUse != NULL);

		Intersection(DUTmpSet, suses, b->du.PUse);
		for( i = FirstElement(DUTmpSet); i != NoElement;
		     i = NextElement(i,DUTmpSet))
		{
			if( DUDagPtrs[i] == d )
		/**/		break;
		}
		assert(i != NoElement);


		DelMember(i,suses);
		DelMember(i,b->du.PUse);
	}
}
