/* ops.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	ops - Information about intermediate code operators.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: ops.c,v 5.5 89/05/12 12:51:56 pcc Rel-3_0 $";
/* static char ID[] = "@(#)ops.c	9.2	of 86/02/20"; */
#endif

#include <cmanifest.h>
#include <bool.h>
#include <dag.h>
#include <dagsymbol.h>
#include <ops.h>
#include <tree.h>
#include <assert.h>
#include <erroro.h>

Boolean
SideEffectOp(o)
	Operator o;
{
	switch (o) {
		default:
			return False;

		case ASG PLUS:
		case ASG MINUS:
		case ASG MUL:
		case ASG AND:
		case ASG DIV:
		case ASG MOD:
		case ASG LS:
		case ASG RS:
		case ASG OR:
		case ASG ER:
		case INCR:
		case DECR:
			return True;
	}
}

/*
 *	OpMap: this translates some operators into others for use
 *	in the DAG.  This is a little icky.
 */

Operator
OpMap(o)
	Operator o;
{
	switch (o) {
		default:
			return o;

		case ASG PLUS:
		case ASG MINUS:
		case ASG MUL:
		case ASG AND:
		case ASG DIV:
		case ASG MOD:
		case ASG LS:
		case ASG RS:
		case ASG OR:
		case ASG ER:
			return NOASG o;

		case INCR:
		 	return PLUS;

		case DECR:
			return MINUS;
	}
}

Boolean
OpAssignable(op)		/* True if op can become op= */
	Operator op;
{
	switch (op) {
		default:
			return False;

		case PLUS:
		case MINUS:
		case MUL:
		case AND:
		case DIV:
		case MOD:
		case LS:
		case RS:
		case OR:
		case ER:
			return True;
	}
}

/*
 * Map ADDR node types to NAME types
 */

Operator
ToNAME(o)
	Operator o;
{
	switch(o)
	{
	case ADDR:
#ifndef MPX
	case CADDR:
#endif
		return NAME;
	case LADDR:
		return LNAME;
	case PADDR:
		return PNAME;
	case STADDR:
		return STATNAME;
	default:
		InternalFault("Bad op to ToNAME: %d\n", o);
	}
	/*NOTREACHED*/
}

/*
 * Map NAME node types to ADDR types
 */

Operator
ToADDR(o)
	Operator o;
{
	switch(o)
	{
	case NAME:
		return ADDR;
	case LNAME:
		return LADDR;
	case PNAME:
		return PADDR;
	case STATNAME:
		return STADDR;
	default:
		InternalFault("Bad op to ToADDR %d\n", o);
	}
	/*NOTREACHED*/
}

/*
 *	Does a node represent an address ?
 */

Boolean
Is_Addr(d)
	DAG_Node d;
{
	if( d->op == OCONVLEAF )
		return Is_Addr(d->u.in.left);
	else
		return d->op == ADDR || d->op == LADDR ||
			 d->op == PADDR || d->op == STADDR;
}
