/* loop.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
#ifndef LOOPHDR

#ifndef lint
/*	@(#) (Gould) $Header: loop.h,v 5.5 89/05/12 12:51:49 pcc Rel-3_0 $		  */
/* static char LOOP_SCCSID[] = "@(#)loop.h	15.1"; */
#endif

#include <bool.h>
#include <longset.h>
#include <blocks.h>
#include <flow.h>
#include <identifier.h>

typedef struct LTmE {
	Identifier	id;		/* Id of this loop temp */
	struct LTmE	*next;		/* next temp on the list */
} LTmE_type, *LTempList;

typedef struct LTE {
	LongSet		loop;		/* set of blocks in loop */
	LongSet		exits;		/* set of blocks that transfer control
					 * outside the loop */
	LTempList	ltemps;		/* loop temps used by this loop */
	struct LTE	*child;		/* list of children of this loop:
					 * loops that are contained within
					 * this one
					 */
	struct LTE	*sibling;	/* list of siblings of this loop:
					 * loops that are disjoint with
					 * this one */
	FlowIndex	head;		/* head of loop */
	BasicBlock	prehead;	/* pre-header, if any.  CANNOT BE A
					 * FlowIndex */
	Boolean		known_indir_stores;/* are there indirect stores to
					 * known places in this loop? */
	Boolean		unknown_indir_stores;/* are there indirect stores to
					 * unknown places in this loop? */
	} LTE_type, *LTabEntry;

extern int nloops;		/* number of loops in program */
extern LTabEntry *LoopPtrs;	/* an array of pointers to loop information */

extern void LoopInvariants();
extern void FindLoops();
extern void FreeLTempList();
extern void DumpLTabEntry();
extern void DumpLoopTree();

#define LOOPHDR

#endif
