/* identifier.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	An "identifier" within the flow optimizer
 */

#ifndef IDENTIFIER

#define IDENTIFIER

#ifndef lint
/*	@(#) (Gould) $Header: identifier.h,v 5.5 89/05/12 12:50:47 pcc Rel-3_0 $		  */
/* static char ID_SCCSID[] = "@(#)	identifier.h	15.1	of 86/09/25"; */
#endif

/*
 *	An identifier is a unique name given by the flow optimizer to
 *	any object that is entered in the symbol table.  These are atomic
 *	objects: ICONs, NAMEs, PNAMEs, LNAMEs, and ADDRs.  ICONs and
 *	ADDRs are unusual in that they evaluate to themselves as opposed
 *	to standing for some other value.
 *
 *	It should be noted that the identifier value is unique only
 *	within a given function.  Identifier values for global symbols
 *	(NAMEs) can change from one function to another.
 *
 *	See also: dagsymbol.*
 *
 */


#include <config.h>

/*
 *	The type "Identifier" is defined in config.h
 */

#define	NoId		0		/* Not a valid identifier */
#define	UnknownId	1		/* Used to mark an address reference
					 * that PCO cannot understand.
					 */

/*
 *	 Are two identifiers the same?
 */

#define SameId(id1, id2)	((id1) == (id2))

#endif
