/* flow.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	This defines the data types and exported operations for the
 *	flow graph module.  The flow graph represents the possible
 *	control paths in the function.  See Aho and Ullman, pp. 412 ff.
 */


#ifndef FLOWGRAPH
#define FLOWGRAPH

#ifndef lint
/*	@(#) (Gould) $Header: flow.h,v 5.5 89/05/12 12:50:40 pcc Rel-3_0 $		  */
/* static char FLOW_SCCSID[] = "@(#)	flow.h	14.1	of 86/08/13"; */
#endif

# include <config.h>
# include <bool.h>
# include <blocks.h>
# include <longset.h>
# include <allocvect.h>

/*
 *	FlowIndex is defined in config.h
 */

#define	NullFlow	MaxFlowNodes	/* Not a real flow index */

typedef struct PN {		/* Predecessor */
	struct PN *next;
	FlowIndex p;
} PrdNd, *PredNode;

#define NormNumExits	2
#define ArithIfExits	3		/* for f77 */

#define InitialNode	((FlowIndex) 0)	/* Is there a better way ? */

typedef struct FGN {		/* Flow Graph Node */
	PredNode preds;	/* Predecessors */
	BasicBlock block;	/* Basic block for this node */

	int nexits;			/* number of exits */
	Boolean mult_exit;		/* special block: multiple exits */
	union {
		FlowIndex exits[NormNumExits];	/* mult_exit false */
		FlowIndex *exit_list;		/* mult_exit true  */
	} u;

	Boolean	visited;		/* For DFN computation and
					   storage allocation */
	int DFN;			/* Depth-first number */

	LongSet dom;			/* Dominators of this node */
	int nesting;			/* loop nesting depth */
	int loopweight;			/* Weight assigned to this block - based
					 * on nesting depth */
	AllocationVector v;		/* allocation data for the loop
					   that this block heads */
} FlowNode;

#define IsMultExit(n)	(FlowGraph[(n)].mult_exit)
#define NumExits(n)	(FlowGraph[(n)].nexits)
#define Successor(n, i)	(IsMultExit((n)) ? FlowGraph[(n)].u.exit_list[(i)] \
				     : FlowGraph[(n)].u.exits[(i)])
#define Dom(n)		FlowGraph[(n)].dom

extern FlowNode *FlowGraph;		/* array of FlowNodes */
extern FlowIndex *DFN;			/* FlowNodes in Depth First order */

extern int ldebug;			/* Loop Debugging */
extern int NumFlowNodes;
extern int NumReachableNodes;

extern void	BuildGraph();		/* Construct a flow graph */
extern FlowIndex ExtendGraph();		/* Extend a flow graph */
extern Boolean	IsReducible();		/* Is it reducible? */
extern Boolean	BackEdge();		/* Is an edge a back edge? */
extern void	FreeFlow();		/* Tear it down */
extern void	AddPred();		/* Add a predecessor to a flow graph
					 * node */
extern void	DelPred();		/* Delete a predecessor record from a
					 * flow graph node */
extern void	AdjustFlowGraph();	/* Clean up CBRANCHes that have become
					 * unconditional */
extern void	InitFGindex();		/* Initialize flow indices in the DAG
					 * for a basic block */
extern void	DumpGraph();		/* Debug */

#endif
