/* erroro.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Error Reporting
 */

#ifndef ERRORO

#define ERRORO

#ifndef lint
/*	@(#) (Gould) $Header: erroro.h,v 5.5 89/05/12 12:50:32 pcc Rel-3_0 $		  */
/* static char ERH_SCCSID[] = "@(#)	erroro.h	14.1	of 86/06/11"; */
#endif

/*
 *	This module handles the reporting of errors.  Most of
 *	the errors that can be reported are internal optimizer faults,
 *	but under some circumstances warnings can be given.
 */

/*
 *	Note: these routines are called with variable numbers of arguments.
 *	They can be passed up to 3 int arguments to help customize
 *	the error message.  A newline is always added to the end of
 *	the message.
 */

extern void	ResourceExhausted();	/* Report exhaustion of a resource */
extern void	InternalFault();	/* Report an internal fault(dump) */
extern void	ExternalFault();	/* Report an internal fatal error */
extern void	UserError();		/* Report a user level error */
extern void	Warning();		/* Warn the user about something */
extern void	WarnNoOpt();		/* Warn the user we can't optimize */

/*
 *	Check for storage overflow
 *
 *	p is the pointer from the allocator
 *	m is the message (with up to one %d)
 *	n is the amount needed (or zero if not relevant)
 */

#define CheckStorage(p, m, n)	if ((p) == NULL) ResourceExhausted((m), (n))

#endif
