/* cost.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 * Cost computation.  Computes, for each node in the DAG, the cost of
 * REFERENCING the value of that node.  Changing the cost to the cost
 * of computing the node would not be difficult.
 *
 * Most of this file is machine dependent
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: cost.c,v 5.5 89/05/12 12:49:49 pcc Rel-3_0 $";
/* static char ID[] = "@(#)cost.c	10.1	of 86/02/27"; */
#endif

/*
 * Import
 */

#include <bool.h>
#include <cost.h>
#include <blocks.h>
#include <dag.h>
#include <dagsymbol.h>
#include <assert.h>
#include <ops.h>

/*
 * Forward
 */

/*
 * Computes the cost of each DAG
 */
void
ComputeCosts()
{
	BasicBlock b;

	for( b = FirstBlock; b != NULL; b = b->next )
		if( b->reachable )
			BlockCost(b);
}

/*
 * Compute the cost of a block
 */
void
BlockCost(b)
	BasicBlock b;
{
	DAG_Node d;

	for( d = b->Dag; d != NULL; d = d->next )
		DAGCost(d);
}

/*
 * Compute the cost of EVALUATING (as opposed to referencing) a DAG node
 */
void
DAGCost(d)
	DAG_Node d;
{
	DAG_Node dleft, dright;
	CostType c;
	TWORD ty, tyl, tyr;
	int oty;

	/* the type of (for instance) EQ when both operands
	 * are double is INT; however the evaluation is
	 * more costly than if both operands were ints.
	 * Hence, we make a crude attempt to figure out
	 * the real type of the operation
	 */

	tyl = tyr = ty = d->type;
	oty = optype(d->op);
	if( oty != LTYPE )
	{
		dleft = d->u.in.left;
		tyl = dleft->type;
		if( oty == BITYPE )
		{
			dright = d->u.in.right;
			tyr = dright->type;
		}
		else
			tyr = tyl;
	}

	if( (dope[d->op] & SHFFLG) != 0)
	{
		/* Shifts are unsigned if the left
		 * operand is
		 */
		if( ISUNSIGNED(tyl) && UNSIGNABLE(ty) )
			ty = ENUNSIGN(ty);
	}
	else
	if( (dope[d->op] & (FLOFLG|LOGFLG|SIMPFLG|DIVFLG)) != 0)
	{
		/* arithmetic ops and comparisons are
		 * unsigned if either operand is
		 */
		if( (ISUNSIGNED(tyl)||ISUNSIGNED(tyr))
		    && UNSIGNABLE(ty))
			ty = ENUNSIGN(ty);

		/* floating point arithmetic ops and
		 * comparisons are floating if either
		 * operand is
		 */
#ifdef FORT
		if( (dope[d->op] & (FLOFLG|LOGFLG)) != 0)
		{
			if( tyl == FLOAT || tyr == FLOAT )
				ty = FLOAT;
			if( tyl == DOUBLE || tyr == DOUBLE )
				ty = DOUBLE;
		}
#else
		if( (dope[d->op]&(FLOFLG|LOGFLG))!=0
		    && (tyl==FLOAT || tyl==DOUBLE ||
		        tyr==FLOAT || tyr==DOUBLE ))
				ty = DOUBLE;
#endif
	}

	/* Begin by asking about machine dependent constructs such
	 * as OREGs.  If this is not a machine dependent construct,
	 * compute cost as cost of this node plus cost of children.
	 */

	c = MachCost(d,ty);
	if( c == COST_UNKNOWN )
	{
		if( oty == LTYPE && 
		    (d->op == PNAME || d->op == LNAME || d->op == NAME))
			c = IdRefCost(d->leaf_id);
		else
			c = OpCost(d->op,ty);

		if( oty != LTYPE )
		{
			if( dleft->carrier == NoId ||
			    IsTransparent(dleft->carrier) )
				c += dleft->cost;
			else
				c += IdRefCost(dleft->carrier);
			if( oty == BITYPE )
			{
				if( dright->carrier == NoId ||
				    IsTransparent(dright->carrier) )
					c += dright->cost;
				else
					c += IdRefCost(dright->carrier);
			}
		}
	}

	d->cost = (c > COST_INFINITY ) ? COST_INFINITY : c;
}

CostType
IdRefCost(id)
	Identifier id;
{
	TreeNode t;

	t = IdTree(id);
	if (t != NULL)		/* there is a tree */
		return RefCost(t->in.op, t->in.type);
	else
		return RefCost(IdOp(id), SymType(id));
}

CostType
IdStoreCost(id)
	Identifier id;
{
	TreeNode t;

	t = IdTree(id);
	if (t != NULL)		/* there is a tree */
		return StoreCost(t->in.op, t->in.type);
	else
		return StoreCost(IdOp(id), SymType(id));
}
