/* blocks.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Basic Block Module
 *
 */

/*
 *	This module maintains the basic block representation of a function
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: blocks.c,v 5.5 89/05/12 12:49:25 pcc Rel-3_0 $";
/* static char ID[] = "@(#)blocks.c	15.1	of 86/10/10"; */
#endif


/*
 *	Imported Objects
 */

# include <assert.h>
# include <instruct.h>
# include <labels.h>
# include <bool.h>
# include <longset.h>
# include <flow.h>
# include <blocks.h>
# include <storage.h>
# include <erroro.h>

/*	Exported Objects
 */

BasicBlock FirstBlock,		/* First Block in Function */
	   CurrentBlock,	/* Block under construction */
	   FinalBlock;		/* Final Block in Function (the "end") */

static BasicBlock LastBlock;
static BasicBlock FreeList = NULL;

int NumBlocks;
int NumEntryPoints;		/* Number of entry points to function */

/*
 *	Storage Management
 */

static BasicBlock
AllocBlock()
{
	BasicBlock b, c;	/* We know this is a *BasBlock */
	int i;

	if (FreeList == NULL) {
		c = GetArray(s_Blocks, BlockChunk, BasBlock);
		CheckStorage(c, "storage for basic blocks", 0);

		/* Turn array into linked list (backwards!) */

		b = NULL;
		for (i=0; i < BlockChunk; ++i) {
			c->next = b;
			b = c++;
		}

		/*
		 * Now b points to the head of the free list (the
		 * last entry in the chunk).
		 */
		
	} else
		b = FreeList;

	FreeList = b->next;
	return b;
}

void
FreeBlock(b)
	BasicBlock b;
{
	if( b->ud.Gen != NULL ) { DestroySet( b->ud.Gen); b->ud.Gen = NULL; }
	if( b->ud.Kill != NULL ) { DestroySet( b->ud.Kill); b->ud.Kill = NULL; }
	if( b->ud.In != NULL ) { DestroySet( b->ud.In); b->ud.In = NULL; }
	if( b->ud.Out != NULL ) { DestroySet( b->ud.Out); b->ud.Out = NULL; }

	if( b->ld.Def != NULL ) { DestroySet( b->ld.Def); b->ld.Def = NULL; }
	if( b->ld.PDef != NULL ) { DestroySet( b->ld.PDef); b->ld.PDef = NULL; }
	if( b->ld.Use != NULL ) { DestroySet( b->ld.Use); b->ld.Use = NULL; }
	if( b->ld.In != NULL ) { DestroySet( b->ld.In); b->ld.In = NULL; }
	if( b->ld.Out != NULL ) { DestroySet( b->ld.Out); b->ld.Out = NULL; }

	if( b->av.Gen != NULL ) { DestroySet( b->av.Gen); b->av.Gen = NULL; }
	if( b->av.Comp != NULL ) { DestroySet( b->av.Comp); b->av.Comp = NULL; }
	if( b->av.Kill != NULL ) { DestroySet( b->av.Kill); b->av.Kill = NULL; }
	if( b->av.In != NULL ) { DestroySet( b->av.In); b->av.In = NULL; }
	if( b->av.Out != NULL ) { DestroySet( b->av.Out); b->av.Out = NULL; }

	if( b->du.PUse != NULL ) { DestroySet( b->du.PUse); b->du.PUse = NULL; }

	if (b->code.first != NULL)
		FreeIList(&(b->code));
	FreeDag(b->Dag);
	b->next = FreeList;
	FreeList = b;
}

/*
 *	Initialization
 */

static void
InitBlock()
{
	NumBlocks = 0;
	FirstBlock = CreateBlock();		/* The empty initial block */
	LastBlock  = FirstBlock;
	CurrentBlock = NULL;			/* Not working on a block */
	NumEntryPoints = 1;			/* Usually */
}

BasicBlock
CreateBlock()
{
	BasicBlock p;

	p = AllocBlock();
	assert(p != NULL);
	p->next = NULL;
	InitList(&(p->code));
	p->Dag = NULL;
	p->ud.Gen = NULL;
	p->ud.Kill = NULL;
	p->ud.In = NULL;
	p->ud.Out = NULL;
	p->ld.Def = NULL;
	p->ld.Use = NULL;
	p->ld.In = NULL;
	p->ld.Out = NULL;
	p->av.Gen = NULL;
	p->av.Comp = NULL;
	p->av.Kill = NULL;
	p->av.In = NULL;
	p->av.Out = NULL;
	p->du.PUse = NULL;
	p->in_loop = False;
	p->reachable = True;
	p->blocknum = NumBlocks++;
	p->FGindex = NullFlow;
	return p;
}

static void
AppendBlock(b)
	BasicBlock b;
{
	if (FirstBlock == NULL)
		FirstBlock = b;
	else
		LastBlock->next = b;
	LastBlock = b;
}

/*
 * Link basic block bnew on the list just after b
 */

void
LinkBlock(bnew, b)
	BasicBlock bnew;
	BasicBlock b;
{
	assert(b != FinalBlock);
	bnew->next = b->next;
	b->next = bnew;
}

static void
StartBlock(o)
	Instruction o;
{
	assert(CurrentBlock == NULL);
	CurrentBlock = CreateBlock();
	CurrentBlock->code.first = o;
}

static void
EndBlock(o)
	Instruction o;
{
	assert(CurrentBlock != NULL);
	CurrentBlock->code.last = o;
	o->next = NULL;			/* Break linked list here */
	AppendBlock(CurrentBlock);
	CurrentBlock = NULL;
}

void
BuildBlocks(s)		/* Compute the basic blocks */
	Instruction s;
{
	Instruction pi, i, ni;
	Boolean force_leader;

	InitBlock();
	ClearLabelTable();

	force_leader = False;
	StartBlock(s);

	pi = s;
	i  = s->next;

	while (InstType(i) != FcnEnd) {

		ni = i->next;	/* next instruction */

		/* check for block leaders */

#ifdef FORT
		if (InstType(i) == EntryPoint) {	/* are like labels */
			if (CurrentBlock != NULL)
				EndBlock(pi);
			StartBlock(i);
			++NumEntryPoints;
		} else
#endif /* FORT */
		if (InstType(i) == Label) {	/* Labels are leaders */
			if (CurrentBlock != NULL) EndBlock(pi);
			StartBlock(i);
			Associate(i->u.lb.lab_num, CurrentBlock);
		} else
		if (InstType(i) == ParamHere) {	/* ParamHere must not be in
						 * middle of block */
			assert(CurrentBlock != NULL);
			EndBlock(pi);
			StartBlock(i);
		} else
		if (force_leader) {		/* Forced by previous inst */
			StartBlock(i);
		}
		force_leader = False;

		if( CurrentBlock == NULL ) {	/* Unreferenced instruction */
			InstFree(i);
		} else {

			/* See if this terminates a block */

#ifdef FORT
			if (IsUBranch(i) || IsReturn(i) || IsArithIf(i)) {
#else
			if (IsUBranch(i) || IsReturn(i)) {
#endif
				EndBlock(i);
			} else
			if (IsCBranch(i) || IsSwitch(i)) {
				EndBlock(i);
				force_leader = True;
			}
			pi = i;
		}
		i  = ni;
	}

	/* InstType(i) == FcnEnd.  Always in it's own block */

	if (CurrentBlock != NULL) EndBlock(pi);
	StartBlock(i);
	FinalBlock = CurrentBlock;
	EndBlock(i);
}

/*	Debug
 */

static void
PrintABlock(b)
	BasicBlock b;
{
	printf("Block %d @ %x First: %x Last: %x\n", b->blocknum, b,
			b->code.first, b->code.last);
	printf("\tReachable %c in_loop %c exit %c eligible %c\n",
			b->reachable	? 'Y' : 'N',
			b->in_loop	? 'Y' : 'N',
			b->exit		? 'Y' : 'N',
			b->eligible	? 'Y' : 'N');
}

void
PrintBlocks()
{
	BasicBlock b;

	for (b = FirstBlock; b != NULL; b = b->next) {
		PrintABlock(b);
	}
}
