/* arith.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Evaluation of arithmetic expressions.  This simulates the
 *	run-time arithmetic in order to evaluate constant expressions.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: arith.c,v 5.5 89/05/12 12:49:11 pcc Rel-3_0 $";
/* static char ID[] = "@(#)arith.c	1.1	of 86/04/24"; */
#endif

/*
 *	Imported Objects
 */

# include <cmanifest.h>
# include <pcc.h>
# include <tree.h>
# include <bool.h>
# include <ops.h>
# include <erroro.h>
# include <target.h>
# include <arith.h>

int NoFloatConstFolding = 0;

/*
 * conval() was copied directly from trees.c, with minor modifications to
 * make it fit in
 */

Boolean
conval( p, o, ty, q )
	TreeNode p;
	Operator o;
	TWORD ty;
	TreeNode q;
{
	/* apply the op o to the lval part of p; if binary, rhs is val */

	int i;
	Boolean u, ul;
	CONSZ val;
	Boolean laddr, raddr, lconst, rconst;
	Operator otype;

	otype = optype(o);

	if( p->in.type == DOUBLE || p->in.type == FLOAT )
		if( otype == BITYPE )
			if( q->in.type == DOUBLE || q->in.type == FLOAT )
				return( fconval( p, o, ty, q ) );
		else
			return( fconval( p, o, ty, q ) );

	u = ul = ISUNSIGNED(p->in.type);

		/* OK to check for LADDR, PADDR here in final optimization
		 * as long as node we are looking at is a copy.  Constant
		 * folding must NOT pass any of these things in to us.
		 */

	laddr = (p->in.op == ADDR || p->in.op == STADDR || 
		 p->in.op == LADDR || p->in.op == PADDR);
	lconst = laddr || p->in.op == ICON;

	if( otype == BITYPE )
	{
		val = q->tn.lval;
		u = u || ISUNSIGNED(q->in.type);
		raddr = (q->in.op == ADDR || q->in.op == STADDR || 
			 q->in.op == LADDR || q->in.op == PADDR);
		rconst = raddr || q->in.op == ICON;
	}
	else
	{
		raddr = False;
		rconst = True;
	}

	if( u && (o==LE||o==LT||o==GE||o==GT)) o += (UGE-GE);

/*	Someday, can do better on conditionals
 *
 *	if( o == ANDAND || o == OROR )
 *	{
 *		if( !lconst && !rconst )
 *			return(False);
 *	}
 *	else
 *	{
 */
		if( !lconst || !rconst )
			return(False);
/*
 *	}
 */

	if( o == PLUS )
	{
		if( laddr && raddr )
			return(False);
	}
	else
	{
		if( laddr || raddr )
			return(False);
	}

	if( SZLONG > SZINT  &&  otype == BITYPE ){
		if( p->in.op == ICON && ( p->in.type == LONG || q->in.type == LONG ) )
				p->in.type = q->in.type = LONG;
	}

	switch( o ){

	case PLUS:
		if( raddr )
		{
			/* PLUS, ICON, ADDR.  May happen when pass1 opt gets
			 * done with things like a[i] where a is a global and
			 * i is a local.  May also happen on nonsense like
			 * i[a] instead of a[i]
			 */
			q->tn.lval += p->tn.lval;
			*p = *q;
		}
		else
		{
			p->tn.lval += q->tn.lval;
			if( !laddr )
				p->in.type = q->in.type;
		}
		break;
	case MINUS:
		p->tn.lval -= val;
		break;
	case MUL:
		p->tn.lval *= val;
		break;
	case DIV:
		if( val == 0 ) {
			Warning( "division by 0" );
			return(False);
		}
		else
		if( u )
			p->tn.lval = ((UCONSZ) p->tn.lval) / (UCONSZ) val;
		else
				p->tn.lval /= val;
		break;
	case MOD:
		if( val == 0 ) {
			Warning( "division by 0" );
			return(False);
		}
		else
		if( u )
			p->tn.lval = ((UCONSZ) p->tn.lval) % (UCONSZ) val;
		else
			p->tn.lval %= val;
		break;
	case AND:
		p->tn.lval &= val;
		break;
	case OR:
		p->tn.lval |= val;
		break;
	case ER:
		p->tn.lval ^=  val;
		break;
	case LS:
		i = val;
		p->tn.lval = p->tn.lval << i;
		break;
	case RS:
		i = val;
		if( ul )
			p->tn.lval = ((UCONSZ) p->tn.lval) >> i;
		else
			p->tn.lval = p->tn.lval >> i;
		break;

	case UNARY MINUS:
		if( SZLONG > SZINT && p->tn.type == UNSIGNED ) /* its an ICON from sizeof */
			p->tn.lval = (unsigned)-p->tn.lval;
		else
			p->tn.lval = - p->tn.lval;
		break;
	case COMPL:
		if( SZLONG > SZINT && p->tn.type == UNSIGNED ) /* its an ICON from sizeof */
			p->tn.lval = (unsigned)~p->tn.lval;
		else
			p->tn.lval = ~p->tn.lval;
		break;
	case NOT:
		p->tn.lval = !p->tn.lval;
		break;
	case LT:
		p->tn.lval = p->tn.lval < val;
		break;
	case LE:
		p->tn.lval = p->tn.lval <= val;
		break;
	case GT:
		p->tn.lval = p->tn.lval > val;
		break;
	case GE:
		p->tn.lval = p->tn.lval >= val;
		break;
	case ULT:
		p->tn.lval = (UCONSZ)(p->tn.lval) < (UCONSZ)val;
		break;
	case ULE:
		p->tn.lval = (UCONSZ)(p->tn.lval) <= (UCONSZ)val;
		break;
	case UGE:
		p->tn.lval = (UCONSZ)(p->tn.lval) >= (UCONSZ)val;
		break;
	case UGT:
		p->tn.lval = (UCONSZ)(p->tn.lval) > (UCONSZ)val;
		break;
	case EQ:
		p->tn.lval = p->tn.lval == val;
		break;
	case NE:
		p->tn.lval = p->tn.lval != val;
		break;
	case ANDAND:				/* NEW */
		p->tn.lval = p->tn.lval && val;
		break;
	case OROR:				/* NEW */
		p->tn.lval = p->tn.lval || val;
		break;
	case OCONVLEAF:				/* NEW */
	case OCONVTREE:				/* NEW */
	case SCONV:				/* NEW */
		if( !DoCast(p,ty) )
			return(False);
		break;
	case UNARYNOP:				/* NEW */
		break;
	default:
		return(False);
		}
	p->tn.type = ty;
	return(True);
}

/*
 * fconval() was copied directly from conval(), with minor modifications to
 * make it work for floating point values.
 */

Boolean
fconval( p, o, ty, q )
	TreeNode p;
	Operator o;
	TWORD ty;
	TreeNode q;
{
	/* apply the op o to the lval part of p; if binary, rhs is val */

	FCONSZ val;
	Operator otype;

	otype = optype(o);

	if( NoFloatConstFolding )
/**/		return( False );

	if( otype == BITYPE ) {
		if( q->in.op != FCON )
/**/			return( False );
		val = q->fpn.dval;
	}

	if( p->in.op != FCON )
/**/		return( False );

	switch( o ){

	case PLUS:
		p->fpn.dval += val;
		break;
	case MINUS:
		p->fpn.dval -= val;
		break;
	case MUL:
		p->fpn.dval *= val;
		break;
	case DIV:
		if( val == 0.0 ) {
			Warning( "division by 0.0" );
			return(False);
		}
		else
			p->fpn.dval /= val;
		break;

	case UNARY MINUS:
		p->fpn.dval = - p->fpn.dval;
		break;
	case NOT:
		p->tn.lval = !p->fpn.dval;
		p->tn.op = ICON;
		break;
	case LT:
		p->tn.lval = p->fpn.dval < val;
		p->tn.op = ICON;
		break;
	case LE:
		p->tn.lval = p->fpn.dval <= val;
		p->tn.op = ICON;
		break;
	case GT:
		p->tn.lval = p->fpn.dval > val;
		p->tn.op = ICON;
		break;
	case GE:
		p->tn.lval = p->fpn.dval >= val;
		p->tn.op = ICON;
		break;
	case EQ:
		p->tn.lval = p->fpn.dval == val;
		p->tn.op = ICON;
		break;
	case NE:
		p->tn.lval = p->fpn.dval != val;
		p->tn.op = ICON;
		break;
	case ANDAND:				/* NEW */
		p->tn.lval = p->fpn.dval && val;
		p->tn.op = ICON;
		break;
	case OROR:				/* NEW */
		p->tn.lval = p->fpn.dval || val;
		p->tn.op = ICON;
		break;
	case OCONVLEAF:				/* NEW */
	case OCONVTREE:				/* NEW */
	case SCONV:				/* NEW */
		if( !DoCast(p,ty) )
			return(False);
		break;
	case UNARYNOP:				/* NEW */
		break;
	default:
		return(False);
		}
	p->tn.type = ty;
	return(True);
}

