#/* makefile.m4 */
#		      Makefile.m4 for COPT
#		  (c) Copyright 1987 Gould Inc.
#		       All Rights Reserved
#
# @(#) (Gould) $Header: Makefile.m4,v 5.5 89/05/12 12:48:55 pcc Rel-3_0 $
#
#******************************************************************************
#
#	NOTE: This Makefile should be run through m4 to define MACHINE before
#	feeding it to make.  MACHINE is defined in a file called my_machine,
#	created by Makefile, which m4 will incorporate into this file.
#
#******************************************************************************
#
undefine(`index')
#
DESTDIR		=
INSTDIR		= $(DESTDIR)/lib
BASEDIR		= $(DESTDIR)/usr/src/src/lib/pcc/copt
#CC		= /bin/cc
CC		= /bin/cc
CFLAGS		= $(OPT) -DSDBDEBUG -DTWOPASS -DSCCS -DSTORESTATS -I. -DINLINER \
			$(MACHINE)
#
OPT		= -O
#	-O		- Use optimizers.
#	-DSCCS		- Insert SCCS module information.
#	-DSTORESTATS	- Save statistics.
#	-DSDBFLAG	- Add dbx callable debug routines. (Not with -O)
#	-DTWOPASS	- Needed by ccom include files.
#	-I.		- Needed because includes use <> instead of "".
LDFLAGS		= -n $(MACHLDFLAG)
GFLAGS		= -s
PRINT		= /usr/ucb/print
CTAGS		= /usr/ucb/ctags -w
MAKE		= /bin/make
INSTALL		= /usr/bin/install -c
CO		= co
REV		=
PROGRAM		= copt

# "release.h" was present in the list of HDRS, but is no longer used.
HDRS = \
	activity.h allocate.h allocvect.h arith.h \
	availexpr.h benefit.h blocks.h bool.h \
	carrier.h cmanifest.h comsubex.h config.h \
	constant.h cost.h dag.h daghash.h \
	dagsymbol.h dagtree.h deadstore.h delay.h \
	duchain.h erroro.h flow.h gcomsubex.h \
	identifier.h idiom.h inliner.h instruct.h \
	labels.h livedead.h longset.h loop.h \
	ops.h opt.h option.h prune.h readero.h \
	refcount.h storage.h target.h \
	temp.h tree.h udchain.h undef.h writero.h

IHDRS = \
	memory.h pcc.h

SHDRS = \
	caloff.h macdefs.h manifest.h opdesc.h treewalk.h

SRCS = \
	activity.c allocate.c allocvect.c arith.c \
	availexpr.c benefit.c blocks.c carrier.c \
	commo.c comsubex.c constant.c cost.c \
	dag.c daghash.c dagsymbol.c dagtree.c \
	deadstore.c delay.c duchain.c erroro.c \
	findloop.c flow.c gcomsubex.c idiom.c \
	inliner.c instruct.c labels.c livedead.c \
	longset.c loop.c ops.c opt.c \
	option.c pcc.c prune.c readero.c \
	refcount.c storage.c target.c temp.c \
	tree.c udchain.c undef.c writero.c

OBJS = \
	activity.o allocate.o allocvect.o arith.o \
	availexpr.o benefit.o blocks.o carrier.o \
	commo.o comsubex.o constant.o cost.o \
	dag.o daghash.o dagsymbol.o dagtree.o \
	deadstore.o delay.o duchain.o erroro.o \
	findloop.o flow.o gcomsubex.o idiom.o \
	inliner.o instruct.o labels.o livedead.o \
	longset.o loop.o ops.o opt.o \
	option.o pcc.o prune.o readero.o \
	refcount.o storage.o target.o temp.o \
	tree.o udchain.o undef.o writero.o
#
include(my_machine)
undefine(`include')

all:		$(PROGRAM)

$(PROGRAM): 	$(SHDRS) $(OBJS) mkvers
		sh mkvers "Gould/CSD C optimizer" > version.c
		$(CC) $(LDFLAGS) -o $@ $(OBJS) version.c
		rm -f version.c version.o

caloff.h:;	ln -s ../ccom/caloff.h caloff.h
macdefs.h:;	ln -s ../ccom/macdefs.h macdefs.h
manifest.h:;	ln -s ../ccom/manifest.h manifest.h
opdesc.h:;	ln -s ../ccom/opdesc.h opdesc.h
treewalk.h:;	ln -s ../ccom/treewalk.h treewalk.h

clean:		exclean
		rm -f $(SHDRS) $(OBJS) version.* a.out core

exclean:;	rm -f $(PROGRAM)

depend:
		$(CC) -M $(CFLAGS) $(SRCS) > makedep
		cp Makefile.m4 Makefile.m4.bak
		echo >> Makefile.m4
		echo '#DO NOT DELETE THIS LINE -- DEPENDENCIES FOLLOW' \
		   >> Makefile.m4
		echo >> Makefile.m4
		cat makedep >> Makefile.m4
		rm -f makedep

index:;		$(CTAGS) $(IHDRS) $(HDRS) $(SRCS)

install:;	$(INSTALL) $(PROGRAM) $(INSTDIR)

print:;		@$(PRINT) $(IHDRS) $(HDRS) $(SRCS) Makefile Makefile.m4 Mach_types

base:;		-mkdir $(BASEDIR)
		for i in $(SRCS) $(HDRS) Makefile Makefile.m4 Mach_types mkvers; do \
		$(CO) $(COFLAGS) -p$(REV) RCS/$$i,v > $(BASEDIR)/$$i; \
		done
