/*~!ieee.c*/
/* Name:  ieee.c Part No.: _______-____r
 *
 * Copyright 1992 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nbclib:ieee.c	1.0"

/* IEEE 32 bit floating point format */
typedef struct {
    unsigned s:1, e:8, f:23;
} IE3F;

/* Gould 32 bit floating point format */
typedef struct {
    unsigned e:8, f:24;
} GLDF;

typedef union {
    IE3F ie3;
    GLDF gld;
    float f;
    int i;
} UF;

static int pwr2[] = {0x41400000, 0x41800000, 0x42100000, 0x42200000};

/*
 * Fortran callable conversion routine - IEEE 32 bit format to
 *  Gould single precision floating point format.
 * Usage: real x, cvtie3f, y
 *        y = cvtie3f(x)
 *  where x has been set to a value in IEEE format
 * Note: denormalized values are treated as zero and NaN's are
 *  treated as 'infinity' (largest representable magnitude).
 */

float
cvtie3f_(x)
float *x;
{
    float val;
    UF uv, uf;

    uv.f = *x;
    if (uv.ie3.e == 0)
	return ((float) 0.0);
    if (uv.ie3.e == 255) {
	uf.i = 0x7fffffff;
	val = uf.f;
	goto ret;
    }
    uf.i = 0x40800000 | uv.ie3.f; /* fraction 1.f scaled by 2^-1 */
    val = uf.f;
    /* scaling factor: let IEEE exponent be e == 4*e0 + e1 */
    /* then 2^(e-127)*2 = 2^(4*e0-128+e1+2) = 16^(e0-32)*2^(e1+2) */
    /* e0-32 is an increment to Gould flpt exponent */
    /* 2^(e1+2) comes from table */
    uf.i = (((uv.ie3.e >> 2) - 32) << 24) + pwr2[uv.ie3.e & 0x3];
    val *= uf.f;
ret:
    if (uv.ie3.s)
	return (-val);
    else
	return (val);
}

/* IEEE 64 bit floating point format */
typedef struct {
    unsigned s:1, e:11, f0:20;
    unsigned f1;
} IE3D;

/* Gould 64 bit floating point format */
typedef struct {
    unsigned e:8, f0:24;
    unsigned f1;
} GLDD;

typedef union {
    IE3D ie3;
    GLDD gld;
    double d;
    int i[2];
} UD;

/*
 * Fortran callable conversion routine - IEEE 64 bit format to
 *  Gould double precision floating point format.
 * Usage: double precision x, cvtie3d, y
 *        y = cvtie3d(x)
 *  where x has been set to a value in IEEE format
 * Note: denormalized values are treated as zero and NaN's are
 *  treated as 'infinity' (largest representable magnitude).
 */

double
cvtie3d_(x)
double *x;
{
    double val;
    UD uv, ud;

    uv.d = *x;
    if (uv.ie3.e < 763)
	return ((float) 0.0);
    if (uv.ie3.e > 1278) {
	ud.i[0] = 0x7fffffff;
	ud.i[1] = 0xffffffff;
	val = ud.d;
	goto ret;
    }
    /* get fraction 1.f scaled by 2^-1 */
    ud.i[0] = 0x40800000 | (uv.ie3.f0 << 3)
		| ((uv.ie3.f1 & 0xe0000000) >> 29);
    ud.i[1] = (uv.ie3.f1 & 0x1fffffff) << 3;
    val = ud.d;
    /* scaling factor: let IEEE exponent be e == 4*e0 + e1 */
    /* then 2^(e-1023)*2 = 2^(4*e0-1024+e1+2) = 16^(e0-256)*2^(e1+2) */
    /* e0-256 is an increment to Gould flpt exponent */
    /* 2^(e1+2) comes from table */
    ud.i[0] = (((uv.ie3.e >> 2) - 256) << 24) + pwr2[uv.ie3.e & 0x3];
    ud.i[1] = 0;
    val *= ud.d;
ret:
    if (uv.ie3.s)
	return (-val);
    else
	return (val);
}

float
cvtfie3_(x)
float *x;
{
    UF uv, uf;
    int exp;
    double fabs(), frexp();

    uf.f = *x;
    if (uf.f == (float) 0.0)
	return((float) 0.0);
    uv.ie3.s = (uf.i < 0) ? 1 : 0;
    uf.f = (float) frexp(fabs((double) uf.f), &exp);
    if (exp > 128) {
	exp = 129;
	uf.i = 0;
    }
    if (exp <= -126) {
	exp = -126;
	uf.i = 0;
    }
    uv.ie3.e = exp + 126;
    uv.ie3.f = uf.i & 0x007fffff;
    return(uv.f);
}

double
cvtdie3_(x)
double *x;
{
    UD uv, ud;
    int exp;
    double fabs(), frexp();

    ud.d = *x;
    if (ud.d == 0.0)
	return(0.0);
    uv.ie3.s = (ud.i[0] < 0) ? 1 : 0;
    ud.d = frexp(fabs(ud.d), &exp);
    uv.ie3.e = exp + 1022;
    uv.ie3.f0 = ((ud.i[0] & 0x007ffff8) >> 3);
    uv.ie3.f1 = ((ud.i[0] & 0x00000007) << 29)
		+ ((unsigned) (ud.i[1] & 0xfffffff8) >> 3);
    return(uv.d);
}
