*  *********************************************************************
*  
*  
*       Rev  004  12-MAY-89 15:04  GANN      GANN     
*   Version control header added                                        
*  
*
************************************************************************
         SUBROUTINE   OUT_NEW_BLOCK(LINE_BUF,LINE_LEN,TYPE,CAROT)

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         CHARACTER    LINE_BUF*1(132)
         INTEGER      LINE_LEN,LLEN,LLEN1*1(4),TYPE*1,CAROT*2,LAST_NUM
         INTEGER      HALF*2,LBYTE*1(2),IBYTE*1
         BIT          IBIT(8),BIT_OBJ1(800),BIT_OBJ5(800)           !002
         LOGICAL      COMPRESS

         INCLUDE 'OBJ_COM.INC'

         INTEGER      I, IB, J                                  !001
         EQUIVALENCE  (LLEN,LLEN1),(HALF,LBYTE)
         EQUIVALENCE  (BIT_OBJ1,OBJ_COMMAND(21)),(IBIT,IBYTE)       !002
         EQUIVALENCE  (BIT_OBJ5,OBJ_COMMAND(25))                    !002
         DATA         LAST_NUM/0/


*  INSURE EXTENDED IS NOT SET

         INLINE
         CEA
         NOP
         ENDI

*  DETERMINE WHETHER OR NOT TO COMPRESS SOURCE.

         COMPRESS = .TRUE.
         DO I=3,LINE_LEN
            IF (ICHAR(LINE_BUF(I)).GE.96) THEN
               COMPRESS = .FALSE.        !LOWER CASE
            END IF
         END DO

*  IF WE DON'T COMPRESS SOURCE (BECAUSE OF LOWER CASE) THEN
*  TELL CATALOGER BY SETTING BIT 0 IN THE ISC SUB_TYPE BYTE.

         IF (.NOT. COMPRESS) THEN
            TYPE = TYPE + 128
         END IF

* IF NEW SOURCE LINE, THEN OUTPUT WHOLE LINE

         IF (CAROT.EQ.0) THEN

*  SET LENGTH

            IF (COMPRESS) THEN
               LLEN = ((LINE_LEN-2)*6)/8
               IF (MOD((LINE_LEN-2)*6,8).NE.0) THEN
                  LLEN = LLEN + 1
               END IF
               LLEN = LLEN + 2
            ELSE
               LLEN = LINE_LEN
            END IF
                IF (OBJ_TYP .EQ. 30) THEN                           !002
                     OBJ_COMMAND(3) = 22 + LLEN1(4)                 !002
                ELSE                                                !002
                     OBJ_COMMAND(3) = 18 + LLEN1(4)
                ENDIF                                               !002

*  NOW MOVE SOURCE INTO OBJ_COMMAND (BIAS ASCII CHARACTERS BY -20)

            IF (OBJ_TYP .EQ. 30) THEN                               !002
                 OBJ_COMMAND(23) = ICHAR(LINE_BUF(1))               !002
                 OBJ_COMMAND(24) = ICHAR(LINE_BUF(2))               !002
            ELSE                                                    !002
                 OBJ_COMMAND(19) = ICHAR(LINE_BUF(1))
                 OBJ_COMMAND(20) = ICHAR(LINE_BUF(2))
            ENDIF                                                   !002
            IF (COMPRESS) THEN
               IF (OBJ_TYP .EQ. 30) THEN                            !002
                    DO I=25,LINE_LEN+22                             !002
                       OBJ_COMMAND(I) = ICHAR(LINE_BUF(I-22)) - 32  !002
                    END DO                                          !002
               ELSE                                                 !002
                    DO I=21,LINE_LEN+18
                       OBJ_COMMAND(I) = ICHAR(LINE_BUF(I-18)) - 32
                    END DO
               ENDIF                                                !002
            ELSE
               IF (OBJ_TYP .EQ. 30) THEN                            !002
                    DO I=25,LINE_LEN+22                             !002
                       OBJ_COMMAND(I) = ICHAR(LINE_BUF(I-22))       !002
                    END DO                                          !002
               ELSE                                                 !002
                    DO I=21,LINE_LEN+18
                       OBJ_COMMAND(I) = ICHAR(LINE_BUF(I-18))
                    END DO
               ENDIF                                                !002
            END IF

*  NOW COMPRESS EACH CHARACTER TO 6 BITS

            IF (COMPRESS) THEN
               IB = 1
               IF (OBJ_TYP .EQ. 30) THEN                            !002
                    DO I=25,LINE_LEN+22                             !002
                       IBYTE = OBJ_COMMAND(I)                       !002
                       DO J=3,8                                     !002
                          BIT_OBJ5(IB) = IBIT(J)                    !002
                          IB = IB + 1                               !002
                       END DO                                       !002
                    END DO                                          !002
               ELSE                                                 !002
                    DO I=21,LINE_LEN+18
                       IBYTE = OBJ_COMMAND(I)
                       DO J=3,8
                          BIT_OBJ1(IB) = IBIT(J)                    !002
                          IB = IB + 1
                       END DO
                    END DO
               ENDIF                                                !002
            END IF

*  SET DATA BLOCK LENGTH

            IF (OBJ_TYP .EQ. 30) THEN                               !002
                 OBJ_LENGTH = LLEN + 22                             !002
            ELSE                                                    !002
                 OBJ_LENGTH = LLEN + 18
            ENDIF                                                   !002

*  CLEAR ANY PREVIOUS CAROT VALUE

            IF (OBJ_TYP .EQ. 30) THEN                               !002
                 OBJ_COMMAND(22) = 0                                !002
            ELSE                                                    !002
                 OBJ_COMMAND(10) = 0
            ENDIF                                                   !002

         ELSE

            IF (OBJ_TYP .EQ. 30) THEN                               !004
                OBJ_COMMAND(3) = OBJ_COMMAND(3) + 2                 !004
                OBJ_LENGTH = OBJ_LENGTH + 2                         !004
            ENDIF                                                   !004

*  INSERT POINTER TO PREVIOUS SOURCE LINE

            HALF = CAROT - 2
            IF (OBJ_TYP .EQ. 30) THEN                               !002
                 OBJ_COMMAND(22) = LBYTE(2)                         !002
            ELSE                                                    !002
            OBJ_COMMAND(10) = LBYTE(2)
            ENDIF                                                   !002
         END IF

*  SET ISC SUB_TYPE

         IF (OBJ_TYP .EQ. 30) THEN                                  !002
              OBJ_COMMAND(21)  = TYPE                               !002
         ELSE                                                       !002
              OBJ_COMMAND(9)  = TYPE
         ENDIF                                                      !002

*  NOW INSERT DATA BLOCK INTO OUTPUT BUFFER

         CALL OUT_BLOCK();

         RETURN
         END
         SUBROUTINE   OUT_BLOCK();

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         INCLUDE 'OBJ_COM.INC'

         INTEGER        J_LAST, J                                   !001
         INTEGER      OBJ_BUF*1(120),OBJ_SEQ*2
         EQUIVALENCE  (OBJ_SEQ,OBJ_BUF(5))
         DATA         J_LAST/7/
         DATA         OBJ_SEQ/0/


         IF (J_LAST+OBJ_LENGTH .GT. 120) THEN
            OBJ_BUF(1) = X'FF'
            OBJ_BUF(2) = J_LAST - 7
            IF (J_LAST.LE.120) THEN
               DO J=J_LAST,120
                  OBJ_BUF(J) = 0
               END DO
            END IF
            OBJ_SEQ = OBJ_SEQ + 1
            CALL CHECK_SUM(OBJ_BUF)
            J_LAST = 7
         END IF

*  MOVE OBJECT DATA BLOCK TO OUTPUT BUFFER

         DO J=J_LAST,J_LAST + OBJ_LENGTH - 1
            OBJ_BUF(J) = OBJ_COMMAND( J - J_LAST + 1)
         END DO

*  NOW BUMP OUTPUT BUFFER POINTER

         J_LAST = J_LAST + OBJ_LENGTH

         RETURN

         ENTRY CHECK_BUF

         OBJ_BUF(1) = X'DF'
         OBJ_BUF(2) = J_LAST - 7
         OBJ_SEQ    = OBJ_SEQ + 1
         DO J=J_LAST,120
            OBJ_BUF(J) = 0
         END DO
         CALL CHECK_SUM(OBJ_BUF)
         OBJ_SEQ = 0
         J_LAST  = 7
         RETURN
         END
         SUBROUTINE   CHECK_SUM(OBJ_BUF)

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         INTEGER      J, ISTAT                                  !001
         INTEGER      OBJ_BUF*1(120),ISUM,ISUM1*1(4),FCB(8),PROG*8
         EQUIVALENCE  (ISUM,ISUM1)
         DATA         PROG/0/


*  COMPUTE OBJECT RECORD CHECKSUM

         ISUM = 0
         DO J=7,120
            ISUM = ISUM + OBJ_BUF(J)
         END DO
         ISUM = IAND(ISUM,X'FFFF')
         OBJ_BUF(3) = ISUM1(3)
         OBJ_BUF(4) = ISUM1(4)

*  NOW WRITE OBJECT MODULE

         CALL WRIT_REC(120,OBJ_BUF,4HGO  ,ISTAT)                    !MOD
         IF (ISTAT.NE.0) THEN
            CALL M:ABORT(PROG,4HFT04)
         END IF

         RETURN
         END
         SUBROUTINE   SET_SYM(D_SYM)

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         INCLUDE 'OBJ_COM.INC'


*  MOVE SYMBOL FROM OBJECT DATA BLOCK TO D_SYM

         INTEGER      D_SYM*1(8)

         INTEGER      I                                         !001

* When compiling for native mode (FORT41NN) we enter here extended

         INLINE
         CEA
         ENDI

         DO I=1,8
             IF (OBJ_TYP .EQ. 30) THEN                              !002
                  D_SYM(I) = OBJ_COMMAND(I+12)                      !002
             ELSE                                                   !002
                  D_SYM(I) = OBJ_COMMAND(I+10)
             ENDIF                                                  !002
          END DO
          RETURN
          END
      LOGICAL FUNCTION NEXT_DATA_BLOCK()

         INCLUDE 'OBJ_COM.INC'


*  PURPOSE:  THIS ROUTINE WILL RETRIEVE THE NEXT OBJECT DATA BLOCK
*            FROM 'GO'

*  INPUT:    ASSIGNED SGO AND LIBRARY FILES

*  OUTPUT:   (COMMON VARIABLES)
*            NEXT_DATA_BLOCK = .TRUE., IF A NEXT DATA BLOCK EXISTS
*                              .FALSE.,OTHERWISE
*            OBJ_TYP         = OBJECT BLOCK TYPE (16+SUBTYPE IF EXT)
*            OBJ_LENGTH      = ACTUAL LENGTH OF OBJECT BLOCK
*            OBJ_LLENGTH     = LOGICAL LENGTH OF OBJECT BLOCK
*            OBJ_CKSUM       = CHECKSUM OF OBJECT BLOCK
*            OBJ_COMMAND     = OBJECT DATA BLOCK
*            OBJ_EOF         = (OPPOSITE FROM NEXT_DATA_BLOCK)
*            OBJ_LFC         = LFC WHERE NEXT DATA BLOCK CAME FROM
*            OBJ_RECORD      = CURRENT OBJECT RECORD
*            OBJ_START       = START OF CURRENT DATA BLOCK IN OBJ_RECORD
*            OBJ_FNUM        = SEQUENTIAL FILE NUMBER
*            OBJ_FTYP        = 0  (IF OBJ_EOF = .TRUE)
*                            = 1  SYSTEM SGO FILE
*                            = 2  PERMANENT SGO FILE
*                            = 3  PERMANENT LIBRARY FILE
*            OBJ_LOC         = CURRENT LOCATION COUNTER

*            OBJ_LAST        = .TRUE., WHEN READING LAST OBJECT
*                              MODULE OF A LIBRARY
*            LIB_EOF         = .TRUE., WHEN WE HAVE READ THE
*                              LAST DATA BLOCK ON A LIBRARY

*  LOCAL DECLARATIONS

      INTEGER  OBJ_NEXT,ORG_ADDRESS,ORG_BYTE*1(4)
      LOGICAL INIT
      EQUIVALENCE  (ORG_ADDRESS,ORG_BYTE)
      DATA    INIT/.TRUE./

      IF (INIT) THEN
         OBJ_START = 0
         OBJ_NEXT = 0
         OBJ_REC_LEN = 0
         OBJ_EOF = .FALSE.
         OBJ_LAST= .TRUE.
         INIT    = .FALSE.
         OBJ_LOC = 0
      END IF

*  READ NEXT OBJECT RECORD (IF NECESSARY)

      IF (OBJ_NEXT.GE.OBJ_REC_LEN.OR.OBJ_TYP.EQ.X'F') THEN
         CALL READ_NXT_OBJ ()
         IF (OBJ_EOF) THEN
            NEXT_DATA_BLOCK = .FALSE.
            RETURN
         END IF
         OBJ_START   = 7
         OBJ_REC_LEN = OBJ_RECORD(2)+7
      ELSE
         OBJ_START = OBJ_NEXT
      END IF

*  HERE, THERE EXISTS ANOTHER DATA BLOCK

      NEXT_DATA_BLOCK = .TRUE.

*  DETERMINE OBJECT DATA BLOCK TYPE

      OBJ_TYP = OBJ_RECORD(OBJ_START)
      OBJ_TYP = ISHFT(OBJ_TYP, -4)

*  SET OBJECT DATA BLOCK LENGTH

      IF (OBJ_TYP.EQ.13) THEN
         OBJ_TYP     = OBJ_RECORD(OBJ_START+1) + 16
         OBJ_LENGTH  = OBJ_RECORD(OBJ_START+2)
         OBJ_LLENGTH = OBJ_LENGTH - 3
      ELSE
         OBJ_LLENGTH = IAND(OBJ_RECORD(OBJ_START),X'F')
         IF (OBJ_LLENGTH.EQ.0) THEN
            OBJ_LLENGTH = 16
         END IF
         OBJ_LENGTH  = OBJ_LLENGTH + 1
      END IF

*  SET OBJECT COMMAND

      LEN_CTRL = OBJ_LENGTH - OBJ_LLENGTH
      DO I=1,OBJ_LENGTH
         OBJ_COMMAND(I) = OBJ_RECORD(OBJ_START+I-1)
      END DO

*  SET START OF NEXT DATA BLOCK

      OBJ_NEXT = OBJ_START + OBJ_LENGTH

      RETURN

      ENTRY INIT_OBJ ()
      INIT = .TRUE.
      CALL RD_INIT ()
      RETURN
      END
      SUBROUTINE READ_NXT_OBJ ()

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         INCLUDE 'OBJ_COM.INC'

*  ROUTINE TO READ NEXT OBJECT RECORD INTO THE ARRAY 'OBJ_RECORD'.

*  LOCAL DECLARATIONS

      INTEGER         IEOF, NBYTES                            !001
      INTEGER  LFC_SGO,INFO*2(8)
      LOGICAL  EOF_SGO,INIT,MORE_LIB
      DATA     EOF_SGO,INIT,LFC_SGO/.FALSE.,.TRUE.,4HGO* /          !MOD


*  ON FIRST ENTRY, CHECK STATUS OF SGO

      IF (INIT) THEN
         OBJ_FTYP = 2
         OBJ_FNUM = 1
         EOF_SGO = .FALSE.
         INIT = .FALSE.
      END IF

*  IF WE HAVE NOT EXHAUSTED 'SGO' THEN CONTINUE 'SGO' READ

      IF (.NOT.EOF_SGO) THEN
         CALL READ_REC(120,OBJ_RECORD,4HGO* ,IEOF,NBYTES)
         IF (IEOF.EQ.1) THEN
            GO TO 10
         END IF
         OBJ_LFC = LFC_SGO
         RETURN
      END IF

*  HERE 'SGO' EXHAUSTED.  FETCH NEXT OBJECT RECORD FROM LIBRARIES

10    EOF_SGO = .TRUE.
      OBJ_EOF = .TRUE.
      OBJ_FTYP= 0

      RETURN

      ENTRY RD_INIT ()
      INIT = .TRUE.
      RETURN
      END
      SUBROUTINE PARSE_ARRAY(BUF1,START,STATE,NBYTES,LAST_TOKEN,FSC)

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

         INTEGER         I, IBOUND, J, K                         !001
      CHARACTER  BUF1*1(132),ID_BUF*1(80),CHRNXT*1(4),LAST_TOKEN*10
      CHARACTER  LBUFC*40
      INTEGER    START,STATE,NBYTES,GETCHR,NXTCHR,ID_START,ID_END,
     1           NUM_DIMENSION,BOUND,NUM_ARRAY,DIGIT_COUNT,
     2           BOUND_NUM,NOTNUM
C920081 INTEGER    ARRAY_STAT(32,1000),ARR_STB*1(128,1000),ARR_2*2(64, !V5.1.1.2
      INTEGER    ARRAY_STAT(32,1500),ARR_STB*1(128,1500),ARR_2*2(64,
     +           1500)
C920081 +           1000)                                              !V5.1.1.2
C920081 INTEGER    IBYTE*1,OB,NUM_PARAM,ARRAY_PARM(3,2000),PARAM4(2)   !V5.1.1.2
      INTEGER    IBYTE*1,OB,NUM_PARAM,ARRAY_PARM(3,3000),PARAM4(2)
      INTEGER    PARAM_NAME*8,LSIZE,LBUF(10),ISTAT
      INTEGER*8  DBL_BOUND,BOUND_PTR
      LOGICAL    ARRAY_FOUND,LOWER_BOUND,SYM_BOUND,PARAM_FOUND
      LOGICAL    ARR_CHANGE,STARLAST,FSC
      LOGICAL    CHARDAT                                       !V5.1.6 910769
      BIT        BIT_IN(8),BIT_OUT(64)
C920081 CHARACTER  ARR_STATC*1(128,1200),CHAR_BOUND*1(8)              !V5.1.1.2
      CHARACTER  ARR_STATC*1(128,1700),CHAR_BOUND*1(8)
C920081 CHARACTER  ARR_PARMC*1(12,2000)                               !V5.1.1.2
      CHARACTER  ARR_PARMC*1(12,3000)
      COMMON/A/  NUM_ARRAY,NUM_PARAM
      EXTENDED BLOCK/ASTAT/ARRAY_STAT,ARRAY_PARM
      EXTENDED BASE/ASTAT/256
      EQUIVALENCE (LBUF,LBUFC)
      EQUIVALENCE (ARRAY_STAT,ARR_STATC),(CHAR_BOUND,DBL_BOUND)
      EQUIVALENCE (ARRAY_STAT,ARR_STB),(ARRAY_STAT,ARR_2)
      EQUIVALENCE (NXTCHR,CHRNXT),(BIT_IN,IBYTE),(BIT_OUT,DBL_BOUND)
      EQUIVALENCE (ARRAY_FOUND,PARAM_FOUND),(ARRAY_PARM,ARR_PARMC)
      EQUIVALENCE (PARAM4,PARAM_NAME)
      DATA  LBUFC/' *** LIMIT OF 2000 PARAMETERS/SUBROUTINE'/
      DATA  LSIZE/40/


      I = START; STARLAST = .FALSE.;
      FSC = .FALSE.
      CHARDAT = .FALSE.
C920081 DO UNTIL (I .GT. NBYTES.OR. NUM_ARRAY .GT. 1000)       !V5.1.1.2
      DO UNTIL (I .GT. NBYTES.OR. NUM_ARRAY .GT. 1500)
         NXTCHR = GETCHR(I)
         IF (NXTCHR .EQ. 32) THEN
            LEAVE
         END IF
         IF (NXTCHR .EQ. 59) THEN      !FOUND A SEMI-COLON, NEW LINE
            FSC = .TRUE.
            START = I
            LEAVE
         END IF
         GO TO (1,2,3,4,5,6) STATE + 1

*  STATE 0

  1      SELECT CASE NXTCHR
            CASE 32,42,40,44       ! BLANK * ( ,
               STATE = 0
            CASE 33                ! '!'
               STATE = 0
               I = NBYTES + 1
            CASE 47                ! /
               STATE = 5
            CASE 48:57             ! ANY DIGIT
               STATE = 0
            CASE DEFAULT           ! START OF IDENTIFIER
               STATE = 1
         END SELECT
         ID_START = 1
         ID_END   = 1
         ID_BUF(ID_START) = CHRNXT(4)
         ARRAY_FOUND = .FALSE.
         GO TO 100

*  STATE 1

  2      SELECT CASE NXTCHR
            CASE 33                ! '!'
               STATE = 0
               I = NBYTES + 1
            CASE 41,44             ! ) ,
               STATE = 0
            CASE 47                ! /
               STATE = 5
            CASE 42                ! *
               STATE = 2
               STARLAST = .TRUE.
            CASE 40,61             ! ( =
               STATE = 3
            CASE DEFAULT
               STATE = 1
               IF (ID_END .LT. 80) THEN
                  ID_END = ID_END + 1
                  ID_BUF(ID_END) = CHRNXT(4)
               END IF
         END SELECT
         GO TO 100

*  STATE 2

  3      SELECT CASE NXTCHR
            CASE 33                ! '!'
               STATE = 0
               I = NBYTES + 1
            CASE 48:57             ! ANY DIGIT
               STATE = 2
            CASE 41,44             ! ) ,
               STATE = 0
            CASE 40                ! (
               IF ( STARLAST ) THEN   ! CHARACTER*(*) NOT AN ARRAY
                  STATE = 0
               ELSE
                  STATE = 3
               ENDIF
            CASE DEFAULT
               STATE = 1
         END SELECT
         STARLAST = .FALSE.
         GO TO 100

*  STATE 3

  4      IF (.NOT. ARRAY_FOUND) THEN
            NUM_DIMENSION = 0;
            BOUND         = 0;
            IBOUND        = 1;
            BOUND_NUM     = 0;
            BOUND_PTR     = 0;
            DBL_BOUND     = X'2020202020202020'
            ARR_CHANGE    = .FALSE.
            IF (ID_END .GT. ID_START+7) THEN
               ID_END = ID_START + 7
            END IF
            IF (LAST_TOKEN .NE. 'PARAMETER') THEN
               NUM_ARRAY     = NUM_ARRAY + 1
               DO J=1,32
                  ARRAY_STAT(J,NUM_ARRAY) = 0
               END DO
               DO J = ID_START,ID_END
                  ARR_STATC(J-ID_START+1,NUM_ARRAY) = ID_BUF(J)
               END DO

*  BLANK FILL ARRAY NAME

               IF (ID_END - ID_START .LT. 7) THEN
                  DO J= ID_END - ID_START + 2, 8
                     ARR_STATC(J,NUM_ARRAY) = ' '
                  END DO
               END IF
               ARRAY_FOUND = .TRUE.
            ELSE
               NUM_PARAM = NUM_PARAM + 1
C920081         IF (NUM_PARAM .GT. 2000) THEN                  !V5.1.1.2
               IF (NUM_PARAM .GT. 3000) THEN
                  CALL WRIT_REC (LSIZE,LBUF,4HLO  ,ISTAT)           !MOD
                  STOP
               END IF
               DO J=1,3
                  ARRAY_PARM(J,NUM_PARAM) = 0
               END DO
               DO J = ID_START,ID_END
                  ARR_PARMC(J-ID_START+1,NUM_PARAM) = ID_BUF(J)
               END DO

*  BLANK FILL PARAMETER NAME

               IF (ID_END - ID_START .LT. 7) THEN
                  DO J= ID_END - ID_START + 2, 8
                     ARR_PARMC(J,NUM_PARAM) = ' '
                  END DO
               END IF
               PARAM_FOUND = .TRUE.
            END IF

            DIGIT_COUNT = 0
         END IF

         SELECT CASE NXTCHR
            CASE 45                ! -
               IBOUND = -1
            CASE 48:57             ! ANY DIGIT
               STATE = 3
               DIGIT_COUNT = DIGIT_COUNT + 1
               CHAR_BOUND(DIGIT_COUNT) = CHAR(NXTCHR)
            CASE 41                ! )
15             STATE = 0
               IF (LAST_TOKEN .EQ. 'PARAMETER') THEN
                  CALL RECORD_PARM
                  GO TO 100
               END IF
               CALL  RECORD_BOUND
               IF (SYM_BOUND) THEN     !RECORD BOUND AS SYMBOLIC
                  ARR_2(8,NUM_ARRAY) = ARR_2(8,NUM_ARRAY) +
     &                                 2 ** (BOUND_NUM - 1)
               END IF
               SYM_BOUND = .FALSE.
               NUM_DIMENSION = NUM_DIMENSION + 1
               ARR_STB (9,NUM_ARRAY)  = NUM_DIMENSION
               ARR_STB (10,NUM_ARRAY) = BOUND_NUM
               ARR_STB (13,NUM_ARRAY) = (BOUND_PTR+2)*4

*  CONVERT TO SINGLY DIMENSIONED ARRAY IF BOUND CONTAINS EXPRESSION

               IF (ARR_CHANGE) THEN
                  ARR_STB (9,NUM_ARRAY)  = 1
                  ARR_STB (10,NUM_ARRAY) = 1
                  ARR_STB (13,NUM_ARRAY) = 12
                  ARRAY_STAT (6,NUM_ARRAY) = 1
                  ARR_2 (6,NUM_ARRAY) = 0
                  ARR_2 (8,NUM_ARRAY) = 0
               END IF
            CASE 44,58             ! , :
               IF (LAST_TOKEN .EQ. 'PARAMETER') THEN
                  CALL RECORD_PARM
                  STATE = 0
                  GO TO 100
               END IF
20             STATE = 3
               CALL RECORD_BOUND
               IF (SYM_BOUND) THEN     !RECORD BOUND AS SYMBOLIC
                  ARR_2(8,NUM_ARRAY) = ARR_2(8,NUM_ARRAY) +
     &                                 2 ** (BOUND_NUM - 1)
               END IF
               SYM_BOUND = .FALSE.
               IF (NXTCHR.EQ.58) THEN   ! INDICATE LOWER BOUND
                  ARR_2 (6,NUM_ARRAY) = ARR_2 (6,NUM_ARRAY) +
     &                                    2 ** (BOUND_NUM - 1)
               ELSE
                  NUM_DIMENSION = NUM_DIMENSION + 1
               END IF
            CASE 33                ! '!'
               I = NBYTES + 1
            CASE 42,43,47          ! * + /
               STATE = 4
               DBL_BOUND = X'2020202020202020'
               IBOUND    = 1
            CASE DEFAULT
               STATE = 3
               SYM_BOUND = .TRUE.
               DIGIT_COUNT = DIGIT_COUNT + 1
               IF (DIGIT_COUNT .LE. 8) THEN
                  CHAR_BOUND(DIGIT_COUNT) = CHAR(NXTCHR)
               END IF
         END SELECT
         GO TO 100

*  STATE 4 (EXPRESSION IN ARRAY BOUNDS OR PARAMETER STATEMENT)

 5       SELECT CASE NXTCHR
            CASE 33                ! '!'
               I = NBYTES + 1
            CASE 41                ! )
               IF (LAST_TOKEN .EQ. 'PARAMETER') THEN
                  ARRAY_PARM(3,NUM_PARAM) = X'01020304'
                  STATE = 0
               ELSE
                  GO TO 15
               END IF
            CASE 44,58             ! , :
               IF (LAST_TOKEN .EQ. 'PARAMETER') THEN
                  ARRAY_PARM(3,NUM_PARAM) = X'01020304'
                  STATE = 0
               ELSE
                  GO TO 20
               END IF
            CASE DEFAULT
               STATE = 4
         END SELECT
          ARR_CHANGE = .TRUE.
         GO TO 100

*  STATE 5 -- IGNORE ALL CHARACTERS UNTIL BACKSLASH FOUND

  6      SELECT CASE NXTCHR
            CASE 33                ! '!'
               STATE = 5
               I = NBYTES + 1
            CASE 47,92             ! SLASH & BACKSLASH
               IF (CHARDAT) THEN   ! MAY HAVE A / '/' / CASE     !V5.1.6 910769
                 STATE = 5         !  IF SO KEEP IGNORING CHARS  !V5.1.6 910769
               ELSE                !                             !V5.1.6 910769
                 STATE = 0
               ENDIF
            CASE 39                ! QUOTE '  (CHARACTER STRING)  !V5.1.6 910769
               CHARDAT = .NOT. CHARDAT   !TOGGLE CHARDAT          !V5.1.6 910769
               STATE = 5
            CASE DEFAULT           ! START OF IDENTIFIER
               STATE = 5
         END SELECT

100      CONTINUE
         IF (BOUND_NUM .GE. 15. .OR. NUM_DIMENSION .GE. 8) THEN
            INLINE
            CEA
            ENDI
            RETURN
         END IF
         END DO
         RETURN
         INTERNAL SUBROUTINE RECORD_BOUND
         BOUND_NUM = BOUND_NUM + 1

*  CHECK FOR SYMBOLIC PARAMETER

         IF (SYM_BOUND) THEN
            DO J=1,NUM_PARAM
               PARAM4(1) = ARRAY_PARM(1,J)
               PARAM4(2) = ARRAY_PARM(2,J)
               IF (PARAM_NAME .EQ. DBL_BOUND) THEN
                  BOUND = ARRAY_PARM(3,J)
                  IF (BOUND .EQ.X'01020304') THEN  ! EXPRESSION
                     ARR_CHANGE = .TRUE.
                     DBL_BOUND = 0
                     GO TO 17
                  END IF
                  SYM_BOUND = .FALSE.
                  GO TO 11
               END IF
            END DO
         END IF

*  FIRST, RECORD NUMERIC BOUND

         IF (.NOT. SYM_BOUND) THEN
            INLINE
            LD        6,DBL_BOUND
            SVC       1,X'28'
            STW       7,BOUND
            ENDI

            BOUND = BOUND * IBOUND    ! POSSIBLE NEGATION
11          IBOUND= 1                 ! RESET IBOUND
            DBL_BOUND = X'2020202020202020'
            IF (BOUND_NUM .LE. 14) THEN
               ARRAY_STAT (BOUND_PTR+5,NUM_ARRAY) = BOUND
            END IF
            BOUND_PTR = BOUND_PTR + 1
            DIGIT_COUNT = 0
            BOUND       = 0
         ELSE

*  HERE, RECORD SYMBOLIC BOUND. FIRST, COMPRESS THE SYMBOL NAME.

            OB = 1
            DO J=1,8
               IBYTE = ICHAR(CHAR_BOUND(J)) - 32
               DO K=3,8
                  BIT_OUT(OB) = BIT_IN(K)
                  OB = OB + 1
               END DO
            END DO

*  NOW RIGHT JUSTIFY SYMBOL NAME TO RIGHT MOST SIX BYTES

17          CONTINUE
            INLINE
            LD     6,DBL_BOUND
            SRLD   6,16             ! RIGTH JUSTIFY SYMBOL NAME
            SBR    6,2              ! INDICATE SYMBOLIC BOUND
            STD    6,DBL_BOUND
            ENDI

*  INDICATE WHETHER OR NOT BOUND IS NEGATIVE

            IF (IBOUND .EQ. -1) THEN
               INLINE
               SBM   3,DBL_BOUND    ! BOUND IS NEGATIVE
               ENDI
            END IF

*  MOVE BOUND IN TO ARRAY STATUS ARRAY

            IF (BOUND_NUM .LE. 14) THEN
               DO J=1,8
               ARR_STATC((BOUND_PTR+4)*4+J,NUM_ARRAY) = CHAR_BOUND(J)
               END DO
            END IF

*  BUMP 'BOUND_PTR' & RESET OTHER BOUND COUNTERS

            BOUND_PTR = BOUND_PTR + 2
            DBL_BOUND = X'2020202020202020'
            IBOUND= 1                 ! RESET IBOUND
            DIGIT_COUNT = 0
            BOUND       = 0
         END IF

         RETURN
         END INTERNAL
         INTERNAL SUBROUTINE RECORD_PARM
            INLINE
            LD        6,DBL_BOUND
            SVC       1,X'28'
            STW       6,NOTNUM
            STW       7,BOUND
            ENDI

*  IF PARAMETER VALUE WAS SYMBOLIC, THEN R7 WILL EQUAL X'20202020'

            IF( NOTNUM .EQ. 0) THEN        ! SYMBOLIC VALUE
               NUM_PARAM = NUM_PARAM - 1
            ELSE
               BOUND = BOUND * IBOUND    ! POSSIBLE NEGATION
               ARRAY_PARM(3,NUM_PARAM) = BOUND
            END IF
            IBOUND= 1                 ! RESET IBOUND
            DBL_BOUND = X'2020202020202020'
            DIGIT_COUNT = 0
            BOUND       = 0
            SYM_BOUND   = .FALSE.

            END INTERNAL
         INTERNAL FUNCTION GETCHR();
         DO WHILE (BUF1(I).EQ.' '.AND.I.LE.NBYTES)
            I = I + 1
         END DO
         IF (I.GT.NBYTES) THEN
            GETCHR = 32            ! ' '
            RETURN
         END IF
         GETCHR = ICHAR(BUF1(I))
         I = I + 1
         RETURN
         END INTERNAL
         INLINE
         CEA
         ENDI
         RETURN
         END
         SUBROUTINE  CHECK_ARRAY(D_SYM)

         IMPLICIT NONE

         OPTION (PRODUCT_ID = 'AID.E3.004')                   ! 39 $VER

C920081   INTEGER     ARRAY_STAT(32,1000),NUM_ARRAY                !V5.1.1.2
         INTEGER     ARRAY_STAT(32,1500),NUM_ARRAY
C920081   INTEGER     NUM_PARAM,ARRAY_PARM(3,2000)                 !V5.1.1.2
         INTEGER     NUM_PARAM,ARRAY_PARM(3,3000)
C920081   INTEGER     SYM4(2),SYM8*8,ARR_STAT1*1(128,1000),D_SYM*8 !V5.1.1.2
         INTEGER     SYM4(2),SYM8*8,ARR_STAT1*1(128,1500),D_SYM*8
         INTEGER     IND,IND1*1(4)

         INTEGER        I, J                                    !001
         COMMON/A/  NUM_ARRAY,NUM_PARAM
         EXTENDED BLOCK/ASTAT/ARRAY_STAT,ARRAY_PARM
         EXTENDED BASE/ASTAT/256

         INCLUDE 'OBJ_COM.INC'

         EQUIVALENCE (SYM4,SYM8),(ARRAY_STAT,ARR_STAT1),(IND,IND1)

*  RETURN IF NO ARRAYS HAVE BEEN FOUND

         IF (NUM_ARRAY .EQ. 0) THEN
            INLINE
            CEA
            ENDI
            RETURN
         END IF

*  SET SYMBOL AND END OF OBJECT BLOCK

         SYM8 = D_SYM
         IND1(4) = OBJ_COMMAND(3)

*  SEARCH FOR ARRAY ENTRY

         DO I=1,NUM_ARRAY
            IF (SYM4(1).EQ.ARRAY_STAT(1,I)) THEN
               IF (SYM4(2).EQ.ARRAY_STAT(2,I)) THEN

*  HERE WE HAVE AN ARRAY MATCH. MOVE ARRAY INFO INTO OBJECT BLOCK.

                  DO J=1,ARR_STAT1(13,I)
                     OBJ_COMMAND(J+IND) = ARR_STAT1(J+8,I)
                  END DO
                  OBJ_COMMAND(3) = ARR_STAT1(13,I) + IND
                  OBJ_LENGTH     = OBJ_COMMAND(3)
                  IF (OBJ_COMMAND (2) .EQ. X'0E') THEN              !003
                     OBJ_COMMAND(4) = OBJ_COMMAND(4) + X'40'        !003
                  ELSE                                              !003
                     OBJ_COMMAND(4) = OBJ_COMMAND(4) + 8            !003
                  END IF                                            !003
                  LEAVE
               END IF
            END IF
         END DO
         INLINE
         CEA
         ENDI
         RETURN
         END
