/************************************************************************
*									*
*		tyname.c - return printable type name			*
*									*
************************************************************************/

#include "standard.h"
#include "ulsmch.h"

extern struct ulsmch	u;		/* the machine definition	*/

static
addec( p, n ) register char *p; unsigned int n;{

	register i;
	char	debuf[6];

	i = 0;
	do debuf[i++] = n%10; while(n /= 10);
	while( --i >= 0 ) *p++ = debuf[i] + '0';
	*p = '\0';
}

static
char *
toend(p) reg char *p; {
	while( *p ) p++;
	return p;
}

char *
tyname(t) typwd t; {		/* form a better printable type name */
	/* on alternating calls, diffent buffers are used so that
	   we can print two names in the same print statement	*/

	static char	b1[32],b2[32];
	static char	*p1 = b1, *p2 = b2;
	reg char	*p;
	reg int		i, j;

	p = p2; p2 = p1; p1 = p;		/* exchange pointers */
	*p = 0;
	for(;;)switch( t & TYMASK ){

default:	return "unknown type";
case TYLOG:	return "logical";
case TYINT:	if( t & UFLAG ) strcat(p,"uns ");
		i = varlen(t);
		if( i <= u.charsize ){ strcat( p, "char" ); goto retp1; }
		if( i <= u.shortsize ){ strcat( p, "short" ); goto retp1; }
		if( i <= u.intsize ){ strcat( p, "int" ); goto retp1; }
		if( i <= u.longsize ){ strcat( p, "long" ); goto retp1; }
		if( i <= u.llongsize ){ strcat( p, "long long" ); goto retp1; }
		strcat( p, "int*" );
		addec( toend(p), varlen(t) );
retp1:		return p1;

case TYPTR:	strcat(p, "ptr to ");		goto more;

case TYFCN:	strcat(p, "func ret ");		goto more;

case TYREAL:	i = varlen(t);
		if( i <= u.floatsize ) return "float";
		if( i <= u.doubsize ) return "double";
		return "long double";

case TYENUM:	strcat(p, "enum "); goto esu;
case TYSTRUCT:	strcat(p, "struct "); goto esu;
case TYUNION:	strcat(p, "union ");
esu:		addec(toend(p),t>>4);
		goto retp1;

case TYARRAY:	strcat(p,"arr[");
		i = decrefa(t) & 0xffff;
		if( i != 0xffff ) addec(toend(p),i);
		strcat(p,"] of ");
		p = toend(p);
		goto more;

case TYVOID:	return "void";

case TYMORE:	i = decrefa(t);
		if( i & ATNEAR ) strcat(p,"near ");
		if( i & ATFAR ) strcat(p,"far ");
		if( i & ATCONST ) strcat(p,"const ");
		if( i & ATVOL ) strcat(p,"volatile ");
		if( i & ATPGZ ) strcat(p,"pagezero ");
more:		t = decreft(t);
		continue;

case TYFLD:	i = decreft(t);
		j = i>>8 & 0xff;	/* Field length */
		i &= 0xff;		/* Field position */
		strcat(p,"bits [");
		addec(toend(p),i);
		strcat(p,"-");
		addec(toend(p),i+j-1);
		strcat(p,"] in ");
		t = decrefa(t);
		p = toend(p);
		continue;

case TYDEC:	if( t & UFLAG ) strcat(p,"uns ");
		strcat(p,"dec*");
		addec(toend(p),varlen(t));
		goto retp1;
	}
}
