/************************************************************************
*									*
*		readu.c - machine description structure reader		*
*									*
************************************************************************/

#include "uccio.h"
#include "uls.h"
#include "ulsmch.h"

/* This procedure reads the header portion of an Icode file and
   puts the following arguments into a string space provided by
   the caller.  Note: In this string region, strings are terminated
   by NULL not present in the source.  This is for the convenience
   of other routines that might wish to process them.
*/

char *
readu(up,stt,send) struct ulsmch *up;char *stt, *send;{
	/* up points to an empty ulsmch struct that is to be filled
		in by this routine
	   stt is the place where XARG strings are to be put, and
	   send is the boundary for the XARG strings

	   return if all went ok.
	   fatal error via MSG otherwise
	*/

	register	i,
			j;
	register char	*p;

	fseek( stdin, 0L, 0 );
	i = sizeof( struct ulsmch );
	p = (char *)up;
	while( --i >= 0 ) *p++ = j = getchar();
	if( j == EOF ) goto eof;
	if( (up->magic&0xff) != MAGIC )
		MSG( "7bad magic in header");
	if( (up->thislen&0xff) != sizeof( struct ulsmch ) )
		MSG( "7bad length in header");
	p = stt;		/* point to string space		*/
	while( (i = getchar()) == XARG ){
		if( p >= send )goto oflo;		/* overflow	*/
		*p++ = XARG;				/* stash XARG	*/
		i = getchar();				/* string count	*/
		if( i == EOF ) goto eof;		/* end of file	*/
		if( p >= send ) goto oflo;		/* overflow	*/
		*p++ = i;				/* stash count	*/
		while( --i >= 0 ){			/* loop		*/
			j = getchar();			/* get char	*/
			if( j == EOF ) goto eof;	/* end of file	*/
			if( p >= send )goto oflo;	/* overflow	*/
			*p++ = j;			/* put away	*/
		}
		if( p >= send )goto oflo;		/* overflow	*/
		*p++ = 0;				/* terminate	*/
	}
	if( i != EOF ) ungetc(i,stdin);	/* put back last character	*/
	return;

eof:	MSG( "7eof in reading header" );
oflo:	MSG( "7header string overflow" );
}
