/************************************************************************
*									*
*		predicate.c - various tests now in function form	*
*									*
************************************************************************/

#include "standard.h"
#include "aaux.h"

extern AUXTAB		aux[];

/*			type predicates			*/
/* the introduction of CONST and VAR to the C language did considerable
   violence to the internal typing structure of the ULS C compiler.
   In particular, it is no longer easy to determine the type with a
   macro because there may be one or more links in the way.  Hence, all
   of the predicate macros have been converted to functions.

   This will probably make the compiler slightly smaller but also
   slower.  Unfortunately, the way the language is going, the compiler
   will probably get slower still.

   In the functions that follow, the most commonly used predicates have
   the type extraction coded in line, while the less commonly used predicates
   call the bt() function.  This can be changed easily if necessary.
*/

truetype(typword) reg ushort typword; {

	while( (typword & TYMASK) == TYMORE )
		typword = aux[auxx(typword)].typword;
	return typword;
}

trtdect(typword)ushort typword; {
	return tdect(truetype(typword));
}

trtdeca(typword)ushort typword; {
	return tdeca(truetype(typword));
}

bt(typword) reg ushort typword; {

	while( (typword & TYMASK) == TYMORE )
		typword = aux[auxx(typword)].typword;
	return typword & TYMASK;
}

isint(typword) reg ushort typword; {

	while( (typword & TYMASK) == TYMORE )
		typword = aux[auxx(typword)].typword;
	typword &= TYMASK;
	return typword == TYINT;
}

islog(typword) ushort typword; {

	return bt(typword) == TYLOG;
}

isptr(typword) reg ushort typword; {

	while( (typword & TYMASK) == TYMORE )
		typword = aux[auxx(typword)].typword;
	typword &= TYMASK;
	return typword == TYPTR;
}

isreal(typword) ushort typword; {

	return bt(typword) == TYREAL;
}

isdec(typword) ushort typword; {

	return bt(typword) == TYDEC;
}

isfcn(typword) ushort typword; {

	return bt(typword) == TYFCN;
}

isuns(typword) reg ushort typword; {

	reg int	bty;

	bty = typword & TYMASK;
	while( bty == TYMORE ){
		typword = aux[auxx(typword)].typword;
		bty = typword & TYMASK;
	}
	if( bty == TYINT ) return typword & UFLAG;
	if( bty == TYFLD ) return isuns( decrefa(typword) );
	if( bty == TYPTR ) return 1;
	return 0;
}

isstruct(typword) ushort typword; {

	return bt(typword) == TYSTRUCT;
}

isunion(typword) ushort typword; {

	return bt(typword) == TYUNION;
}

isstun(typword) reg ushort typword; {

	typword = bt(typword);
	if( typword == TYSTRUCT ) return 1;
	if( typword == TYUNION ) return 1;
	return 0;
}

isarray(typword) ushort typword; {

	return bt(typword) == TYARRAY;
}

isfield(typword) ushort typword; {

	return bt(typword) == TYFLD;
}

isenum(typword) ushort typword; {

	return bt(typword) == TYENUM;
}

ushort
attributes(typword) ushort typword; {

	if( (typword & TYMASK) != TYMORE ) return 0;
	return aux[typword>>4].auxword;
}

isATTR(typword,attr) ushort typword, attr; {

	return attributes(typword) & attr;
}

isCONVAR(typword) ushort typword; {
	
	while( isarray(typword) ) typword = decreft(typword);
	return attributes(typword) & ATCONST;
}

isVOL(typword) ushort typword; {
	
	while( isarray(typword) ) typword = decreft(typword);
	return attributes(typword) & ATVOL;
}

isFAR(typword) ushort typword; {
	
	while( isarray(typword) ) typword = decreft(typword);
	return attributes(typword) & ATFAR;
}

isNEAR(typword) ushort typword; {
	
	while( isarray(typword) ) typword = decreft(typword);
	return attributes(typword) & ATNEAR;
}

isPGZ(typword) ushort typword; {
	
	while( isarray(typword) ) typword = decreft(typword);
	return attributes(typword) & ATPGZ;
}
