/*~!myatof.c*/
/* Name:  myatof.c Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nblib:myatof.c	1.0"

#include <ctype.h>
#include "float.h"

/*  Note : this atof() generates an internal floating point representation
 *	   of a number.  If we are in IEEE mode, the number is translated
 *	   to IEEE format.  Otherwise it is translated to Encore format.
 */

FPN ifpn;	/* internal floating point number */

double
myatof(s)
register  unsigned char  *s;
{
	register int i;
	int	tz;
	int	exp;
	int	sign;

	zerof( &ifpn );		/* clear destination number */
	sign = exp = tz = 0;	/* and local variables */

	i = *s++;		/* get 1st char */

	/* skip any leading white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* see if a sign given */
	if( i == '-' ) {
		sign++;
		i = s++;
	} else if( i == '+' )
		i = s++;
	/* skip any more white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* now process any number digits */
	while( i >= '0' && i <= '9' ){
		tz = dodig( &ifpn, i-'0', tz );
		i = s++;
	}
	/* now process a fraction, if present */
	if( i == '.' ){
		/* do the fraction */
		i = s++;
		while( i >= '0' && i <= '9' ){
			tz = dodig( &ifpn, i-'0', tz );
			exp--;
			i = s++;
		}
	}
	/* we are done with number */
	/* set the exponent */
	ifpn.ne += (tz + exp);
	/* if negative, negate the value */
	if( sign ) negf( &ifpn );

	return(flag.bit.sgn ? -d.d : d.d);
}

