/************************************************************************
*									*
*		errmsg.c - produce error messages mapped if neccessary	*
*									*
************************************************************************/

#include "uccio.h"
#include "ulsmch.h"
#include <setjmp.h>
#define BADEXIT 1

static jmp_buf	*msgjmpt;
static short	*msgline;
static char	*msgexname;
static char	**msgchpt;
static char	*msgchbase;
static short	*msgbrktb;
static char	*msgpt1;
static char	*msgpt2;
static char	*msgpt3;
static char	*msgname;
static short	hdrout;
static short	errinit;
static FILE     *MSGout = stderr;

extern short	errcnt,
		warncnt;

int warnlevel = 4;
int errlim = 10;

static char	*msghead[] = {		/* default message headers */
	/*0*/	"warning: ",
	/*1*/	"warning: ",
	/*2*/	"error:   ",		/* semantic error		*/
	/*3*/	"syntax:  ",
	/*4*/	"error:   ",
	/*5*/	"syntax:  ",
	/*6*/	"fatal:   ",
	/*7*/	"internal:"
};

msginit( exname, linenopt, path1, path2, path3 )
	char *exname, *path1, *path2, *path3; short *linenopt; {

	msgexname = exname;
	msgline = linenopt;
	msgpt1 = path1;
	if( path2 != (char *)0 ){
		msgpt2 = path2;
		if( path3 != (char *)0 ) msgpt3 = path3;
	}
}

msgchbk( charpt, charba, brktb ) char **charpt, *charba;short *brktb; {

	msgchpt = charpt;
	msgchbase = charba;
	msgbrktb = brktb;
}


msgfile( file ) FILE *file; {

	MSGout = file;
}


msgjmp( jbufpt ) jmp_buf *jbufpt; {

	msgjmpt = jbufpt;
}

msgfname( name ) char *name; {

	msgname = name;
}

MSG( s,a,b,c,d,e,f ) register char *s; {
	register	severity;
	register	lnum;
	register char	*bp;
	short		*bkpt;
	short		chonline;
	char		*zp;
	short		i;

	severity = 3;
	if( *s >= '0' && *s <= '7' ) severity = *s++ - '0';
	else if( *s == '.' ) s++, severity = -1;
	if( severity >= 0 && severity + warnlevel < 2 ) return;
	if( severity >= 6 && MSGout != stderr ){
		fflush( MSGout );
		MSGout = stderr;
	}
	if( hdrout == 0 && severity >= 0 ){
		fprf(MSGout,"%s:\n",msgexname);
		hdrout++;
	}
	lnum = *msgline;
	zp = 0;

	if( msgchpt && severity > 1 && (bp = *msgchpt) &&
	    (chonline = bp - msgchbase) >= 0 && chonline < 1920 ){
		bkpt = msgbrktb;
		while( chonline >= *bkpt++ ) lnum++;
		zp = bp - 20;
		if( zp < msgchbase ) zp = msgchbase;
		i = *bp;
		*bp = 0;
		if( msgname ) fprf(MSGout, "%s	",msgname);
		fprf(MSGout, "%d:	%s^",lnum,zp);
		*bp = i;
		i = bp[10];
		bp[10] = 0;
		fprf(MSGout, "%s\n",bp);
		bp[10] = i;
	}
	if( severity >= 0 ){
		if( msgname ) fprf(MSGout, "%s	",msgname);
		if( lnum ) fprf(MSGout, "%d:	",lnum);
		fprf(MSGout,"%s ",msghead[severity]);
	}
	fprf(MSGout,s,a,b,c,d,e,f);
	fprf(MSGout,"\n");
	if( severity <= 1 ){
		if( severity >= 0 ) warncnt++;
		return;
	}
	if( ++errcnt == errlim){
 		fprf(MSGout, "error limit reached\n");
		severity = 6;
	}
	if( severity >= 6 ) quit(BADEXIT);
	if( severity >= 4 && msgjmpt ) longjmp( msgjmpt, 1 );
}
