# 1 "gamma.c"




































# 1 "/u/cinclude/math.h"
























extern int errno, signgam;

extern double atof(), frexp(), ldexp(), modf();
extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double erf(), erfc();
extern double exp(), log(), log10(), pow(), sqrt();
extern double floor(), ceil(), fmod(), fabs();
extern double gamma();
extern double hypot();
extern int matherr();
extern double sinh(), cosh(), tanh();
extern double sin(), cos(), tan(), asin(), acos(), atan(), atan2();
















# 55 "/u/cinclude/math.h"


# 59 "/u/cinclude/math.h"


# 63 "/u/cinclude/math.h"
























struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};










# 37 "gamma.c"

# 1 "/u/cinclude/values.h"































































# 91 "/u/cinclude/values.h"











































# 38 "gamma.c"

# 1 "/u/cinclude/errno.h"























# 28 "/u/cinclude/errno.h"

extern int errno;
extern int mpxerr;


























































extern char * sys_errlist[];
void perror ();































































































# 39 "gamma.c"



int signgam;

double
gamma(x)
register double x;
{
	extern double pos_gamma();
	struct exception exc;

	exc.type = 0;
	exc.name = "gamma";
	exc.arg1 = x;
	exc.retval = ((float)0.7237005145e76);
	signgam = 1;
	if (x > 0)
		x = pos_gamma(x, &exc);
	else {
		static double pi = 3.14159265358979323846;
		double temp; 

		if (!modf(x = -x, &temp)) { 
			exc.type = 2;
			if (!matherr(&exc)) {
				(void) write(2, "gamma: SING error\n", 18);
				errno = 33;
			}
			return (exc.retval);
		}
		if (x >= (3.0 * (((8 * (int)sizeof(double)) - 8 + 0 - 1) % 2 ? (1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1)/2) * 1.41421356237309504880 : 1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1)/2)))
			exc.type = 3;
		else {
			if ((temp = sin(pi * x)) < 0)
				temp = -temp;
			else
				signgam = -1;
			return (-(log(x * temp/pi) + pos_gamma(x, &exc)));
		}
	}
	if (exc.type != 3)
		return (x);
	if (!matherr(&exc))
		errno = 34;
	return (exc.retval);
}

static double p2[] = {
    -0.67449507245925289918e1,
    -0.50108693752970953015e2,
    -0.43933044406002567613e3,
    -0.20085274013072791214e4,
    -0.87627102978521489560e4,
    -0.20886861789269887364e5,
    -0.42353689509744089647e5,
}, q2[] = {
    1.0,
    -0.23081551524580124562e2,
    0.18949823415702801641e3,
    -0.49902852662143904834e3,
    -0.15286072737795220248e4,
    0.99403074150827709015e4,
    -0.29803853309256649932e4,
    -0.42353689509744090010e5,
};

static double p[] = {
    -0.1633436431e-2,
    0.83645878922e-3,
    -0.5951896861197e-3,
    0.793650576493454e-3,
    -0.277777777735865004e-2,
    0.83333333333333101837e-1,
};

static double
pos_gamma(x, excp)
register double x;
struct exception *excp;
{
	register double y, z;

	if (x > 8) {	
	
		if (x >= 0.7237005577332262e76/(0.69314718055994530942 * ((1 << 8 - 1) - 1 + 0))) {
			excp->type = 3;
			return (excp->retval);
		}
		z = (x - 0.5) * log(x) - x + 0.9189385332046727417803297;
		if (x > (3.0 * (((8 * (int)sizeof(double)) - 8 + 0 - 1) % 2 ? (1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1)/2) * 1.41421356237309504880 : 1L << ((8 * (int)sizeof(double)) - 8 + 0 - 1)/2)))
			return (z);
		x = 1/x;
		y = x * x;
		return (z + x * (((((( ( ( ( ( p)))))[0] * (((((y))))) + ( ( ( ( ( p)))))[1]) * ((((y)))) + ( ( ( ( p))))[2]) * (((y))) + ( ( ( p)))[3]) * ((y)) + ( ( p))[4]) * (y) + ( p)[5]));
	}
	y = 1;
	if (x < y)
		y /= (x * (y + x));
	else if (x < 2) {
		y /= x;
		x -= 1;
	} else {
		for ( ; x >= 3; y *= x)
			x -= 1;
		x -= 2;
	}
	return (log(y * ((((((( ( ( ( ( ( p2))))))[0] * ((((((x)))))) + ( ( ( ( ( ( p2))))))[1]) * (((((x))))) + ( ( ( ( ( p2)))))[2]) * ((((x)))) + ( ( ( ( p2))))[3]) * (((x))) + ( ( ( p2)))[4]) * ((x)) + ( ( p2))[5]) * (x) + ( p2)[6])/(((((((( ( ( ( ( ( ( q2)))))))[0] * (((((((x))))))) + ( ( ( ( ( ( ( q2)))))))[1]) * ((((((x)))))) + ( ( ( ( ( ( q2))))))[2]) * (((((x))))) + ( ( ( ( ( q2)))))[3]) * ((((x)))) + ( ( ( ( q2))))[4]) * (((x))) + ( ( ( q2)))[5]) * ((x)) + ( ( q2))[6]) * (x) + ( q2)[7])));
}
