*  *********************************************************************
*
*  $Locked:       01-DEC-93 08:20  BEVIER    Add external trap support.$
*  $Header:  284  01-DEC-93 08:22  BEVIER    BEVIER                    $
*  $Log:   @ISCSRC^(DV.TXPM.SYSM)SH.PTCH                               $
*  
*       Rev  284  01-DEC-93 08:22  BEVIER    BEVIER                     
*  MPX 3.6 Non-RSX IPU support.                                         
*
*       Rev  283  22-NOV-93 11:08  MJF       MJF
*  Split into three files.  The first is the common code at the start
*  of the file.  The second file is the patch stuff for pre-3.5.  The
*  third file is the patch stuff for 3.5 and later.
*
*       Rev  282  19-NOV-93 17:23  MJF       MJF
*  Made mods for 3.6 for non-ipu case (H.MEMM is the only module
*  that needed it).  Changes needed for ipu support will be added
*  later.
*
*       Rev  281  03-JUN-93 18:25  MJF       MJF
*  Handle RMSS absence better.  Also, I'm not sure TXPM can
*  find H.RMSS for RMSS version 3.0a.
*
*       Rev  280  20-APR-93 11:59  JACK      JACK
*  Compensating for H.EXEC code changes in MPX-32 3.5U02A
*
*       Rev  279  14-JUL-92 12:22  MJF       MJF
*  E.5D version
*  Changes for RMSS 3.0b.  Changes also seemed to work for 3.1.
*
*       Rev  278  07-JUL-92 09:14  MJF       MJF
*  The final (?!) fix for M.CMD/T.LINBUF processing.  The last fix
*  wasn't always being called.  The current fix will always be called
*  (I think).
*
*       Rev  277  06-JUL-92 16:29  MJF       MJF
*  Change patch code sequences for H.EXEC3.
*  (3.5U02)
*
*       Rev  276  25-JUN-92 08:28  MJF       MJF
*  Move the check for T.LINBUF moving.  It used to be made only after
*  we determined that the task had the bit set in the preamble that said
*  the task had to run as a TXPM task.  This meant that we didn't make
*  the check in the task was not an explicit TXPM task, but had to run
*  as one anyway.  That's now fixed.
*
*       Rev  275  18-JUN-92 10:34  MJF       MJF
*  Changed for 3.5u02 (IOCS, etc.)
*
*       Rev  274  13-APR-92 09:58  GANN      GANN
*  Changed SVC 7,30 support to reflect Encore documentation for
*  the extended data block.  Now it biases the addresses we know
*  about for documented service types and makes a guess at any others
*
*       Rev  273  03-APR-92 10:10  SYSTEM    GANN
*  Fixed bugs in all svc 7 biasing routines, especially 30 & 34.
*
*       Rev  272  16-MAR-92 15:50  GANN      GANN
*  Added SVC 7,30.
*
*       Rev  271  04-MAR-92 11:12  GANN      MJF
*  Handle T.LINBUF differently. We now have a bit that is set and then
*  checked.  If the bit is on, then TXPM copies the line buffer into the
*  user's TSA, otherwise it does not copy it.  For OS' prior to 3.4u03,
*  that internal bit is always on; there is no way for the user to turn
*  it off.  For 3.4u03 and later, TXPM checks bit 28 of the TXPM word
*  in the task's preamble (DDUMP reports that word as location X'4c').
*  If the bit is on, then TXPM will set the internal bit (and therefore
*  copy the line buffer from mem pool to the TSA).  Otherwise TXPM will
*  not do the copy.  Note that this is a departure for 3.4u03 and later-
*  the default is NOT to do the copy, since bit 28 will almost always
*  be off.
*
*       Rev  270  05-FEB-92 14:44  GANN      GANN
*  Put in a fix for STATIC partitions that logically overlap
*  the OS.  Problem was that if a non-TXPM task tried to
*  include one of these partitions, it crashed the system.
*  So now if we are returning a negative map block index,
*  we zero it so that the common will conflict with the TSA
*  and/or DSECT, generating an RM16.
*
*       Rev  269  31-JAN-92 09:31  GANN      GANN
*  Added Orbis versions of 3.2C U03.  Did not check out Orbis
*  TAMM because I don't have it.  It will probably not work.
*  Use TXPMINIT to check it out.
*
*       Rev  268  09-OCT-91 16:22  MJF       MJF
*  Handle M.CALL being SVC 6
*
*       Rev  267  09-OCT-91 13:11  MJF       MJF
*  Use modified M.TXPM and M.TXINTL, and change TSK.LVL5 to
*  TSK.LINE.
*
*       Rev  266  03-MAY-91 14:18  GANN      GANN
*  Version released in E.5B.
*  Made changes for MPX 3.5 U02 BL4.  Added patch EXC2A to account
*  to changes to EXEC around that patch, and changed patch ICP1 to
*  not check one instruction it used to check.  This is because the
*  instruction is different on the new version and is not needed to
*  correctly locate the patch.  I also noticed and fixed a bug in
*  the one TAMM patch that has two different instruction sequences
*  to search for.  FI.NR was incorectly being incremented on both
*  patches.  I also changed FI.ENT to allow a parameter indicating
*  whether or not to increment FI.NR.  This makes adding
*  duplicate instruction search sequences easier.
*
*       Rev  265  11-FEB-91 12:57  GANN      GANN
*  Change version to E.5.
*
*       Rev  264  10-JAN-91 16:20  MJF       MJF
*  Baseline 12 and 13 changes.  Also fixed a bug whereby T.DSOR
*  was being treated as a fullword address, rather than as a map#.
*
*       Rev  263  30-NOV-90 16:47  MJF       MJF
*  MEMM code changes for 3.5 U01 bl 10.
*
*       Rev  262  17-OCT-90 14:51  MJF       MJF
*  Mods for RMSS 3.0 U02.  Also handled the fact that SYSGEN's
*  DSECT starts at 6a000 now.
*
*       Rev  261  10-OCT-90 11:17  MJF       MJF
*  SVC6 dispatch bug fix
*
*       Rev  260  08-OCT-90 15:59  MJF       MJF
*  Delete comment about control switches.
*
*       Rev  259  27-SEP-90 07:32  MJF       MJF
*  Change version number to E.4C
*
*       Rev  258  21-SEP-90 13:44  MJF       MJF
*  Get rid of OS35U00A
*
*       Rev  257  14-SEP-90 17:38  MJF       MJF
*  Begin adding RMSS support.
*
*       Rev  256  27-AUG-90 09:51  GANN      GANN
*  Fixed new patches for IPU code in several places.  I also
*  changed the patch to ICP so that is searches for the correct
*  instruction to get the beginning of ICP.  This is so that the
*  code will work on old and new versions of ICP.
*
*       Rev  255  26-JUL-90 15:45  GANN      GANN
*  For MPX 3.5 and up, changed NOTFOUND routine to generate an
*  abort message that tells us and the user what patch failed.
*  We simply set C.NOLOAD and then go search through SYSGEN and
*  change the generated abort (normally SG26) to the abort code
*  we want.  File TG.ERR allows TSM to tell the user what patch
*  failed.
*
*       Rev  254  20-JUL-90 08:55  MJF       MJF
*   Version control header added; split from SH.TXPMMS
*
*       Rev  253  19-JUL-90 08:48  MJF       MJF
*  Finish auto patching.  Still needs testing.
*
*       Rev  252  13-JUL-90 14:22  MJF       MJF
*  Seahawk modifications for 3.4U03a. Problem was caused by
*  Seahawk's lack of taking a TRSC to PSD2 correctly.  This version
*  checks for Seahawk, and if it finds it, it uses the actual MPL
*  rather than using its own in the patch area.
*
*       Rev  251  02-JUL-90 13:32  GANN      GANN
*  Delete def to FI.STRT. It was only required for 3.5 debugging and is
*  no longer needed.  Other versions of PTCH do not assemble with it in.
*
*       Rev  250  02-JUL-90 11:58  GANN      GANN
*  Added a mask to accelerator code to fix a MF01. Problem was that
*  a CEA instruction was commented out in rev 236 and so part of
*  the LPSD instruction was being used as part of the index, causing
*  a MF01.  I just masked the reg containing the lpsd instruction
*  before using it as an index.
*
*       Rev  249  18-JUN-90 19:12  MJF       MJF
*  Interim lock during new patch facility.  IPU patches
*  still need to be done.  Everything needs to be tested.
*
*       Rev  248  15-JUN-90 16:33  MJF       MJF
*  Interim unlock during patch facility changes.
*
*       Rev  247  08-JUN-90 14:41  MJF       MJF
*  Support for 3.5 U00A, plus fixed a bug intro'd when we added
*  1.x support.
*
*       Rev  246  18-MAY-90 12:08  GANN      GANN
*  Make H.SURE processing conditional for concept only (C.3227).
*  H.SURE cann only be present for mpx 3.4 U0n and higher. SVC 5
*  is reserved for H.SURE.
*
*       Rev  245  12-MAY-90 13:58  MJF       MJF
*  Integrate 1.x mods made in FtL first week of 5/90.
*  H.SURE mods still need to be made for 1.x.
*
*       Rev  244  11-MAY-90 22:14  MJF       MJF
*  3.5 baseline 10
*
*       Rev  243  20-MAR-90 13:57  BEVIER    BEVIER
*  TXPM.ACC WAS BEING SET IN TXPMFLGS, SHOUND HAVE BEEN RTC IN TXPMFLGS.
*  ADDED ONE.INIT FLAG FOR TXPMFLGS TO SHOW ONE-SHOT INIT COMPLETE.
*
*       Rev  242  20-MAR-90 10:16  BEVIER    BEVIER
*  Correct ipu gating bug. Move TXPMFLGS to byte 0 of C.UBIAS (C8) so
*  in.txpm flag can be cleared from dispatch code.  Set bit 0 (TXPMOS)
*  of TXPMFLGS to indicate TXPM on system.
*
*       Rev  241  14-MAR-90 08:40  BEVIER    BEVIER
*  Modifications for MPX 3.5 baseline 8.0.
*
*       Rev  240  31-JAN-90 12:11  BEVIER    BEVIER
*  Add final 34u03 mods
*
*       Rev  239  30-JAN-90 09:26  BEVIER    BEVIER
*  Add support for MPX 3.5 baseline 7.
*
*       Rev  238  30-JAN-90 08:26  BEVIER    BEVIER
*  Add support for MPX 1.5E.  Add support for movable tsa
*  in mpx 3.5 mapped in.
*
*       Rev  237  30-JAN-90 08:11  BEVIER    BEVIER
*  Add initial support for mapped-out mpx.  Add initial movable
*  TSA support in MPX 3.5 mapped-in mode.  Correct SIMSTAR support
*  in all revisions.
*
*       Rev  236  05-DEC-89 18:33  BEVIER    BEVIER
*  Do not allow csect to be shared for txpm tasks running in auto
*  mode.  Set psd word2 in accel to that in h.ipcl.
*
*       Rev  235  29-NOV-89 19:08  BEVIER    BEVIER
*  Correct interface patches in s.iocs17 to unbias fcb properly
*  before going to s.exec68 EA dispatch.
*
*       Rev  234  29-NOV-89 14:57  BEVIER    BEVIER
*  Correct patch for H.EXEC3.  Add biasing for T.TSAOR for MPX3.5.
*
*       Rev  233  21-NOV-89 15:59  BEVIER    BEVIER
*  Turn on tsa biasing when svc 2,7d called (M.GTSAD)
*
*       Rev  232  20-NOV-89 14:16  BEVIER    BEVIER
*  Add MPX 3.4u03 support and MPX 3.5 BL6 support.  Move S.TXPM.6 routin
*  to PTCH. Correct SVC 1,3 code.  Correct SVC 7,19 code. Add support fo
*  new SVC's 2,AF (M.OSWRIT), 2,7E (M.OSREAD), and 2,7D (M.GTSAD). Make
*  release E4B mods.
*
*       Rev  231  15-MAY-89 16:35  BEVIER    BEVIER
*  Inhibit dispatch to H.AID if H.AID not on system.
*  This was causing AID debugger to get MF01.
*
*       Rev  230  08-MAY-89 16:07  BEVIER    BEVIER
*  CORRECT TYPE CONTROL BLOCK BIASING; HAD INVALID BRANCH
*
*       Rev  229  27-MAR-89 08:08  BEVIER    BEVIER
*  Correct S.TRV.54 to use C.CIPU instead of C.CURR during test for
*  map overrun in H.IPU.
*
*       Rev  228  02-FEB-89 08:50  BEVIER    BEVIER
*  Add support for MPX 3.4 U02.
*
*       Rev  227  13-JAN-89 16:38  BEVIER    BEVIER
*  ADD SUPPORT FOR SVC 2,X'7C' (M.GDD) NEW IN MPX 3.4
*
*       Rev  226  10-JAN-89 07:50  BEVIER    BEVIER
*  CORRECT REG DURING DEBUG DISPATCH.
*  ADD SUPPORT FOR SVC 2,X'AE' M.TSMPC
*  DELETE DUKE POWER CODE THAT'S NOT USED ANYMORE.
*
*       Rev  225  06-JAN-89 06:29  BEVIER    BEVIER
*  CORRECT SVC BIASING FOR SVC 2 AFTER SVC 1.
*  SVC 1 FLAGS WERE BEING LEFT ON CAUSING INCORRECT BIASING.
*
*       Rev  224  09-NOV-88 08:31  GANN      GANN
*   Version control header added
*
*
*    REMAP PROCESSOR  VERSION NUMBER *** E4B ***                *238*
*
*    SUPPORTS: MPX1.5E,MPX2.1A, MPX2.2, MPX2.3, MPX2.4, MPX3.2A, MPX3.2B
*              MPX3.2C, MPX3.2C.UCS, MPX3.2C.U03, MPX3.3, MPX3.3.U02
*              MPX3.4, MPX3.4U01, MPX3.402, MPX3.4U03, MPX3.5BL6
*
************************************************************************
*        RESTRICTED RIGHTS LEGEND                                      *
*                                                                      *
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE             *
*        RESTRICTIONS STATED IN XXXXXXXX LICENSE AGREEMENT             *
*        (FORM NO. 1218) OR, FOR GOVERNMENT CUSTOMERS,                 *
************************************************************************
*
*216.  MODIFIED BY JCB (08/10/88) TO:    (REV E3.13) (E3B)     *216*
*      A.  ADD H.MEMM,7 PATCH TO ALLOW INCLUSION OF PARTITION  *216*
*          BELOW C.TSAD ADDRESS IN TXPM TASK.                  *216*
*      B.  CHANGES ARE DENOTED BY *216*                        *216*
*
*217.  MODIFIED BY MJF (8/31/88) TO:     (REV E3.14) (E3B)     *217*
*      A.  SUPPORT 3.4U01                                      *217*
*      B.  CHANGES ARE DENOTED BY *217*                        *217*
*
*218.  MODIFIED BY JCB (9/16/88) TO:     (REV E3.15) (E3B)     *218*
*      A.  CORRECT H.ICP DISPATCH CODE WHEN H.SURE NOT GEN'D.  *218*
*      B.  CHANGES ARE DENOTED BY *218*                        *218*
*
*219.  MODIFIED BY JCB (9/16/88) TO:     (REV E3.16) (E3B)     *219*
*      A.  ADD SUPPORT FOR QUAD SYNC HANDLER, X.25, ETHERNET,  *219*
*          TEL-NET, DOD, ETC. COMM STUFF. SVC 7'S, 6'S, E'S.   *219*
*      B.  CHANGES ARE DENOTED BY *219*                        *219*
*
*220.  MODIFIED BY JCB (10/06/88) TO:    (REV E3.17) (E3B)     *220*
*      A.  ADDED TEST FOR BASE MODE TASK IN S.TXPM.8.          *220*
*          NEW COMMON COMPILER WAS LOOKING LIKE ABS LOAD MOD   *220*
*      B.  CHANGES ARE DENOTED BY *220*                        *220*
*
*221.  MODIFIED BY JCB (10/14/88) TO:    (REV E3.18) (E3B)     *221*
*      A.  ADDED OPTIONAL CODE TO SET MINIMUM TSA BASE IN      *221*
*          SUBROUTINE S.TXPM.8 IN SH.PTCH.                     *221*
*      B.  CHANGES ARE DENOTED BY *221*                        *221*
*
*222.  MODIFIED BY JCB (10/25/88) TO:    (REV E3.19) (E3B)     *222*
*      A.  DELETE BIASING FOR SVC 7,X'18' FROM TXPM.  NOW IN   *222*
*          SN.NOT IN DOD SOFTWARE.                             *222*
*      B.  CHANGES ARE DENOTED BY *222*                        *222*
*
*223.  MODIFIED BY JCB (10/31/88) TO:    (REV E3.20) (E3B)     *223*
*      A.  CORRECT DETECTION OF ON.QSXIO HANDLER LOGIC.        *223*
*          WAS CAUSING MF01 FOR NON I/O SVC'S WITH FCB'S.      *223*
*      B.  CHANGES ARE DENOTED BY *223*                        *223*
*
*224.  MODIFIED BY GC (11/09/88) TO:     (REV E3.224) (E3B)    *224*
*      A.  ADD VERSION CONTROL.                                *224*
*      B.  CHANGES ARE DENOTED BY *224*                        *224*
*
*225.  MODIFIED BY JCB (01/06/89) TO:    (REV E3.225) (E3B)    *225*
*      A.  CORRECT SVC BIASING WHEN SVC 2 IS EXECUTED AFTER    *225*
*          DOING SVC 1,X'54' (M.SUSP). THE SVC 2 WAS BEING     *225*
*          EXECUTED AS AN SVC 1.  SVC TYPE FLAGS WERE NOT      *225*
*          BEING RESET.                                        *225*
*      B.  CHANGES ARE DENOTED BY *225*                        *225*
*
*226.  MODIFIED BY JCB (01/10/89) TO:    (REV E3.226) (E3B)    *226*
*      A.  CORRECT REGISTER VALUE DURING DEBUGGER DISPATCH.    *226*
*      B.  ADD SUPPORT FOR SVC 2,X'AE' (M.TSMPC) NEW IN 3.4.   *226*
*      C.  CHANGES ARE DENOTED BY *226*                        *226*
*
*227.  MODIFIED BY JCB (01/13/89) TO:    (REV E3.227) (E3B)    *227*
*      A.  ADD SUPPORT FOR SVC 2,X'7C' (M.GDD) NEW IN 3.4.     *227*
*      B.  CHANGES ARE DENOTED BY *227*                        *227*
*
*228.  MODIFIED BY JCB (01/31/89) TO:    (REV E3.228) (E3B)    *228*
*      A.  ADD SUPPORT FOR MPX 3.4 U02 RELEASE.                *228*
*      B.  CHANGES ARE DENOTED BY *228*                        *228*
*
*229.  MODIFIED BY JCB (03/27/89) TO:    (REV E3.229) (E3B)    *229*
*      A.  CORRECT MAP OVERRUN TEST FOR IPU TO USE C.CIPU      *229*
*      B.  CHANGES ARE DENOTED BY *229*                        *229*
*
*       Rev  230  08-MAY-89 16:07  BEVIER    BEVIER
*  CORRECT TYPE CONTROL BLOCK BIASING; HAD INVALID BRANCH
*
*230.  MODIFIED BY JCB (05/08/89) TO:    (REV E4.230) (E4)     *230*
*      A.  CORRECT TYPE CONTROL BLOCK BIASING ROUTINE. HAD     *230*
*          INVALID BRANCH.                                     *230*
*      B.  CHANGES ARE DENOTED BY *230*                        *230*
*
*231.  MODIFIED BY JCB (05/15/89) TO:    (REV E4.231) (E4)     *231*
*      A.  ADDED TEST TO SEE IF H.AID WAS ON SYSTEM BEFORE     *231*
*          EXECUTING SVC 'A'-'D'.  CAUSED MF01 IN DEBUGGER.    *231*
*      B.  CHANGES ARE DENOTED BY *231*                        *231*
*
*232.  MODIFIED BY JCB (10/19/89) TO:    (REV E4.232) (E4B)    *232*
*      A.  ADD SUPPORT FOR MPX 34U03                           *232*
*      B.  MOVE S.TXPM.6 TO PTCH CODE FOR BIASING T.TSAEND     *232*
*      C.  CORRECT TCP.UB ROUTINE TO FIX BAD BRANCH            *232*
*      D.  CORRECT SVC 1,3 CODE TO RESET CONTEXT INHIBIT FLAG  *232*
*      E.  CORRECT SVC7.19 ROUTINE TO BIAS R6 NOT R1           *232*
*      F.  CORRECTLY INITIALIZE SVC 2'S ABOVE X'7F'            *232*
*      G.  PRELIMINARY SUPPORT FOR MPX3.5 BL6                  *232*
*      H.  ADD SUPPORT FOR SVC 2,AF M.OSWRIT                   *232*
*      I.  ADD SUPPORT FOR SVC 2,7E M.OSREAD                   *232*
*      J.  ADD SUPPORT FOR SVC 2,7D M.GTSAD                    *232*
*      K.  CHANGES ARE DENOTED BY *232*                        *232*
*
*233.  MODIFIED BY JCB (11/21/89) TO:    (REV E4.233) (E4B)    *233*
*      A.  TURN ON TSA BIASING WHEN SVC 2,7D CALLED (M.GTSAD)  *233*
*      B.  CHANGES ARE DENOTED BY *233*                        *233*
*
*234.  MODIFIED BY JCB (11/29/89) TO:    (REV E4.234) (E4B)    *234*
*      A.  CORRECT MPX3.5 PATCHES                              *234*
*      B.  CHANGES ARE DENOTED BY *234*                        *234*
*
*235.  MODIFIED BY JCB (11/30/89) TO:    (REV E4.235) (E4B)    *235*
*      A.  CORRECT EA DISPATCH TO S.EXEC68 IN S.EXEC17 TO      *235*
*          PROPERLY UNBIAS FCB BEFORE DISPATCH (3.5 ONLY).     *235*
*      B.  CHANGES ARE DENOTED BY *235*                        *235*
*
*236.  MODIFIED BY JCB (12/06/89) TO:    (REV E4.236) (E4B)    *236*
*      A.  CORRECT INHIBITING OF SHARED CSECT FOR AUTO-TXPM    *236*
*      B.  CHANGES ARE DENOTED BY *236*                        *236*
*
*237.  MODIFIED BY JCB (12/07/89) TO:    (REV E4.237) (E4B)    *237*
*      A.  START MODIFICATIONS FOR MPX 3.5 MAPPED OUT MPX      *237*
*      B.  ADD SUPPORT FOR MOVABLE TSA IN 3.5 MAPPED IN MPX    *237*
*      C.  CHANGES ARE DENOTED BY *237*                        *237*
*
*238.  MODIFIED BY JCB (01/18/90) TO:    (REV E4.238) (E4B)    *238*
*      A.  ADD SUPPORT FOR MPX 1.5E TO TXPM                    *238*
*      B.  CHANGES ARE DENOTED BY *238*                        *238*
*
*239.  MODIFIED BY JCB (01/30/90) TO:    (REV E4.239) (E4B)    *239*
*      A.  ADD SUPPORT FOR MPX 3.5 BL 7                        *239*
*      B.  CHANGES ARE DENOTED BY *239*                        *239*
*
*240.  MODIFIED BY JCB (01/31/90) TO:    (REV E4.240) (E4B)    *240*
*      A.  ADD FINAL SUPPORT FOR MPX 3.4 U03                   *240*
*      B.  CHANGES ARE DENOTED BY *240*                        *240*
*
*241.  MODIFIED BY JCB (03/02/90) TO:    (REV E4.241) (E4B)    *241*
*      A.  ADD SUPPORT FOR MPX 3.5 BL 8                        *241*
*      B.  CHANGES ARE DENOTED BY *241*                        *241*
*
*242.  MODIFIED BY JCB (03/20/90) TO:    (REV E4.242) (E4B)    *242*
*      A.  CORRECT IPU GATING PROBLEM.  CAUSED RANDOM ABORTS.  *242*
*          TXPMFLGS NOW EQUATED TO C.UBIAS AND USES BITS 0-7   *242*
*          FOR INTERNAL TXPM FLAGS                             *242*
*      B.  CHANGES ARE DENOTED BY *242*                        *242*
*
*243.  MODIFIED BY JCB (03/02/90) TO:    (REV E4.241) (E4B)    *243*
*      A.  TXPM.ACC BEING SET IN TXPMFLGS INSTEAD OF EVENT.PTR *243*
*      B.  CHANGES ARE DENOTED BY *243*                        *243*
*
************************************************************************
         LIST      NONG,NOMAC                                   *232*
         IFT       C.3227,N27
C.3227   SETT              Pass C.3227 condition from cond2 to macros
N27      ANOP
         IFF       C.3227,N77
C.3227   SETF              Pass C.3227 condition from cond2 to macros
N77      ANOP
         TITLE     H.PTCH -- PATCH PROCESSOR
         PROGRAM   H.PTCH          XPM-64.E5.EE4                46 $VER
         DEF       VER.PTCH        VERSION NUMBER
         DEF       PRG.PTCH        DATE
         DEF       VER.MPXR        MPX REVISION                 *226*
VER.PTCH EQU       X'8E5EE4'                                    25 $VER
PRG.PTCH EQU       X'12013'        MMDDY                        22 $PRG
         IFF       C.3227,NOT27                                 *226*
         IFT       OS.15E,O15E                                  *238*
VER.MPXR EQU       X'15E07'        15E-7X                       *238*
O15E     ANOP                                                   *238*
         IFT       OS.21A,O21A                                  *226*
VER.MPXR EQU       X'21A07'        21A-7X                       *226*
O21A     ANOP                                                   *226*
         IFT       OS.22,O22                                    *226*
VER.MPXR EQU       X'22007'        22-7X                        *226*
O22      ANOP                                                   *226*
         IFT       OS.23,O23                                    *226*
VER.MPXR EQU       X'23007'        23-7X                        *226*
O23      ANOP                                                   *226*
         IFT       OS.24,O24                                    *226*
VER.MPXR EQU       X'24007'        24-7X                        *226*
O24      ANOP                                                   *226*
NOT27    ANOP                                                   *226*
         IFT       C.3227,GOT27                                 *226*
         IFT       OS.15E,O15E                                  *238*
VER.MPXR EQU       X'15E00'        21A                          *238*
O15E     ANOP                                                   *238*
         IFT       OS.21A,O21A                                  *226*
VER.MPXR EQU       X'21A00'        21A                          *226*
O21A     ANOP                                                   *226*
         IFT       OS.22,O22                                    *226*
VER.MPXR EQU       X'22000'        22                           *226*
O22      ANOP                                                   *226*
         IFT       OS.23,O23                                    *226*
VER.MPXR EQU       X'23000'        23                           *226*
O23      ANOP                                                   *226*
         IFT       OS.24,O24                                    *226*
VER.MPXR EQU       X'24000'        24                           *226*
O24      ANOP                                                   *226*
         IFT       OS.32A,O32A                                  *226*
VER.MPXR EQU       X'32A00'        32A                          *226*
O32A     ANOP                                                   *226*
         IFT       OS.32B,O32B                                  *226*
         IFF       OS.ORBIO,O32B                                *226*
         IFF       OS.ORBTM,O32B                                *226*
VER.MPXR EQU       X'32B00'        32B-STD VERSION              *226*
O32B     ANOP                                                   *226*
         IFT       OS.32B,O32B                                  *226*
         IFT       OS.ORBIO,O32B                                *226*
         IFF       OS.ORBTM,O32B                                *226*
VER.MPXR EQU       X'32B0D'        32B-ORBIS IOCS               *226*
O32B     ANOP                                                   *226*
         IFT       OS.32B,O32B                                  *226*
         IFF       OS.ORBIO,O32B                                *226*
         IFT       OS.ORBTM,O32B                                *226*
VER.MPXR EQU       X'32B0E'        32B-ORBIS TAMM               *226*
O32B     ANOP                                                   *226*
         IFT       OS.32B,O32B                                  *226*
         IFT       OS.ORBIO,O32B                                *226*
         IFT       OS.ORBTM,O32B                                *226*
VER.MPXR EQU       X'32B0F'        32B-ORBIS IOCS TAMM          *226*
O32B     ANOP                                                   *226*
         IFT       OS.32C,O32C                                  *226*
         IFF       OS.ORBIO,O32C                                *226*
         IFF       OS.ORBTM,O32C                                *226*
VER.MPXR EQU       X'32C00'        32C-STD VERSION              *226*
O32C     ANOP                                                   *226*
         IFT       OS.32C,O32C                                  *226*
         IFT       OS.ORBIO,O32C                                *226*
         IFF       OS.ORBTM,O32C                                *226*
VER.MPXR EQU       X'32C0D'        32C-ORBIS IOCS               *226*
O32C     ANOP                                                   *226*
         IFT       OS.32C,O32C                                  *226*
         IFF       OS.ORBIO,O32C                                *226*
         IFT       OS.ORBTM,O32C                                *226*
VER.MPXR EQU       X'32C0E'        32C-ORBIS TAMM               *226*
O32C     ANOP                                                   *226*
         IFT       OS.32C,O32C                                  *226*
         IFT       OS.ORBIO,O32C                                *226*
         IFT       OS.ORBTM,O32C                                *226*
VER.MPXR EQU       X'32C0F'        32C-ORBIS IOCS TAMM          *226*
O32C     ANOP                                                   *226*
         IFT       OS.UCS,OUCS                                  *226*
VER.MPXR EQU       X'32CC0'        32C-UCS                      *226*
OUCS     ANOP                                                   *226*
         IFT       OS.U03,OU03                                  *226*
         IFF       OS.ORBIO,OU03                                *226*
         IFF       OS.ORBTM,OU03                                *226*
VER.MPXR EQU       X'32C30'        32C-U03-STD VERSION          *226*
OU03     ANOP                                                   *226*
         IFT       OS.U03,OU03                                  *226*
         IFT       OS.ORBIO,OU03                                *226*
         IFF       OS.ORBTM,OU03                                *226*
VER.MPXR EQU       X'32C3D'        32C-U03-ORBIS IOCS           *226*
OU03     ANOP                                                   *226*
         IFT       OS.U03,OU03                                  *226*
         IFF       OS.ORBIO,OU03                                *226*
         IFT       OS.ORBTM,OU03                                *226*
VER.MPXR EQU       X'32C3E'        32C-U03-ORBIS TAMM           *226*
OU03     ANOP                                                   *226*
         IFT       OS.U03,OU03                                  *226*
         IFT       OS.ORBIO,OU03                                *226*
         IFT       OS.ORBTM,OU03                                *226*
VER.MPXR EQU       X'32C3F'        32C-U03-ORBIS IOCS TAMM      *226*
OU03     ANOP                                                   *226*
         IFT       OS.33,O33                                    *226*
         IFF       OS.ORBIO,O33                                 *226*
         IFF       OS.ORBTM,O33                                 *226*
VER.MPXR EQU       X'33000'        33-STD VERSION               *226*
O33      ANOP                                                   *226*
         IFT       OS.33,O33                                    *226*
         IFT       OS.ORBIO,O33                                 *226*
         IFF       OS.ORBTM,O33                                 *226*
VER.MPXR EQU       X'3300D'        33-ORBIS IOCS                *226*
O33      ANOP                                                   *226*
         IFT       OS.33,O33                                    *226*
         IFF       OS.ORBIO,O33                                 *226*
         IFT       OS.ORBTM,O33                                 *226*
VER.MPXR EQU       X'3300E'        33-ORBIS TAMM                *226*
O33      ANOP                                                   *226*
         IFT       OS.33,O33                                    *226*
         IFT       OS.ORBIO,O33                                 *226*
         IFT       OS.ORBTM,O33                                 *226*
VER.MPXR EQU       X'3300F'        33-ORBIS IOCS TAMM           *226*
O33      ANOP                                                   *226*
         IFT       OS.U02,OU02                                  *226*
         IFF       OS.ORBIO,OU02                                *226*
         IFF       OS.ORBTM,OU02                                *226*
VER.MPXR EQU       X'33200'        33-U02-STD VERSION           *226*
OU02     ANOP                                                   *226*
         IFT       OS.U02,OU02                                  *226*
         IFT       OS.ORBIO,OU02                                *226*
         IFF       OS.ORBTM,OU02                                *226*
VER.MPXR EQU       X'3320D'        33-U02-ORBIS IOCS            *226*
OU02     ANOP                                                   *226*
         IFT       OS.U02,OU02                                  *226*
         IFF       OS.ORBIO,OU02                                *226*
         IFT       OS.ORBTM,OU02                                *226*
VER.MPXR EQU       X'3320E'        33-U02-ORBIS TAMM            *226*
OU02     ANOP                                                   *226*
         IFT       OS.U02,OU02                                  *226*
         IFT       OS.ORBIO,OU02                                *226*
         IFT       OS.ORBTM,OU02                                *226*
VER.MPXR EQU       X'3320F'        33-U02-ORBIS IOCS TAMM       *226*
OU02     ANOP                                                   *226*
         IFT       OS.34,O34                                    *226*
VER.MPXR EQU       X'34000'        34-STD VERSION               *226*
O34      ANOP                                                   *226*
         IFT       OS.34U01,O341                                *232*
VER.MPXR EQU       X'34100'        34-U01 VERSION               *226*
O341     ANOP                                                   *226*
         IFT       OS.34U02,O342                                *228*
VER.MPXR EQU       X'34200'        34-U02 VERSION               *228*
O342     ANOP                                                   *228*
         IFT       OS.34U03,O343                                *232*
VER.MPXR EQU       X'34300'        34-U03 VERSION               *232*
O343     ANOP                                                   *232*
         IFT       OS.35,O35                                    *232*
*258          IFT       OS35U00A,DO.U00A                                 !247
*258 VER.MPXR EQU       X'3500A'                                         !247
*258 DO.U00A  ANOP                                                       !247
*258          IFF       OS35U00A,NO.U00A                                 !247
         IFF       C.MPXOUT,MO                                  *237*
         IFT       OS.36,O36                                    !284
VER.MPXR EQU       X'36000'        36-STD VERSION               !284
O36      ANOP                                                   !284
         IFF       OS.36,O36                                    !284
VER.MPXR EQU       X'35000'        35-STD VERSION               *232*
O36      ANOP                                                   !284
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
VER.MPXR EQU       X'3500B'        35-STD MAPPED OUT VERSION    *237*
MO       ANOP                                                   *237*
*258 NO.U00A  ANOP                                                       !247
O35      ANOP                                                   *232*
GOT27    ANOP                                                   *237*
         IFF       OS.15E,SKIP                                  *238*
         LIST      NONG,MAC                                         !244
         M.VRSION                  MACRO LIB VERSION ID
         LIST      NONG,NOMAC                                       !244
SKIP     ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
*        H.PTCH :  PATCHING PROCESSOR                             *
*
*  Starting with 3.5, OH.PTCH now does some patching by searching fo!249
*  code sequences.  The code-searching section starts at label      !249
*  FI.STRT.  Label FINDINST is a subroutine that does the searching.!249
*  The code to search for is defined with the help of macros FI.ENT,!249
*  and the MK.xxx macros, and the F.xxx macros that correspond      !249
*  to M. macros by the similar names (e.g., F.PLPSD is fashioned    !249
*  after M.PLPSD).                                                  !249
*     Should H.PTCH NOT find a code sequence it is looking for,     !249
*  it will tell SYSGEN to abort.  SYSGEN will tell the user that    !249
*  module H.PTCH was unable to initialize.                          !249
*  It will abort with a TGxx error, not an SGxx error.              !260
*                                                              *221*
*        NOTE! NOTE! NOTE!                                     *221*
*                                                              *221*
*        THE GOTO FOLLOWING PATCH1 IN SUBROUTINE S.TXPM.8      *221*
*        CAN BE REMOVED TO ALLOW CODE TO SET THE MINIMUM       *221*
*        TSA ADDRESS FOR TXPM TASKS.  THIS MAY BE NECESSARY    *221*
*        ON LARGE O/S SYSTEMS WHERE SYSTEM TABLES ARE LARGE.   *221*
*        GOULD PROCESSORS AND SOME XPM PROCESSORS LOOK AT      *221*
*        THE UDT'S DURING EXECUTION.  HAVING A TSA BASE LOWER  *221*
*        THAN THE TABLES MAY CAUSE UNEXPECTED RESULTS AND      *221*
*        ABORTS.  THIS OPTIONAL CODE NOW SETS THE TSA MINIMUM  *221*
*        AT THE END OF THE UDT'S (C.DTTA).  THIS ADDRESS CAN   *221*
*        ALSO BE MODIFIED TO CHANGE THE MINIMUM TSA ADDRESS.   *221*
*                                                              *221*
OS15E    ANOP                                                   *238*
         EXT       ADR.MASK,TXPMREGS,S.TXPM.1,S.TXPM.0
         IFF       C.MPXOUT,MO                                  *237*
         EXT       S.TRV.10,S.TRV.11,EXEC.05,EVNT.PTR           *242*
         EXT       IPUREGS,SPLREGS,CPUREGS,S.TRV.32,MPX.INT
*273          EXT       BIAS.R1, BIAS.R2                                 !272
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
         EXT       EXEC.05,EVNT.PTR                    *237*    *242*
         EXT       CPUREGS,S.TRV.32,MPX.INT
MO       ANOP                                                   *237*
         EXT       DBHAT,S.EXEC68,H.IOCS.,H.EXEC.,H.MEMM.
         EXT       H.IP06,IPCL.ICB,H.TAMM.,IP0F.ICB,H.TSM.
         IFF       C.MPXOUT,MO                                  *237*
         EXT       BKOP,H.REXS.,IP0FS,S.TRV.16
*251          DEF       FI.STRT                                          !248
         EXT       BORT.USR                                     *219*
         DEF       S.TXPM23,S.TXPM.6                            *232*
         DEF       XVTBLA,X.SVCTN6,X.SVCTN7,X.SVCTNE            *219*
         DEF       SVC6IN,SVC7IN,SVCEIN,SVC6OUT,SVC7OUT,SVCEOUT *219*
         DEF       ACX.BIAS                                     *219*
         DEF       PTCH.MCL        M.CALL SVC #                     !268
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
         EXT       IP0FS                                        *237*
         EXT       BORT.USR                                     *219*
MO       ANOP                                                   *237*
         IFT       OS.35,DO35                                   *232*
         EXT       H.EXSUB.                                     *232*
DO35     ANOP                                                   *232*
         IFT       OS.34U02,OS342                               *228*
         EXT       IP04.ICB,IP05.ICB                            *228*
OS342    ANOP                                                   *228*
         IFT       OS.34U03,OS343                               *232*
         EXT       IP04.ICB,IP05.ICB                            *232*
OS343    ANOP                                                   *232*
         IFT       OS.35,OS35                                   *232*
         EXT       IP04.ICB,IP05.ICB                            *232*
OS35     ANOP                                                   *232*
         IFT       C.3227,X.X
         IFF       MPX.EVNT,X.Y
         IFF       C.MPXOUT,MO                                  *237*
         DEF       A.TRV.13
MO       ANOP                                                   *237*
X.Y      ANOP
X.X      ANOP
         M.EQUS
         M.MDE                     MACHINE DEPENDENT EQUATES
         M.TBLS                    NEED  EQUATES
         M.PSB.
         M.PRB.
         M.RXB.
         IFT       OS.35,GETM   INCLUDE IF MPX 3.5              *232*
         M.MIDS    MIDL EQUATES                                 *232*
         M.BREGS                                                    !249
         M.MRRQ                                                     !249
         M.RG.LDR                                                   !249
GETM     ANOP                                                   *232*
         LIST      ON,MAC,NGLIST                                    !267
         M.TXPM                                                     !267
         LIST      NOREPT,NOMAC,NGLIST
         TITLE     H.PTCH -- REMAP PROCESSOR -- (MACRO DEFINITIONS) !261
*
*------------------------------------------------------------------
* MACRO TO REPLACE AN LPSD INSTRUCTION IN A SYSTEM MODULE WITH A
* BRANCH INTO THE "PATCH" REGION.  THE ADDRESS OF THE PSD IS USED
* TO BUILD OPTIONAL LD AND LPSD INSTRUCTIONS IN THE "PATCH" ROUTINE
* THAT IS BEING USED.  THE LABELS OF THE LD AND/OR LPSD INSTRUCTION
* ARE OPTIONALLY PROVIDED.
*
* PARAMETERS:
*
*                  MOD             MPX MODULE TO PATCH
*                  OFFSET          OFFSET IN MOD OF INSTR
*                  ROUTN           DISPATCH ROUTINE ADDRESS
*                  LD.LAB          LABEL OF LD INSTRUCTION
*                                  (OPTIONAL)
*                  LPSD.LAB        LABEL OF LPSD INSTRUCTION
*                                  (OPTIONAL)
*
M.PLPSD  DEFM      MOD,OFFSET,ROUTN,LD.LAB,LPSD.LAB
         LI        R1,%OFFSET      GET OFFSET IN SYSTEM MODULE
         LW        R2,%MOD,X1      GET SYSTEM LPSD INSTRUCTION
         IFP       %LPSD.LAB,%NO   SEE IF LPSD IS TO BE USED
         STW       R2,%LPSD.LAB    PUT IN DISPATCH ROUTINE
%NO      ANMW      R2,=X'FFFF8'    SAVE ONLY PSW ADDRESS
         IFP       %LD.LAB,%NOLD   DO WE WANT PSD ADDR IN LD INSTR
         ORMW      R2,%LD.LAB      OR IN LD INSTRUCTION
         STW       R2,%LD.LAB      PUT IN PATCH CODE
%NOLD    LA        R3,%ROUTN       GET ADDRESS OF PATCH CODE
         ORMW      R3,=X'EC000001' OR IN DISPATCH BR INSTRUCTION
         STW       R3,%MOD,X1      STORE IN SYSTEM MODULE
         ENDM
* ----------------------------------------------------------------
*  The following five "F." macros are modified copies of correspondi!249
*  "M." macros.  They were all originally written for the change    !249
*  number at the end of this line.                                  !249
* ----------------------------------------------------------------- !249
*  Macro to replace an LPSD instruction in memory with a branch into!249
*  the "patch" region.  The address of the PSD is used to build opti!249
*  LD and LPSD instructions in the patch routine that is being used.!249
*  The labels of the LD and LPSD instructions are optionally provide!249
*                                                                   !249
*  PARAMETERS:                                                      !249
*                  REG             Register containing addr of LPSD !249
*                       Cannot be R2!                               !249
*                  ROUTN           Dispatch routine address         !249
*                  LD.LAB          Label of LD instruction          !249
*                                  (OPTIONAL)                       !249
*                  LPSD.LAB        Label of LPSD instruction        !249
*                                  (OPTIONAL)                       !249
*                                                                   !249
*                  Destroyed: R2                                    !249
*                                                                   !249
F.PLPSD  DEFM      REG,ROUTN,LD.LAB,LPSD.LAB                        !249
         LW        R2,,%REG        Get system's LPSD instruction    !249
         IFP       %LPSD.LAB,%NO   See if LPSD is to be used        !249
         STW       R2,%LPSD.LAB    Put in dispatch routine          !249
%NO      ANMW      R2,=X'FFFF8'    Save PSW addr only               !249
         IFP       %LD.LAB,%NOLD   Do we want PSD addr in LD instr? !249
         ORMW      R2,%LD.LAB      OR in LD instruction             !249
         STW       R2,%LD.LAB      Put it in patch code             !249
%NOLD    LA        R2,%ROUTN       Get address of patch code        !249
         ORMW      R2,=X'EC000001' OR in dispatch BR instruction    !249
         STW       R2,,%REG        Store in OS                      !249
         ENDM                                                       !249
*-------------------------------------------------------------------!249
* MACRO TO CHANGE THE ADDRESS OF A LOCAL INSTRUCTION                !249
*                                                                   !249
* PARAMETERS:                                                       !249
*                                                                   !249
*                  LABEL           Label of local instruction       !249
*                  REG             Register that has final offset   !249
*                                                                   !249
*                  REG is modified                                  !249
*                                                                   !249
* NOTE: THE CURRENT ADDRESS IN THE INSTRUCTION MUST BE 0            !249
*                                                                   !249
F.PTCHCT DEFM      LABEL,REG                                        !249
         SLL       %REG,12                                          !249
         SRL       %REG,12                                          !249
         ORMW      %REG,%LABEL                                      !249
         STW       %REG,%LABEL                                      !249
         ENDM                                                       !249
*                                                                   !249
*-------------------------------------------------------------------!249
* MACRO TO REPLACE A CONDITIONAL INSTRUCTION WITH A BRANCH INTO     !249
* THE "PATCH" REGION AND EXIT TO THE CONDITIONAL ADDRESS CONTAINED  !249
* IN THE BRANCH INSTRUCTION.                                        !249
*                                                                   !249
* PARAMETERS:                                                       !249
*                                                                   !249
*                  REG             Register that has final address  !249
*                       MUST be R1!!!!                              !249
*                  ROUTN           PATCH ROUTINE ADDRESS            !249
*                  LABEL           LABEL TO BRANCH TO WHEN DONE     !249
*                                  (OPTIONAL)                       !264
*                  RET_REG         Reg that has addr to return to   !249
*                                  (OPTIONAL)                       !249
*                  RET_LABL        LOCAL LABEL FOR RETURN INSTR     !249
*                                  (OPTIONAL)                       !249
*                                                                   !249
*                  Regs destroyed: 2, 3, 6, RET_REG                 !249
*                                                                   !249
F.PTCHB  DEFM      REG,ROUTN,LABEL,RET_REG,RET_LABL                 !249
         LW        R2,,%REG        GET BRANCH INSTRUCTION           !249
         SRLD      R2,20           SAVE THE BRANCH OP CODE          !249
         SLL       R2,20           PUT OP CODE IN RIGHT PLACE       !249
         LA        R6,%ROUTN       GET ADDRESS OF PATCH CODE        !249
         ORR       R6,R2           INSERT PATCH ROUTINE ADDRESS     !249
         SBR       R2,31           INSURE LEFT HW BRANCH            !249
         STW       R2,,%REG        STORE IN SYSTEM MODULE           !249
         IFP       %LABEL,DO.LABEL                                  !264
         SRL       R3,12           ADDRESS ONLY IN R3               !249
         ORMW      R3,BRANCH       OR IN RETURN INSTRUCTION         !249
         SBR       R3,31           INSURE LEFT HW BRANCH            !249
         STW       R3,%LABEL       PUT IN PATCH RETURN ADDRESS      !249
DO.LABEL ANOP                                                       !264
         IFP       %RET_REG,%NORET SEE IF THEY WANT A RETURN        !249
         ORMW      %RET_REG,BRANCH       OR IN BU INSTRUCTION       !249
         SBR       %RET_REG,31           INSURE LEFT HW BRANCH      !249
         STW       %RET_REG,%RET_LABL    PUT IN PATCH CODE          !249
%NORET   EQU       $                                                !249
         ENDM                                                       !249
*                                                                   !249
*-------------------------------------------------------------------!249
* MACRO TO CHANGE AN INSTRUCTION                                    !249
*                                                                   !249
* PARAMETERS:                                                       !249
*                  REG             Register that has instr's address!249
*                       Can't be R2!                                !249
*                                                                   !249
*                  R2 destroyed                                     !249
*                                                                   !249
* NOTE: THE INSTRUCTION TO INSERT SHOULD BE CODED IMEDIATELY AFTER T!249
*       MACRO DEFINITION.                                           !249
*                                                                   !249
* EG.    F.PTCHC   R3                                               !249
*        LW        R1,TRAV.S32                                      !249
*                                                                   !249
F.PTCHC  DEFM      REG                                              !249
         LW        R2,$+3W                                          !249
         STW       R2,,%REG                                         !249
         BU        $+2W                                             !249
         ENDM                                                       !249
*                                                                   !249
*-------------------------------------------------------------------!249
* MACRO TO REPLACE AN INSTRUCTION WITH A BRANCH INTO A "PATCH"      !249
* REGION IN H.TXPM                                                  !249
*                                                                   !249
* PARAMETERS:                                                       !249
*                                                                   !249
*                  REG             Register that contains the addres!249
*                                  of the instr                     !249
*                       It MUST be R3!                              !249
*                  LABEL           LABEL TO BRANCH TO WHEN DONE     !249
*                  REP_ADDR        LOCAL LABEL TO SAVE PATCHED      !249
*                                  INSTRUCTION AT (OPTIONAL)        !249
*                  RET_ADDR        LOCAL LABEL TO INSERT A RETURN AT!249
*                                  (OPTIONAL)                       !249
*                                                                   !249
*                  Destroyed regs: 1, 2, 4                          !249
*                                                                   !249
* NOTE: THE INSTRUCTIONS TO BRANCH TO SHOULD BE INSERTED IMEDIATELY !249
*       AFTER THE MACRO DECLARATION                                 !249
*                                                                   !249
F.PTCHG  DEFM      REG,LABEL,REP_ADDR,RET_ADDR                      !249
         LW        R4,=X'FFFFF'                                     !249
         IFP       %REP_ADDR,%NOSAVE    SEE IF NEED TO SAVE OLD INST!249
         LW        R1,,%REG             YES                         !249
         STW       R1,%REP_ADDR                                     !249
%NOSAVE  EQU       $                                                !249
         LA        R2,%LABEL            Get addr of 1st instr       !249
         TRRM      R2,R2                Get rid of all but addr     !249
         ORMW      R2,BRANCH            ADD INSTRUCTION             !249
         STW       R2,,%REG             STORE INTO MODULE           !249
         IFP       %RET_ADDR,%NORET     SEE IF THEY WANT A RETURN AD!249
         LA        R1,1W,%REG           GET RETURN ADDRESS          !249
         TRRM      R1,R1                                            !249
         ORMW      R1,BRANCH            CHANGE TO BU                !249
         STW       R1,%RET_ADDR                                     !249
%NORET   EQU       $                                                !249
         ENDM                                                       !249
* ----------------------------------------------------------------- !249
*  The following macros were added during the change number listed  !249
*  at the end of this line.  These macros generate various masks    !249
*  used during the instruction search process.                      !249
MK.CMPW  DEFM              Complete Word                            !249
         DATAW     -1                                               !249
         ENDM                                                       !249
MK.NOADR DEFM              Instruction. ignore the address          !249
         DATAW     X'FFF80000'                                      !249
         ENDM                                                       !249
MK.BM    DEFM              Bits in Memory                           !249
         DATAW     X'FC780000'                                      !249
         ENDM                                                       !249
MK.BR    DEFM              Bits in Registers                        !249
         DATAH     X'F87C'                                          !249
         ENDM                                                       !249
MK.CMPH  DEFM              Complete halfword                        !249
         DATAH     -1                                               !249
         ENDM                                                       !249
MK.NOMKW DEFM              No Mask, entire Word                     !249
         DATAW     0                                                !249
         ENDM                                                       !249
MK.NOMKH DEFM              No Mask, Halfword                        !249
         DATAH     0                                                !249
         ENDM                                                       !249
MK.MCALL DEFM              For M.CALLs                              !249
         GEN       16/-1,8/0,8/-1                                   !249
         ENDM                                                       !249
* ----------------------------------------------------------------- !249
*  The following macro is an attempt to combine the M.TSAD with     !277
*  the mask macros listed earlier.  It parallels one of the possible!277
*  M.TSAD invocations, plus the comparison masks.                   !277
MK.MTSAD DEFM      REG                                              !277
         LW        %REG,C.SCOFDQ                                    !277
         MK.CMPW                                                    !277
         TSCR      3,3                                              !277
         NOP                                                        !277
         MK.CMPW                                                    !277
         LW        %REG,DQE.TAD,%REG                                !277
         MK.CMPW                                                    !277
         ANMW      %REG,C.ADMASK                                    !277
         MK.CMPW                                                    !277
         ENDM                                                       !277
* ----------------------------------------------------------------- !277
*  Macro FI.ENT creates the beginning of an entry usable by         !249
*  the FindInstruction subroutine.  To use FINDINST, create an      !249
*  entry header using FI.ENT, then follow it with the instructions  !249
*  you want to search for.  After each full word of instructions,   !249
*  generate a full word of masks.                                   !249
*     The parameters to FI.ENT are:                                 !253
*        FI.ENT    ENTNM,STRTENT,ENDENT,LOCN,REPEAT                 !275
*  ENTNM is the name of the entry; the label at the start of the    !253
*        entry                                                      !253
*  STRTENT is the first word of code in the sequence of instructions!253
*        that FINDINST will look for                                !253
*  ENDENT is the last word of code in the sequence of instructions  !253
*        that FINDINST will look for (actually it is the mask       !253
*        for the last entry; it is also the address of the end      !253
*        address of the entry)                                      !253
*  LOCN is the label assigned to the actual target instruction.     !253
*  REPEAT is a flag that asks that the counter not be incremented   !275
*                                                                   !253
*  To use FI.ENT, call it with appropriate parameters, then follow  !253
*  it with two words that point to the start location and end       !253
*  location in the OS where FINDINST should look.  Then place       !253
*  the instruction sequence you are looking for after that.  The    !253
*  first word of the sequence should be labeled with parameter 2    !253
*  from FI.ENT.  The address of the first word after the sequence   !253
*  must be labeled with parameter 3.  The instruction you are       !253
*  finally interested in should be labeled with parameter 4.  You   !253
*  MUST follow each instruction with a mask word.  This word will   !253
*  be used to mask the compares that FINDINST does.                 !253
*     You need not put the instructions right after the FI.ENT      !253
*  and its two address words.                                       !253
*                                                                   !249
*        FI.ENT    IOC1,IOC1.S,IOC1.E,IOC1.L                        !249
*        ACW       *IOCSSTRT                                        !249
*        ACW       *IOCSEND                                         !249
* IOC1.S LA        R1,FCB.IOQA,X3                                   !249
*        MK.CMPW                                                    !249
*        ZMB       3,X3                                             !249
*        MK.CMPW                                                    !249
* IOC1.L M.CALL    IOCS,10                                          !249
*        MK.MCALL                                                   !249
*        TRR       R2,R3                                            !249
*        ZBR       R3,3                                             !249
*        MK.CMPW                                                    !249
* IOC1.E EQU       $                                                !249
*                                                                   !249
*  This will find the instruction sequence LA R1, ... through the ZB!249
*  FINDINST will start looking at *IOCSSTRT, and end at *IOCSEND.   !249
*  If found, R3 will point to the found M.CALL instruction.         !249
*                                                                   !249
FI.NR    SET       0                                                !249
FI.NRENT EQU       0                                                !249
FI.OFFS  EQU       1B                                               !249
FI.NMBR  EQU       1H                                               !249
FI.ENT   DEFM      ENTNM,STRTENT,ENDENT,LOCN,REPEAT                 !266
*                  Define a Find Instruction ENTry                  !266
         IFA       %REPEAT,FINOP                                    !266
FI.NR    SET       FI.NR+1                                          !249
FINOP    ANOP                                                       !266
         BOUND     1W                                               !249
%ENTNM   GEN       8/%ENDENT-%STRTENT/2,8/%LOCN-%STRTENT/2,16/FI.NR !249
         ENDM                                                       !249
*
         IFF       C.MPXOUT,MO                                  *237*
         IFF       OS.15E,OS15E                                 *238*
OS15E    ANOP                                                   *238*
*
*--------------------------------------------------------------------
*  MACRO TO BIAS REGISTER R
*
BIAS.R   DEFM      R               MACRO TO BIAS REGISTER R
         LMW       R6,1W*%R,X1     FETCH REGISTER TO BIAS
         BZ        %LEND           NO BIAS IF ZERO
         TRR       R5,R5           SEE IF BIAS/REBIAS
         BN        $+2W            GO IF REBIAS
         ADR       R5,R6           BIAS ADDRESS
         CAMW      R6,C.TSAD       IS ADDR IN O/S OR USER
         BLT       $+2W            GO IF IN O/S
         ARMW      R5,1W*%R,X1     BIAS/REBIAS CUZ ADDR IN USER
%LEND    EQU       $
         ENDM
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
*-----------------------------------------------------------------------
* MACRO TO TEST IF IN IPU
*
T.IPU    DEFM      R
         IFF       C.3227,%1JUNK
         LW        %R,=X'910000'   GET SPAD ADDRESS
         TSCR      %R,%R           READ IPU STATUS WD
%1JUNK   ANOP
         IFT       C.3227,%2JUNK
         RDSTS     %R              READ STATUS
%2JUNK   ANOP
         TBR       %R,27           SEE IF IPU
         ENDM
*
MO       ANOP                                                   *237*
         IFF       OS.35,MI       NOT REQUIRED IN 35            *237*
*-----------------------------------------------------------    *237*
* MACRO TO GET TSA ADDRESS                                      *237*
M.TSAD   DEFM      R                                            *237*
         LW        %R,C.TSAD                                    *237*
         ENDM                                                   *237*
*                                                               *237*
MI       ANOP                                                   *237*
         IFF       OS.15E,OS15E                                 *238*
*-----------------------------------------------------------------------
* MACRO TO CHANGE THE ADDRESS OF A LOCAL INSTRUCTION
*
* PARAMETERS:
*
*                  LABEL           LABEL ATTACHED TO LOCAL INSTRUCTION
*                  MOD             NAME OF MODULE THAT CONTAINS ADDRESS
*                  OFFSET          OFFSET OF ADDRESS IN ABOVE MODULE
*
* NOTE: THE CURRENT ADDRESS IN THE INSTRUCTION MUST BE 0
*
M.PTCHCT DEFM      LABEL,MOD,OFFSET
         LW        R4,=X'FFFFF'
         LA        R1,%MOD
         ADI       R1,%OFFSET
         TRRM      R1,R1
         ORMW      R1,%LABEL
         STW       R1,%LABEL
         ENDM
*
*-----------------------------------------------------------------------
* MACRO TO REPLACE A CONDITIONAL INSTRUCTION WITH A BRANCH INTO
* THE "PATCH" REGION AND EXIT TO THE CONDITIONAL ADDRESS CONTAINED
* IN THE BRANCH INSTRUCTION.
*
* PARAMETERS:
*
*                  MOD             MODULE TO PATCH
*                  OFFSET          OFFSET IN MOD OF INSTR
*                  ROUTN           PATCH ROUTINE ADDRESS
*                  LABEL           LABEL TO BRANCH TO WHEN DONE
*                  RET_OFFS        MODULE OFFSET TO RETURN TO
*                                  (OPTIONAL)
*                  RET_LABL        LOCAL LABEL FOR RETURN INSTR
*                                  (OPTIONAL)
*
M.PTCHB  DEFM      MOD,OFFSET,ROUTN,LABEL,RET_OFFS,RET_LABL
         LI        R1,%OFFSET
         LW        R2,%MOD,X1      GET BRANCH INSTRUCTION
         SRLD      R2,20           SAVE THE BRANCH OP CODE
         SLL       R2,20           PUT OP CODE IN RIGHT PLACE
         LA        R6,%ROUTN       GET ADDRESS OF PATCH CODE
         ORR       R6,R2           INSERT PATCH ROUTINE ADDRESS
         SBR       R2,31           INSURE LEFT HW BRANCH
         STW       R2,%MOD,X1      STORE IN SYSTEM MODULE
         SRL       R3,12           ADDRESS ONLY IN R3
         ORMW      R3,BRANCH       OR IN RETURN INSTRUCTION
         SBR       R3,31           INSURE LEFT HW BRANCH
         STW       R3,%LABEL       PUT IN PATCH RETURN ADDRESS
         IFP       %RET_OFFS,%NORET     SEE IF THEY WANT A RETURN
         LI        R1,%RET_OFFS    GET OFFSET IN MODULE TO RETURN
         LA        R1,%MOD,X1      CALCULATE RETURN ADDRESS
         ORMW      R1,BRANCH       OR IN BU INSTRUCTION
         SBR       R1,31           INSURE LEFT HW BRANCH
         STW       R1,%RET_LABL    PUT IN PATCH CODE
%NORET   EQU       $
         ENDM
*
*-----------------------------------------------------------------------
* MACRO TO CHANGE AN INSTRUCTION
*
* PARAMETERS:
*                  MOD             MODULE CONTAINING INSTRUCION TO CHANG
*                  OFFSET          OFFSET IN MODULE TO CHANGE
*
* NOTE: THE INSTRUCTION TO INSERT SHOULD BE CODED IMEDIATELY AFTER THE
*       MACRO DEFINITION.
*
* EG.    M.PTCHC   H.EXEC,27C
*        LW        R1,TRAV.S32
*
M.PTCHC  DEFM      MOD,OFFSET
         LI        R1,%OFFSET
         LW        R2,$+3W
         STW       R2,%MOD,X1
         BU        $+2W
         ENDM
*
*-----------------------------------------------------------------------
* MACRO TO REPLACE AN INSTRUCTION WITH A BRANCH INTO A "PATCH"
* REGION IN H.TXPM
*
* PARAMETERS:
*
*                  MOD             MODULE TO PATCH
*                  OFFSET          OFFSET IN MOD OF INSTRUCTION TO PATCH
*                  LABEL           LABEL TO BRANCH TO WHEN DONE
*                  REP_ADDR        LOCAL LABEL TO SAVE PATCHED
*                                  INSTRUCTION AT (OPTIONAL)
*                  RET_ADDR        LOCAL LABEL TO INSERT A RETURN AT
*                                  (OPTIONAL)
*
* NOTE: THE INSTRUCTIONS TO BRANCH TO SHOULD BE INSERTED IMEDIATELY
*       AFTER THE MACRO DECLARATION
*
M.PTCHG  DEFM      MOD,OFFSET,LABEL,REP_ADDR,RET_ADDR
         LW        R4,=X'FFFFF'
         LI        R3,%OFFSET
         IFP       %REP_ADDR,%NOSAVE    SEE IF NEED TO SAVE OLD INST
         LW        R1,%MOD,X3           YES
         STW       R1,%REP_ADDR
%NOSAVE  EQU       $
         LA        R2,%LABEL            GET ADDRESS OF FIRST INST
         TRRM      R2,R2                GET RID OF ALL BUT ADDR
         ORMW      R2,BRANCH            ADD INSTRUCTION
         STW       R2,%MOD,X3           STORE INTO MODULE
         IFP       %RET_ADDR,%NORET     SEE IF THEY WANT A RETURN ADDR
         ADI       R3,1W                SET OFFSET TO RETURN ADDRESS
         LA        R1,%MOD,X3           GET RETURN ADDRESS
         TRRM      R1,R1                MASK OFF UNWANTED STUFF
         ORMW      R1,BRANCH            CHANGE TO BU
         STW       R1,%RET_ADDR
%NORET   EQU       $
         ENDM
*
OS15E    ANOP                                                   *238*
         IFF       C.MPXOUT,MO                                  *237*
MO       ANOP                                                   *237*
*
         TITLE     H.PTCH -- REMAP PROCESSOR -- (EQUATES)           !261
*--------------------------------------------------------------------
*   SCRATCHPAD AND INTERRUPT EQUATES
*
T.LMIT   EQU       X'1800'         LOAD MODULE INFO TABLE BIAS
         IFF       C.3227,S.7X                                  *206*
OS.32X   SETF                                                   *206*
DBG.NMAP EQU       1                                            *206*
S.7X     ANOP                                                   *206*
         IFT       C.3227,S.3X                                  *206*
DBG.NMAP EQU       4                                            *206*
         IFF       OS.32A,S.7X                                  *206*
         IFF       OS.32B,S.7X                                  *206*
         IFF       OS.32C,S.7X                                  *206*
         IFF       OS.UCS,S.7X                                  *206*
         IFF       OS.U03,S.7X                                  *206*
         IFF       OS.33,S.7X                                   *206*
         IFF       OS.U02,S.7X                                  *206*
         IFF       OS.34,S.7X                                   *210*
         IFF       OS.34U01,S.7X                                *232*
         IFF       OS.34U02,S.7X                                *228*
         IFF       OS.34U03,S.7X                                *232*
         IFF       OS.35,S.7X                                   *232*
         IFF       OS.36,S.7X                                   !284
OS.32X   SETF                                                   *206*
S.7X     ANOP                                                   *206*
         IFF       OS.21A,S.3X                                  *206*
         IFF       OS.22,S.3X                                   *206*
         IFF       OS.23,S.3X                                   *206*
         IFF       OS.24,S.3X                                   *206*
OS.32X   SETT                                                   *206*
S.3X     ANOP                                                   *206*
         IFF       C.MPXOUT,MO                                  *237*
IPU.GATE EQU       6               IPU GATE FLAG 2X
IPU.SCH  EQU       6               IPU SCHED FLAG 3X            *211*
EXEC.RUN EQU       5               IPU RUNNING FLAG             *211*
         EXT       EXEC.FLG
         IFT       OS.36,O36                                    !284
         EXT       EXC.IPUP        NEW SCHEDULING FLAG          !284
IPU.REQP EQU       0               PENDING IPU REQUEST FLAG     !284
O36      ANOP                                                   !284
MO       ANOP                                                   *237*
         M.TXINTL                  Define internals                 !267
*
*PR.NOMPX EQU        X'133'         BIT 7 SET SAYS THIS IS TXPM TASK
*                                  BIT 6 SET SAYS SEPERATE OVERLAYS
*                                  BIT 5 SET SAYS ONLY MPX TASK
*
*            PREAMBLE WORD X'2C':  BYTE 2 = # OS MAPS TO INCLUDE
*                                  BYTE 3 = 1, RUN TASK AS 'NO-MPX'
*
*  NOTE:  IF BYTE 3 = 1 ('NO-MPX' TASK) AND BYTE 2 = 0 (INCLUDE 0
*         OS MAPS), THEN THE TASK WILL BE RUN IN THE 'MPX' ENVIORNMENT.
*         THUS, AT LEAST 1 OS MAP MUST BE MAPPED IN AT RUN TIME IN THE
*         'NO-MPX' ENVIRONMENT.
*
*--------------------------------------------------------------------
*
*  DEBUG EQUATES
*
DBG.OS   EQU       DBG.NMAP*2      # MAPS FOR DEBUGGER + OS TABLES
*
*  HANDLER ADDRESS TABLE
*
*        LIST      NONG,NODATA,NOMAC
         LIST      NONG,NODATA,MAC,REP
HAT      DATAW     1
         ACW       T.INIT          SYSGEN INITIALIZATION
*
         IFF       C.MPXOUT,MO                                  *237*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     S.TXPM23         DETERMINE RESOURCE SPEC. TYPE
***********************************************************************
*
*   FUNCTIONAL DESCRIPTION.
*
*        THIS ROUTINE EXAMINES THE RESOURCE SPECIFICATION PARAMETER
*        TO DETERMINE ITS FORMAT; PN, PNB, R.I.D, SHORT R.I.D, LFC
*        OR FCB.
*
*   INPUT.
*
*        R1 = RESOURCE SPECIFICATION
*
*                  NOTE THAT AN FCB OR LFC WILL HAVE ITS TOP BYTE CLEAR
*                  AS IT WILL EITHER BE A G'XXX' OR AN ADDRESS. IT IS
*                  AS CONVENIENT TO PROVIDE AN FCB ADDRESS AS TO PROVIDE
*                  THE CONTENTS OF WORD 0 OF AN FCB!
*                  OTHER FORMS OF THE RESOURCE SPECIFICATION WILL
*                  CONTAIN A BYTE COUNT IN BTE 0, FOLLOWED BY THE
*                  ADDRESS OF THE PN, PNB, RID OR SRID.
*
*   OUTPUT.
*
*        R7 = RESOURCE SPECIFICATION CODE
*
*        CODE      MEANING
*        ====      =======
*         0        PATH NAME
*         1        PATH NAME BLOCK
*         2        R. I. D.
*         3        SHORT R. I. D.
*         4        FCB ADDRESS
*         5        LFC
*         6        ALLOCATION INDEX
*
*        IF THE REPLY CODE IS 4 THRU 6, R1 WILL CONTAIN THE FPT ADDRESS
*        OF THE ALLOCATED FCB OR LFC.
*
*        CC1 IS SET ON FAILURE (ALL REGISTERS INTACT)
*
************************************************************************
*
         BOUND     1W
S.TXPM23 T.IPU     R7              SEE IF IN IPU
         BS        SV23.000        SKIP CPU SAVE IF YES
         STF       R0,T23.CPUS     SAVE CPU REGS
         LA        R3,T23.CPUS     SAVE AREA ADDR TO R3
         BU        SV23.MRG        CPU REGS SAVED, GO ON
SV23.000 STF       R0,T23.IPUS     SAVE IPU REGS
         LA        R3,T23.IPUS     SAVE AREA ADDR TO R3
SV23.MRG LW        R4,=X'FFFFFF'   GENERAL MASK
         TRRM      R1,R1           ADDRESS/LFC
         LI        R7,4            ASSUME FCB WILL BE FOUND
         M.TSAD    R2              TSA ADDR                     *237*
         LNB       R6,T.FILES,R2   # OF FPT ENTRIES
         LW        R2,T.FPTA,R2    FPT ADDR
SV23.001 TBM       4,FPT.FLGS,R2   SEE IF FREE
         BS        SV23.002        GO IF NOT IN USE
         CMMW      R1,FPT.LFC,R2   SEE IF LFC
         BEQ       SV23.004        GO IF SO
         CMMW      R1,FPT.FCBA,R2  SEE IF FCB
         BNE       SV23.002        GO IF NOT THIS ONE
         LMW       R5,FCB.LFC,R1   GET FCB LFC
         CMMW      R5,FPT.LFC,R2   DO THEY MATCH?
         BEQ       SV23.005        GO IF SO
SV23.002 ADI       R2,FPT.SIZE     STEP TO NEXT FPT
         BIB       R6,SV23.001     LOOP THRU ALL FPTS
*  IT'S NOT A LFC OR FCB ADDRESS. ALL OTHER RESOURCE SPECIFICATIONS
*  NEED BYTE COUNT STORED AT BYTE 0 OF R1. IF IT IS 0, THERE'S AN ERROR.
         LB        R0,1W,R3        BYTE COUNT EXISTING?
         BNZ       SV23.006        IF BYTE COUNT <> 0, GO ON
*
*  DROP THRU ON ERROR
*
SV23.020 SBM       1,0W,R3         SET REPLY CC1
*
*  EXIT POINT
*
SV23.003 STW       R7,7W,R3        REPLY R7
         LF        R0,0W,X3        RESTORE CALLERS CONTEXT
         TRSW      R0              RETURN TO CALLER
*
*  LFC LOCATED
*
SV23.004 LI        R7,5            SHOW LFC TYPE
*
*  FCB LOCATED
SV23.005 EQU       $
         BU        SV23.003        GO EXIT
*
*  HERE IF NOT LFC/FCB
*
*        FIRST, TRY FOR AN ALLOCATION INDEX
*
SV23.006 LI        R7,6            SHOW ALIX TYPE
         LNW       R5,C.ARTA       GET ART ADDRESS
         ZR        R4              FOR DIVIDE
         ADR       R1,R5           GET ART OFFSET
         BN        SV23.06A        GO IF NOT ART
         IFT       OS.32X,S.7X                                  *232*
         IFF       OS.32A,S.7X                                  *232*
         IFF       OS.32B,S.7X                                  *232*
         IFF       OS.32C,S.7X                                  *232*
         IFF       OS.UCS,S.7X                                  *232*
         IFF       OS.U03,S.7X                                  *232*
         DVI       R4,8W           ART SIZE IS NOW 8W           *232*
*                                  IN 3.3 AND AFTER             *232*
S.7X     ANOP                                                   *232*
         IFF       OS.33,SIZ6W
         IFF       OS.U02,SIZ6W
         IFF       OS.34,SIZ6W                                  *210*
         IFF       OS.34U01,SIZ6W                               *232*
         IFF       OS.34U02,SIZ6W                               *228*
         IFF       OS.34U03,SIZ6W                               *232*
         IFF       OS.35,SIZ6W                                  *232*
         IFF       OS.36,SIZ6W                                  !284
         DVI       R4,6W           ART SIZE IS 6W BEFORE 3.3
SIZ6W    ANOP
         CAMH      R5,C.ARTN       INSIDE ART TABLE
         BGT       SV23.06A        GO IF NOT
         TRR       R4,R4           ANY REMAINDER (NOT ART MULTIPLE)
         BZ        SV23.003        IF NONE, MUST BE AN ALIX
SV23.06A LI        R7,2            ASSUME RID
         CI        R0,32           RID LENGTH
         BNE       SV23.008        GO IF CAN'T BE RID
         LB        R6,RD.RTYPE,R1  GET TOP BYTE OF TYPE H/W
         BNZ       SV23.008        GO IF NOT RID
*
* NOW SEE IF 1ST CHAR OF VOLNAME IS NOT A SPECIAL CHAR
*
         LB        R6,RD.IDNAM,R1  GET 1ST CHAR ID
         LI        R2,SV23.010-SV23.011  GET -VE NUM SPEC CHARS
SV23.007 CAMB      R6,SV23.011,R2  TEST SPECIAL CHAR
         BEQ       SV23.008        GO IF SPEC (NOT RID)
         BIB       R2,SV23.007     TEST ALL SPECIALS
*
*   IT IS AN RID
*
         LI        R6,7
         ANR       R1,R6           DOUBLE WORD BOUND ?
         BNZ       SV23.020        NO
         BU        SV23.003        SO GO EXIT
*
SV23.008 LI        R7,3            ASSUME SRID
         CI        R0,8            SRID LENGTH
         BEQ       SV23.003        GO IF SRID (SHOULD NOT HAPPEN)
*
* CAN ONLY BE PN OR PNB
*
SV23.009 ZR        R7              ASSUME PN
         LB        R6,0,R1         GET FIRST CHAR
         CI        R6,G'!'         CHECK FOR PNB
         BNE       SV23.003        GO IF PN (NOT PNB)
         LI        R7,1            SET PN TYPE
         BU        SV23.003        AND EXIT
*
*  SPECIAL CHARACTER TABLE FOR VOL NAME START
*
SV23.010 DATAB     C'@!(^'         SPECIAL DELIMITERS
SV23.011 EQU       $               DELIMITS SV23.010 TABLE
T23.CPUS RES       1F              CPU REG SAVE
T23.IPUS RES       1F              IPU REG SAVE
*
OS15E    ANOP                                                   *238*
MO       ANOP                                                   *237*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     H.PTCH -- REMAP PROCESSOR -- S.TXPM.3 (ADJ. T.BIAS)
*
*--------------------------------------------------------------------
*
*  THIS ROUTINE WILL ADJUST THE RELOCATION BIAS FOR THE 'NO-MPX'
*  ENVIRONMENT, IF THIS IS A 'NO-MPX' TASK.
*
*  CALLED BY:  H.TAMM, DURING TASK ACTIVATION (AND OVERLAY LOAD).
*
*  ON INPUT :  R1 = TSA ADDRESS
*  ON OUTPUT:  R7 = ADJUSTED RELOCATION BIAS
*
         BOUND     1W
AJ.RELB  EQU       $               ADJUST RELOCATION BIAS
*
*  COMPUTE IN R7 THE 'NO-MPX' BIAS
*
         IFT       C.MPXOUT,MO                                  *237*
S.TXPM.3 LCW       R7,T.BIAS,X1    FETCH REGULAR BIAS           *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
S.TXPM.3 LW        R7,T.BIAS,X1    FETCH REGULAR BIAS           *237*
MO       ANOP                                                   *237*
         LW        R1,C.CURR       DQE ADDRESS
         LW        R1,DQE.PSSF,X1  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  'NO-MPX' TASK?
         BNS       TRAV.3.2        NO RETURN
         TRR       R2,R4           SAVE R2
         LW        R2,C.REGS       TSA ADDRESS
         IFF       OS.35,D35       NOT IN 3.5                   *232*
         LW        R7,T.DBHAT,X2   DEBUGGER PRESENT?
         BZ        TRAV.3.1        BRANCH IF NOT
         CAR       R2,R7
         BLE       TRAV.3.1        CONTINUE IF ALREADY SET TO TRAVIS
         STW       R7,TSK.DBHT,X1  SAVE IN DQE CONTEXT AREA
         LA        R7,DBHAT        OUR HAT TABLE ADDRESS
         STW       R7,T.DBHAT,X2   MAKE T.DBHAT POINT TO TRAVIS
D35      ANOP                                                   *232*
         IFT       C.MPXOUT,MO                                  *237*
TRAV.3.1 LCW       R7,T.BIAS,X2    FETCH REGULAR BIAS           *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
TRAV.3.1 LW        R7,T.BIAS,X2    FETCH REGULAR BIAS           *237*
MO       ANOP                                                   *237*
         SUMW      R7,TSK.BIAS,X1  'NO-MPX' BIAS IN R7
         TRR       R4,R2           RESTORE R2
TRAV.3.2 LW        R1,C.REGS       FETCH TSA ADDRESS
AJ.RELBR BU        $-$             RETURN INSTRUCTION
         IFT       OS.35,D35                                    *232*
*                                                               *232*
         TITLE     H.PTCH -- REMAP PROCESSOR -- SETHAT          *232*
*                                                               *232*
*---------------------------------------------------------------*232*
*                                                               *232*
*  THIS ROUTINE WILL SET THE DBHAT ADDRESS TO TXPM AND SAVE THE *232*
*  MPX HAT ADDRESS IN TSK.DBHT.                                 *232*
*                                                               *232*
*  CALLED BY:  S.TAMM4 DURING DEBUGGER OVERLAY LOAD.            *232*
*                                                               *232*
*  ON INPUT :  R3 = TSA ADDRESS                                 *232*
*              R1, R4 = AVAILABLE FOR USE                       *232*
*                                                               *232*
         BOUND     1W                                           *232*
SETHAT   EQU       $               SET DBHAT ADDRESS            *232*
         LW        R1,C.CURR       TXPM CONTEXT ADDRESS         *232*
         LW        R1,DQE.PSSF,X1  CONTEXT ADDRESS              *232*
         TBM       TSK.TXPM,TSK.FLG1,X1  'NO-MPX' TASK?         *232*
         BNS       SETHAT.1        NO RETURN                    *232*
         IFT       C.MPXOUT,MO                                  *237*
         LCW       R4,T.DBHAT,X3   DEBUGGER PRESENT?            *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LW        R4,T.DBHAT,X3   DEBUGGER PRESENT?            *237*
MO       ANOP                                                   *237*
         BZ        SETHAT.1        BRANCH IF NOT                *232*
         CAMW      R4,C.TSAD       BELOW TSA                    *237*
         BLE       SETHAT.1        CONTINUE IF SET TO TXPM      *232*
         STW       R4,TSK.DBHT,X1  SAVE IN CONTEXT AREA         *232*
         LA        R4,DBHAT        OUR HAT TABLE ADDRESS        *232*
         IFT       C.MPXOUT,MO                                  *237*
         STCW      R4,T.DBHAT,X3   MAKE T.DBHAT POINT TO TXPM   *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         STW       R4,T.DBHAT,X3   MAKE T.DBHAT POINT TO TXPM   *237*
MO       ANOP                                                   *237*
SETHAT.1 M.CALL    H.TAMM,1        LOAD THE TASK DEBUGGER       *232*
SETHAT.R BU        $-$             RETURN INSTRUCTION           *232*
D35      ANOP                                                   *232*
*
         IFF       C.MPXOUT,MO                                  *237*
         TITLE     H.PTCH -- REMAP PROCESSOR -- S.TXPM.A (TSA REFS FIXS)
*
*--------------------------------------------------------------------
*
*  THIS ROUTINE DOES THE FOLLOWING:
*
*  1.  TESTS THE CODE BEING LOADED FOR REFERENCES TO THE TSA
*      AND REPLACES THE INSTRUCTION WITH AN UNIMPLEMENTED INSTRUCTION.
*  2.  CLEARS USR.TSAB SO IT CAN BE SET UPON FIRST TSA REF BY USER.
*
*  CALLED BY:  H.TAMM, DURING TASK ACTIVATION.
*
*  ON ENTRY:   ALL REGS IN USE BY TAMM.1 (R3=INSTRUCTION ADDRESS)
*  ON EXIT:    ALL REGS RESTORED
*
         BOUND     1W
S.TXPM.A BEI                       STAY BLOCKED
         STF       R0,L.REGS       SAVE THE REGS
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  TXPM TASK?
         BNS       S.A.EXIT        EXIT IF NOT
         TRR       R5,R5           ARE WE ON LAST REL BLOCK
         BNZ       S.A.XXX         BR IF NOT
         CI        R6,-4           ARE WE ON LAST WORD OF REL
         BNE       S.A.XXX         CONTINUE IF NOT LAST BLOCK
         TRR       R4,R4           ANY RELOCATION BITS
         BNZ       S.A.XXX         CONTINUE IF YES
         TRR       R3,R6           COPY LOAD ADDRESS
         TRR       R3,R5           ANOTHER COPY
         SRL       R5,SHIFTA       MAKE MAP NUMBER
         SLL       R5,SHIFTA       START OF MAP ADDRESS
         SUR       R5,R6           GET OFFSET IN MAP
         CI        R6,31W          IN FIRST 31W
         BGE       S.A.XXX         IF NOT, CONTINUE                *206*
         M.TSAD    R2              GET TSA ADDRESS                 *237*
         LW        R2,T.REGP,X2    GET STACK POINTER               *206*
         CAMW      R5,30W,X2       SEE IF IN 1ST MAP (RG.LOAD)     *206*
         BNE       S.A.EXIT        BR IF NOT, MAY MAP FAULT        *206*
S.A.XXX  EQU       $               NOT LAST WD OF LAST REL MATRIX
         LW        R5,0W,X3        GET 32 BITS OF ADDRESS
         BZ        S.A.EXIT        NO DATA, SO EXIT             *232*
         ANMW      R5,=X'7FFFF'    LOOK AT 19 BITS OF ADDRESS
         BZ        S.A.EXIT        NO DATA, SO EXIT             *232*
         CI        R5,C.TSAD       TSA ADDRESS?
         BEQ       S.A.GON         BR IF YES
         CI        R5,C.REGS       TSA REFERENCE?
         BEQ       S.A.GON         BR IF YES
         CI        R5,C.TXPM       TXPM TSA REFERENCE
*268          BNE       S.A.EXIT        NO TSA REFERENCE, SO EXIT
         BNE       S.A.SVC0        NO TSA REFERENCE, SO check M.CALL!268
S.A.GON  LW        R4,OP.MASK      OPCODE MASK NON-INDEXED
         LMW       R5,0W,X3        GET THE INSTRUCTION
         SRL       R5,20           ALL BUT ADDRESS PART
         CI        R5,X'AC0'       LOAD INSTR?
         BEQ       S.A.GOGO        BR IF WE GOT HIM
         CI        R5,X'B80'       ADD INSTR?
         BEQ       S.A.GOGO        BR IF WE GOT HIM
         CI        R5,X'BC0'       SUBT INSTR?
         BNE       S.A.EXIT        NO TSA REFERENCE, SO EXIT
S.A.GOGO LI        R4,X'409'       GET UNIMPLEMENTED INSTR
         LW        R5,0W,X3        GET INSTRUCTION AGAIN
         SRLD      R4,16           POSITION U.I. FIRST, OP 2ND
         STW       R5,0W,X3        REPLACE THE INSTRUCTION
         ZBM       USR.TSAB,TSK.FLG1,X2  NO REF YET, SET IN UI TRAP
S.A.EXIT LF        R0,L.REGS       RESTORE REGS
         UEI                       UNBLOCK INTS
         NOP                       FILLER
S.A.RET  BU        $-$             SET BY EP8
* ----------------------------------------------------------------- !268
S.A.SVC0 LH        R5,,X3          Check for M.CALLs                !268
         CI        R5,X'C806'      SVC?                             !268
         BNE       S.A.EXIT        Go if no                         !268
         LB        R5,2B,X3        Get SVC index                    !268
         SRL       R5,4            Lose other four bits             !268
         TRR       R5,R5           SVC 0?                           !268
         BEQ       S.A.02          Go if yes                        !268
         CI        R5,MPX_SVC      Or the MPX M.CALL?               !268
         BNE       S.A.EXIT        Go if no                         !268
S.A.02   EQU       $               We have an M.CALL.  See if we    !268
*        can replace it with an SVC 1 or 2.                         !268
         LH        R7,1H,X3        Get the sub-index                !268
         SLL       R7,20           Isolate it                       !268
         SRL       R7,20                                            !268
         LI        R2,-SVC0.NRE*4  Loop and indexer                 !268
S.A.L    CAMH      R7,SVC0.TBE,X2  Found a match?                   !268
         BEQ       S.A.F           Go if so                         !268
         BIW       R2,S.A.L        Loop if not                      !268
         BU        S.A.EXIT        Not one we can replace           !268
S.A.F    LH        R7,SVC0.TBE+1H,X2 Get replacement                !268
         STH       R7,1H,X3        And store                        !268
         BU        S.A.EXIT                                         !268
* ---------------                                                   !268
SVC0.TBL DATAH     H.IOCS*256+14   M.CALL H.IOCS,14                 !268
         DATAH     X'103F'         SVC 1,X'3F'                      !268
         DATAH     H.IOCS*256+3                                     !268
         DATAH     X'1031'                                          !268
         DATAH     H.IOCS*256+4                                     !268
         DATAH     X'1032'                                          !268
         DATAH     H.IOCS*256+1                                     !268
         DATAH     X'1030'                                          !268
         DATAH     H.REXS*256+21                                    !268
         DATAH     X'2052'                                          !268
         DATAH     H.REMM*256+17                                    !268
         DATAH     X'2049'                                          !268
         DATAH     H.TSM*256+8                                      !268
         DATAH     X'1029'                                          !268
         DATAH     H.TSM*256+9                                      !268
         DATAH     X'102A'                                          !268
SVC0.NRE EQU       $-SVC0.TBL/4    Nr entries; 1w per entry         !268
SVC0.TBE EQU       $                                                !268
OP.MASK  DATAW     X'FC700000'     OPCODE MASK, NON-INDEXED
L.REGS   RES       1F              REG SAVE AREA
*
MO       ANOP                                                   *237*
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     H.PTCH -- REMAP PROCESSOR -- S.TXPM.4 (NOMPX BIAS)
*
*--------------------------------------------------------------------
*
*  THIS ROUTINE DOES THE FOLLOWING:
*
*  1.  COMPUTES THE 'NO-MPX' BIAS
*  2.  CHECKS FOR DSECT/CSECT OVERLAP
*  3.  ADJUST CSECT ORIGIN BY THE 'NO-MPX' TASKS
*
*  CALLED BY:  H.TAMM, DURING TASK ACTIVATION.
*
*  ON INPUT:   R5 = T.DSOR (DSECT ORIGIN IN MIDL)
*        R3 = TSA ADDRESS
*
S.TXPM.4 LW        R3,C.REGS       TSA ADDRESSS
         LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2 TXPM TASK?
         BS        TRAV.4.2        BRANCH IF YES
         TBM       TSK.OMPX,TSK.FLG2,X2  IS THIS MPX ONLY TASK
         BS        TRAV.4.1        DO NOT ADJUST CSOR IF MPX ONLY
         BU        TRAV.4.1        CAN BE NOOP'ED IF WANTED
         LI        R7,-DBG.NMAP    8K WD ADJUSTMENT FOR TXPM SIZE
         ARMH      R7,T.CSOR,X3    LOWER CSECT ORIGIN
TRAV.4.1 CAMH      R5,T.CSOR,X3    DOES DSECT OVERLAP CSECT?
         BGT       TRAV.4.3        BRANCH IF ERROR
         ADMB      R5,C.MSD        ADD IN OS SIZE
         SLL       R5,SHIFTA       FORM ENDING ADDRESS
         SUI       R5,1W           LAST ADDRESS IN MAP BLOCK
         IFT       C.MPXOUT,MO                                  *237*
         STCW      R5,T.LAST,X3    USE AS ENDING ADDRESS        *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         STW       R5,T.LAST,X3    USE AS ENDING ADDRESS        *237*
MO       ANOP                                                   *237*
         TBM       TSK.OMPX,TSK.FLG2,X2  MPX ONLY TASK?
         BS        TRV4.RET        YES, JUST RETURN
         BU        TRV4.RET        CAN BE NOOP'ED IF WANTED
         LI        R7,DBG.NMAP     8K WD ADJUSTMENT FOR TXPM SIZE
         ARMH      R7,T.CSOR,X3    RESTORE CSECT ORIGIN
         BU        TRV4.RET        TASK O.K., RETURN
*
*  TASK DOESN'T FIT, SO FORCE TO RUN AS T-XPM (IF MPX ONLY BIT NOT SET)
*
TRAV.4.3 TBM       TSK.OMPX,TSK.FLG2,X2  IS THIS MPX ONLY TASK
         BS        TRV4.ERR        RM65 ERROR IF SO
         TRR       R5,R6           DSECT END TO R6
         SUMH      R6,T.CSOR,X3    # OF MAPS TOO LARGE
         BU        TRV.4.4         CAN BE NOOP'ED IF WANTED
         LI        R7,DBG.NMAP     8K WD ADJUSTMENT FOR TXPM SIZE
         ARMH      R7,T.CSOR,X3    RESTORE CSECT ORIGIN
TRV.4.4  LB        R7,C.MSD        NUMBER OF OS MAPS
         SUR       R6,R7           R7 = # OF MPX MAPS TO LEAVE IN
         BNP       TRV4.ERR
         CI        R7,DBG.OS       WILL DEBUG FIT WITH OS TABLES?
         BLT       $+2W            BRANCH IF IT WON'T
         SUI       R7,DBG.NMAP     MAKE ROOM FOR DEBUGGER
         CAMW      R7,MIN.MAPS     WILL USERS TSA BE .LT. MIN.MAPS
         BLT       TRV4.ERR        RM65 ERROR IF WE CAN'T LOAD
         STB       R7,TSK.NMAP,X2  FORCE TASK TO RUN AS T-XPM
         SBM       TSK.TXPM,TSK.FLG1,X2
         SBM       TSK.FORC,TSK.FLG1,X2
         IFT       C.MPXOUT,MO                                  *237*
         LCH       R7,T.CSSZ,X3    GET CSECT SIZE               *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LH        R7,T.CSSZ,X3    GET CSECT SIZE               *237*
MO       ANOP                                                   *237*
         BZ        TRAV.4.2        BR IF NON
         IFF       OS.33,T.21.X    NOT IN 3.3                   *236*
         IFF       OS.U02,T.21.X   NOT IN 3.3 U02 VERSION       *236*
         IFF       OS.34,T.21.X    NOT IN 3.4                   *236*
         IFF       OS.34U01,T.21.X NOT IN 3.4 U01               *236*
         IFF       OS.34U02,T.21.X NOT IN 3.4 U02               *236*
         IFF       OS.34U03,T.21.X NOT IN 3.4 U03               *236*
         IFF       OS.35,T.21.X    NOT IN 3.5                   *236*
         IFF       OS.36,T.21.X    NOT IN 3.6                   !284
* THIS CODE ONLY USED BEFORE MPX 3.3                            *236*
         TBM       2,T.LMIT+PR.FLAG,X3   SHARED CSECT?
         BNS       TRAV.4.2        BR IF NOT
         ZBM       2,T.LMIT+PR.FLAG,X3   FORCE NON SHARED
         SBM       5,T.LMIT+PR.FLAG,X3   FORCE MULTI COPIED
T.21.X   ANOP                                                   *236*
         IFT       OS.32X,T.21.X   NOT IN 2.X                   *236*
         IFF       OS.32A,T.21.X                                *236*
         IFF       OS.32B,T.21.X                                *236*
         IFF       OS.32C,T.21.X   NOT IN 3.2C                  *236*
         IFF       OS.UCS,T.21.X   NOT IN 3.2C UCS VERSION      *236*
         IFF       OS.U03,T.21.X   NOT IN 3.2C U03 VERSION      *236*
* THIS CODE USED WITH MPX 3.3 AND AFTER                         *236*
WK.LMIT  EQU       0                                            *237*
         IFT       C.MPXOUT,MO                                  *237*
         LCW       R3,T.WKADR,X3   GET WORKING MAP ADDR         *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LW        R3,T.WKADR,X3   GET WORKING MAP ADDR         *237*
MO       ANOP                                                   *237*
         TBM       2,WK.LMIT+PR.FLAG,X3   SHARED CSECT?         *236*
         BNS       TRAV.4.2        BR IF NOT                    *236*
         ZBM       2,WK.LMIT+PR.FLAG,X3   FORCE NON SHARED      *236*
         SBM       5,WK.LMIT+PR.FLAG,X3   FORCE MULTI COPIED    *236*
T.21.X   ANOP                                                   *236*
*
TRAV.4.2 LW        R3,C.REGS       GET TSA ADDRESS              *236*
         ADMB      R5,C.MSD        ADD IN OS SIZE               *236*
         SLL       R5,SHIFTA       FORM ENDING ADDRESS
         SUI       R5,1W           LAST ADDRESS IN MAP BLOCK
         IFT       C.MPXOUT,MO                                  *237*
         STCW      R5,T.LAST,X3    USE AS ENDING ADDRESS        *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         STW       R5,T.LAST,X3    USE AS ENDING ADDRESS        *237*
MO       ANOP                                                   *237*
*
*  COMPUTE IN R7 THE BIAS DIFFERENCE BETWEEN THE 'NO-MPX' AND THE 'MPX'
*  ENVIRONMENTS. SAVE IN TSK.BIAS.
*
         LB        R7,C.MSD        FETCH NUMBER OF OS MAP BLOCKS
         LB        R5,TSK.NMAP,X2  FETCH # OF OS MAPS IN 'NMPX' ENV.
         SUR       R5,R7           -# OF MAPS WE ARE LEAVING IN
         ARMH      R7,T.CSOR,X3    ADD BIAS DIFFERENCE TO CSECT ORIGIN
         ARMH      R7,T.EAOR,X3    ADD BIAS DIFFERENCE TO E. A. ORIGIN
         ARMH      R7,T.DBOR,X3    ADD BIAS DIFFERENCE TO DEBUG ORIGIN
         SLL       R7,SHIFTA       COMPUTE BIAS CHANGE
         STW       R7,TSK.BIAS,X2  SAVE IN DQE
         TRN       R7,R7           NEGATE
         ADMW      R7,T.LAST,X3    ADD IN ENDING ADDRESS
         CAMW      R7,FIVE12       COMPARE WITH X'7FFFC'
         BLE       TRV4.RET        RETURN OK IF TASK WILL FIT
TRV4.ERR ADI       R0,2W           OOOPS, TASK STILL TO BIG !!
*                                  ABNORMAL RETURN
TRV4.RET TRSW      R0              NORMAL RETURN
*
FIVE12   DATAW     X'7FFFC'        LAST EXECUTABLE ADDRESS
*
OS15E    ANOP                                                   *238*
         IFF       C.MPXOUT,MO                                  *237*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     H.PTCH -- REMAP PROCESSOR -- S.TXPM.6 (BIAS TSA)
*---------------------------------------------------------------------
*
*  THIS ROUTINE WILL BIAS/UNBIAS ALL TSA ADDRESSES
*
*  ON INPUT:   R6 = 0, RE-BIAS ALL ADDRESSES (FOR T-XPM ENVIRONMENT)
*                 = 1, BIAS    ALL ADDRESSES (FOR MPX   ENVIRONMENT)
*              R2 = CONTEXT AREA ADDRESS
*
*  ON OUTPUT:  ALL TSA ADDRESSES ARE BIASED/BIASED
*
*  CALLED BY:  S.TXPM.2 AND S.TXPM.1
*
         BOUND     1W
S.TXPM.6 M.TSAD    R3              FETCH TSA ADDRESS            *237*
         LW        R4,ADR.MASK     20 BIT ADDRESS MASK
         LW        R7,TSK.BIAS,X2  FETCH BIAS DIFFERENCE
         CI        R6,0            BIAS OR RE-BIAS
         BNE       TRAV.6.1        BRANCH IF BIAS (FOR MPX ENVIRONMENT)
         SBM       TSK.TSAB,TSK.FLG1,X2   INDICATE TSA IS RE-BIASED
         BS        TXPM.6.L        LEAVE IF ALREADY RE-BIASED
         TRN       R7,R7           NEGATE
         LW        R5,T.LINBUF,X3  GET LINE BUFFER ADDRESS
         BZ        BB.ERR          NO BIAS REQUIRED
* HERE WE MUST SAVE LINBUF ADDRESS AND ALLOCATE BLOCKING BUFFER
* TO MOVE THE LINBUF INTO TO USER CAN REFERENCE LINE BUFFER IN
*  A TXPM TASK.
*  However, if user didn't request that we play with it, then we    !271
*  leave it alone.                                                  !271
         TBM       TSK.BTLB,TSK.FLG1,X2 Did user want this?         !271
         BNS       BB.ERR          Go if not                        !271
         LW        R1,TSK.LINE,X2  GET SAVED BB ADDRESS
         BNZ       TRAV.6.5        GOT ONE, SO JUST COPY CONTENT
         LNB       R6,T.BBUFN,X3   GET # BB'S
         BZ        BB.ERR          BR IF NONE TO ALLOCATE
         LW        R1,T.BBUFA,X3   GET FIRST BB ADDRESS
         BU        $+3W            SKIP OVER INITIAL CODE
         TBM       4,0W,X1         IS BB AVAILABLE
         BS        $+4W            BR IF AVAILABLE
         ADI       R1,192W         NEXT BB
         BIB       R6,$-3W         CHECK THEM ALL
         BU        BB.ERR          BR IF NONE THERE
         STW       R1,TSK.LINE,X2  SAVE BB ADDRESS IN CONTEXT AREA
         ZMD       0W,X1           CLEAN AND ALLOCATE IT
TRAV.6.5 STW       R5,1W,X1        SAVE OLD LINE BUFFER ADDRESS IN BB
         ADI       R1,1D           START LINBUF AT 2ND DW OF BB
         STW       R1,T.LINBUF,X3  PUT IN TSA
         ARMW      R7,T.LINBUF,X3  BIAS NEW LINE BUFFER ADDRESS
         ZBM       TSK.CMD,TSK.FLG2,X2  IS THERE A M.CMD IN PROGRESS
         BNS       TRAV.6.4        BR IF NOT
         LW        R3,TSK.REGP,X2  GET CURRENT REG POINTER
         LW        R6,7W,X3        GET USERS REG
         SUR       R5,R6           GET DELTA
         ADR       R1,R6           CALC NEW ADDRESS
         STW       R6,7W,X3        UPDATE USERS REG 7
         ARMW      R7,7W,X3        BIAS USERS REG
TRAV.6.4 TRR       R5,R3           GET OLD LINE BUFFER ADDRESS
         LB        R6,16B,X3       GET NUMBER OF WORDS IN LINBUF
         ADI       R6,1            PLUS 1W ROUNDING
         SRL       R6,1            MAKE DW COUNT
         TRN       R6,R6           USE AS LOOP COUNT
         LD        R4,0W,X3        GET LINE BUFFER DOUBLE WORD
         STD       R4,0W,X1        PUT IN BB
         ADI       R1,1D           NEXT BB LOCATION
         ADI       R3,1D           NEXT LINBUF LOC
         BIB       R6,$-4W         LOOP FOR ALL
         M.TSAD    R3              RESTORE TSA ADDRESS          *237*
         LW        R4,ADR.MASK     RELOAD 20 BIT MASK
BB.ERR   LNB       R5,T.FILES,X3   NUMBER OF FPT'S
         LW        R3,T.FPTA,X3    FPT POINTER
*
         BU        TRAV.6.2
TRAV.6.1 ZBM       TSK.TSAB,TSK.FLG1,X2   INDICATE TSA IS BIASED
         BNS       TXPM.6.L               LEAVE IF ALREADY BIASED
         LW        R5,T.LINBUF,X3  GET LINE BUFFER ADDRESS      *212*
         BZ        TRAV.6.3        NO RE-BIAS REQUIRED          *212*
         TBM       TSK.BTLB,TSK.FLG1,X2 Does user want this?        !271
         BNS       TRAV.6.3        Go if no                         !271
         LW        R1,TSK.LINE,X2  GET SAVED BLOCKING BUFF ADDR
         BZ        TRAV.6.3        BR IF NON
         LW        R5,1W,X1        GET OLD LINE BUFFER ADDRESS
         STW       R5,T.LINBUF,X3  REPLACE LINE BUFFER ADDRESS
TRAV.6.3 LNB       R5,T.FILES,X3   GET NUMBER OF FPT'S
         LW        R3,T.FPTA,X3    FETCH FPT POINTER
         ADR       R7,R3           BIAS FPT POINTER
*
*  FIRST, BIAS FILE POINTER TABLE ENTRIES
*
TRAV.6.2 LMW       R6,1W,X3        FETCH FCB ADDRESS
         BZ        $+2W            SKIP IF 0
         ARMW      R7,1W,X3        BIAS FCB ADDRESS
         LMW       R6,2W,X3        FETCH FATA ADDRESS
         BZ        $+2W            SKIP IF 0
         ARMW      R7,2W,X3        BIAS FATA ADDRESS
         ADI       R3,3W           POINT TO NEXT FPT
         BIB       R5,TRAV.6.2     GO BIAS NEXT FPT ENTRY
         M.TSAD    R3              RESTORE TSA ADDRESS          *237*
*----------------------------------BIAS ALL KNOWN TSA ADDRESSES
         ARMW      R7,T.BIAS,X3    DSECT START
         ARMW      R7,T.TEND,X3    TSA ENDING ADDRESS
         IFF       OS.15E,OS15X                                 *238*
         ARMW      R7,T.FSSP,X3    CURRENT PUSH DOWN LEVEL
         ARMW      R7,T.LAST,X3    LAST LOGICAL ADDRESS
OS15X    ANOP                                                   *238*
         ARMW      R7,T.FATA,X3    FILE ASSIGNMENT TABLE
         ARMW      R7,T.FPTA,X3    FILE POINTER TABLE
         ARMW      R7,T.END,X3     LAST DSECT LOCATION
         IFT       OS.34U03,I343   ONLY IN 34U03                *232*
         ARMW      R7,T.TSAEND,X3  BIAS END OF TSA ADDRESS      *232*
I343     ANOP                                                   *232*
         IFT       OS.35,I35       ONLY IN 35                   *232*
         ARMW      R7,T.TSAEND,X3  BIAS END OF TSA ADDRESS      *232*
*264          ARMW      R7,T.TSAOR,X3   BIAS TSA ORIGIN              *233*
         SRA       R7,SHIFTA       Address to map number            !264
         ARMH      R7,T.TSAOR      Bias TSA origin                  !264
         SLA       R7,SHIFTA       Back to an address               !264
I35      ANOP                                                   *232*
         ARMW      R7,T.TRAD,X3    TRANSFER ADDRESS OF MAIN SEGMENT
         IFT       OS.32X,NOMIDLA
         ARMW      R7,T.MIDLA,X3   MAP IMAGE DESCRIPTOR LIST
         ARMW      R7,T.MEMLA,X3   MEMORY ATTRIBUTE TABLE
NOMIDLA  ANOP
         ARMW      R7,T.REGP,X3    CURRENT PUSHDOWN ADDRESS
         IFF       OS.15E,OS15X                                 *238*
         ARMW      R7,T.BASEP,X3   FILE SYSTEM BUFFER ADDRESS
OS15X    ANOP                                                   *238*
         ARMW      R7,T.VATA,X3    VOLUME ASSIGNMENT TABLE ADDRESS
         IFF       OS.15E,OS15X                                 *238*
         ARMW      R7,T.SEGA,X3    SEGMENT DEFINITION AREA ADDRESS
OS15X    ANOP                                                   *238*
*----------------------------------BIAS ALL CONDITIONAL TSA ADDRESSES
         LMW       R6,T.CONTXT+8W,X3    DEBU CONTEXT PSW
         BZ        $+2W
         ARMW      R7,T.CONTXT+8W,X3    TASK DEBUGGER CONTEXT PSW
         IFF       OS.15E,OS15X                                 *238*
         LMW       R6,T.FIRST,X3
         BZ        $+2W
         ARMW      R7,T.FIRST,X3   FIRST LOGICAL ADDRESS
OS15X    ANOP                                                   *238*
         LMW       R6,T.DBHAT,X3
         BZ        $+2W
         ARMW      R7,T.DBHAT,X3   TASK DEBUGGER HAT
         IFF       OS.15E,OS15X                                 *238*
         LMW       R6,T.EXCPAD,X3
         BZ        $+2W
         ARMW      R7,T.EXCPAD,X3  ARITHEMETIC EXCP. HANDLER
OS15X    ANOP                                                   *238*
         LMW       R6,T.ABRTA,X3
         BZ        $+2W
         ARMW      R7,T.ABRTA,X3   ABORT RECEIVER ADDRESS
         LMW       R6,T.BBUFA,X3
         BZ        $+2W
         ARMW      R7,T.BBUFA,X3   BLOCKING BUFFER ADDRESS
         LMW       R6,T.BREAK,X3
         BZ        $+2W
         ARMW      R7,T.BREAK,X3   BREAK RECEIVER ADDRESS
         IFF       OS.15E,OS15X                                 *238*
         LMW       R6,T.SYCF,X3
         BZ        $+2W
         ARMW      R7,T.SYCF,X3    SYC DEDICATED FAT
         LMW       R6,T.SGOF,X3
         BZ        $+2W
         ARMW      R7,T.SGOF,X3    SGO DEDICATED FAT
         LMW       R6,T.SLOF,X3
         BZ        $+2W
         ARMW      R7,T.SLOF,X3    SLO DEDICATED FAT
         LMW       R6,T.SBOF,X3
         BZ        $+2W
         ARMW      R7,T.SBOF,X3    SBO DEDICATED FAT
OS15X    ANOP                                                   *238*
         LMW       R6,T.MSGR,X3
         BZ        $+2W
         ARMW      R7,T.MSGR,X3    MESSAGE RECEIVER ADDRESS
         LMW       R6,T.CURH,X3
         BZ        $+2W
         ARMW      R7,T.CURH,X3    CURRENT HIGH DSECT ADDRESS
         LMW       R6,T.CRHX,X3
         BZ        $+2W
         ARMW      R7,T.CRHX,X3    CURRENT HIGH EXTENDED ADDRESS
         IFT       OS.32X,NOIDXA
         LW        R6,T.IDXA,X3
         SLL       R6,8
         SRA       R6,8            ISOLATE OVERLAY TABLE ADDRESS
         BNP       $+2W
         ARMW      R7,T.IDXA,X3    OVERLAY TABLE ADDRESS
NOIDXA   ANOP
TXPM.6.L M.TSAD    R3              RESTORE TSA ADDRESS          *237*
         TRSW      R0
OS15E    ANOP                                                   *238*
MO       ANOP                                                   *237*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     H.PTCH -- REMAP PROCESSOR -- S.TXPM.8 (DQE CONTXT)
*
*  THIS ROUTINE INITIALIZES THE DQE CONTEXT AREA WITH INFORMATION
*  FROM WORD X'2C' IN THE LOAD MODULE PREAMBLE.
*
*  ON INPUT:  R2 = CHILD'S DQE ADDRESS
*
*  ON OUTPUT: 1. DQE CONTEXT AREA INITIALIZED (FOR THIS TASK)
*             2. REPLACED INSTRUCTION EXECUTED SUCH THAT...
*             3. R6 & R7 = PROJECT NAME.
*
*             DESTROYED: R0, R4, R5
*
*  CALLED BY:  H.TAMM, DURING ACTIVATION PROCESSING
*
S.TXPM.8 TRR       R0,R5           MOVE RETURN ADDRESS TO R5
         ZR        R0
         LB        R1,DQE.NUM,X2   FETCH DQE NUMBER
         MPI       R0,DQE.LCXT     FORM DQE CONTEXT AREA INDEX
         ADMW      R1,C.CTXT       ADD IN CONTEXT ORIGIN
         ZMD       TSK.NMAP,X1     CLEAR DQE CONTEXT ENTRY
         ZMD       TSK.DBHT,X1
         ZMD       TSK.LVL0,X1
         ZMD       TSK.LVL2,X1
         ZMD       TSK.LVL4,X1
         ZMD       TSK.RPSD,X1
         ZMD       TSK.REGP,X1
         ZMD       TSK.DQE,X1
         LA        R7,TSK.LVL0,X1  GET LEVEL ZERO ADDRESS
         STW       R7,TSK.LVLP,X1  STORE AS DEFAULT
         STW       R1,DQE.PSSF,X2  SAVE CONTEXT ADDRESS IN DQE
         ZMW       DQE.PSSB,X2     CLEAR BIAS VALUE
         ZMH       DQE.PSSB+2H,X2  CLEAR OTHER INFO WORD
         STW       R2,TSK.DQE,X1   SAVE DQE ADDRESS
         TRR       R1,R0           SAVE DQE CONTEXT ADDRESS
         IFT       C.3227,ACCL.2
         IFF       MPX.EVNT,SKIP.A SKIP CODE IF MPX EVENT SET
         IFF       C.MPXOUT,MO                                  *237*
*
*  ENABLE ACCELERATOR IF TXPM.ACC SET
*
         TBM       TXPM.ACC,EVNT.PTR  ENABLE ACCELERATOR?
         BNS       ACCL.1             BRANCH IF NOT
         SBM       RTC,TXPMFLGS       ACCELERATOR ENABLED?      *243*
         BS        ACCL.2             BRANCH IF ALREADY ENABLED
*
*  ENABLE ACCELERATOR
*
MO       ANOP                                                   *237*
SKIP.A   ANOP
PTCH.01  LW        R6,0            H.IPCL 'DAI' INSTRUCTION
         STW       R6,RTC.DAI      SAVE FOR H.TXPM HANDLING RTC INTRPTS
         STW       R6,RTC.DAI1     SAVE FOR MPX TASK ACCELERATOR
         IFF       MPX.EVNT,SKIP.A SKIP CODE IF MPX EVENT SET
         IFF       C.MPXOUT,MO                                  *237*
         SLL       R6,6            ISOLATE PRIORITY
         SRL       R6,25           RIGHT JUSTIFY
         SLL       R6,2            MAKE A WORD OFFSET
         LW        R1,C.INTVA      T-XPM INTERRUPT VECTOR TABLE
         ADR       R6,R1           POINT TO RTC ENTRY
         ADMW      R6,MPX.INT      INT.BASE = RTC SI LOCATION
         STW       R6,RTC.SI       SAVE RTC SI LOCATION
         LW        R1,,X1          T-XPM RTC ICB ADDRESS
         ORMW      R1,LPSD.13      BUILD RTC RETURN LPSD
         STW       R1,LPSD.13
*236*    CEA                                                    *236*
         ANMW      R1,=X'7FFFC'    MASK OFF LPSD INSTRUCTION        !250
         LW        R1,2W,X1        FETCH NEW PSW
         STW       R1,RTC.NPSW     SAVE (FOR DISABLE)
         LW        R6,B.TRV.12     FETCH BRANCH TO RTC HDLR
         STW       R6,3W,X1        REPLACE 'BU S.TRV.32'
*236*    SEA                                                    *236*
         LW        R1,RTC.SI       ADDRESS OF MPX RTC SI LOC
         LW        R6,,X1          FETCH MPX RTC SI VECTOR      *236*
         STW       R6,RTC.VECT     SAVE FOR DISABLE             *236*
         LA        R7,S.TRV.13     MPX TASK ACCELERATOR
         STW       R7,,X1          ENABLE ACCELERATOR FOR MPX TASKS
         TRR       R6,R1           GET MPX ICB ADDRESS          *236*
         LW        R7,3W,X1        GET NEW PSD WD2              *236*
         STW       R7,S.TRV.13+3W  PUT IN TXPM ICB              *236*
         BU        ACCL.2
*
*  NOW SEE IF WE NEED TO TURN ACCELERATORS OFF
*
ACCL.1   ZBM       RTC,TXPMFLGS    IS ACCELERATOR ON?           *243*
         BNS       ACCL.2          BRANCH IF ALREADY TURNED OFF
*
*  HERE, TURN ACCELATORS OFF
*
         LW        R1,RTC.SI
         LW        R7,RTC.VECT     FETCH ORIGINAL SI VECTOR
         STW       R7,,X1          TURN MPX ACCELERATOR OFF
*
         LW        R1,RTC.NPSW     FETCH NEW PSW ADR. FOR T-XPM ACCL
         LW        R7,B.TRV.32     FETCH ORIGINAL BRANCH
         STW       R7,3W,X1        DISABLE T-XPM ACCELERATOR
MO       ANOP                                                   *237*
SKIP.A   ANOP
*
*  CHECK FOR ONE SHOT INITIALIZATION
*
ACCL.2   SBM       ONE.INIT,TXPMFLGS RTC ICB SET UP (ONE-SHOT)? *243*
         BS        INIT.SET        BRANCH IF SET
*
*  SET UP T-XPM COPY OF C.TSAD
*
         IFT       OS.32X,JMP.IT
         IFF       C.MPXOUT,MO                                  *237*
*252          TBM       7,C.MACH        IS THIS A 32/67 OR 32/97?
         LB        R4,C.MACH       Get machine type                 !252
         BZ        IS.6797         Go if Seahawk                    !252
         TBR       R4,31                                            !252
         BNS       NOT.6797        NO, LEAVE C.HIMAP SET TO 255
IS.6797  LI        R4,X'7FF'       SET C.HIMAP TO 4095 FOR 67 & 97  !252
         STH       R4,C.HIMAP      UPDATE C.
*
*  INSURE AT LEAST 2 MAP BLOCKS ON A 67 & 97.  BECAUSE OF SOME
*  FIRMWARE LIMITATION (?), THE LPSDCM INSTRUCTION REQUIRES AT
*  LEAST 2 MAPS TO BE LOADED!
*  We'll treat Seahawk like a 67/97.                                !252
*
         LI        R4,2            MIN MAPS FOR 67/97
         STW       R4,MIN.MAPS     DEFAULT FOR 67/97 IS 2
         LW        R4,=X'FFFFFF'   24-BIT MASK
         STW       R4,ADR.MASK     UPDATE OUR MASK TO 24 BITS
NOT.6797 EQU       $
MO       ANOP                                                   *237*
JMP.IT   ANOP
         IFF       C.MPXOUT,MO                                  *237*
         M.TSAD    R4              GET TSA ADDR IN MPX ENVIR    *237*
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
         LW        R4,C.REGS       GET TSA ADDR IN MPX ENVIR    *237*
MO       ANOP                                                   *237*
         STW       R4,C.TXPM       SET FOR H.AID COMPATABILITY
         IFF       C.MPXOUT,MO                                  *237*
*232*    SBM       0,*C.MPL        SET O/S RETAIN BIT           *232*
         LW        R7,C.MPAC       GET CURRENT PATCH ADDRESS
         ZR        R6
         DVMW      R6,C.MGRAN      R7 = # OF OS MAPS REQUIRED
         TRR       R6,R6           ANY REMAINDER?
         BZ        $+2W            BRANCH IF NOT
         ADI       R7,1            ...ELSE BUMP BY 1 MAP BLOCK
         CAMW      R7,MIN.MAPS     SEE IF .GT. MIN.MAPS
         BLE       $+2W            MIN.MAPS O.K. IF .LE.
         STW       R7,MIN.MAPS     UPDATE MIN.MAPS
*                                                                *221*
************* START OF OPTIONAL MIN TSA CODE *********************221*
PATCH1   EQU       $               START OF OPT MIN TSA CODE     *221*
         GOTO      SKIP.MIN        REMOVE TO ENABLE CODE         *221*
         LW        R7,C.DTTA       GET END ADDRESS OF UDT'S      *221*
         ZR        R6                                            *221*
         DVMW      R6,C.MGRAN      R7 = # OF OS MAPS REQUIRED    *221*
         TRR       R6,R6           ANY REMAINDER?                *221*
         BZ        $+2W            BRANCH IF NOT                 *221*
         ADI       R7,1            ...ELSE BUMP BY 1 MAP BLOCK   *221*
         CAMW      R7,MIN.MAPS     SEE IF .GT. MIN.MAPS          *221*
         BLE       $+2W            MIN.MAPS O.K. IF .LE.         *221*
         STW       R7,MIN.MAPS     UPDATE MIN.MAPS               *221*
SKIP.MIN ANOP                                                    *221*
************* END OF OPTIONAL MIN TSA CODE ***********************221*
*                                                                *221*
MO       ANOP                                                   *237*
         LW        R1,C.SWAP       GET SWAPPERS DQE ADDRESS
         LW        R4,C.CTXT       GET OUT CONTEXT ADDRESS
         ADI       R4,DQE.LCXT     POINT TO SWAPPERS CONTEXT
         STW       R4,DQE.PSSF,X1  SET UP SWAPPERS DQE
         ZMW       DQE.PSSB,X1     CLEAN ICB ADDRESS LOCATION
         IFF       OS.32X,SW.01    IF 2.X APPLY SWAPPER PATCH
         IFT       C.3227,SW.00    IF 2X APPLY PATCH
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR         NEED ADDRESS OF SWAPPER
         LA        R1,J.SWAPR      GET SWAPPERS ADDRESS
         LW        R4,$+3W         GET REPLACEMENT INSTRUCTION
         STW       R4,X'1D04',X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         LI        R6,-256         SCAN 256 MAP REGS
SW.00    ANOP
         IFF       C.3227,SW.01    IF 7X APPLY PATCH
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR         NEED ADDRESS OF SWAPPER
         LA        R1,J.SWAPR      GET SWAPPERS ADDRESS
         LW        R4,$+3W         GET REPLACEMENT INSTRUCTION
         STW       R4,X'1940',X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         LI        R6,-32          SCAN 32 MAP REGS
SW.01    ANOP
         IFT       OS.32C,DO.EXT
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR
         LI        R1,X'220'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'00014000'     NEW PSD WD2
         LI        R1,X'228'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'80010000'     NEW PSD WD2
DO.EXT   ANOP                      3.2C(UCS+U03) AND 3.3 ONLY
         IFT       OS.U03,DO.EXT
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR
         LI        R1,X'220'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'00014000'     NEW PSD WD2
         LI        R1,X'228'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'80010000'     NEW PSD WD2
DO.EXT   ANOP                      3.2C(UCS+U03) AND 3.3 ONLY
         IFT       OS.UCS,DO.EXT
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR
         LI        R1,X'228'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'80010000'     NEW PSD WD2
DO.EXT   ANOP                      3.2C(UCS+U03) AND 3.3 ONLY
         IFT       OS.U02,DO.EXT
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR
         LI        R1,X'234'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'80010000'     NEW PSD WD2
DO.EXT   ANOP                      3.2C(UCS+U03) AND 3.3 ONLY
         IFT       OS.33,DO.EXT
*------------------------------------------------------------------
*
* H.SWAPR PATCHES
*
*------------------------------------------------------------------
         EXT       J.SWAPR
         LI        R1,X'234'-X'18' OFFSET IN SWAPR
         LW        R4,$+3W         GET REPLACEMENT CODE
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER
         BU        $+2W            SKIP OVER INSTRUCTION
         DATAW     X'80010000'     NEW PSD WD2
DO.EXT   ANOP                      3.2C(UCS+U03) AND 3.3 ONLY
         IFT       OS.34,DO.EXT                                    *210*
*------------------------------------------------------------------*210*
*                                                                  *210*
* H.SWAPR PATCHES                                                  *210*
*                                                                  *210*
*------------------------------------------------------------------*210*
         EXT       J.SWAPR                                         *210*
         LI        R1,X'234'-X'18' OFFSET IN SWAPR                 *210*
         LW        R4,$+3W         GET REPLACEMENT CODE            *210*
         STW       R4,J.SWAPR,X1   PUT IN SWAPPER                  *210*
         BU        $+2W            SKIP OVER INSTRUCTION           *210*
         DATAW     X'80010000'     NEW PSD WD2                     *210*
DO.EXT   ANOP                      3.2C(UCS+U03), 3.3 & 3.4 ONLY   *210*
*
*  DONE WITH T-XPM INITIALIZATION.  CHECK FOR T-XPM TASK.
*
INIT.SET TRR       R0,R1           RESTORE DQE CONTEXT ADDRESS
         TBM       NO.TXPM,EVNT.PTR  IS TXPM TO RUN AT ALL?
         BS        TRAV.8.J        BR IF NOT
         LB        R4,PR.NOMPX,X3  Get preamble word                !278
         IFT       OS.34U03,DO.BTLB                                 !278
*  Note that the following code is repeated (in the original,       !278
*  not in the extracted) for 3.4u03 and 3.5.  That's because        !278
*  COND2 doesn't understand combined expressions (e.g., using       !278
*  .OR.).                                                           !278
         ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !278
         TBR       R4,PR.BTLB+24   Does user want us to move        !278
*                                  T.LINBUF around?                 !278
         BNS       $+2W                                             !278
         SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !278
DO.BTLB  ANOP                                                       !278
         IFT       OS.35,DO.BTLB                                    !278
*  Note that the following code is repeated (in the original,       !278
*  not in the extracted) for 3.4u03 and 3.5.  That's because        !278
*  COND2 doesn't understand combined expressions (e.g., using       !278
*  .OR.).                                                           !278
         ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !278
         TBR       R4,PR.BTLB+24   Does user want us to move        !278
*                                  T.LINBUF around?                 !278
         BNS       $+2W                                             !278
         SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !278
DO.BTLB  ANOP                                                       !278
         LB        R7,PR.NMAP,X3   FETCH USER SPECIFIED TSA ORIGIN/1000
         BNZ       INT.0X          PROCESS IT IF SPECIFIED      *205*
         TBM       6,PR.FLAG,X3    IS THIS A BASE MODE TASK     *220*
         BS        TRAV.8.L        LEAVE KUZ BASE MODE NOT SUPP *220*
         TBM       3,PR.FLAG,X3    IS THIS AN ABS TASK          *205*
         BNS       TRAV.8.L        LEAVE IF NOT                 *205*
         LW        R7,PR.ORGD,X3   GET TASK ORIGIN              *205*
         ANMW      R7,=X'007FFFFF' CLEAR FLAGS                  *214*
         SUI       R7,4096W        LESS 4KW FOR TSA (GUESSED)   *205*
         CAMW      R7,C.TSAD       IS EST TSA LESS STD TSA      *205*
         BGT       TRAV.8.L        NO, CONTINUE                 *205*
         SBM       7,PR.NOMPX,X3   SET TXPM FLAG IN PREAMBLE    *205*
         SRL       R7,12           MAKE 1K'S                    *205*
         STB       R7,PR.NMAP,X3   SET IN PREAMBLE INFO         *205*
INT.0X   SLL       R7,12           * 1000 (HEX)                 *205*
         ZR        R6
         DVMW      R6,C.MGRAN      R7 = # OF OS MAPS USER WANTS
         TRR       R6,R6           ANY REMAINDER?
         BZ        $+2W            BRANCH IF NOT
         ADI       R7,1            ...ELSE BUMP BY 1 MAP BLOCK
         CAMB      R7,C.MSD        CLAMP AT # OF MPX MAP BLOCKS
         BLT       $+2W
         LB        R7,C.MSD
*278          LB        R4,PR.NOMPX,X3  FETCH 'NO-MPX' BYTE
*278          IFT       OS.34U03,DO.BTLB                                 !276
*278 *  Note that the following code is repeated (in the original,       !276
*278 *  not in the extracted) for 3.4u03 and 3.5.  That's because        !276
*278 *  COND2 doesn't understand combined expressions (e.g., using       !276
*278 *  .OR.).                                                           !276
*278          ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !276
*278          TBR       R4,PR.BTLB+24   Does user want us to move        !276
*278 *                                  T.LINBUF around?                 !276
*278          BNS       $+2W                                             !276
*278          SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !279
*278 DO.BTLB  ANOP                                                       !276
*278          IFT       OS.35,DO.BTLB                                    !276
*278 *  Note that the following code is repeated (in the original,       !276
*278 *  not in the extracted) for 3.4u03 and 3.5.  That's because        !276
*278 *  COND2 doesn't understand combined expressions (e.g., using       !276
*278 *  .OR.).                                                           !276
*278          ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !276
*278          TBR       R4,PR.BTLB+24   Does user want us to move        !276
*278 *                                  T.LINBUF around?                 !276
*278          BNS       $+2W                                             !276
*278          SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !279
*278 DO.BTLB  ANOP                                                       !276
*278          SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !276
         TBR       R4,31                = 1 MEANS 'NO-MPX' TASK
         BNS       TRAV.8.L        LEAVE IF NOT EQUAL TO 1
*276          IFT       OS.34U03,DO.BTLB                                 !271
*276 *  Note that the following code is repeated (in the original,       !271
*276 *  not in the extracted) for 3.4u03 and 3.5.  That's because        !271
*276 *  COND2 doesn't understand combined expressions (e.g., using       !271
*276 *  .OR.).                                                           !271
*276          ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !271
*276          TBR       R4,PR.BTLB+24   Does user want us to move        !271
*276 *                                  T.LINBUF around?                 !271
*276          BNS       $+2W                                             !271
*276 DO.BTLB  ANOP                                                       !271
*276          IFT       OS.35,DO.BTLB                                    !271
*276 *  Note that the following code is repeated (in the original,       !271
*276 *  not in the extracted) for 3.4u03 and 3.5.  That's because        !271
*276 *  COND2 doesn't understand combined expressions (e.g., using       !271
*276 *  .OR.).                                                           !271
*276          ZBM       TSK.BTLB,TSK.FLG1,X1 Initial value               !271
*276          TBR       R4,PR.BTLB+24   Does user want us to move        !271
*276 *                                  T.LINBUF around?                 !271
*276          BNS       $+2W                                             !271
*276 DO.BTLB  ANOP                                                       !271
*276          SBM       TSK.BTLB,TSK.FLG1,X1 Tell everyone               !271
         IFF       C.MPXOUT,MO                                  *237*
         CAMW      R7,MIN.MAPS     DOES USER WANT TSA < MIN.MAPS
         BGE       GT.ONE          BRANCH IF NOT
         LW        R7,MIN.MAPS     GET MINIMUM NUMBER OF O/S MAPS
MO       ANOP                                                   *237*
GT.ONE   STB       R7,TSK.NMAP,X1  SET # OF OS MAPS IN CONTEXT AREA
         SBM       TSK.TXPM,TSK.FLG1,X1  INDICATE TXPM TASK
         LB        R4,PR.PAGED,X3  GET DSECT PAGES
         CI        R4,X'FF'        CAT'ED BY E1 CATALOGER
         BNE       TRAV.8.L        BR IF NOT
         LB        R4,PR.NPAGE,X3  FETCH # OF DSECT PAGES
         BZ        TRAV.8.L        BRANCH IF 0
         STB       R4,PR.PAGED,X3  UPDATE PR.PAGED IN PREAMBLE
*
TRAV.8.L TBM       MPX.ONLY,EVNT.PTR  ARE MPX TASKS TO STAY MPX?
         BS        TRAV.8.J        BR IF YES
         ZBM       5,PR.NOMPX,X3   IS TASK TO BE MPX ONLY?
         BNS       $+2W            BR IF NOT
TRAV.8.J SBM       TSK.OMPX,TSK.FLG2,X1  SET RUN AS MPX ONLY BIT
         LW        R1,C.REGS       RESTORE R1
         IFT       C.MPXOUT,MO                                  *237*
         LCD       R6,T.PRJCT,X1   EXECUTE REPLACED INSTR       *237*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LD        R6,T.PRJCT,X1   EXECUTE REPLACED INSTR       *237*
MO       ANOP                                                   *237*
         TRSW      R5              ...AND RETURN
MIN.MAPS DATAW     1               MINIMUM NUMBER OF MAPS IN
OS15E    ANOP                                                   *238*
         IFF       C.MPXOUT,MO                                  *237*
         IFF       OS.15E,OS15E                                 *238*
         TITLE     H.TXPM -- REMAP PROCESSOR -- S.TRV.12 (RTC RETURN)
*
*---------------------------------------------------------------------
*
*  THIS ROUTINE WILL RETURN DIRECTLY TO A T-XPM TASK FROM A REAL TIME
*  CLOCK INTERRUPT.
*
*  CALLED BY:  T-XPM RTC ICB
*
         BOUND     1W
S.TRV.12 EQU       $
PTCH.02  LW        R2,0            IPCL.ITU
         CI        R2,-1           TIMER ABOUT TO EXPIRE
         BNE       TXPM.RTC        BRANCH IF NOT
         LW        R2,LPSD.13      FETCH OLD PSD ADDRESS
         BU        S.TRV.32        LET H.IPCL HANDLE THIS ONE
TXPM.RTC ABM       31,C.INTC       BUMP RTC INTERRUPT COUNT
PTCH.03  ABM       31,0            IPCL.ITU
RTC.DAI  DAI       0               SET BY S.TXPM.8
         LF        R0,CPUREGS      RESTORE USER'S REGISTERS
LPSD.13  LPSD      0               RETURN TO POINT OF INTERRUPT
*
B.TRV.12 BL        S.TRV.12
B.TRV.32 BL        S.TRV.32
RTC.NPSW REZ       1W              NEW PSW ADDRESS FOR TXPM RTC
RTC.SI   REZ       1W              MPX SI LOC FOR RTC
RTC.VECT REZ       1W              MPX SI VECTOR FOR RTC
A.TRV.13 ACW       S.TRV.13        ADDRESS OF TXPM CLOCK ICB
*
         BOUND     1D
S.TRV.13 EQU       $
         RES       2W              OLD PSD
         GEN       1/1,4/0,1/1,7/0,19/W(IPCL)
         GEN       1/1,14/0,1/1,16/0
IPCL     BEI
         STF       R0,CPUREGS      SAVE USER'S REGISTERS
PTCH.04  LW        R2,0            IPCL.ITU
         CI        R2,-1           TIMER ABOUT TO EXPIRE
         BEQ       TIME.EXP        BRANCH IF TIMER ABOUT TO EXPIRE
PTCH.05  ABM       31,0            IPCL.ITU
         ABM       31,C.INTC       BUMP RTC INTERRUPT COUNT
RTC.DAI1 DAI       0               SET BY S.TXPM.8
         LF        R0,CPUREGS      RESTORE USER'S REGISTERS
         LPSD      S.TRV.13        RETURN TO POINT OF INTERRUPT
*
*  HERE, MPX TASK INTERRUPTED & TIMER ABOUT TO EXPIRE
*
TIME.EXP ABM       31,C.GINT       BUMP GLOBAL INTERRUPT COUNT
         LD        R6,S.TRV.13     FETCH OLD PSD
PTCH.06  STD       R6,0            STUFF IN IPCL.OLD
         LF        R0,CPUREGS
         UEI                       HANDLER RUNS UNBLOCKED
PTCH.07  BU        0               BRANCH TO EP + 1W
OS15E    ANOP                                                   *238*
MO       ANOP                                                   *237*
         IFT       OS.15E,OS15E                                 *238*
*---------------------------------------------------------------*238*
*                                                               *238*
*        SVC 1,3 SVC CODING TO RESET TSA BIASING FOR USER       *238*
*                                                               *238*
         BOUND     1W                                           *238*
RST_TSA  EQU       $               RESET TSA BIASING FOR USER   *238*
         M.TSAD    R3              FETCH TSA ADDRESS            *238*
         LW        R1,T.PRNO,X3    GET HIS DQE ADDRESS          *238*
         LW        R2,DQE.PSSF,X1  GET TXPM CONTEXT ADDRESS     *238*
         ZBM       USR.TSAB,TSK.FLG1,X2  RESET TSA BIASING      *238*
         M.RTRN                    RETURN TO CALLER             *238*
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
*----------------------------------------------------------------------
*
*        SVC 1,3 SVC CODING TO RESET TSA BIASING FOR USER
*
         BOUND     1W
RST_TSA  EQU       $               RESET TSA BIASING FOR USER
         IFF       C.MPXOUT,MO                                  *237*
         M.TSAD    R3              FETCH TSA ADDRESS            *237*
         LW        R1,T.PRNO,X3    GET HIS DQE ADDRESS          *237*
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
         LW        R3,C.REGS       GET TSA ADDRESS              *237*
         LCW       R1,T.PRNO,X3    GET HIS DQE ADDRESS          *237*
MO       ANOP                                                   *237*
         LW        R2,DQE.PSSF,X1  GET TXPM CONTEXT ADDRESS
         ZBM       USR.TSAB,TSK.FLG1,X2  RESET TSA BIASING
         M.RTRN                    RETURN TO CALLER
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
         IFT       OS.32X,TRV.14X
         IFF       C.MPXOUT,MO                                  *237*
*                                                               *216*
*  THIS ROUTINE WILL TEST THE PARTITION START ADDRESS AGAINST   *216*
*  THE TXPM TASK ORIGIN INSTEAD OF AGAINST THE C.TSAD.          *216*
*                                                               *216*
*        ON ENTRY: R3=TSA ADDRESS                               *216*
*                  R4=STARTING MAP NUMBER OF PARTITION          *216*
S.TRV114 LW        R3,C.CURR       GET DQE ADDRESS              *216*
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR                 *216*
         ANMW      R0,=X'87FFFFFF' CLEAR RETURN CC'S            *216*
         IFT       OS.35,D35                                    *232*
         SRL       R4,11           MAKE ADDRESS MAPS            *232*
D35      ANOP                                                   *232*
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?            *216*
         BNS       TRV.114M        BRANCH IF NOT                *216*
         CAMB      R4,TSK.NMAP,X3  TXPM O/S SIZE                *216*
         BU        TRV.114C        MERGE CODE                   *216*
TRV.114M CAMB      R4,C.MSD        SEE IF IN O/S                *216*
TRV.114C BLE       TRV.114E        BR IF ERROR                  *216*
         SBR       R0,2            SET GT CC                    *216*
         BU        TRV.114L        GET OUT                      *216*
TRV.114E SBR       R0,3            SET EQ CC                    *216*
         SBR       R0,4            SET LT CC                    *216*
TRV.114L LW        R3,C.REGS       RESTORE TSA ADDRESS          *216*
         IFT       OS.35,D35                                    *232*
         SLL       R4,11           MAKE MAPS AN ADDREESS        *232*
D35      ANOP                                                   *232*
         TRSW      R0              RETURN PROPER CC'C           *216*
         IFF       OS.35,D35                                    *232*
*
*  THIS ROUTINE WILL DETERMINE THE MIDL ORIGIN (IN TSA) OF
*  A MEMORY PARTITION TO BE INCLUDED IN THE USER'S ADDRESS SPACE
*
         BOUND     1W                                           *232*
S.TRV.14 TRR       R2,R6           SAVE USER REG
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.14.5        BRANCH IF NOT
         SUMB      R4,TSK.NMAP,X2  - # OF T-XPM OS MAPS
         BU        TRV.14.L        NOW LEAVE
TRV.14.5 SUMB      R4,C.MSD        - # OF   MPX OS MAPS
TRV.14.L TRR       R6,R2           RESTORE USERS REG
         TRSW      R0              RETURN
D35      ANOP                                                   *232*
MO       ANOP                                                   *237*
TRV.14X  ANOP
         IFT       OS.35,D35                                    *232*
         IFF       C.MPXOUT,MO                                  *237*
*                                                               *232*
*  THIS ROUTINE WILL DETERMINE THE MIDL ORIGIN (IN TSA) OF      *232*
*  A MEMORY PARTITION TO BE INCLUDED IN THE USER'S ADDRESS SPACE*232*
*                                                               *232*
         BOUND     1W                                           *232*
S.TRV.A4 TRR       R2,R6                                        *232*
         LW        R2,C.CURR       DQE ADDRESS                  *232*
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS          *232*
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?            *232*
         BNS       TRV.A4.S        BRANCH IF NOT                *232*
TRV.A4.C LB        R3,TSK.NMAP,X2  - # OF T-XPM OS MAPS         *232!263
         BU        TRV.A4.L        LEAVE                        *232*
*263 TRV.A4.S LH        R3,T.ATBIAS,X3  GET NORMAL TSA BIAS          *240*
TRV.A4.S RES       1W              Replaced instruction             !263
TRV.A4.L TRR       R6,R2           RESTORE USERS REG    `       *232*
*263          TRSW      R0              RETURN                       *232*
TRV.A4.R BU        0               Return                           !263
MO       ANOP                                                   *237*
D35      ANOP                                                   *232*
         IFF       OS.32X,TRV14AX
*
*  THIS ROUTINE WILL DETERMINE THE MIDL ORIGIN (IN TSA) OF
*  A MEMORY PARTITION TO BE INCLUDED IN THE USER'S ADDRESS SPACE
*  THIS VERSION IS FOR 2.X SYSTEMS
         BOUND     1W
S.TRV14A TRR       R2,R6           SAVE USER REG
         LW        R1,C.CURR       DQE ADDRESS
         LW        R1,DQE.PSSF,X1  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  T-XPM TASK?
         BNS       TRV14A.5        BRANCH IF NOT
         SUMB      R4,TSK.NMAP,X1  - # OF T-XPM OS MAPS
         BU        TRV14A.L        NOW LEAVE
TRV14A.5 SUMB      R4,C.MSD        - # OF   MPX OS MAPS
TRV14A.L TRSW      R0              RETURN
*
TRV14AX  ANOP
         IFF       OS.32X,TRV15X
*
*  THIS ROUTINE WILL UNBIAS A CSECT ORIGIN BEFORE BUILDING A SMT
*  ENTRY.  CALLED FROM MEMM.7
*  R2=DQE ADDRESS, R6=CSECT ORIGIN
*
TRV.15.1 LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  TXPM TASK?
         BNS       TRV15.1L        EXIT IF NOT
         ADMB      R6,TSK.NMAPS,X2 ADD IN TXPM O/S SIZE
         SUMB      R6,C.MSD        LESS MPX O/S SIZE
TRV15.1L STB       R6,SMT.MAPS,X1  STORE MAP START
         LW        R2,C.CURR       RESTORE DQE ADDRESS
         TRSW      R0              RETURN
*
TRV15X   ANOP
         IFF       C.MPXOUT,MO                                  *237*
*
*  THIS ROUTINE WILL ADJUST THE SHARED PARTITION ORIGIN IN
*  THE MIDL (TSA) TO REFLECT THE T-XPM BIAS DIFFERENCE
*
*        ON ENTRY: R3=TSA ADDRESS
*                  R4=RESULTS REG FOR RETURN
S.TRV.15 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
TRV.15.P LH        R4,SMT.MAPS,X1  LOAD START MAP NUMBER OF PARTITION
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.15.L        BRANCH IF NOT
         ADMB      R4,C.MSD        ADD O/S SIZE
         SUMB      R4,TSK.NMAP,X3  LESS TXPM O/S SIZE
TRV.15.L LW        R3,C.REGS       RESTORE TSA ADDRESS
         TRR       R4,R4           SEE IF GENERATED MAP ...         !270
         BNN       $+3H            IS NEGATIVE                      !270
         ZR        R4              IF SO, RETURN 0                  !270
*                                  (THIS FORCES RM16)               !270
         TRSW      R0              RETURN
         IFT       OS.35,D35                                    *232*
*                                                               *232*
*  THIS ROUTINE WILL ADJUST THE SHARED PARTITION ORIGIN IN      *232*
*  THE MIDL (TSA) TO REFLECT THE T-XPM BIAS DIFFERENCE          *232*
*                                                               *232*
*        ON ENTRY: R3=TSA ADDRESS                               *232*
*                  R4=STARTING MAP NUMBER TO BIAS               *232*
S.TRV.A5 LW        R3,C.CURR       GET DQE ADDRESS              *232*
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR                 *232*
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?            *232*
         BNS       TRV.A5.L        BRANCH IF NOT                *232*
         ADMB      R4,C.MSD        ADD O/S SIZE                 *232!263
         SUMB      R4,TSK.NMAP,X3  LESS TXPM O/S SIZE           *232*
TRV.A5.L LW        R3,C.REGS       RESTORE TSA ADDRESS          *232*
         TRR       R4,R4           SEE IF GENERATED MAP ...         !270
         BNN       TRV.A5.P        IS NEGATIVE                      !270
         LI        R4,0            IF SO, RETURN 0                  !270
*                                  (THIS FORCES RM16)               !270
TRV.A5.P RES       1W              Replaced instruction             !263
*263          TRSW      R0              RETURN                       *232*
TRV.A5.R BU        0               Return                           !263
D35      ANOP                                                   *232*
MO       ANOP                                                   *237*
         IFF       OS.32X,TRV.15E
*
*  THIS ROUTINE WILL ADJUST THE SHARED PARTITION ORIGIN IN
*  THE MIDL (TSA) TO REFLECT THE T-XPM BIAS DIFFERENCE
*
*        ON ENTRY: R3=TSA ADDRESS
*                  R2=RESULTS REG FOR RETURN
TRV.15.2 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
         LB        R2,SMT.MAPS,X1  LOAD START MAP NUMBER OF PARTITION
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       T.15.2.L        BRANCH IF NOT
         ADMB      R2,C.MSD        ADD O/S SIZE
         SUMB      R2,TSK.NMAP,X3  LESS TXPM O/S SIZE
T.15.2.L LW        R3,C.REGS       RESTORE TSA ADDRESS
         TRSW      R0              RETURN
*
*  THIS ROUTINE WILL ADJUST THE SHARED PARTITION ORIGIN IN
*  THE MIDL (TSA) TO REFLECT THE T-XPM BIAS DIFFERENCE
*
*        ON ENTRY: R3=TSA ADDRESS
*                  R6=RESULTS REG FOR RETURN
TRV.15.6 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
         LB        R6,SMT.MAPS,X1  LOAD START MAP NUMBER OF PARTITION
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       T.15.6.L        BRANCH IF NOT
         ADMB      R6,C.MSD        ADD O/S SIZE
         SUMB      R6,TSK.NMAP,X3  LESS TXPM O/S SIZE
T.15.6.L LW        R3,C.REGS       RESTORE TSA ADDRESS
         TRSW      R0              RETURN
*
*  THIS ROUTINE WILL ADJUST THE SHARED PARTITION ORIGIN IN
*  THE MIDL (TSA) TO REFLECT THE T-XPM BIAS DIFFERENCE
*
*        ON ENTRY: R3=TSA ADDRESS
*                  R5=RESULTS REG FOR RETURN
TRV.15.5 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
         LB        R5,SMT.MAPS,X1  LOAD START MAP NUMBER OF PARTITION
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       T.15.5.L        BRANCH IF NOT
         ADMB      R5,C.MSD        ADD O/S SIZE
         SUMB      R5,TSK.NMAP,X3  LESS TXPM O/S SIZE
T.15.5.L LW        R3,C.REGS       RESTORE TSA ADDRESS
         TRSW      R0              RETURN
TRV.15E  ANOP
         IFT       C.3227,TRV15A.Z
         IFF       OS.32X,TRV15A.Z
*
* THIS DOES THE SAVE AS S.TRV.15 BUT DOES NOT DESTROY R0
* (ONLY CALLED BY 2.X CONCEPT VERSION)
*
S.TRV15A LW        R3,C.CURR       DQE ADDR
         LW        R3,DQE.PSSF,X3  CONTEXT ADDRESS
         LB        R2,SMT.MAPS,X1
         TBM       TSK.TXPM,TSK.FLG1,X3
         BNS       TRV15A.L        NOT A TXPM TASK
         ADMB      R2,C.MSD        ADD O/S SIZE
         SUMB      R2,TSK.NMAP,X3  LESS TXPM O/S SIZE
TRV15A.L LW        R3,C.REGS       RESTORE TSA ADDRESS
TRV15A.R RES       1W              PLACE RETURN BRANCH HERE
TRV15A.Z ANOP
*
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
         IFF       OS.32B,T.17.IN
         IFF       OS.32C,T.17.IN  NOT IN 3.2C
         IFF       OS.UCS,T.17.IN  NOT IN 3.2C UCS VERSION
         IFF       OS.U03,T.17.IN  NOT IN 3.2C U03 VERSION
         IFF       OS.23,T.17.IN   NOT IN 2.3
         IFF       OS.24,T.17.IN   NOT IN 2.4
         IFF       OS.33,T.17.IN   NOT IN 3.3
         IFF       OS.U02,T.17.IN  NOT IN 3.3 U02 VERSION
         IFF       OS.34,T.17.IN   NOT IN 3.4                   *210*
         IFF       OS.34U01,T.17.IN  NOT IN 3.4 U01 VERSION     *232*
         IFF       OS.34U02,T.17.IN  NOT IN 3.4 U02 VERSION     *228*
         IFF       OS.34U03,T.17.IN  NOT IN 34U03               *232*
         IFF       OS.35,T.17.IN   NOT IN 35                    *232*
         IFF       OS.36,T.17.IN   NOT IN 36                    !284
*
*  ROUTINE TO MASK REG 2 WITH 20 BIT ADDRESS CURRENT TASK IS
*  A T-XPM TASK; ELSE USE 19 BIT ADDRESS
*
* R6 = AVAILABLE
* R0 = AVAILABLE
*
         BOUND     1W
S.TRV.17 TRR       R2,R6           SAVE USER'S REG 2
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X2  TXPM TASK?
         BNS       TRV.17.N        BR IF NOT
         ANMW      R6,ADR.MASK     20-BIT MASK FOR TXPM
         BU        TRV.17.L        RETURN TO CALLER
TRV.17.N ANMW      R6,=X'7FFFF'    19-BIT MASK FOR MPX TASK
TRV.17.L TRR       R6,R2           RESTORE USER'S R2
         TRSW      R0              RETURN TO CALLER
*
T.17.IN  ANOP
         IFF       C.MPXOUT,MO                                  *237*
*
*        MASK ADDRESS IN R1 WITH 20BIT (TXPM) OR 19BIT (MPX)
*
* R7 = AVAILABLE
* R0 = AVAILABLE
*
         BOUND     1W
S.TRV.18 TRR       R2,R7           SAVE USERS R2
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.18.M
         ANMW      R1,ADR.MASK     20 BIT MASK FOR TXPM
         BU        TRV.18.L        GO EXIT
TRV.18.M ANMW      R1,=X'7FFFF'    19 BIT FOR MPX TASKS
TRV.18.L TRR       R7,R2           RESTORE USERS R2
         TRSW      R0              EXIT
*
*        MASK ADDRESS IN R6 WITH 20BIT (TXPM) OR 19BIT (MPX)
*
* R7 = AVAILABLE
* R0 = AVAILABLE
*
         BOUND     1W
S.TRV.19 TRR       R2,R7           SAVE USERS R2
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.19.M
         ANMW      R6,ADR.MASK     20 BIT MASK FOR TXPM
         BU        TRV.19.L        GO EXIT
TRV.19.M ANMW      R6,=X'7FFFF'    19 BIT FOR MPX TASKS
TRV.19.L TRR       R7,R2           RESTORE USERS R2
         TRSW      R0              EXIT
*
*        MASK ADDRESS IN R7 WITH 20BIT (TXPM) OR 19BIT (MPX)
*
* R6 = AVAILABLE
* R0 = AVAILABLE
*
         BOUND     1W
S.TRV.20 TRR       R2,R6           SAVE USERS R2
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.20.M
         ANMW      R7,ADR.MASK     20 BIT MASK FOR TXPM
         BU        TRV.20.L        GO EXIT
TRV.20.M ANMW      R7,=X'7FFFF'    19 BIT FOR MPX TASKS
TRV.20.L TRR       R6,R2           RESTORE USERS R2
         TRSW      R0              EXIT
*
MO       ANOP                                                   *237*
         IFF       OS.32B,T.21.X
         IFF       OS.32C,T.21.X   NOT IN 3.2C
         IFF       OS.UCS,T.21.X   NOT IN 3.2C UCS VERSION
         IFF       OS.U03,T.21.X   NOT IN 3.2C U03 VERSION
         IFF       OS.23,T.21.X    NOT IN 2.3
         IFF       OS.24,T.21.X    NOT IN 2.4
         IFF       OS.33,T.21.X    NOT IN 3.3
         IFF       OS.U02,T.21.X   NOT IN 3.3 U02 VERSION
         IFF       OS.34,T.21.X    NOT IN 3.4                      *210*
         IFF       OS.34U01,T.21.X NOT IN 3.4 U01                  *232*
         IFF       OS.34U02,T.21.X NOT IN 3.4 U02                  *228*
         IFF       OS.34U03,T.21.X NOT IN 3.4 U03                  *232*
         IFF       OS.35,T.21.X    NOT IN 3.5                      *232*
         IFF       OS.36,T.21.X    NOT IN 3.6                      !284
*
*  ROUTINE TO LOAD A 19 BIT MASK IN R4 FOR MPX TASKS & 20 BIT MASK
*  FOR T-XPM TASKS
*
* R4 = AVAILABLE
* R0 = AVAILABLE
*
         BOUND     1W
S.TRV.21 TRR       R2,R4           SAVE USERS R2
         LW        R2,C.CURR       GET DQE ADDR
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.21.L        BRANCH IF NOT
         LW        R2,ADR.MASK     20 BIT MASK FOR R4
         BU        $+2W            SKIP OVER 19 BIT LOAD
TRV.21.L LW        R2,=X'7FFFF'    FETCH 19 BIT MASK
         XCR       R2,R4           RESTORE USER R2 AND SET MASK IN R4
         TRSW      R0
T.21.X   ANOP
         IFF       C.3227,TRV.31.E
*
*  ADJUST # OF OS MAPS WHEN CREATING A 32/7X PROTECTION IMAGE
*        R2 = UNUSED
*        R7 = # O/S MAPS
*
         BOUND     1W
S.TRV.22 LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.22.5        BRANCH IF NOT
         ADMB      R7,TSK.NMAP,X2  + # OF T-XPM OS MAPS
         BU        TRV.22P         NOW LEAVE
TRV.22.5 ADMB      R7,C.MSD        + # OF   MPX OS MAPS
TRV.22P  BU        0               RETURN
*
*  ADJUST TSA ORIGIN WHEN CREATING A 32/7X PROTECTION IMAGE
*        R2 = TXPM CONTEXT ADDRESS FROM S.TRV.22 CALL
*        R3 = TSA ADDRESS
*        R6 = END OF TSA ADDRESS
*
         BOUND     1W
S.TRV.23 LW        R6,T.TEND,X3    FETCH REGULAR TSA ORIGIN
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.23P         BRANCH IF NOT
         SUMW      R6,TSK.BIAS,X2  ADJUST TSA END BY BIAS DIFFERENCE
TRV.23P  BU        0               RETURN
*
*  ADJUST BUFFER ADDRESS FOR 32/7X PROTECTION IMAGE BUFFER VALIDATION
*        R2 = AVAILABLE
*        R1&R4 = BUFFER ADDRESSES TO BIAS IF TXPM TASK
*
         BOUND     1W
S.TRV.24 LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET TXPM CONTEXT AREA ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.24.L        BRANCH IF NOT
         SUMW      R4,TSK.BIAS,X2  ADJUST BUFFER START BY BIAS DIFF.
         SUMW      R1,TSK.BIAS,X2  ADJUST BUFFER END   BY BIAS DIFF.
TRV.24.L SRL       R4,11           EXECUTE REPLACED INSTRUCTIONS
         SRL       R1,11           ...
TRV.24P  BU        0               RETURN
*
*  ADJUST # OF OS MAPS WHEN CREATING A 32/7X PROTECTION IMAGE
*        R3 = C.REGS
*        R4 = RETURN VALUE
*
         BOUND     1W
S.TRV.25 LW        R3,C.CURR       DQE ADDR
         LW        R3,DQE.PSSF,X3  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.25.5        BRANCH IF NOT
         LB        R4,TSK.NMAP,X3  # OF T-XPM OS MAPS
         BU        TRV.25.L        NOW LEAVE
TRV.25.5 LB        R4,C.MSD        # OF   MPX OS MAPS
TRV.25.L LW        R3,C.REGS       RESTORE R3
TRV.25P  BU        0               RETURN
*
*  ADJUST BUFFER ADDRESS FOR 32/7X PROTECTION IMAGE BUFFER VALIDATION
*        R3 = C.REGS
*        R2 = ADJUSTED BUFFER ADDRESS
*
         BOUND     1W
S.TRV.26 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  GET TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.26.L        BRANCH IF NOT
         SUMW      R2,TSK.BIAS,X3  ADJUST BUFFER START BY BIAS DIFF.
TRV.26.L ADR       R2,R1           ADR R2,R1 (FORM ENDING ADDRESS)
         SRL       R2,SHIFTA       START MAP BLOCK NUMBER
         LW        R3,C.REGS       RESTORE R3                   *208*
TRV.26P  BU        0               RETURN
*
*  ADJUST RELATIVE MAP NUMBER FOR UPDATE OF PROTECTION IMAGE
*        R2 = C.REGS
*        R6&R7 = AVAILABLE
*        R1 = REL MAP NUM ON EXIT
*        R3 = REL MAP NUM ON ENTRY
*
         BOUND     1W
S.TRV.27 LW        R2,C.CURR       DQE ADDRESS
         TRR       R3,R1           MAP NUM TO WORK REG
         LW        R2,DQE.PSSF,X2  TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.27.L        BRANCH IF NOT
         CAMB      R1,TSK.NMAP,X2  REL MAP < T-XPM TSA ADDRESS?
         BLT       TRV.27.L        IS SO, NO ADJUSTMENT NECESSARY
         SUMB      R1,C.MSD        REGAIN RELATIVE MAP NUMBER
         ADMB      R1,TSK.NMAP,X2  ADJUST RELATIVE MAP NUMBER
TRV.27.L SLL       R1,1            MAKE HALFWORD INDEX
         LW        R2,C.REGS       RESTORE TSA ADDRESS
TRV.27P  BU        0               RETURN
*
*  ADJUST RELATIVE MAP NUMBER FOR UPDATE OF PROTECTION IMAGE
*        R2 = C.REGS
*        R6&R7 = AVAILABLE
*        R1 = REL MAP NUM ON EXIT
*        R3 = REL MAP NUM ON ENTRY
*
         BOUND     1W
S.TRV.28 LW        R2,C.CURR       DQE ADDRESS
         TRR       R3,R1           MAP NUM TO WORK REG
         LW        R2,DQE.PSSF,X2  TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.28.L        BRANCH IF NOT
         CAMB      R1,TSK.NMAP,X2  REL MAP < T-XPM TSA ADDRESS?
         BLT       TRV.28.L        IS SO, NO ADJUSTMENT NECESSARY *208*
         SUMB      R1,C.MSD        REGAIN RELATIVE MAP NUMBER
         ADMB      R1,TSK.NMAP,X2  ADJUST RELATIVE MAP NUMBER
TRV.28.L SLL       R1,1            MAKE HALFWORD INDEX
         LW        R2,C.REGS       RESTORE TSA ADDRESS
TRV.28P  BU        0               RETURN
*
*  ADJUST # OF OS MAPS WHEN EXCLUDING A 32/7X PARTITION
*        R3 = TSA ADDRESS
*        R2 = ADJUSTED O/S SIZE
*
         BOUND     1W
S.TRV.29 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.29.5        BRANCH IF NOT
         ADMB      R2,TSK.NMAP,X3  + # OF T-XPM OS MAPS
         BU        TRV.29.L        NOW LEAVE
TRV.29.5 ADMB      R2,C.MSD        + # OF   MPX OS MAPS
TRV.29.L LW        R3,C.REGS       RESTORE TSA ADDRESS
TRV.29P  BU        0               RETURN
*
*  ADJUST # OF OS MAPS WHEN UNPROTECTING PAGE 0 OF DEBUGGER
*        R3 = TSA ADDRESS
*        R6 = ADJUSTED O/S SIZE
*
         BOUND     1W
S.TRV.30 LW        R3,C.CURR
         LW        R3,DQE.PSSF,X3  TXPM CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.30.5        BRANCH IF NOT
         ADMB      R6,TSK.NMAP,X3  + # OF T-XPM OS MAPS
         BU        TRV.30.L        NOW LEAVE
TRV.30.5 ADMB      R6,C.MSD        + # OF   MPX OS MAPS
TRV.30.L LW        R3,C.REGS       RESTORE TSA ADDRESS
TRV.30P  BU        0               RETURN
TRV.31.E ANOP
*
         IFF       OS.32X,TRV.33.E  THIS IS FOR 2.X ONLY
*
*  THIS ROUTINE CAUSES S.EXEC21 PROCESSING TO BE HANDLED FOR 2.X
*  JUST LIKE IT IS FOR 3.X ON DISPATCHES TO BREAK RECEIVERS.
*        R2 = DQE ADDRESS
*        R3 AND R6 AVAILABLE
*
         BOUND     1W
S.TRV.33 LW        R3,C.REGS       GET TSA ADDRESS
         LW        R6,T.BREAK,X3   DOES USER HAVE BREAK RECEIVER
TRV.33BK BNZ       0               GO DISPATCH TO SX21.41 IF YES
TRV.33RI NOP                       REPLACED INSTRUCTION
TRV.33RT BU        0               RETURN TO EXEC.21
*
TRV.33.E ANOP
         IFF       C.MPXOUT,MO                                  *237*
*
*-----------------------------------------------------------------------
*
*  CHECK FOR OVERRUN OF CONFIGURED MAPS
*  CALLED FROM S.EXEC20 BEFORE LPSDCM
*
S.TRV.39 LW        R1,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X1  CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV39RPL        BRANCH IF NOT
         LB        R3,DQE.TAN,X1   GET TASK NUMBER
         IFT       C.3227,TRV39X
         SLL       R3,3            GET MPL OFFSET - 3X
TRV39X   ANOP
         IFF       C.3227,TRV39X
         SLL       R3,2            GET MPL OFFSET - 7X
TRV39X   ANOP
         ADMW      R3,C.MPL        CALC MPL ENTRY ADDR
         IFT       C.3227,TRV39X
         LH        R4,1H,X3        GET # OF USER MAPS
TRV39X   ANOP
         IFF       C.3227,TRV39X
         LB        R4,*0W,X3       GET # OF USER MAPS
TRV39X   ANOP
         LH        R5,C.HIMAP      FETCH # OF CONFIGURED MAPS
         ADI       R5,1            C.HIMAP NUMBERED FROM 0
         SUMB      R5,C.MSD        LESS SIZE OF O/S
         CAR       R5,R4           TOO MANY MAPS SPECIFIED
         BLT       TRV39RPL        BRANCH IF # NOT EXCEEDED
         IFT       C.3227,TRV39X
         STH       R5,1H,X3        CLAMP MAX COUNT
TRV39X   ANOP
         IFF       C.3227,TRV39X
         STB       R5,*0W,X3       CLAMP MAX COUNT
TRV39X   ANOP
TRV39RPL LPSDCM    *-*             REPLACED INSTRUCTION
*
*-----------------------------------------------------------------------
*
*  THIS ROUTINE IS AN EXCURSION FROM S.IOCS30 WHO INITIALIZES AN
*  FCB.  HERE, WE RESET BITS 0-3 OF FCB.SPST INSTEAD OF ZEROING
*  THE WHOLE BYTE SINCE H.TXPM USES BITS 4-7 OF FCB.SPST & THEY
*  MAY ALREADY BE SET.
*
         BOUND     1W
S.TRV.40 ZBM       0,FCB.SPST,X1
         ZBM       1,FCB.SPST,X1
         ZBM       2,FCB.SPST,X1
         ZBM       3,FCB.SPST,X1
TRV.40.L BU        0               RETURN TO S.IOCS.30
*
*-----------------------------------------------------------------------
*
*  CHECK FOR OVERRUN OF CONFIGURED MAPS
*  CALLED FROM S.MEMM5 AND S.MEMM19 DURING MEMORY ALLOCATION
*  AND DEALLOCATION
*
S.TRV.41 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV41RPL        BRANCH IF NOT
         ZBM       TSK.MORN,TSK.FLG2,X3   CLEAR MAP OVERRUN IND.
         ZMB       TSK.NORM,X3     CLEAR # OF OVERRUN MAPS
         ADMB      R4,C.MSD        TOTAL # OF MAPS IN WITH MPX MAPPED IN
         LH        R3,C.HIMAP      FETCH # OF CONFIGURED MAPS
         ADI       R3,1            C.HIMAP NUMBERED FROM 0
         SUR       R4,R3
         BGE       TRV.41.M        BRANCH IF # CONFIGURED NOT EXCEEDED
         TRN       R3,R4           POSITIVE # OF OVERRUN MAPS
         LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDR
         STB       R4,TSK.NORM,X3  SAVE # OF OVERRUN MAPS
         SBM       TSK.MORN,TSK.FLG2,X3   INDICATE MAP OVERRUN
         LW        R3,C.CURR
         LH        R4,C.HIMAP      CLAMP AT MAX CONFIGURED
         ADI       R4,1            C.HIMAP NUMBERED FROM 0
TRV.41.M SUMB      R4,C.MSD        ... - NUMBER OF MPX MAPS
TRV41RPL RES       1W              EXECUTE REPLACED INSTRUCTION
         LW        R3,C.REGS       RESTORE USER R3
         IFT       C.3227,TRV41RP2
         LW        R2,T.PRNO,X3    RESTORE DQE ADDRESS
TRV41RP2 ANOP
         TRSW      R0              RETURN TO MPX
*
MO       ANOP                                                   *237*
         IFF       OS.32X,T.43.X
*
*  ROUTINE TO ADJUST C.MSD FOR GETTING EXTENDED MEMORY
*
*        R2 = REG TO ADJUST
*        R3 = C.REGS
*
S.TRV.42 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.42.5        BRANCH IF NOT
         SUMB      R2,TSK.NMAP,X3  - # OF T-XPM OS MAPS
         BU        TRV.42.L        NOW LEAVE
TRV.42.5 SUMB      R2,C.MSD        - # OF   MPX OS MAPS
TRV.42.L LW        R3,C.REGS       RESTORE TSA ADDRESS
         TRSW      R0              RETURN
*
*  ROUTINE TO ADJUST C.MSD FOR GETTING EXTENDED MEMORY
*
*        R2 = REG TO ADJUST
*        R3 = C.REGS
*
S.TRV.43 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.43.5        BRANCH IF NOT
         SUMB      R2,TSK.NMAP,X3  - # OF T-XPM OS MAPS
         BU        TRV.43.L        NOW LEAVE
TRV.43.5 SUMB      R2,C.MSD        - # OF   MPX OS MAPS
TRV.43.L LW        R3,C.REGS       RESTORE TSA ADDRESS
TRV43RET BU        0               RETURN
T.43.X   ANOP
         IFF       OS.35,D35                                    *232*
*
*  ROUTINE TO ADJUST C.MSD FOR S.MEMM20 - CHECK NEW TASK SIZE
*
S.TRV.44 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.44.5        BRANCH IF NOT
         ADMB      R4,TSK.NMAP,X3  - # OF T-XPM OS MAPS
         BU        TRV.44.L        NOW LEAVE
TRV.44.5 ADMB      R4,C.MSD        - # OF   MPX OS MAPS
TRV.44.L LW        R3,C.REGS       RESTORE USER R3
TRV44RET BU        0               RETURN
*
*  ROUTINE TO ADJUST C.MSD FOR H.MEMM,7 - DYNAMIC PARTITION START CALC
*
S.TRV.45 TRR       R2,R5           SAVE R2 IN R5
         LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.45.5        BRANCH IF NOT
         ADMB      R3,TSK.NMAP,X2  - # OF T-XPM OS MAPS
         BU        TRV.45.L        NOW LEAVE
TRV.45.5 ADMB      R3,C.MSD        - # OF   MPX OS MAPS
TRV.45.L TRR       R5,R2           RESTORE USER'S R2
         LW        R5,SMT.IND,X1   RESTORE USER R5 (DESTROYED IN QSHUT)
TRV45RET RES       1W              RETURN
D35      ANOP                                                   *232*
         IFT       OS.35,D35                                    *232*
         IFF       C.MPXOUT,MO                                  *237*
*                                                               *232*
*  ROUTINE TO ADJUST C.MSD FOR S.MEMM20 - CHECK NEW TASK SIZE   *232*
*                                                               *232*
S.TRV.B4 LW        R3,C.CURR       GET DQE ADDRESS              *232*
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS          *232*
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?            *232*
         BNS       TRV.B4.5        BRANCH IF NOT                *232*
         LB        R3,TSK.NMAP,X3  - # OF T-XPM OS MAPS         *232*
         BU        TRVB4RET        NOW LEAVE                    *232*
TRV.B4.5 LB        R3,C.MSD        - # OF   MPX OS MAPS         *232*
TRVB4RET BU        0               RETURN                       *232*
*                                                               *232*
*  ROUTINE TO ADJUST C.MSD FOR H.MEMM,7 - DYNAM PRT START CALC  *232*
*                                                               *232*
*  INPUT   R2 = TSA ADDRESS                                     *232*
*  OUTPUT  R2 = O/S SIZE                                        *232*
*                                                               *232*
         BOUND     1W                                           *232*
S.TRV.B5 TRR       R3,R0           SAVE R3 IN R0                *232*
         LW        R3,C.CURR       GET DQE ADDRESS              *232*
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS          *232*
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?            *232*
         BNS       TRV.B5.L        BRANCH IF NOT                *232*
         LB        R2,TSK.NMAP,X3  - # OF T-XPM OS MAPS         *232*
         BU        TRV.B5.1                                     *232*
         IFT       C.MPXOUT,MOX                                 *237*
TRV.B5.L LCH       R2,T.ATBIAS,X2  GET O/S SIZE                 *232*
MOX      ANOP                                                   *237*
         IFF       C.MPXOUT,MOX                                 *237*
TRV.B5.L LH        R2,T.ATBIAS,X2  GET O/S SIZE                 *232*
MOX      ANOP                                                   *237*
TRV.B5.1 TRR       R0,R3           RESTORE USER'S R3            *232*
TRVB5RET BU        0               RETURN                       *232*
MO       ANOP                                                   *237*
D35      ANOP                                                   *232*
*
         IFT       OS.32X,TRV46SKP      THIS ONE NOT USED ON 2.X
         IFF       C.MPXOUT,MO                                  *237*
*
* ROUTINE TO CREATE SMT.MAPS CORRECTLY ON DYNAMIC PART. CREATE
*
         BOUND     1W                                           *232*
         IFF       OS.35,D35                                    *232*
S.TRV.46 TRR       R2,R4           SAVE R2 IN R4
D35      ANOP                                                   *232*
         IFT       OS.35,D35                                    *232*
S.TRV.46 TRR       R2,R7           SAVE R2 IN R7                *232*
D35      ANOP                                                   *232*
         LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2 TXPM TASK?
         BNS       TRV.46.R        NO
         ADMB      R6,TSK.NMAP,X2  PATIENCE!
         SUMB      R6,C.MSD        R6 = PART. STRT. TSA RELATIVE
TRV.46.R STH       R6,SMT.MAPS,X1  EXECUTE REPLACED INSTRUCTION
         IFF       OS.35,D35                                    *232*
         TRR       R4,R2           RESTORE USER REG 2
         NOP                       BOUND THIS HUMMER
D35      ANOP                                                   *232*
         IFT       OS.35,D35                                    *232*
         TRR       R7,R2           RESTORE USER REG 2           *232*
         TRR       R5,R7           RESTORE R7                   *232*
D35      ANOP                                                   *232*
TRV46RET BU        0               RETURN TO H.MEMM
MO       ANOP                                                   *237*
TRV46SKP ANOP
*
         IFF       OS.32X,TRV47SKP THIS ONE NOT USED ON 3.X
*
*  ROUTINE TO ADJUST C.MSD FOR CHECK VS HIGHMAP
*
S.TRV.47 LW        R3,C.CURR       GET DQE ADDRESS
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV.47.5        BRANCH IF NOT
         ADMB      R4,TSK.NMAP,X3  - # OF T-XPM OS MAPS
         BU        TRV.47.L        NOW LEAVE
TRV.47.5 ADMB      R4,C.MSD        - # OF   MPX OS MAPS
TRV.47.L LW        R3,C.REGS       RESTORE USER R3
TRV47RET RES       1W              RETURN
TRV47SKP ANOP
*
*  ROUTINE TO ADJUST CSECT LOAD ADDRESS DURING TASK ACTIVATION
*  CALLED FROM TAMM.1
*  REGS: R7=CSECT ORIGIN
*        R2=LOAD INFORMATION POINTER
*        R3,R4,R0 USABLE
*
S.TRV.48 LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3 TXPM TASK?
         BNS       TRV.48.L        LEAVE IN NOT
         ADMW      R7,TSK.BIAS,X3  BIAS CSECT LOAD ADDRESS
TRV.48.L ANMW      R7,=X'FFFFFC'   REPLACED INSTRUCTION
         TRSW      R0              RETURN TO TAMM.1
*
*  ROUTINE TO BIAS CSECT TRANSFER ADDRESS IN TAMM.3
*  REGS: R6=TRANSFER ADDRESS
*        R0,R1,R7 USABLE
*
S.TRV.49 LW        R1,C.CURR       DQE ADDRESS
         LW        R1,DQE.PSSF,X1  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  TXPM TASK?
         BNS       TRV.49.R        RETURN TO TAMM.3
         ADMW      R6,TSK.BIAS,X1  BIAS TRANSFER ADDRESS
TRV.49.R BU        $-$             RETURN TO TAMM.3
         IFF       OS.35,D35                                    *232*
*
*  ROUTINE TO BIAS LAST LOADED DSECT ADDRESS FOR ABSOLUTE
*  TASKS IN TAMM.3
*  REGS: R6=PR.ENDD - LAST LOADED ADDRESS, BIT 7 SET IF ABS
*        R0,R1,R7 USABLE
*
         BOUND     1W
S.TRV.4X ZBR       R6,7            IS THIS AN ABSOLUTE ADDRESS
         BNS       TRV.4X.A        RETURN IF NOT
         LW        R1,C.CURR       DQE ADDRESS
         LW        R1,DQE.PSSF,X1  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  TXPM TASK?
         BNS       TRV.4X.R        RETURN TO TAMM.3
         ADMW      R6,TSK.BIAS,X1  BIAS LAST LOADED ADDRESS
         BU        TRV.4X.R        SKIP BIASING FOR ABS ADR
TRV.4X.A ADMW      R6,T.BIAS,X3    ADD IN RELOCATION ADDRESS
TRV.4X.R TRSW      R0              RETURN TO TAMM.3
D35      ANOP                                                   *232*
         IFT       OS.35,D35                                    *232*
*                                                               *232*
*  ROUTINE TO BIAS LAST LOADED DSECT ADDRESS FOR ABSOLUTE       *232*
*  TASKS IN TAMM.3                                              *232*
*  REGS: R6=PR.ENDD - LAST LOADED ADDRESS, BIT 7 SET IF ABS     *232*
*        R0,R1,R7 USABLE                                        *232*
*                                                               *232*
         BOUND     1W                                           *232*
S.TRV.BX ZBR       R6,7            IS THIS AN ABSOLUTE ADDRESS  *232*
         BNS       TRV.BX.A        RETURN IF NOT                *232*
         LW        R1,C.CURR       DQE ADDRESS                  *232*
         LW        R1,DQE.PSSF,X1  CONTEXT ADDRESS              *232*
         TBM       TSK.TXPM,TSK.FLG1,X1  TXPM TASK?             *232*
         BNS       TRV.BX.R        RETURN TO TAMM.3             *232*
         IFT       C.MPXOUT,MO                                  *237*
         LCW       R1,TSK.BIAS,X1  BIAS LAST LOADED ADDRESS     *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
TRV.BX.R ZR        R1              NO RELOCATION FOR ABS TASK   *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
TRV.BX.A LCW       R1,T.BIAS,X3    ADD IN RELOCATION ADDRESS    *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LW        R1,TSK.BIAS,X1  BIAS LAST LOADED ADDRESS     *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
TRV.BX.R ZR        R1              NO RELOCATION FOR ABS TASK   *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
TRV.BX.A LW        R1,T.BIAS,X3    ADD IN RELOCATION ADDRESS    *232*
         TRSW      R0              RETURN TO TAMM.3             *232*
MO       ANOP                                                   *237*
*
*  Routine to bias last-loaded DSECT for 3.5U01 and later.          !264
*  R6 = PR.ENDD w/o flags, R1 has flags, TAMM already determined    !264
*    that task is absolute.                                         !264
*                                                                   !264
S.TRV.CX LW        R1,C.CURR                                        !264
         LW        R1,DQE.PSSF,X1  Get context area                 !264
         TBM       TSK.TXPM,TSK.FLG1,X1 TXPM task?                  !264
         BNS       TRV.CX.R        Go if no                         !264
         ADMW      R6,TSK.BIAS,X1  Else add in TXPM bias            !264
TRV.CX.R BU        $-$             Return to TM3.885A               !264
D35      ANOP                                                   *232*
*
*  ROUTINE TO BIAS ABSOL TRANSFER ADDRESS IN TAMM.3
*  REGS: R7=TRANSFER ADDRESS
*        R0,R3,R6 USABLE
*
         BOUND     1W
S.TRV.4A LW        R3,C.CURR       DQE ADDRESS
         LW        R3,DQE.PSSF,X3  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X3  TXPM TASK?
         BNS       TRV.4A.R        RETURN TO TAMM.3
         ADMW      R7,TSK.BIAS,X3  BIAS TRANSFER ADDRESS
TRV.4A.R BU        $-$             RETURN TO TAMM.3
*
*  ROUTINE TO DETERMINE TSA ORIGIN FOR ABSOLUTE LOAD MODULE
*  REGS: R5=DSECT ORIGIN FOR ABSOLUTE LOAD MODULE
*        R4,R2,R6 USABLE
*
         BOUND     1W
S.TRV.4B TRR       R2,R4           SAVE R2 BEFORE USING
         LW        R2,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X2  CONTEXT ADDRESS
         TBM       TSK.OMPX,TSK.FLG2,X2  IS THIS MPX ONLY TASK
         BS        TRV.4B.E        GO LET USER ABORT WITH RM64 ERROR
         IFT       OS.35,DO.35                                      !264
         LH        R6,T.DSOR,X3    MPX may have "fixed" T.DSOR      !264
*                                  to  be negative for TXPM tasks   !264
         BNN       $+2W            Go if it didn't "fix" it         !264
         ZMH       T.DSOR,X3       Else clamp it to zero            !264
DO.35    ANOP                                                       !264
         TRR       R5,R6           COPY LOAD MODULE ORIGIN
         SUMW      R6,T.TEND,X3    SUBT OLD END ADDRESS
         ADR       R3,R6           ADD IN OLD TSA ADDR
         SRL       R6,SHIFTA       FORM NEW O/S SIZE
         CAMW      R6,MIN.MAPS     IS TSA < MINIMUM ADDRESS
         BLT       TRV.4B.E        ABORT WITH RM64 IF YES
         STB       R6,TSK.NMAP,X2  FORCE TASK TO RUN AS T-XPM
         SBM       TSK.TXPM,TSK.FLG1,X2
         SBM       TSK.FORC,TSK.FLG1,X2
         SLL       R6,SHIFTA       NEW TSA ORIGIN FOR THIS TASK
         TRN       R6,R6           NEGATE FOR SUBT
         ADR       R3,R6           CALC NEW BIAS VALUE
         STW       R6,TSK.BIAS,X2  SAVE NEW BIAS
         ADR       R6,R5           SET NEW LOAD ORIGIN
         TRR       R4,R2           RESTORE R2
TRV.4B.R BU        $-$             RETURN TO S.TAMM5
TRV.4B.E BU        $-$             RETURN TO S.TAMM5 FOR RM64 ERROR
         IFF       OS.32X,TRV.4XN  SKIP IF NOT 3.2X
*
*  THIS ROUTINE ALLOWS TAMM TO LOAD ABOVE 128KW ON 2.X SYSTEMS
*
S.TRV.4C ZBR       R4,12           20 BIT ADDRESS?
         BNS       $+2W            BR IF NOT
         SBM       FCB.EA,FCB.SPST,X1  SET EXTENDED ADDRESS BIT
         STW       R4,FCB.TCW,X1   REPLACED INSTRUCTION
TRV.4C.R BU        $-$             RETURN TO TAMM.1
*
*  THIS ROUTINE RESETS EXTENDED ADDRESS MODE IF SET DURING LOADING
*
S.TRV.4D ZBM       FCB.EA,FCB.SPST,X1  RESET EXT ADDR BIT
         TRR       R5,R5           REPLACED INSTRUCTION
TRV.4D.R BU        $-$             RETURN TO TAMM.1
*
TRV.4XN  ANOP                      SKIP PREVIOUS CODE IF 3X
*
         IFT       OS.32X,FOR3X    THIS ONE NOT USED ON 2.X
         IFF       OS.33,FOR3X     NOT IN 3.3 ANYMORE           *237*
         IFF       OS.U02,FOR3X    NOT IN 3.3U02 ANYMORE        *237*
         IFF       OS.34,FOR3X     NOT IN 3.4 ANYMORE           *237*
         IFF       OS.34U01,FOR3X  NOT IN 3.4U01 ANYMORE        *237*
         IFF       OS.34U02,FOR3X  NOT IN 3.4U02 ANYMORE        *237*
         IFF       OS.34U03,FOR3X  NOT IN 3.4U03 ANYMORE        *237*
         IFF       OS.35,FOR3X     NOT IN 3.5 ANYMORE           *237*
         IFF       OS.35,D35                                    *232*
*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM2.8
*  BIAS COUNT IN R5 - R6 USABLE
*  R1 HAS CHILD'S DQE ADDRESS - USE IT!                         *202*
         BOUND     1W
S.TRV.4E TRR       R1,R6           SAVE X1 - CHILD'S DQE ADDR
         LW        R1,DQE.PSSF,X1  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  T-XPM TASK?
         BNS       TRV.4E.1        BRANCH IF NOT
         SUMB      R5,TSK.NMAP,X1  - # OF T-XPM OS MAPS
         SUMB      R5,TSK.NMAP,X1  - # OF T-XPM OS MAPS
         BU        TRV.4E.L        NOW LEAVE
TRV.4E.1 SUMB      R5,C.MSD        - # OF   MPX OS MAPS
         SUMB      R5,C.MSD        - # OF   MPX OS MAPS
TRV.4E.L TRR       R6,R1           RESTORE R1
         TRSW      R0              RETURN
D35      ANOP                                                   *232*
         IFT       OS.35,D35                                    *232*
         IFF       C.MPXOUT,MO                                  *237*
*                                                               *232*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM2.8                       *232*
*  BIAS COUNT IN R5 - R6 USABLE                                 *232*
*  R2 HAS TSA ADDRESS, USE IT TO GET CHILD'S DQE ADDRESS        *232*
         BOUND     1W                                           *232*
S.TRV.BE LW        R3,T.PRNO,X2    GET CHILD'S DQE ADDR         *232*
         LW        R3,DQE.PSSF,X3  GET CONTEXT ADDRESS          *232*
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?            *232*
         BNS       TRV.BE.1        BRANCH IF NOT                *232*
         LB        R1,TSK.NMAP,X3  - # OF T-XPM OS MAPS         *237*
         SLL       R1,MM.SHFT      MAKE INTO BYTE COUNT         *232*
TRV.BE.1 SUR       R1,R5           - # OF   MPX OS MAPS         *232*
TRV.BE.R BU        $-$             RETURN                       *232*
MO       ANOP                                                   *237*
D35      ANOP                                                   *232*
FOR3X    ANOP
         IFT       OS.32X,FOR3X    THIS ONE NOT USED ON 2.X
         IFF       OS.32A,FOR3X    NOT IN MPX 3.2A
         IFF       OS.32B,FOR3X    NOT IN MPX 3.2B
         IFF       OS.32C,FOR3X    NOT IN MPX 3.2C
         IFF       OS.U03,FOR3X    NOT IN MPX 3.2C U03
         IFF       OS.UCS,FOR3X    NOT IN MPX 3.2C UCS
         IFF       OS.32X,FOR3X    NOT IN ANY 3X SYSTEM         *237*
         IFF       OS.35,D35       THIS VERSION NOT IN 35       *232*
*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM3.3
*  BIAS COUNT IN R6 - R7 USABLE
         BOUND     1W
S.TRV.4F TRR       R2,R7           SAVE R2
         LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.4F.1        BRANCH IF NOT
         SUMB      R6,TSK.NMAP,X2  - # OF T-XPM OS MAPS
         BU        TRV.4F.L        NOW LEAVE
TRV.4F.1 SUMB      R6,C.MSD        - # OF   MPX OS MAPS
TRV.4F.L TRR       R7,R2           RESTORE R2
TRV.4F.R BU        $-$             RETURN TO S.TM3.3
*
D35      ANOP                                                   *232*
         IFT       OS.35,D35       THIS VERSION IN 35           *232*
         IFF       C.MPXOUT,MO                                  *237*
*                                                               *232*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM3.3                       *232*
*  GET MAP COUNT IN R4 - R7 USABLE                              *232*
*  X3 HAS TSA ADDRESS                                           *232*
         BOUND     1W                                           *232*
S.TRV.BF TRR       R2,R7           SAVE R2                      *232*
         LW        R2,T.PRNO,X3    GET DQE ADDRESS              *232*
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS          *232*
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?            *232*
         BNS       TRV.BF.1        BRANCH IF NOT                *232*
         LB        R4,TSK.NMAP,X2  - # OF T-XPM OS MAPS         *232*
         BU        TRV.BF.L        NOW LEAVE                    *232*
TRV.BF.1 LCH       R4,T.ATBIAS,X3  - # OF   MPX OS MAPS         *232*
TRV.BF.L TRR       R7,R2           RESTORE R2                   *232*
TRV.BF.R BU        $-$             RETURN TO S.TM3.3            *232*
MO       ANOP                                                   *237*
D35      ANOP                                                   *232*
FOR3X    ANOP
         IFT       OS.32X,FOR3X    THIS ONE NOT USED ON 2.X
         IFF       OS.33,FOR3X     NOT IN MPX 3.3
         IFF       OS.U02,FOR3X    NOT IN MPX 3.3 U02
         IFF       OS.34,FOR3X     NOT IN MPX 3.4               *210*
         IFF       OS.34U01,FOR3X  NOT IN MPX 3.4 U01           *232*
         IFF       OS.34U02,FOR3X  NOT IN MPX 3.4 U02           *228*
         IFF       OS.34U03,FOR3X  NOT IN MPX 3.4 U03           *232*
         IFF       OS.35,FOR3X     NOT IN MPX 3.5               *232*
*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM3.1
*  BIAS COUNT IN R7 - R1 USABLE
         BOUND     1W
S.TRV.4G LW        R1,C.CURR       GET DQE ADDRESS
         LW        R1,DQE.PSSF,X1  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X1  T-XPM TASK?
         BNS       TRV.4G.1        BRANCH IF NOT
         SUMB      R7,TSK.NMAP,X1  - # OF T-XPM OS MAPS
         BU        TRV.4G.L        NOW LEAVE
TRV.4G.1 SUMB      R7,C.MSD        - # OF   MPX OS MAPS
TRV.4G.L TRSW      R0              RETURN
*
FOR3X    ANOP
         IFT       OS.32X,FOR3X    THIS ONE NOT USED ON 2.X
         IFF       OS.33,FOR3X     NOT IN MPX 3.3
         IFF       OS.U02,FOR3X    NOT IN MPX 3.3 U02
         IFF       OS.34,FOR3X     NOT IN MPX 3.4               *210*
         IFF       OS.34U01,FOR3X  NOT IN MPX 3.4 U01           *232*
         IFF       OS.34U02,FOR3X  NOT IN MPX 3.4 U02           *228*
         IFF       OS.34U03,FOR3X  NOT IN MPX 3.4 U03           *232*
         IFF       OS.35,FOR3X     NOT IN MPX 3.5               *232*
*
*  ROUTINE TO ADJUST MIDL SIZE IN S.TM3.6
*  BIAS COUNT IN R1 - R2 USABLE
         BOUND     1W
S.TRV.4H LW        R2,C.CURR       GET DQE ADDRESS
         LW        R2,DQE.PSSF,X2  GET CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  T-XPM TASK?
         BNS       TRV.4H.1        BRANCH IF NOT
         SUMB      R1,TSK.NMAP,X2  - # OF T-XPM OS MAPS
         SUMB      R1,TSK.NMAP,X2  - # OF T-XPM OS MAPS
         BU        TRV.4H.L        NOW LEAVE
TRV.4H.1 SUMB      R1,C.MSD        - # OF   MPX OS MAPS
         SUMB      R1,C.MSD        - # OF   MPX OS MAPS
TRV.4H.L TRSW      R0              RETURN
*
FOR3X    ANOP
         IFT       OS.35,DO.35                                      !264
*  This routine is the 3.5U01 equivalent of S.TRV.46.  It creates   !264
*  SMT.MAPS correctly on dynamic partition create.                  !264
S.TRV.4J TRR       R6,R7           Save R6 for now                  !264
         LW        R3,C.CURR       R3 available                     !264
         LW        R3,DQE.PSSF,X3  TXPM context area                !264
         TBM       TSK.TXPM,TSK.FLG1,X3 TXPM task?                  !264
         BNS       TRV.4J.R        Go if no                         !264
         ADMB      R6,TSK.NMAP,X3                                   !264
         SUMB      R6,C.MSD                                         !264
TRV.4J.R STH       R6,SMT.MAPS,X1  Replaced instruction             !264
         TRR       R7,R6           Restore R6                       !264
         TRR       R5,R7           Ditto with R7, though I'm        !264
*                                  not sure we need it              !264
TRV4JRET BU        $-$             Return                           !264
DO.35    ANOP                                                       !264
*-----------------------------------------------------------------------
         BOUND     1W
DSP.MN   BEI                       MAIN H.EXEC DISPATCH
         STF       R0,CPUREGS      SAVE CPU REGS
PTCH.08  LD        R6,0            EXEC.D1
         BL        S.TXPM.1
         LF        R0,CPUREGS      RESTORE USERS REGS
PTCH.09  LPSD      0               EXEC.D1
*
*-----------------------------------------------------------------------
         BOUND     1W
DSP.EX05 BEI                       S.EXEC5 DISPATCH FOR NESTED INT
         STF       R0,TXPMREGS     SAVE CPU REGS
PTCH.X5  LD        R6,0            EXEC.D1
         BL        EXEC.05         SPECIAL ENTRY
         LF        R0,TXPMREGS     RESTORE USERS REGS
PTCH.Y5  LPSD      0               EXEC.D1
         IFT       OS.32X,DS.34    INCLUDE IF 3X                *228*
         IFF       OS.32A,DS.34    NOT IN 32A                   *228*
         IFF       OS.32B,DS.34    NOT IN 32B                   *228*
         IFF       OS.32C,DS.34    NOT IN 32C                   *228*
         IFF       OS.UCS,DS.34    NOT IN UCS                   *228*
         IFF       OS.U02,DS.34    NOT IN U02                   *228*
         IFF       OS.U03,DS.34    NOT IN U03                   *228*
         IFF       OS.33,DS.34     NOT IN 33                    *228*
*                                  IN 3.4, 3.4U01, 3.4U02       *228*
*                                                               *210*
*---------------------------------------------------------------*210*
         BOUND     1W                                           *210*
DSP.SURE BEI                       H.SURE DISPATCH              *210*
         STF       R0,TXPMREGS     SAVE CPU REGS                *210*
SURE.P1  LD        R6,0            GET RETURN PSD               *210*
         BL        EXEC.05         USE FAST INT PATH            *210*
         LF        R0,TXPMREGS     RESTORE REGS FOR DISP        *210*
SURE.RT  LPSDCM    0               SV5.TPS1                     *210*
*                                                               *210*
*---------------------------------------------------------------*210*
         BOUND     1W                                           *210*
DSP.ICP  BEI                       H.ICP DISPATCH               *210*
         STF       R0,TXPMREGS     SAVE CPU REGS                *210*
ICP.P1   LD        R6,0            GET RETURN PSD               *210*
         BL        EXEC.05         USE FAST INT PATH            *210*
         LF        R0,TXPMREGS     RESTORE REGS FOR DISP        *210*
ICP.RT   LPSDCM    0               EXEC.D1                      *210*
*                                                               *210*
DS.34    ANOP                                                   *210*
         IFT       OS.32X,DS.34                                 *232*
         IFF       OS.32A,DS.34                                 *232*
         IFF       OS.32B,DS.34                                 *232*
         IFF       OS.32C,DS.34                                 *232*
         IFF       OS.UCS,DS.34                                 *232*
         IFF       OS.U03,DS.34                                 *232*
         IFF       OS.33,DS.34                                  *232*
         IFF       OS.U02,DS.34                                 *232*
         IFF       OS.34,DS.34                                  *232*
         IFF       OS.34U01,DS.34                               *232*
*                                  IN 34U02, 34U03, 35          *232*
*---------------------------------------------------------------*228*
         BOUND     1W                                           *228*
DSP.IP04 BEI                       H.IP04 DISPATCH - UI01       *228*
         STF       R0,CPUREGS      SAVE CPU REGS                *228*
IP04.P1  LD        R6,0            GET RETURN PSD               *228*
         BL        S.TXPM.1        DISP TO TXPM TASK            *228*
         LF        R0,CPUREGS      RESTORE REGS FOR DISP        *228*
IP04.RT  LPSD      0               IP04.OLD                     *228*
*                                                               *228*
*---------------------------------------------------------------*228*
         BOUND     1W                                           *228*
DSP.IP05 BEI                       H.IP05 DISPATCH - PV01       *228*
         STF       R0,CPUREGS      SAVE CPU REGS                *228*
IP05.P1  LD        R6,0            GET RETURN PSD               *228*
         BL        S.TXPM.1        DISP TO TXPM TASK            *228*
         LF        R0,CPUREGS      RESTORE REGS FOR DISP        *228*
IP05.RT  LPSD      0               IP05.OLD                     *228*
*                                                               *228*
DS.34    ANOP                                                   *228*
*---------------------------------------------------------------*219*
         BOUND     1W                                           *219*
DSP.SVC7 BEI                       H.SVC7 DISPATCH              *219*
         STF       R0,TXPMREGS     SAVE CPU REGS                *219*
         LD        R6,2F,X3        GET RETURN PSD               *219*
         BL        EXEC.05         USE FAST INT PATH            *219*
         LF        R0,TXPMREGS     RESTORE REGS FOR DISP        *219*
         LPSD      2F,X3           SVC7.OLD                     *219*
*                                                               *219*
*-----------------------------------------------------------------------
         BOUND     1W
DSP.IP06 BEI                       SVC 0 & 3 DISPATCHES
         STF       R0,CPUREGS      SAVE CPU REGS
PTCH.32  LD        R6,0            SVC3.OLD
         BL        S.TXPM.1        SEE IF TXPM DISPATCH
         LF        R0,CPUREGS      RESTORE USERS REGS
PTCH.33  LPSD      0               SVC3.OLD
*
*-----------------------------------------------------------------------
DSP.BR   BEI                       BREAK RECEIVER DISPATCH
         STF       R0,CPUREGS      SAVE REGS
PTCH.10  LD        R6,0            SX21.4T
         BL        S.TXPM.1
         LF        R0,CPUREGS
PTCH.11  LPSD      0               SX21.4T
*
*-----------------------------------------------------------------------
DSP.MR   BEI                       MSG   RECEIVER DISPATCH
         STF       R0,CPUREGS
PTCH.12  LD        R6,0            SX21.6T
         BL        S.TXPM.1
         LF        R0,CPUREGS
PTCH.13  LPSD      0               SX21.6T
*
*-----------------------------------------------------------------------
DSP.AR   BEI                       ABORT RECEIVER DISPATCH
         STF       R0,CPUREGS
         IFF       OS.35,D35       THIS VERSION NOT IN 35       *232*
         LW        R6,T.CONTXT+8W,X3    GET USERS PSW
         STW       R6,T.ABRTA,X3   SAVE IN TSA FOR ABORT MSG
D35      ANOP                                                   *232*
         LF        R0,T.CONTXT,X3  GET USER REGS FROM CONTEXT AREA
         STF       R0,CXTREGS      SAVE IN TXPM
         LA        R2,CXTREGS      ADDRESS OF SAVE AREA
         LW        R3,C.CURR       DQE ADDRESS
         LW        R1,DQE.PSSF,X3  CONTEXT ADDRESS
         LA        R1,TSK.LVL0,X1  GET LEVEL 0 ADDRESS
         ZBM       TSK.SVC,TSK.LVL,X1  CLEAR SVC FLAG FOR BASE LEV
         ZBM       TSK.SVC1,TSK.SVCI,X1 CLEAR SVC TYPE BIT      *219*
         ZBM       TSK.SVC2,TSK.SVCI,X1 CLEAR SVC TYPE BIT      *219*
         ZBM       TSK.SVC6,TSK.SVCI,X1 CLEAR SVC TYPE BIT      *219*
         ZBM       TSK.SVC7,TSK.SVCI,X1 CLEAR SVC TYPE BIT      *219*
         ZBM       TSK.SVCE,TSK.SVCI,X1 CLEAR SVC TYPE BIT      *219*
PTCH.14  LD        R6,0            SX27.PSD
         BL        S.TXPM.0        SEE IF TXPM TASK
         LF        R0,CPUREGS
PTCH.15  LPSD      0               SX27.PSD
*
CXTREGS  RES       1F              TEMP CONTEXT REGS DURING ABORT
*
*-----------------------------------------------------------------------
DSP.EA   BEI                       I/O END-ACTION DISPATCH
         STF       R0,CPUREGS
         LW        R3,C.CURR       DQE ADDRESS
         LW        R2,DQE.PSSF,X3  CONTEXT ADDRESS
         TBM       TSK.TXPM,TSK.FLG1,X2  TXPM TASK
         BNS       DSP.EAR         NOT TXPM, DO DISPATCH
         IFF       C.MPXOUT,MO                                  *237*
         LW        R4,ADR.MASK     20-BIT MASK
         LNW       R5,TSK.BIAS,X2  GET REBIAS VALUE
         LA        R2,CPUREGS      REG SAVE AREA ADDRESS
         LMW       R6,1W,X2        GET FCB OR CNP ADDRESS
         BZ        $+2W            SKIP IF NONE
         ARMW      R5,1W,X2        BIAS R1
MO       ANOP                                                   *237*
         IFT       C.MPXOUT,MO                                  *237*
         LA        R2,CPUREGS      REG SAVE AREA ADDRESS
MO       ANOP                                                   *237*
PTCH.16  LD        R6,0            SX68.PSD
         BL        S.TXPM.0
DSP.EAR  LF        R0,CPUREGS      RESTORE USERS REG & EXIT
PTCH.17  LPSD      0               SX68.PSD
*
*-----------------------------------------------------------------------
*       THIS DISPATCH IS USUALLY TO S.IOCS1, HOWEVER, WHEN      *205*
*       USING INTERRUPT ON EOB DISPATCH, IT IS DIRECTLY         *205*
*       TO THE USER. THEREFORE WE MUST DO TXPM DISPATCH.        *205*
DSP.EA2  BEI                       I/O END ACTION DISPATCH      *205*
         STF       R0,CPUREGS      SAVE REGS                    *205*
         LD        R6,4W,X2        GET DISPATCH PSD             *205*
         BL        S.TXPM.1        SEE IF TXPM DISPATCH         *205*
         LF        R0,CPUREGS      NOT TXPM TASK, DO DISPATCH   *205*
         LPSD      4W,X2           DISPATCH                     *205*
*                                                               *205*
*-----------------------------------------------------------------------
DSP.AE   BEI                       ARITH EXCPTION DISPATCH
         STF       R0,CPUREGS
PTCH.18  LD        R6,0            PSD.OLD
         BL        S.TXPM.1
         LF        R0,CPUREGS
PTCH.19  LPSD      0               PSD.OLD
*
         IFT       OS.35,DO.RMSS                                    !257
*-------------------------------------------------------------------!257
DSP.RMS1 BEI                       RMSS                             !257
         STF       R0,CPUREGS                                       !257
PTCH.34  LD        R6,0            PSD.OLD                          !257
         BL        S.TXPM.1                                         !257
         LF        R0,CPUREGS                                       !257
PTCH.35  LPSD      0                                                !257
*                                                                   !257
*-------------------------------------------------------------------!257
DSP.RMS2 BEI                       RMSS                             !257
         STF       R0,CPUREGS                                       !257
PTCH.36  LD        R6,0            PSD.OLD                          !257
         BL        S.TXPM.1                                         !257
         LF        R0,CPUREGS                                       !257
PTCH.37  LPSD      0                                                !257
*                                                                   !257
*-------------------------------------------------------------------!257
DSP.RMS3 BEI                       RMSS                             !257
         STF       R0,CPUREGS                                       !257
PTCH.38  LD        R6,0            PSD.OLD                          !257
         BL        S.TXPM.1                                         !257
         LF        R0,CPUREGS                                       !257
PTCH.39  LPSD      0                                                !257
*                                                                   !257
DO.RMSS  ANOP                                                       !257
*-----------------------------------------------------------------------
         IFF       OS.35,DOTHER                                 *235*
         IFF       OS.34U03,DOTHER                              *235*
EAB.IO   BL        S.TRV.10        END-ACTION BIAS FOR NW I/O
         BS        S.EXEC68
EAB.IOR  BU        0               RETURN
*
*-----------------------------------------------------------------------
EAB.IO1  EQU       $               END-ACTION BIAS FOR NW I/O
PTCH.20  BNZ       0               S17.5.30 + 1W
         BL        S.TRV.10
PTCH.21  BU        0               S17.5.40
*
DOTHER   ANOP                                                   *235*
         IFT       OS.35,NEWCODE                                *235*
         IFF       C.MPXOUT,MO                                  *237*
EAB.IO   BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
         BL        S.EXEC68        DISPATCH TO EA, NO RETURN    *235*
*-----------------------------------------------------------------------
EAB.IO1  BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
EAB.IO1A M.CALL    H.EXEC,12       EXIT END ACTION, NO RETURN   *235*
*-----------------------------------------------------------------------
EAB.IO2  BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
EAB.IO2A REZ       1W              REPLACED INSTRUCTION         *235*
EAB.IO2R BU        $-$             RETURN TO S.IOCS17           *235*
MO       ANOP                                                   *237*
NEWCODE  ANOP                                                   *235*
         IFT       OS.34U03,NEWCODE                             *235*
EAB.IO   BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
         BL        S.EXEC68        DISPATCH TO EA, NO RETURN    *235*
*-----------------------------------------------------------------------
EAB.IO1  BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
EAB.IO1A M.CALL    H.EXEC,12       EXIT END ACTION, NO RETURN   *235*
*-----------------------------------------------------------------------
EAB.IO2  BL        S.TRV.10        UNBIAS FCB FOR N/W END-ACTION*235*
EAB.IO2A REZ       1W              REPLACED INSTRUCTION         *235*
EAB.IO2R BU        $-$             RETURN TO S.IOCS17           *235*
NEWCODE  ANOP                                                   *235*
*-----------------------------------------------------------------------
         IFF       C.MPXOUT,MOX                                 *237*
EAB.MR   BL        S.TRV.11        END-ACTION BIAS FOR NW MSG
EAB.INST REZ       1W              REPLACED INSTRUCTION
EAB.MRR  BU        0               RETURN INSTRUCTION
*
*-----------------------------------------------------------------------
EAB.MR1  BL        S.TRV.11        END-ACTION BIAS FOR NW MSG
EAB.INS1 REZ       1W              REPLACED INSTRUCTION
EAB.MRR1 BU        0               RETURN INSTRUCTION
*
*-----------------------------------------------------------------------
*                  FOR VERSION 3.2C UCS VERSION AND NEWER       *232*
TSM.2A   TBM       FCB.EA,FCB.SPST,X1   EM ADDRESS?
         BNS       TSM.2.1A        BRANCH IF NOT
         IFT       C.MPXOUT,MO                                  *237*
         LCW       R1,FCB.TCW,X1   FETCH TCW                    *232*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
         LW        R1,FCB.TCW,X1   FETCH TCW                    *232*
MO       ANOP                                                   *237*
         ANR       R4,R1           MASK                         *232*
         SBR       R1,12           INDICATE EXTENDED
         SUI       R1,1B           BACK UP
PTCH.SS  BU        0               RETURN TO 'LIN.8WX'
         IFT       C.MPXOUT,MO                                  *237*
TSM.2.1A LCW       R1,FCB.TCW,X1   FETCH TCW                    *232*
MO       ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
TSM.2.1A LW        R1,FCB.TCW,X1   FETCH TCW                    *232*
MO       ANOP                                                   *237*
         ANR       R4,R1           MASK IT                      *232*
         SUI       R1,1B           BACK UP
PTCH.TT  BU        0               RETURN TO 'LIN.8WX'
*
MOX      ANOP                                                   *237*
         IFF       C.MPXOUT,MO                                  *237*
*-----------------------------------------------------------------------
*      ROUTINE TO UNBIAS RXB (CALLED FROM S.EXEC63) SINCE THERE
*      EXISTS NO SVC RETURN FROM M.XMSGR & M.XRUNR
         BOUND     1W
TRV.16   BL        S.TRV.16        GO BIAS RXB
TRV.16.R BU        $-$             RETURN TO S.EXEC63
*
MO       ANOP                                                   *237*
*-----------------------------------------------------------------------
AJ.CSECT STW       R0,$+5W         ADJUST CSECT ORIGIN
         BL        S.TXPM.4
         LW        R0,$+3W
         TRSW      R0
PTCH.22  BU        0               1DCC (H.TAMM) RM65
         REZ       1W              SAVE AREA FOR R0
*
*-----------------------------------------------------------------------
         IFF       C.MPXOUT,MO                                  *237*
*  ROUTINE TO ALLOW FOR EXTENDED ADDRESS IN SHORT FCB
*
*  CALLED FROM:  S.IOCS20
*
*  ON INPUT:  R1 = FCB ADDRESS
*             R6 = XFER COUNT
*             R7 = DATA ADDRESS
*
SHRT.FCB XCR       R6,R7
         ZBR       R6,12           CLEAR 'F' BIT
         TBM       FCB.EA,FCB.SPST,X1   EXTENDED ADDRESS?
         BNS       $+2W            BRANCH IF NOT
         SBR       R6,12           MAKE ADDRESS EXTENDED
         TBM       12,FCB.TCW,X1   'F' BIT SET?
PTCH.23  BU        0
*
*-----------------------------------------------------------------------
TSM.1    TRN       R4,R4           NEGATE R4
         TBM       FCB.EA,FCB.SPST,X2   EM ADDRESS?
         BNS       TSM.1.1              BRANCH IF NOT
         TRR       R6,R2           TCW TO R2
         ANMW      R2,=X'7FFFF'    MASK ADDRESS
         SBR       R2,12           SET FOR EXTENDED MEMORY
PTCH.24  BU        0               RETURN TO 'RD.27'
TSM.1.1  TRR       R6,R2           TCW TO R2
PTCH.25  BU        0               RETURN TO 'RD.27' - 1W
*
*-----------------------------------------------------------------------
TSM.2    TBM       FCB.EA,FCB.SPST,X1   EM ADDRESS?
         BNS       TSM.2.1         BRANCH IF NOT
         LMW       R1,FCB.TCW,X1   FETCH TCW
         SBR       R1,12           INDICATE EXTENDED
PTCH.26  BU        0               RETURN TO 'LIN.8WX'
TSM.2.1  LMW       R1,FCB.TCW,X1   FETCH TCW
PTCH.27  BU        0               RETURN TO 'LIN.8WX'
*
*-----------------------------------------------------------------------
TSM.3    ANMW      R6,=X'7FFFF'    MASK ADDRESS
         TBM       FCB.EA,FCB.SPST,X1   EXTENDED ADDRESS?
         BNS       TSM.3.1         BRANCH IF NOT EXTENDED
         SBR       R6,12           SET EXTENDED
TSM.3.1  TRSW      R0              RETURN
*
*-----------------------------------------------------------------------
S.TSM01  LW        R5,T.CONTXT+8W,X3    FETCH OLD PSW FROM CONTEXT
S.TSM011 LW        R3,C.CURR       GET DQE ADDR
         LW        R3,DQE.PSSF,X3  GET TXPM CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X3  IS THIS A T-XPM TASK?
         BNS       S.TSM01L              NO, LEAVE
         TRR       R5,R3                 PSW TO R3
         ANMW      R3,=X'FFFFF'    ISOLATE ADDRESS              *214*
         CAMW      R3,C.TSAD             WAS DISPATCH TO USER?
         BLE       S.TSM01L              NO, SO LEAVE
         LW        R3,C.CURR       GET DQE ADDR
         LW        R3,DQE.PSSF,X3  GET TXPM CONTEXT ADDR
         LNW       R3,TSK.BIAS,X3        FETCH BIAS
         ADR       R3,R5           BIAS PSD
S.TSM01L LW        R3,C.REGS       REFETCH TSA ADDR
         TRSW      R0              RETURN TO S.TSM01
*
S.TSM015 LW        R5,T.BIAS,R3    FETCH BIAS
         BU        S.TSM011        GO MERGE
*
MO       ANOP                                                   *237*
         IFF       OS.23,ERRT.OUT                    NOT IN 2.3
         IFF       OS.24,ERRT.OUT                    NOT IN 2.4
         IFF       C.MPXOUT,MO                                  *237*
*-----------------------------------------------------------------------
*  PICK UP ADDRESS ONLY FROM FCB.ERRT
*  -- NOTE -- MUST BE OK TO DESTROY R4 !
*
ERRT.FCB TRR       R0,R4           SAVE RETURN
         ANMW      R4,=X'07FFFFFF' CLEAR CONDITION CODES        *214*
         LW        R6,FCB.ERRT,X1  FETCH ERROR ADDRESS
         ANMW      R6,=X'FFFFF'    ISOLATE ADDRESS              *214*
         TRR       R6,R6           RESET CONDITION CODES
         BL        $+1W            CC'S TO R0
         ANMW      R0,=X'F8000000' ISOLATE CONDITION CODES      *214*
         ORR       R4,R0           MERGE WITH RETURN ADDRESS
         TRSW      R0              RETURN
*
MO       ANOP                                                   *237*
ERRT.OUT ANOP
         IFF       C.MPXOUT,MO                                  *237*
*  PATCH FOR H.BKDM TO CLEAR FCB.SPST WHEN SAVING FCB PARAMETERS
*  CLEAR ONLY T-XPM BITS IN FCB.SPST!
*
*-----------------------------------------------------------------------
BKDM     LW        R6,FCB.ERRT,X1  FETCH ERROR RETURN ADDRESS
         ZBM       FCB.ECP,FCB.SPST,X1 RESET EXECUTE CHAN PGM BIT
         ZBM       FCB.FBIT,FCB.SPST,X1  CLEAR FBIT INDICATOR
         ZBM       FCB.EA,FCB.SPST,X1    CLEAR EA   INDICATOR
         ZBM       FCB.BSED,FCB.SPST,X1  CLEAR BIAS INDICATOR
BKDM.RET BU        0               RETURN
*
*-----------------------------------------------------------------------
MO       ANOP                                                   *237*
         IFF       OS.34U03,SKIP                                *235*
         IFF       OS.35,SKIP                                   *235*
EAB.IO2  EQU       $               END-ACTION BIAS FOR NW I/O SHRT FCB
PTCH.28  BS        0               S17.EADR + X'20'
         BL        S.TRV.10
PTCH.29  BU        0               S17.1.06
*
*-----------------------------------------------------------------------
EAB.IO3  EQU       $
PTCH.30  BNZ       0               S17.5.30 + 1W
         BL        S.TRV.10
PTCH.31  BU        0               S17.5.40
SKIP     ANOP                                                   *235*
*
LDR.MASK DATAW     X'000FFFFC'     ALLOW EXTENDED ADDRESS FOR 2.X LOADER
*
*-----------------------------------------------------------------------
         IFF       C.MPXOUT,MO                                  *237*
*
* THIS IS A BIASING ROUTINE FOR I/O CALLS TO N.QSXIO HANDLER    *219*
* THE ADDRESS IN FCB.ERWA IS A POINTER TO AN 'N' WORD PARAMETER *219*
* BLOCK.  THE SVC NUMBER IS IN TSK.SVCT,X3.                     *219*
*
* AT THIS POINT REGS HAVE FOLLOWING VALUES:             *219*
*       R0 - RETURN ADDRESS                             *219*
*       R1 - FCB ADDRESS                                *219*
*       R2 - CONTEXT POINTER                            *219*
*       R3 - LEVEL POINTER                              *219*
*       R4 - ADDRESS MASK                               *219*
*       R5 - SIGNED BIAS VALUE                          *219*
*       R6 - FAT ADDRESS                                *219*
*       R7 - I/O INDICATOR = 1                          *219*
*
* THE VALUE FCB.ERWA IN THE FCB HAS NOT BEEN BIASED YET *219*
*
         BOUND     1W                                   *219*
ACX.BIAS EQU       $       H.QSXIO BIASING ROUTINE      *219*
         LMW       R6,FCB.ERWA,X1  GET PB ADDR          *219*
         BZ        ACX.RET EXIT IF ZERO                 *219*
         ARMW      R5,FCB.ERWA,X1  BIAS PBA IN FCB      *219*
         TBM       TSK.SVC,TSK.LVL,X3  NEED TO BIAS PBA *219*
         BNS       ACX.UB  NO, BECAUSE THIS IS UNBIAS   *219*
         ADR       R5,R6   BIAS FOR ACCESS              *219*
ACX.UB   CAMW      R6,C.TSAD ABOVE O/S                  *219*
         BGE       ACX.GO  CONTINUE IF YES              *219*
         LW        R5,=C'TX05' ELSE, ERROR              *219*
         BL        BORT.USR  ABORT HIM                  *219*
*
ACX.GO   LB        R7,TSK.SVCT,X3  GET SVC NUMBER       *219*
         TRR       R6,R1     PBA TO R1 FOR ACCESS       *219*
*
* R1 CONTAINS PARAMETER BLOCK ADDRESS FROM NOW ON       *219*
*
* SVC 1,X'30' OPEN IS NOT BIASED                        *219*
         CI        R7,X'37' ID NETWORK LAYER            *219*
         BEQ       IDNT.OP  BR IF YES                   *219*
* SVC 1,X'31' SET SCM LINE CONTROL IS NOT BIASED        *219*
         CI        R7,X'32' SEND PACKET                 *219*
         BEQ       SEND.OP  BR IF YES                   *219*
* SVC 1,X'38' CANCEL IDENTIFICATION IS NOT BIASED       *219*
* SVC 1,X'25' EXEC CHAN PROG IS INVALID OP FOR QS       *219*
         CI        R7,X'33' CONNECT LOGICAL LINK        *219*
         BEQ       CONN.OP  BR IF YES                   *219*
* SVC 1,X'34' DISCONNECT LOGICAL LINK IS NOT BIASED     *219*
* SVC 1,X'35' INITIALIZE SCM MODE IS NOT BIASED         *219*
* SVC 1,X'36' ABORT LOGICAL LINK IS NOT BIASED          *219*
* SVC 1,X'10' SET LINK PARAMETERS IS NOT BIASED         *219*
         CI        R7,X'3E' OBTAIN LINK STATISTICS      *219*
         BEQ       OBTN.OP  BR IF YES                   *219*
         CI        R7,X'0D' RECEIVE                     *219*
         BEQ       RECV.OP  BR IF YES                   *219*
* SVC 1,X'39' CLOSE IS NOT BIASED                       *219*
* SVC 1,X'26' REMOTE IPL IS NOT BIASED                  *219*
* SVC 1,X'27' LOAD ACS IS NOT BIASED                    *219*
ACX.RET  TRSW      R0      RETURN TO TXPM               *219*
*
         BOUND     1W                                   *219*
IDNT.OP  EQU       $       IDENTIFY NETWORK LAYER ENTITY*219*
*
* FOUR WORD PSB                                         *219*
* WD 0 = FLAGS & STATUS                                 *219*
* WD 1 = NOTIFICATION ROUTINE ADDRESS                   *219*
* WD 2 = NOTIFICATION INFORMATION BLOCK ADDRESS         *219*
* WD 3 = DIAL-OUT LINK PHONE NUMBER ADDRESS             *219*
*
         LMW       R6,1W,X1 N.R.A.                      *219*
         BZ        $+2W    NO BIAS IF ZERO              *219*
         ARMW      R5,1W,X1 BIAS IT                     *219*
         LMW       R6,2W,X1 N.I.B.A.                    *219*
         BZ        $+2W    NO BIAS IF ZERO              *219*
         ARMW      R5,2W,X1 BIAS IT                     *219*
         LMW       R6,3W,X1 P.N.A.                      *219*
         BZ        $+2W    NO BIAS IF ZERO              *219*
         ARMW      R5,3W,X1 BIAS IT                     *219*
         BU        ACX.RET   WE ARE DONE, EXIT          *219*
*
SEND.OP  EQU       $       SEND PACKET                  *219*
*
* WD 1 OF PARAMETER BLOCK HAS BSD OR DATA ADDR          *219*
         TBM       0,0W,X1 IS THIS USER BUFFER ADDR     *219*
         BNS       OBTN.OP BIAS USER BUFF ADDRESS       *219*
*
* THIS IS A BSD ADDRESS (IN MEM POOL OR STATIC PART)    *219*
* PASS THIS ADDRESS ALONG AS IS, BECAUSE SYSTEM MODULES *219*
* ASSUME LOGICAL = PHYSICAL.  THESE MODULES HAVE BEEN   *219*
* 228IFIED TO GO UNMAPPED WHEN ACCESSING THE BSD ADDR.  *219*
*
         BU        ACX.RET   WE ARE DONE, EXIT          *219*
*
CONN.OP  EQU       $       CONNECT LOGICAL LINK         *219*
*
* WD 1 OF PARAMETER BLOCK HAS BSD OR DATA ADDR          *219*
         TBM       0,0W,X1 IS THIS USER BUFFER ADDR     *219*
         BNS       OBTN.OP BIAS USER BUFF ADDRESS       *219*
*
* THIS IS A BSD ADDRESS (IN MEM POOL OR STATIC PART)    *219*
* PASS THIS ADDRESS ALONG AS IS, BECAUSE SYSTEM MODULES *219*
* ASSUME LOGICAL = PHYSICAL.  THESE MODULES HAVE BEEN   *219*
* 228IFIED TO GO UNMAPPED WHEN ACCESSING THE BSD ADDR.  *219*
*
         BU        ACX.RET   WE ARE DONE, EXIT          *219*
*
OBTN.OP  EQU       $       OBTAIN LINK STATISTICS       *219*
*
* WD 1 OF PB HAS USER BUFFER ADDRESS                    *219*
*
         LMW       R6,1W,X1  GET BUFFER ADDRESS         *219*
         BZ        $+2W    SKIP IF ZERO                 *219*
         ARMW      R5,1W,X1  BIAS BUFFER ADDRESS        *219*
         BU        ACX.RET RETURN TO TXPM               *219*
*
RECV.OP  EQU       $       RECEIVE                      *219*
*
* FOUR WORD PSB                                         *219*
* WD 0 = FLAGS & STATUS                                 *219*
* WD 1 = BSD ADDRESS                                    *219*
* WD 2 = USER BUFFER ADDRESS                            *219*
* WD 3 = USER BUFFER LENGTH                             *219*
*
         LMW       R6,2W,X1 USER BUFFER ADDRESS         *219*
         BZ        $+2W    NO BIAS IF ZERO              *219*
         ARMW      R5,2W,X1 BIAS IT                     *219*
         BU        ACX.RET   WE ARE DONE, EXIT          *219*
*
*-----------------------------------------------------------------------
*
* NEW SVC 6, 7, AND E BIASING ROUTINES                  *219*
* THESE ROUTINES CAN BE MODIFIED FOR CUSTOM SVC'S       *219*
*
SVC6IN   DATAW     S6IN         ADDRESS OF SVC6IN TBL   *219*
SVC6OUT  DATAW     S6OUT        ADDRESS OF SVC6OUT TBL  *219*
SVC7IN   DATAW     S7IN         ADDRESS OF SVC7IN TBL   *219*
SVC7OUT  DATAW     S7OUT        ADDRESS OF SVC7OUT TBL  *219*
SVCEIN   DATAW     SEIN         ADDRESS OF SVCEIN TBL   *219*
SVCEOUT  DATAW     SEOUT        ADDRESS OF SVCEOUT TBL  *219*
X.SVCTN6 DATAH     S6.SZ        SIZE OF SVC 6 TBL       *219*
X.SVCTN7 DATAH     S7.SZ        SIZE OF SVC 7 TBL       *219*
X.SVCTNE DATAH     SE.SZ        SIZE OF SVC E TBL       *219*
*
* EQUATE TABLE FOR DISPATCH ROUTINE OFFSET              *219*
* ONE ENTRY DEFINED FOR EACH ENTRY IN XVTBLA            *219*
*
SEQ7.RET EQU       0            RET TO TXPM             *219*
SEQ7.17  EQU       1            SVC 7,X'17'             *219*
SEQ7.18  EQU       2            SVC 7,X'18'             *219*
SEQ7.20  EQU       3            SVC 7,X'20'             *219*
SEQ7.21  EQU       4            SVC 7,X'21'             *219*
SEQ7.22  EQU       5            SVC 7,X'22' PLUS OTHERS *219*
SEQ7.27  EQU       6            SVC 7,X'27'             *219*
SEQ7.19  EQU       7            SVC 7,X'19' & X'1A'     *219*
SEQ7.30  EQU       8            SVC 7,X'30'                         !272
SEQ7.34  EQU       9            SVC 7,X'34'                         !273
*
         BOUND     1W                                   *219*
*
* SVC6IN TABLE - FOR BIASING SVC 6'S                    *219*
*
*261 S6IN     DATAB     0            NO BIASING FOR NOW      *219*
*261 S6OUT    DATAB     0            NO BIASING FOR NOW      *219*
*
*261 S6.SZ    EQU       0            NO BIASING ROUTINES     *219*
S6IN     EQU       $            No biasing for now                  !261
*  Put input biasing routines byte selectors here                   !261
S6I.SZ   SET       $-S6IN                                           !261
S6OUT    EQU       $                                                !261
*  Put output biasing routine byte selectors here                   !261
S6O.SZ   SET       $-S6OUT                                          !261
S6.SZ    EQU       S6O.SZ       Size of SVC 6 table                 !261
*
         BOUND     1W                                   *219*
*
* SVC7IN TABLE - FOR BIASING SVC 7'S                    *219*
*
S7IN     DATAB     SEQ7.RET     SVC 7,00                *219*
         DATAB     SEQ7.RET     SVC 7,01 INT LVL GETBUF *219*
         DATAB     SEQ7.RET     SVC 7,02 INT LVL FREEBF *219*
         DATAB     SEQ7.RET     SVC 7,03 INT LVL TRNCBF *219*
         DATAB     SEQ7.RET     SVC 7,04 INT LVL ASYNOT *219*
         DATAB     SEQ7.RET     SVC 7,05                *219*
         DATAB     SEQ7.RET     SVC 7,06                *219*
         DATAB     SEQ7.RET     SVC 7,07                *219*
         DATAB     SEQ7.RET     SVC 7,08                *219*
         DATAB     SEQ7.RET     SVC 7,09                *219*
         DATAB     SEQ7.RET     SVC 7,0A                *219*
         DATAB     SEQ7.RET     SVC 7,0B                *219*
         DATAB     SEQ7.RET     SVC 7,0C                *219*
         DATAB     SEQ7.RET     SVC 7,0D                *219*
         DATAB     SEQ7.RET     SVC 7,0E                *219*
         DATAB     SEQ7.RET     SVC 7,0F                *219*
* FROM 10 ON ARE USER SVC'S                             *219*
         DATAB     SEQ7.RET     SVC 7,10 GET BUF NB     *219*
         DATAB     SEQ7.RET     SVC 7,11 FREE BUF NB    *219*
         DATAB     SEQ7.RET     SVC 7,12 TRUNC BUF NB   *219*
         DATAB     SEQ7.RET     SVC 7,13 SPLIT BSD NB   *219*
         DATAB     SEQ7.RET     SVC 7,14 CONCAT BSD NB  *219*
         DATAB     SEQ7.RET     SVC 7,15 INIT BPOOL NB  *219*
         DATAB     SEQ7.RET     SVC 7,16 INC BPOOL NB   *219*
         DATAB     SEQ7.17      SVC 7,17 GET STATS      *219*
         DATAB     SEQ7.18      SVC 7,18 ASYC NOTIF     *219*
         DATAB     SEQ7.19      SVC 7,19 DATA TO BUF    *219*
         DATAB     SEQ7.19      SVC 7,1A DATA FROM BUF  *219*
         DATAB     SEQ7.RET     SVC 7,1B CLEANUP NB     *219*
         DATAB     SEQ7.RET     SVC 7,1C                *219*
         DATAB     SEQ7.RET     SVC 7,1D                *219*
         DATAB     SEQ7.RET     SVC 7,1E                *219*
         DATAB     SEQ7.RET     SVC 7,1F                *219*
         DATAB     SEQ7.20      SVC 7,20 CONN REQ       *219*
         DATAB     SEQ7.21      SVC 7,21 ACCEPT CONN    *219*
         DATAB     SEQ7.22      SVC 7,22 REJECT CONN    *219*
         DATAB     SEQ7.RET     SVC 7,23 DISCONNECT NB  *219*
         DATAB     SEQ7.22      SVC 7,24 SEND DATA      *219*
         DATAB     SEQ7.22      SVC 7,25 SEND EXP DATA  *219*
         DATAB     SEQ7.22      SVC 7,26 REC DATA       *219*
         DATAB     SEQ7.27      SVC 7,27 IDENTIFY       *219*
         DATAB     SEQ7.21      SVC 7,28 CANCEL ID      *219*
         DATAB     SEQ7.RET     SVC 7,29 GET LLCA ADR NB*219*
         DATAB     SEQ7.RET     SVC 7,2A EXIT CLEANUP NB*219*
         DATAB     SEQ7.RET     SVC 7,2B                *219*
         DATAB     SEQ7.RET     SVC 7,2C                *219*
         DATAB     SEQ7.RET     SVC 7,2D                *219*
         DATAB     SEQ7.RET     SVC 7,2E                *219*
         DATAB     SEQ7.RET     SVC 7,2F                *219*
         DATAB     SEQ7.30      SVC 7,30                            !272
         DATAB     SEQ7.RET     SVC 7,31                            !273
         DATAB     SEQ7.RET     SVC 7,32                            !273
         DATAB     SEQ7.RET     SVC 7,33                            !273
         DATAB     SEQ7.34      SVC 7,34                            !273
S7I.SZ   SET       $-S7IN                                           !261
*
* SVC7OUT TABLE - FOR BIASING SVC 7'S                   *219*
*
S7OUT    DATAB     SEQ7.RET     SVC 7,00                *219*
         DATAB     SEQ7.RET     SVC 7,01 INT LVL GETBUF *219*
         DATAB     SEQ7.RET     SVC 7,02 INT LVL FREEBF *219*
         DATAB     SEQ7.RET     SVC 7,03 INT LVL TRNCBF *219*
         DATAB     SEQ7.RET     SVC 7,04 INT LVL ASYNOT *219*
         DATAB     SEQ7.RET     SVC 7,05                *219*
         DATAB     SEQ7.RET     SVC 7,06                *219*
         DATAB     SEQ7.RET     SVC 7,07                *219*
         DATAB     SEQ7.RET     SVC 7,08                *219*
         DATAB     SEQ7.RET     SVC 7,09                *219*
         DATAB     SEQ7.RET     SVC 7,0A                *219*
         DATAB     SEQ7.RET     SVC 7,0B                *219*
         DATAB     SEQ7.RET     SVC 7,0C                *219*
         DATAB     SEQ7.RET     SVC 7,0D                *219*
         DATAB     SEQ7.RET     SVC 7,0E                *219*
         DATAB     SEQ7.RET     SVC 7,0F                *219*
* FROM 10 ON ARE USER SVC'S                             *219*
         DATAB     SEQ7.RET     SVC 7,10 GET BUF NB     *219*
         DATAB     SEQ7.RET     SVC 7,11 FREE BUF NB    *219*
         DATAB     SEQ7.RET     SVC 7,12 TRUNC BUF NB   *219*
         DATAB     SEQ7.RET     SVC 7,13 SPLIT BSD NB   *219*
         DATAB     SEQ7.RET     SVC 7,14 CONCAT BSD NB  *219*
         DATAB     SEQ7.RET     SVC 7,15 INIT BPOOL NB  *219*
         DATAB     SEQ7.RET     SVC 7,16 INC BPOOL NB   *219*
         DATAB     SEQ7.17      SVC 7,17 GET STATS      *219*
         DATAB     SEQ7.18      SVC 7,18 ASYC NOTIF     *219*
         DATAB     SEQ7.19      SVC 7,19 DATA TO BUF    *219*
         DATAB     SEQ7.19      SVC 7,1A DATA FROM BUF  *219*
         DATAB     SEQ7.RET     SVC 7,1B CLEANUP NB     *219*
         DATAB     SEQ7.RET     SVC 7,1C                *219*
         DATAB     SEQ7.RET     SVC 7,1D                *219*
         DATAB     SEQ7.RET     SVC 7,1E                *219*
         DATAB     SEQ7.RET     SVC 7,1F                *219*
         DATAB     SEQ7.20      SVC 7,20 CONN REQ       *219*
         DATAB     SEQ7.21      SVC 7,21 ACCEPT CONN    *219*
         DATAB     SEQ7.22      SVC 7,22 REJECT CONN    *219*
         DATAB     SEQ7.RET     SVC 7,23 DISCONNECT NB  *219*
         DATAB     SEQ7.22      SVC 7,24 SEND DATA      *219*
         DATAB     SEQ7.22      SVC 7,25 SEND EXP DATA  *219*
         DATAB     SEQ7.22      SVC 7,26 REC DATA       *219*
         DATAB     SEQ7.27      SVC 7,27 IDENTIFY       *219*
         DATAB     SEQ7.21      SVC 7,28 CANCEL ID      *219*
         DATAB     SEQ7.RET     SVC 7,29 GET LLCA ADR NB*219*
         DATAB     SEQ7.RET     SVC 7,2A EXIT CLEANUP NB*219*
         DATAB     SEQ7.RET     SVC 7,2B                *219*
         DATAB     SEQ7.RET     SVC 7,2C                *219*
         DATAB     SEQ7.RET     SVC 7,2D                *219*
         DATAB     SEQ7.RET     SVC 7,2E                *219*
         DATAB     SEQ7.RET     SVC 7,2F                *219*
         DATAB     SEQ7.30      SVC 7,30                            !272
         DATAB     SEQ7.RET     SVC 7,31                            !273
         DATAB     SEQ7.RET     SVC 7,32                            !273
         DATAB     SEQ7.RET     SVC 7,33                            !273
         DATAB     SEQ7.34      SVC 7,34                            !273
*
*261 S7.SZ    EQU       48           NUMBER OF SVC 7'S DEF'D *219*
S7O.SZ   SET       $-S7OUT                                          !261
S7.SZ    EQU       S7O.SZ       Size of SVC 7 table                 !261
*
         BOUND     1W                                   *219*
*
* SVCEIN TABLE - FOR BIASING SVC E'S                    *219*
*
*261 SEIN     DATAB     0            NO BIASING FOR NOW      *219*
*261 SEOUT    DATAB     0            NO BIASING FOR NOW      *219*
*
*261 SE.SZ    EQU       0            NO BIASING ROUTINES     *219*
SEIN     EQU       $            No biasing for now                  !261
*  Put input biasing routines byte selectors here                   !261
SEI.SZ   SET       $-SEIN                                           !261
SEOUT    EQU       $                                                !261
*  Put output biasing routine byte selectors here                   !261
SEO.SZ   SET       $-SEOUT                                          !261
SE.SZ    EQU       SEO.SZ       Size of SVC E table                 !261
*
* BIASING ROUTINE DISPATCH TABLE                        *219*
* ONE ENTRY FOR EACH DIFFERENT BIASING ROUTINE          *219*
* DEFINED FOR SVC 6, 7, AND E                           *219*
*
         BOUND     1W                                   *219*
*
XVTBLA   ACW       SVC7.RET     RETURN TO TXPM      0   *219*
         ACW       SVC7.17      SVC 1,X'17'         1   *219*
         ACW       SVC7.RET     RETURN TO TXPM      2   *222*
         ACW       SVC7.20      SVC 1,X'20'         3   *219*
         ACW       SVC7.21      SVC 1,X'21'         4   *219*
         ACW       SVC7.22      SVC 1,X'22'         5   *219*
         ACW       SVC7.27      SVC 1,X'27'         6   *219*
         ACW       SVC7.19      SVC 1,X'19' & X'1A' 7   *219*
         ACW       SVC7.30      SVC 1,X'30'         8               !273
         ACW       SVC7.34      SVC 1,X'34'         9               !273
         ACW       $-$          ADD NEW ROUTN HERE 10   *219*       !273
*
**********************************************************************
*
* ROUTINE TO RETURN TO TXPM                             *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.RET TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER'S R1                             *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.17  EQU       $            GET STATS SVC 7,X'17'   *219*
         BIAS.R    1            BIAS BUFFER ADDRESS     *219*
         TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER'S R6 - DATA ADDRESS              *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.19  EQU       $            GET/DATA SVC 7,X'19',1A *219*
         BIAS.R    6            BIAS DATA ADDRESS       *232*
         TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER CONNECT REQUEST BLOCK -> BY R3   *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.20  EQU       $            CONN REQ SVC 7,X'20'    *219*
         TRR       R2,R7        SAVE R2                             !273
         LMW       R2,3W,X1     GET CONN REQ BLK ADDR   *219*       !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST  *219*
         BNS       $+2W         NO, THIS IS REBIAS      *219*
         ADR       R5,R2        BIAS CBA                *219*       !273
         CAMW      R2,C.TSAD    ABOVE OS?               *219*       !273
         BGE       S7.20.1      BR IF YES               *219*
         LW        R5,=C'TX01'  ABORT CODE              *219*
         BU        BORT.USR     ABORT THE USER          *219*
S7.20.1  LMW       R6,5W,X2     GET MSG LENGTH          *219*       !273
         BZ        S7.20.2      NO USER ADDR IF ZERO    *219*
         LMW       R6,4W,X2     CONN DATA ADDR          *219*       !273
         BZ        $+2W         SKIP IF ZERO            *219*
         ARMW      R5,4W,X2     BIAS ADDRESS            *219*       !273
S7.20.2  TRR       R7,R2        RESTORE R2                          !273
         BIAS.R    3            BIAS CONN BLK ADDRESS   *219*
         TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER'S R3                             *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.21  EQU       $            ACCEPT CONN SVC 7,X'21' *219*
         BIAS.R    3            BIAS ACB ADDRESS        *219*
         TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER REJECT CONNECT BLOCK -> BY R3    *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.22  EQU       $            CONN REJ SVC 7,X'22'    *219*
         TRR       R2,R7        SAVE R2                             !273
         LMW       R2,3W,X1     GET REJ CONN BLK ADDR   *219*       !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST  *219*
         BNS       $+2W         NO, THIS IS REBIAS      *219*
         ADR       R5,R2        BIAS RBA                *219*       !273
         CAMW      R2,C.TSAD    ABOVE OS?               *219*       !273
         BGE       S7.22.1      BR IF YES               *219*
         LW        R5,=C'TX01'  ABORT CODE              *219*
         BU        BORT.USR     ABORT THE USER          *219*
S7.22.1  LMW       R6,2W,X2     GET MSG LENGTH          *219*       !273
         BZ        S7.22.2      NO USER ADDR IF ZERO    *219*
         LMW       R6,1W,X2     REJ CONN DATA ADDR      *219*       !273
         BZ        $+2W         SKIP IF ZERO            *219*
         ARMW      R5,1W,X2     BIAS ADDRESS            *219*       !273
S7.22.2  TRR       R7,R2        RESTORE R2                          !273
         BIAS.R    3            BIAS REJ CONN BLK ADDR  *219*
         TRSW      R0           RETURN TO TXPM          *219*
*
**********************************************************************
*
* ROUTINE TO BIAS USER IDENTIFICATION BLOCK -> BY R3    *219*
*
         BOUND     1W           ALL ROUTN'S ON WD BDY   *219*
SVC7.27  EQU       $            IDENTIFY SVC 7,X'27'    *219*
         TRR       R2,R7        SAVE R2                             !273
         LMW       R2,3W,X1     GET ID BLK ADDR         *219*       !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST  *219*
         BNS       $+2W         NO, THIS IS REBIAS      *219*
         ADR       R5,R2        BIAS RBA                *219*       !273
         CAMW      R2,C.TSAD    ABOVE OS?               *219*       !273
         BGE       S7.27.1      BR IF YES               *219*
         LW        R5,=C'TX01'  ABORT CODE              *219*
         BU        BORT.USR     ABORT THE USER          *219*
S7.27.1  LMW       R6,2W,X2     GET NOTF RTN ADDR       *219*       !273
         BZ        $+2W         SKIP IF ZERO            *219*
         ARMW      R5,2W,X2     BIAS ADDRESS            *219*       !273
         LMW       R6,3W,X2     GET NOTF INF BLD ADDR   *219*       !273
         BZ        $+2W         SKIP IF ZERO            *219*
         ARMW      R5,3W,X2     BIAS ADDRESS            *219*       !273
         TRR       R7,R2        RESTORE R2                          !273
         BIAS.R    3            BIAS ID BLK ADDR        *219*
         TRSW      R0           RETURN TO TXPM          *219*
*                                                                   !273
* ROUTINE TO BIAS PROTOCOL REQUEST BLOCK => R2                      !273
*                                                                   !273
         BOUND     1W                                               !273
SVC7.30  EQU       $            IDENTIFY SVC 7,X'30'                !273
         TRR       R2,R7        SAVE R2                             !273
         LMW       R2,2W,X1     GET PROT BLK ADDR                   !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST              !273
         BNS       $+2W         NO, THIS IS REBIAS                  !273
         ADR       R5,R2        BIAS RBA                            !273
         CAMW      R2,C.TSAD    ABOVE OS?                           !273
         BGE       S7.30.1      BR IF YES                           !273
         LW        R5,=C'TX01'  ABORT CODE                          !273
         BU        BORT.USR     ABORT THE USER                      !273
S7.30.1  LW        R6,1W,X2     GET OPCODE                          !274
         CI        R6,4         SEND REQUEST?                       !274
         BNE       S7.30.2      NO, CHECK OTHER OPCODES             !274
         LMW       R6,2W,X2     GET DATA ADDRESS                    !273
         BZ        $+2W         SKIP IF ZERO                        !273
         ARMW      R5,2W,X2     BIAS ADDRESS                        !273
         BU        S7.30.9      GO BIAS R2                          !274
*
S7.30.2  CI        R6,1         OPEN REQUEST?                       !274
         BNE       S7.30.3      BRANCH IF NO                        !274
         LMW       R6,9W,X2     GET USER NOT. ADDRESS               !274
         BZ        $+2W         SKIP IF ZERO                        !274
         ARMW      R5,9W,X2     BIAS ADDRESS                        !274
         LMW       R6,10W,X2    GET UNB ADDRESS                     !274
         BZ        $+2W         SKIP IF ZERO                        !274
         ARMW      R5,10W,X2    BIAS ADDRESS                        !274
         BU        S7.30.9      GO DO R2                            !274
*
S7.30.3  CI        R6,2         SET CONFIGURATION REQUEST?          !274
         BEQ       S7.30.9      IF SO, NO ADDRESSES, GO DO R2       !274
         CI        R6,10        STATUS REQUEST?                     !274
         BEQ       S7.30.9      IF SO, NO ADDRESSES, GO DO R2       !274
*                               THIS IS FOR ANY OTHER OPCODES       !274
*                               THAT WE MAY NOT KNOW ABOUT          !274
*                               BIAS WORD 2, 9, AND 10 IF A TASK    !274
*                               ADDRESS                             !274
         LMW       R6,2W,X2     GET BUFFER ADDRESS                  !274
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST              !273
         BNS       $+2W         NO, THIS IS REBIAS                  !273
         ADR       R5,R6        BIAS RBA                            !273
         CAMW      R6,C.TSAD    ABOVE OS?                           !273
         BLT       $+2W         SKIP IF NOT TASK ADDRESS            !273
         ARMW      R5,2W,X2     BIAS ADDRESS                        !273
*
         LW        R6,4W,X2     GET PRB LENGTH                      !274
         CI        R6,40        WORD 9 PRESENT?                     !274
         BLT       S7.30.9      NO, DON'T BIAS 9 OR 10              !274
         LMW       R6,9W,X2     GET NOTIFICATION A                  !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST              !273
         BNS       $+2W         NO, THIS IS REBIAS                  !273
         ADR       R5,R6        BIAS RBA                            !273
         CAMW      R6,C.TSAD    ABOVE OS?                           !273
         BLT       $+2W         SKIP IF NOT TASK ADDRESS            !273
         ARMW      R5,9W,X2     BIAS ADDRESS                        !273
*
         LW        R6,4W,X2     GET PRB LENGTH                      !274
         CI        R6,44        WORD 10 PRESENT?                    !274
         BLT       S7.30.9      NO, DON'T BIAS 10                   !274
         LMW       R6,10W,X2    GET NOTFICATION B                   !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST              !273
         BNS       $+2W         NO, THIS IS REBIAS                  !273
         ADR       R5,R6        BIAS RBA                            !273
         CAMW      R6,C.TSAD    ABOVE OS?                           !273
         BLT       $+2W         SKIP IF NOT TASK ADDRESS            !273
         ARMW      R5,10W,X2    BIAS ADDRESS                        !273
*
S7.30.9  TRR       R7,R2        RESTORE R2                          !273
         BIAS.R    2            BIAS PROT BLK ADDR                  !273
         TRSW      R0           RETURN TO TXPM                      !273
*                                                                   !273
* ROUTINE TO BIAS INDICATION REQUEST BLOCK => R2                    !273
*                                                                   !273
         BOUND     1W                                               !273
SVC7.34  EQU       $            IDENTIFY SVC 7,X'34'                !273
         TRR       R2,R7        SAVE R2                             !273
         LMW       R2,2W,X1     GET INDI BLK ADDR                   !273
         TBM       TSK.SVC,TSK.LVL,X3  BIAS ADDR FIRST              !273
         BNS       $+2W         NO, THIS IS REBIAS                  !273
         ADR       R5,R2        BIAS RBA                            !273
         CAMW      R2,C.TSAD    ABOVE OS?                           !273
         BGE       S7.34.1      BR IF YES                           !273
         LW        R5,=C'TX01'  ABORT CODE                          !273
         BU        BORT.USR     ABORT THE USER                      !273
S7.34.1  LMW       R6,0W,X2     GET USER UIB ADDR                   !273
         BZ        $+2W         SKIP IF ZERO                        !273
         ARMW      R5,0W,X2     BIAS ADDRESS                        !273
         LMW       R6,2W,X2     GET USER DATA BUFFER ADDR           !273
         BZ        $+2W         SKIP IF ZERO                        !273
         ARMW      R5,2W,X2     BIAS ADDRESS                        !273
         TRR       R7,R2        RESTORE R2                          !273
         BIAS.R    2            BIAS INDI BLK ADDR                  !273
         TRSW      R0           RETURN TO TXPM                      !273
*
MO       ANOP                                           *237*
OS15E    ANOP                                                   *238*
         LPOOL
**********************************************************************
*
*  THIS IS THE START OF THE VARIABLE CODE AND DATA AREA
*  IF AN IPU IS CONFIGURED, THIS CODE WILL REMAIN INTACT AND
*  THE TRAP, INTERRUPT, AND CONTEXT AREAS WILL FOLLOW.
*
*  IF AN IPU IS NOT CONFIGURED, THIS CODE WILL BE OVERLAID
*  DURING SYSGEN INITIALIZATION WITH THE TRAP, INTERRUPT, AND
*  CONTEXT AREAS.  UNUSED AREAS WILL BE RELEASED DURING SYSGEN.
*
**********************************************************************
         BOUND     1D              IF NO IPU, MUST BE DW BOUND
IPU.CODE EQU       $               START OF IPU SUPPORT CODE
         IFF       C.MPXOUT,MO                                  *237*
         IFF       OS.15E,OS15E                                 *238*
*        ROUTINE TO TEST IF IN H.TXPM
S.TRV.X  BGT       S.X.00          BR IF ABOVE H.IPU
         LH        R5,C.MPAH       GET HIGHEST PATCH ADDRESS
         CAR       R5,R6           SEE IF BELOW PATCH AREA
         BLT       *IPU.04         GO LET TRAP FINISH
*      SEE IF XEQ'ING IN IP0F
         LA        R5,IP0F.ICB     IP0F ENTRY ADDRESS
         CAR       R5,R6           SEE IF BELOW
         BGT       S.X.06          BR IF BELOW
*      AT THIS POINT ADDR .GT. IP0F
         LA        R5,IP0FS        GET ENDING ADDRESS
         CAR       R5,R6           SEE IF ABOVE END
         BLT       *IPU.04         GO LET TRAP FINISH
S.X.06   BU        *-*             RETURN TO SEE IF IN H.IPU
S.X.00   CAMW      R6,HAT+1W       SEE IF IN USER ABOVE TXPM
         BGT       *IPU.12         IF ABOVE HANDLER, HALT IPU
         LA        R5,EXEC.05      START OF TXPM
         CAR       R5,R6           SEE IF BELOW TXPM
         BGT       *IPU.04         GO LET TRAP FINISH
*      SEE IF XEQ'ING IN IP0F
         LA        R5,IP0F.ICB     IP0F ENTRY ADDRESS
         CAR       R5,R6           SEE IF BELOW
         BGT       *IPU.12         BELOW, SO STOP IPU
*      AT THIS POINT ADDR .GT. IP0F
         LA        R5,IP0FS        GET ENDING ADDRESS
         CAR       R5,R6           SEE IF ABOVE END
         BLT       *IPU.04         GO LET TRAP FINISH
         BU        *IPU.12         BELOW, SO STOP IPU
*
IPU.04   DATAW     $-$             ADDRESS OF IPU.4 IN H.IPU
IPU.12   DATAW     $-$             ADDRESS OF IPU.12 IN H.IPU
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
IDSPREGS RES       1F              STORAGE FOR DISPATCH REGS
*
*-----------------------------------------------------------------------
*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD'.
*
*                  MAIN IPU DISPATCH
S.TRV.50 SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG
         STF       R0,IDSPREGS     SAVE USER REGS
         LA        R2,IDSPREGS      REG SAVE AREA ADDRESS
IPU.REPL LD        R6,0            EXEC.D1
         ZBR       R7,17           NO BLOCK BIT IN IPU
         BL        S.TXPM.0
         LF        R0,IDSPREGS      RESTORE USERS REGS
         IFT       OS.32X,IF.05
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
IF.05    ANOP
         IFF       OS.32X,IF.06
         ZBM       IPU.GATE,EXEC.FLG  TELL CPU OK TO SIPU
IF.06    ANOP
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG
IPU.RET  LPSD      0               EXEC.D1
         IFT       OS.32X,T.51.E
*
*-----------------------------------------------------------------------
*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD'.
*
*                  IPU IP09 DISPATCH
S.TRV.51 SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG
         STF       R0,IPUREGS
         LA        R2,IPUREGS      REG SAVE AREA ADDRESS
IPU9.RPL LD        R6,0            EXEC.D1
         BL        S.TXPM.0
         LF        R0,IPUREGS      RESTORE USERS REGS
         IFT       OS.32X,IF.0C
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
IF.0C    ANOP
         IFF       OS.32X,IF.0D
         ZBM       IPU.GATE,EXEC.FLG  TELL CPU OK TO SIPU
IF.0D    ANOP
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG
IPU9.RET LPSD      0               EXEC.D1
T.51.E   ANOP
*
*-----------------------------------------------------------------------
*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD'.
*
*                  IPU IP0F DISPATCH
S.TRV.52 SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG
         STF       R0,IPUREGS
         LA        R2,IPUREGS      REG SAVE AREA ADDRESS
IPUF.RPL LD        R6,0            EXEC.D1
         ZBR       R7,17           NO BLOCK BIT IN IPU
         BL        S.TXPM.0
         LF        R0,IPUREGS      RESTORE USERS REGS
         IFT       OS.32X,IF.0E
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
IF.0E    ANOP
         IFF       OS.32X,IF.0F
         ZBM       IPU.GATE,EXEC.FLG  TELL CPU OK TO SIPU
IF.0F    ANOP
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG
IPUF.RET LPSD      0               EXEC.D1
*
*-----------------------------------------------------------------------
*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD'.
*  IT IS THE DISPATCH FOR SVC 1 AND 2
*                  IPU SVC DISPATCH
S.TRV.53 SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG
         STF       R0,IPUREGS
         LA        R2,IPUREGS      REG SAVE AREA ADDRESS
ISVC.RPL LD        R6,0            SVC.PSD
         ZBR       R7,17           NO BLOCK BIT IN IPU
         BL        S.TXPM.0
         LF        R0,IPUREGS      RESTORE USERS REGS
         IFT       OS.32X,IF.0E
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
IF.0E    ANOP
         IFF       OS.32X,IF.0F
         ZBM       IPU.GATE,EXEC.FLG  TELL CPU OK TO SIPU
IF.0F    ANOP
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG
ISVC.RET LPSD      0               SVC.PSD
*
*-----------------------------------------------------------------------
*
*  CHECK FOR OVERRUN OF CONFIGURED MAPS
*  CALLED FROM H.IPU BEFORE LPSDCM
*
S.TRV.54 LW        R1,C.CIPU       DQE ADDRESS                  *229*
         LW        R3,DQE.PSSF,X1  CONTEXT ADDR
         TBM       TSK.TXPM,TSK.FLG1,X3  T-XPM TASK?
         BNS       TRV54RPL        BRANCH IF NOT
         LB        R3,DQE.TAN,X1   GET TASK NUMBER
         IFT       C.3227,TRV54X
         SLL       R3,3            GET MPL OFFSET - 3X
TRV54X   ANOP
         IFF       C.3227,TRV54X
         SLL       R3,2            GET MPL OFFSET - 7X
TRV54X   ANOP
         ADMW      R3,C.MPL        CALC MPL ENTRY ADDR
         IFT       C.3227,TRV54X
         LH        R4,1H,X3        GET # OF USER MAPS
TRV54X   ANOP
         IFF       C.3227,TRV54X
         LB        R4,*0W,X3       GET # OF USER MAPS
TRV54X   ANOP
         LH        R5,C.HIMAP      FETCH # OF CONFIGURED MAPS
         ADI       R5,1            C.HIMAP NUMBERED FROM 0
         SUMB      R5,C.MSD        LESS SIZE OF O/S
         CAR       R5,R4           TOO MANY MAPS SPECIFIED
         BLT       TRV54RPL        BRANCH IF # NOT EXCEEDED
         IFT       C.3227,TRV54X
         STH       R5,1H,X3        CLAMP MAX COUNT
TRV54X   ANOP
         IFF       C.3227,TRV54X
         STB       R5,*0W,X3       CLAMP MAX COUNT
TRV54X   ANOP
TRV54RPL LPSDCM    $-$             REPLACED INSTRUCTION         *220*
         IFT       OS.32X,DS.34                                 *232*
         IFF       OS.32A,DS.34                                 *232*
         IFF       OS.32B,DS.34                                 *232*
         IFF       OS.32C,DS.34                                 *232*
         IFF       OS.UCS,DS.34                                 *232*
         IFF       OS.U03,DS.34                                 *232*
         IFF       OS.33,DS.34                                  *232*
         IFF       OS.U02,DS.34                                 *232*
         IFF       OS.34,DS.34                                  *232*
         IFF       OS.34U01,DS.34                               *232*
*                                  IN 34U02, 34U03, 35          *232*
*                                                               *228*
*---------------------------------------------------------------*228*
*                                                               *228*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD' *228*
*                                                               *228*
*              IPU UNIMPLEMENTED INSTRUCTION DISPATCH           *228*
IPUI.DSP SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG           *228*
         STF       R0,IPUREGS                                   *228*
         LA        R2,IPUREGS      REG SAVE AREA ADDRESS        *228*
IPUI.RPL LD        R6,0            UIT.OLD                      *228*
         ZBR       R7,17           NO BLOCK BIT IN IPU          *228*
         BL        S.TXPM.0        DISPATCH TO TXPM TASK        *228*
         LF        R0,IPUREGS      RESTORE USERS REGS           *228*
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU          *228*
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG         *228*
IPUI.RT  LPSD      0               UIT.OLD                      *228*
*                                                               *228*
*---------------------------------------------------------------*228*
*                                                               *228*
*  THIS ROUTINE IS EXECUTED BY THE IPU PRIOR TO DOING AN 'LPSD' *228*
*                                                               *228*
*              IPU PRIVLEDGE VIOLATION DISPATCH                 *228*
IPPV.DSP SBM       IN.TXPM,TXPMFLGS  SET IN TXPM FLAG           *228*
         STF       R0,IPUREGS                                   *228*
         LA        R2,IPUREGS      REG SAVE AREA ADDRESS        *228*
IPPV.RPL LD        R6,0            PVT.OLD                      *228*
         ZBR       R7,17           NO BLOCK BIT IN IPU          *228*
         BL        S.TXPM.0        DISPATCH TO TXPM TASK        *228*
         LF        R0,IPUREGS      RESTORE USERS REGS           *228*
         IFF       OS.36,O36                                    !284
         ZBM       C.ICSIPU,C.BIT  TELL CPU OK TO SIPU          *228*
O36      ANOP                                                   !284
         IFT       OS.36,O36                                    !284
         ZBM       C.IPUCSI,C.IPUFLG TELL CPU OK TO SIPU        !284
O36      ANOP                                                   !284
         ZBM       IN.TXPM,TXPMFLGS  CLEAR IN TXPM FLAG         *228*
IPPV.RT  LPSD      0               PVT.OLD                      *228*
*                                                               *228*
DS.34    ANOP                                                   *228*
*                                                               *228*
OS15E    ANOP                                                   *238*
*
*  Now define the SVC index that MPX uses for its M.CALLs.          !268
*  TXPM will check 0 first, then this value, which will be          !268
*  either 0 (for pre-3.5) or 6.                                     !268
MCALL    SET       0                                                !268
         IFT       OS.35,DO.SVC                                     !268
MCALL    SET       6                                                !268
DO.SVC   ANOP                                                       !268
PTCH.MCL DATAB     MCALL                                            !268
         LPOOL                     MORE LITERALS HERE
         TITLE     H.PTCH -- REMAP PROCESSOR -- SYSGEN INIT (TRAPS)
*
*  SET UP ALL TRAP CONTEXT BLOCKS (BASED UPON VECTORS IN SCRATCHPAD)
*
T.INIT   EQU       $               INITIALIZATION ENTRY POINT
         M.EIR
*DBG          LCS       R7                                               !281
*DBG          TBR       R7,3                                             !281
*DBG          BNS       NO.INFLP                                         !281
*DBG          TBR       R7,5                                             !281
*DBG          BNS       NO.INFLP                                         !281
*DBG          BU        $                                                !281
NO.INFLP EQU       $                                                !281
         IFF       OS.15E,OS15E                                 *238*
         M.SVCT    SVCTAB,SVC.END  TELL MPX ABOUT SVC 1,3
OS15E    ANOP                                                   *238*
         IFT       OS.15E,OS15E                                 *238*
         M.SVCT    SVCTAB,SVC.END  TELL MPX ABOUT SVC 1,3       *238*
OS15E    ANOP                                                   *238*
         IFF       OS.15E,OS15E                                 *238*
         IFF       C.MPXOUT,MO                                  *237*
*
*      SEE IF IPU PRESENT AND IF NOT, DELETE IPU CODE
*
         TBM       2,C.CONF        IS AN IPU PRESENT
         BS        $+3W            BR IF YES, LEAVE CODE IN
MO       ANOP                                                   *237*
         LA        R1,IPU.CODE     ADDRESS OF CODE TO OVERLAY
         STW       R1,HAT+1W       UPDATE END ADDRESS
*  Check to see if the SVC 6, 7, and E tables are okay              !261
         LI        R3,S6I.SZ       Size of SVC 6 input table        !261
         CI        R3,S6O.SZ       Does it equal size of SVC6 out?  !261
         BNE       NFND.3          Go if no; abort                  !261
         LI        R3,S7I.SZ       Size of SVC 7 input table        !261
         CI        R3,S7O.SZ       Does it equal size of SVC7 out?  !261
         BNE       NFND.3          Go if no; abort                  !261
         LI        R3,SEI.SZ       Size of SVC 7 input table        !261
         CI        R3,SEO.SZ       Does it equal size of SVCE out?  !261
         BNE       NFND.3          Go if no; abort                  !261
*
OS15E    ANOP                                                   *238*
*  This is the end of SH.PTCH; you must concatenate another file    !283
*  here before you have a complete module.                          !283
