/* This routine picks up arguments from the command line and constructs
 * an argument list for a C program.  In the process, input and output
 * redirection is performed if indicated.  */

/* 12/18/85 added redirection of stderr. */
/* 2/4/86 changed stdin to open LFC=UT when interactive */

#include "@system(include)stdio.h"
#include "@system(include)errno.h"
#define ARGCNT 20   /* WAS 8 */
#define ARGLEN 80     /* was 30 */
#define LINELEN 256  /* was 80 */
#define READ 0
#define WRITE 1
#define NULL 0
#define MPX_DEFAULT 0

struct _myidbl _myid; /* the external definition of the data block from myid */

_mpxinit()

{
#include "@system(include)version.h"
   int    argc = 0;                /* argument counter */
   char   *argv[ARGCNT];           /* pointers to arguments */
   char   argbuf[LINELEN];         /* buffer for argument strings */
   char   *argptr;                 /* pointer into argbuf */
   char   *argpin = 0;             /* pointer into argbuf (in redir)*/
   char   *argpot = 0;             /* pointer into argbuf (out redir)*/
   char   *argper = 0;             /* pointer into argbuf (err redir)*/
   int    sotapp = 0;              /* stdout redir and append   */
   int    serapp = 0;              /* stderr redir and append   */
   int    sersot = 0;              /* stderr redir to stdout   */
   int    argsize;                 /* argument size */
   int    sin,sout,eout;           /* file descriptors for input/output */
   int    i,j;
   int    exmode;                  /* execute mode */
   char   *iinp = "LFC=UT";        /* interactive input JCB  */
   char   *jinp = "SYC";           /* job input */
   char   *actinp;                 /* actual input */
   char   *iout = "LFC=UT";        /* interactive output  */
   char   *jout = "SLO";           /* job output */
   char   *actout;                 /* actual output */
   char   *ierr = "LFC=UT";        /* interactive output  */
   char   *jerr = "SLO";           /* job output */
   char   *acterr;                 /* actual output */
   char   taskid[9];               /* task id string  */


   exmode = _mpxin2();             /* Find out if task was activated  */
   for(i=0;i<8;i++) taskid[i] = ((j=_myid._lm[i])!=' ')?j:'\0';
   taskid[8] = '\0';
   argv[argc++] = taskid;      /* set up first argument in list */
   if(exmode) {                /*  If task was TSM or JOB   */
      actinp = ((exmode == 'J')?jinp: iinp);
      actout = ((exmode == 'J')?jout: iout);
      acterr = ((exmode == 'J')?jerr: ierr);
      argptr = argbuf;                /* set argument buffer pointer */


      /* get arguments until last one found from command line */
      while ((argsize = tscan(argptr,ARGLEN)) != 0) {
         char *curptr = argptr;  /* pointer to actual CL arguments */
         argptr += argsize;   /* argptr points after arg string */
         *argptr++ = NULL;  /* null terminate string */
              /* Check if argument is a redirection argument */
         switch(*curptr){
           case '<':
            argpin = curptr + 1;    /* input redirection */
            break;
           case '>':
            if (*++curptr != '>')   /* check for append mode */
               argpot = curptr;
            else {
               sotapp = 1;
               argpot = curptr + 1;
            }
            break;
           case '2':
            if (*++curptr != '>') { /* check for redirect of stderr */
               argv[argc++] = --curptr;
               break;               /* add argument to argument list*/
            }
            else {
               /* stderr is redirected somewhere */
               switch (*++curptr) {
                 case '>':          /* append */
                  argper = curptr + 1;
                  serapp = 1;
                  break;
                 case '&':    /* redir to ? (only stdout so far)*/
                  if(*++curptr == '1') sersot = 1;
            /* redir to stdout(which may not have been redirected yet)*/
                  break;
                 default:           /* redir to file */
                  argper = curptr;
                  break;
               }
            }
            break;
           default:
            argv[argc++] = curptr;    /* add argument to argument list*/
         }
      }

      argv[argc] = (char *)NULL;  /* null terminate argv JCB */

      if (argpin) {            /* REDIRECTION OF STDIN */
         if ((sin = open(argpin,READ)) != 0) _exitmpx("in2 ");
      } else                   /* NO REDIRECTION OF STDIN */
         if ((sin = open(actinp,READ)) != 0) _exitmpx("in1 ");


      if (argpot) {           /* REDIRECTION OF STDOUT */

         if (sotapp) {        /* WITH APPEND MODE */

            errno = 0;
            if ((sout = open(argpot,WRITE)) == 1) {
               if (seek(sout,0,2) < 0) _exitmpx("out3");
            } else if (errno == E004) {
               if ((sout = creat(argpot,MPX_DEFAULT)) != 1)
                  _exitmpx("out1");
            }

         } else {             /* WITHOUT APPEND MODE */

            /* check for keywords list, print and null */
            if (strcmp(argpot,"LIST") == 0 ||
                strcmp(argpot,"list") == 0)     /* LIST ?*/
               sout = open(actout,WRITE);       /* yes, open term */
            else if (strcmp(argpot,"PRINT") == 0 ||
                     strcmp(argpot,"print") == 0)  /* PRINT? */
               sout = open(jout,WRITE);            /* yes, open SLO */
            else if (strcmp(argpot,"NULL") == 0 ||
                     strcmp(argpot,"null") == 0)   /* NULL? */
               sout = open("DEV=NU",WRITE);        /* yes, open null */
            else if ((sout = creat(argpot,MPX_DEFAULT)) != 1)
               _exitmpx("out4");
         }
      } else {            /* NO REDIRECTION OF STDOUT */
         if ((sout = open(actout,WRITE)) != 1) _exitmpx("out6");
      }


      if (sersot) {  /* STDERR ONTO STDOUT */
            if ((eout = open("LFC=UX1",WRITE)) != 2)
               _exitmpx("err7");
      } else if (argper) {     /* REDIRECTION OF STDERR */
         if (serapp) {  /* APPEND MODE */
            errno = 0;
            if ((eout = open(argper,WRITE)) == 2) {
               if (seek(eout,0,2) < 0) _exitmpx("err3");
            } else if (errno == E004) {
               if ((eout = creat(argper,MPX_DEFAULT)) != 2)
                  _exitmpx("err1");
            }
         } else {       /* WITHOUT APPEND MODE */
            /* check for keywords list, print and null */
            if (strcmp(argper,"LIST") == 0 ||
                strcmp(argper,"list") == 0)
               eout = open(acterr,WRITE);
            else if (strcmp(argper,"PRINT") == 0 ||
                     strcmp(argper,"print") == 0)
               eout = open(jerr,WRITE);
            else if (strcmp(argper,"NULL") == 0 ||
                     strcmp(argper,"null") == 0)
               eout = open("DEV=NU",WRITE);
            else if ((eout = creat(argper,MPX_DEFAULT)) != 2)
               /* Output is to a file */
               _exitmpx("err4");
         }
      } else                 /* NO REDIRECTION OF STDERR */
         if ((eout = open(acterr,WRITE)) != 2) _exitmpx("err6");
   }

/*   Call the C program with the arguments given. */

   main(argc,argv);             /* call the main routine */
   exit(0);             /* if main returns, exit normally */
}


static int _mpxin2()
{
 int   reg[8];
 int   i;

 for (i=0;i<8;i++) reg[i] = 0;

 reg[5] = 0x80000000;
 reg[7] = (int) &_myid;
 mpxsvc(0x1064,reg,reg);

 return((int)_myid._pn[0]);
}
