/* *********************************************************************
 *
 * $Header:  003  11-APR-91 13:47  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)SCIO1.C                                     $
 * 
 *      Rev  003  11-APR-91 13:47  GANN      GANN                       
 * Added a mod to SCINSC to set a buffer as modified.                   
 *
 *      Rev  002  09-APR-91 13:46  GANN      GANN
 * Added a line to scdel to indicate that the current buffer
 * has been modified.  This catches all commands that delete chars
 * to a line.
 *
 *      Rev  001  11-OCT-88 14:10  GANN      GANN
 *  Version control header added
 */
/*
 *
 * Description:
 *      Manipulate buffer and queue up screen operations.
 *
 * Revision 3.13  87/02/20  22:12:59  user
 * Out the door.
 *
 * Revision 3.12  87/02/15  22:41:32  user
 * Trivial function name change SCMOVCUR -> scmovcur.
 *
 * Revision 1.6  87/02/15  22:39:08  user
 * Trivial function name change SCMOVCUR -> scmovcur.
 *
 * Revision 1.5  86/10/21  19:46:12  user
 * Have scref only take one argument; that's all that was ever passed.
 * Use setlinmax() to reset eralinmax.
 *
 * Revision 1.4  86/09/11  23:23:44  user
 * here1 not getting set write if opening up a line in scinsc.
 * Real weird crap on the screen as a result.
 *
 * Revision 1.3  86/08/17  23:21:01  user
 * Use "NOBUF" instead of YES in scsave in several places.
 *
 * Revision 1.2  86/07/07  00:58:29  user
 * Use chkshft() return value in sccdel().
 *
 * Revision 1.1  86/06/29  23:20:38  user
 * First RCS Revision
 */

#include "edt.h"
#include "scio.h"

extern int coloff;

/*------------------------------------------------------------------
 * scdel - Delete characters/lines from the screen and the buffer.
 *
 * Parameters:
 *      chars1 - Number of characters to delete starting at
 *               current position
 *      lines  - Number of lines to delete starting at current
 *               position
 *      chars2 - Number of characters to delete after lines
 *               have been deleted
 *      buf    - Line-type buffer in which to place deleted
 *               characters (LNULL if none)
 *
 * Gotchas:
 *      - If lines is zero, chars1 will be translated into characters
 *        _and_ lines to delete.
 *      - If chars1 is > 0 and greater than the remaining characters
 *        on this line, then the end-of-line "mark" is deleted for
 *        this line.
 *      - If chars2 < 0 and the absolute value is greater than the
 *        preceding characters on the line, the beginning-of-line
 *        "mark" is deleted.
 *
 * Return:
 *      Nothing
 *------------------------------------------------------------------
 */

void scdel(chars1, lines, chars2, buf)

long    chars1;
long    lines;
long    chars2;
register LINE     *buf;

{
register long     tmp;
long              scldel();
void              sccdel();

current->modified = 1; /* indicate current buffer modified */    /*002*/

if (lines)
  /* All work was done for us */;
else if ((chars1 > 0) && (chars1 > (tmp = (2 + here->len - sccol))))
  {
  scsave(YES);
  scsetcur(USEBUF, 0, ADDREL(chars1));
  chars1 = tmp;
  if (lines_rel > 0)
    lines = lines_rel - 1;
  chars2 += sccol - 1;
  scsave(NO);
  }
else if ((chars1 < 0) && (chars1 <= (tmp = -sccol)))
  {
  scsave(YES);
  scsetcur(USEBUF, 0, chars1);
  chars1 = tmp + 1;
  if (lines_rel < 0)
    lines = lines_rel + 1;
  chars2 += sccol - (int)(2 + here->len);
  scsave(NO);
  }

sccdel(chars1, buf);

(void)scldel(lines, buf);

sccdel(chars2, buf);

#ifdef Dscdel
scprintf(24,1,YES,"[%d,%d] - <%ld>-<%ld>-<%ld>",
        scrow,sccol,chars1, lines, chars2);
#endif

scsetcur(USEBUF, scrow, sccol);

return;
}

/*------------------------------------------------------------------
 * sccdel         - Do character deletion (called from scdel)
 *
 * Parameters:
 *      in_dchars - The number of characters to delete (see scdel)
 *      buf       - Where to put the characters (see scdel)
 *
 * Gotchas:
 *
 * Return:
 *      Nothing
 *
 *------------------------------------------------------------------
 */

void sccdel(in_dchars, buf)

long              in_dchars;
register LINE     *buf;

{
long    dchars, tmp;
void    scdocdel();

if (in_dchars == 0)
  return;

dchars = in_dchars;
if ((dchars > 0) && (dchars > (tmp = (1 + here->len - sccol))))
  dchars = tmp;
else if ((dchars < 0) && (dchars < (-sccol + 1)))
  {
  scsetcur(USEBUF, 0, -1);
  if ((chars_rel == 0) || ((++dchars == 0) &&
        (absrow == current->totlines)))
    return;
  }

if (dchars != 0)
  scdocdel((int)dchars, buf);
else if (buf != (LINE *)NULL)
  buf->len = 0;

if ((dchars == in_dchars) || (here == LNULL))
  return;

if ((buf != LNULL) && (buf->len < MAXLINE))
  buf->lin[buf->len++] = '\r';

/* See if the next line exists (haven't fallen off end) and
 * is not NULL (EOB).  If so, append the next line to this line,
 * then delete the excess characters.
 */

scsave(YES);
if (sccol == 1)
  scldel(1L, LNULL);
else
  {
  if (chkshft(current, absrow + 1) != LNULL)
    {
    scinsc(screen[scrow]->lin, -(int)screen[scrow]->len);
    scrow++, sccol = 1;
    scldel(1L, LNULL);
    }
  }
scsave(NO);
scsetcur(USEBUF, 0, 0);

return;
}

/*------------------------------------------------------------------
 * scldel         - Do line deletion (called from scdel)
 *
 * Parameters:
 *      in_dlines - The number of lines to delete (see scdel)
 *      buf       - Where to put the characters (see scdel)
 *
 * Gotchas:
 *
 * Return:
 *      The number of lines deleted
 *
 *------------------------------------------------------------------
 */

long scldel(in_dlines, buf)

long    in_dlines;
LINE    *buf;

{
long              i, dlines;
int               dldir = -(in_dlines < 0);
register int      remaining;
int               midline;
register LINE     **s;

if ((in_dlines == 0) ||
    ((in_dlines > 0) && (here == LNULL)) ||
    ((in_dlines < 0) && (absrow == 1)))
  return(0L);

if (midline = (sccol > 1))
  if (in_dlines > 0)
    {
    sccdel((long)(1 + here->len - sccol), buf); /* Delete to EOL */
    scsetcur(USEBUF, ADDREL(1), 1);             /* Next line */
    in_dlines--;
    }
  else
    {
    sccdel((long)(-sccol + 1), buf);            /* Delete to BOL */
    in_dlines++;
    }

for (dlines = 0, i = (dldir ? -in_dlines : in_dlines); i--;
     current->lines--, dlines++, ADDTOT(current, -1))
  {
  scsetcur(USEBUF, dldir, 1);
  s = &screen[scrow - 1];

  if ((i == 0) && (buf != LNULL))
    {
    strnzcpy(buf->lin, (*s)->lin, (buf->len = (*s)->len));
    buf->lin[buf->len++] = '\r';
    }

  FREE(*s);

  if (absrow < rowsel)
    rowsel--;
  else if (absrow == rowsel)
    colsel = 1;

  remaining = 1 + current->lines - row;
  if (remaining > 0)
    MEMCPY(s, s + 1, LINPSIZ(remaining));
  else
    break;
  }

scsetcur(USEBUF, 0, 0);

scqopc(dlines, scrow);

if (midline)
  {
  scsetcur(USEBUF, 0, -1);
  sccdel(1L, NULL);
  }

return(dlines);
}

/*------------------------------------------------------------------
 * scdocdel - Finally!  Actually delete characters from the buffer.
 *
 * Parameters:
 *      len   - Number of characters to delete (<= characters remaining
 *              on line)
 *      buf   - Where to put the deleted characters
 *
 * Gotchas:
 *
 * Return:
 *      None
 *
 *------------------------------------------------------------------
 */

void scdocdel(len, buf)

register int      len;
LINE              *buf;

{
register int      newlen;
int               c;
int               remaining;

if (len < 0)
  {
  scsetcur(NOSCR, 0, len);
  len = -len;
  }

c = sccol - 1;
newlen = here->len - len;         /* The new length */

/* Move remainder of line over the characters to be deleted */

if ((remaining = newlen - c) < 0) /* Number of chars right of cursor */
  return;      /* Nothing to do */

if (buf != LNULL)
  strnzcpy(buf->lin, here->lin + c, (buf->len = len));

current->dirty0 = YES;
if (remaining > 0)
  MEMCPY(here->lin + c, here->lin + c + len, remaining);

if ((absrow == rowsel) && (sccol <= colsel))
  if ((colsel -= len) < sccol)
    colsel = sccol;

/* Reset the length and terminate the string */

here->len = newlen;
here->lin[newlen] = '\000';

scqref(scrow, sccol, scrow, MAXLINE);

return;
}

/*------------------------------------------------------------------
 * scinsc -    Insert characters onto the screen and the buffer.
 *
 * Parameters:
 *      str    - The character string to insert
 *      len    - The length of the string to insert
 *
 * Gotchas:
 *      - MAXLINE character max line limit is upheld.
 *      - A carriage return in the string inserts a new line.
 *      - NULL characters are valid.
 *
 * Return:
 *      Length of piece between returns...
 *
 *------------------------------------------------------------------
 */

int scinsc(str, len)

int     len;
Pchar   str;

{
register Pchar    p;
register Line     *here1;
register int      newlen;
register int      c;
int               len1;
Pchar             p1;
Pchar             pend;
int               scrlen;
byte              zap;
byte              spcins;
extern char       toobigline[];
void              scopenl();

current->modified = 1;     /* set current buffer as modified *003*/
if (spcins = len < 0)
  len = -len;

here1 = here;
current->dirty0 = YES;
for (pend = str + len, p = str; p < pend; p = p + len1)
  if (!spcins && (*p == '\r'))
    {
    scopenl();
    here1 = here;
    len1 = 1;
    }
  else
    {
    if (spcins || ((p1 = MEMCHR(p, '\r', pend - p)) == NULL))
      p1 = pend;

    len = len1 = p1 - p;

    if (zap = (here1 == LNULL))
      {
      scopenl();
      scsetcur(USEBUF, -1, 1);

      if (len > MAXLINE)
        len = MAXLINE;
      here1 = getline(REALIT, len);

      if (len > 0)
        MEMCPY(here1->lin, p, len);
      here1->lin[len] = '\000';
      }
    else if (len == 0)
      break;
    else
      {
      c = sccol - 1;
      scrlen = (int)here1->len - c;

      if ((newlen = (int)here1->len + len) > MAXLINE)
        {
        int tmp;
        scrlen -= newlen - MAXLINE;   /* Reduce by amount of overage */
        newlen = MAXLINE;
        if (len > (tmp = MAXLINE - c))
          len = tmp;
        errorout(toobigline);
        }

      here1 = getline(REALIT, newlen);

/*
 * First move line over by len characters (some characters may appear to
 * drop off the edge if the line length exceeds MAXLINE).  Then copy
 * inserted characters in.
 */

      if (scrlen > 0)
        MEMCPY(here1->lin + c + len, here1->lin + c, scrlen);

      if (len > 0)
        MEMCPY(here1->lin + c, p, len);

      here1->lin[newlen] = '\000';

      if ((absrow == rowsel) && (sccol < colsel))
        colsel += len;
      }

    scqref(scrow, sccol, scrow, (zap ? sccolmax : newlen));
    here1 = scsetcur(ABSADDR, absrow, ADDREL(len));
    }

return(len);
}

/*-------------------------------------------------------------------
 * scopenl - Open a new line on the screen
 *
 * Arguments:
 *      num - How many lines to open
 *
 * Gotchas:
 *      Screen action for opening a line are different around EOB.
 *      This is handled by scio2 routines.
 *-------------------------------------------------------------------
 */

void scopenl()

{
int               i, r;
register LINE     *here1, *there;
register int      somelen = 1;

here1 = scsetcur(NOBUF, scrow, sccol);

r = scrow;
if (here1 == LNULL)
  {
  r--;
  there = getline(NEWIT, 0);
  }
else if (sccol > here1->len)
  there = getline(NEWIT, 0);
else
  {
  i = sccol - 1;
  somelen = here1->len - i;
  there = getline(NEWIT, somelen);
  strnzcpy(there->lin, here1->lin + i, somelen);
  here1 = getline(REALIT, i);
  somelen = here1->len;
  if ((absrow == rowsel) && (col < colsel))
    rowsel++, colsel -= i;
  }
needlines(current, 1);

if ((i = LINPSIZ(1 + current->lines - row)) > 0)
  MEMCPY(&screen[scrow + 1], &screen[scrow], i);

screen[r] = there;

ADDTOT(current, 1);
current->lines++;

scqopc(-1, scrow);

here1 = scsetcur(USEBUF, ADDREL(1), 1);   /* Position on screen */

if (here1 != LNULL)
  scqref(scrow, 1, scrow, here1->len);

return;
}

/*------------------------------------------------------------------
 * scshft -       Shift the whole screen over by the indicated amount
 *
 * Parameters:
 *      howfar - How many columns to shift.
 *
 * Gotchas:
 *
 * Return:
 *      Returns one if unable to shift, zero if could shift.
 *      Updates coloff to reflect value of leftmost screen position.
 *------------------------------------------------------------------
 */

void scshft(howfar)

register int      howfar;

{
register int      oldcoloff = coloff;

if ((coloff -= howfar) > MAXLINE)
  coloff = MAXLINE;
else if (coloff < 1)
  coloff = 1;

if (coloff == oldcoloff)
  return;

sccolmax += coloff - oldcoloff;

scqref(1, 1, -1, MAXLINE);

#ifdef ISC
/* set max erase column to 255 */
setlinmax();
redraw = YES;
#endif

return;
}

/*------------------------------------------------------------------
 * scref - Schedule a screen refresh.  Clears from top of screen to
 *         specified bottom.
 *
 * Parameters:
 *      botrow - Ending screen row
 *
 * Gotchas:
 *
 * Return:
 *      None
 *
 *------------------------------------------------------------------
 */

void scref(botrow)

int botrow;

{
#ifdef ANSI
extern int        lrow, lcol;

lrow = lcol = -1;
#endif

setlinmax();
scqref(-1, 1, botrow, MAXSCCOL);
}

/*------------------------------------------------------------------
 * scposcur - Perform all preliminary marking and bounds checking, then
 *            position the cursor according to scrow/sccol.
 *
 * Parameters:
 *      inrow, incol - Where to position.  See scsetcur in sciolib.c
 *                     for description.
 *
 * Gotchas:
 *      Calls spccol to determine just where the cursor is supposed to
 *      go depending upon the data at scrow/sccol (tabs mean that the
 *      index into the line is not the same as the screen column).
 *      truerow/truecol reflects the actual position on the screen
 *      (plus coloff) when done.
 *
 * Return:
 *      None
 *------------------------------------------------------------------
 */

int truerow, truecol;

void scposcur(inrow, incol)

int inrow, incol;

{
register int      realcol;
register int      colmax = 1 + sccolmax - coloff;

scsave(NOBUF);
scsetcur(NOBUF, inrow, incol);

truerow = scrow;

if ((current == NULL) || (scrow > scrowmax))
  realcol = truecol = sccol;
else
  {
  truecol = spccol(scrow, sccol, NULL);
  if ((realcol = 1 + truecol - coloff) < 1)
    realcol = 1;
  else if (realcol > colmax)
    realcol = colmax;
  }

scmovcur(truerow, realcol);

scsave(NO);
return;
}
