/* *********************************************************************
 *
 * $Header:  006  29-JAN-92 15:09  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)MYMEM.C                                     $
 * 
 *      Rev  006  29-JAN-92 15:09  GANN      GANN                       
 * Changed DEVOUR so that it would not allocate more than 1.5 Mb        
 * of extended space so EDT/DEVOUR would work on the 27.  This          
 * will make it a little slower on the 67 but since we only have        
 * 4 Mb total mem on the 67 anyway, this is OK.                         
 *
 *      Rev  005  11-APR-91 13:47  GANN      GANN
 * Remove mod to realloc for modified buffer checking.  This set
 * a buffer to modified when scrolling also.
 *
 *      Rev  004  09-APR-91 13:44  GANN      GANN
 * Added a line to realloc to indicate that the current buffer
 * has been modified.  This catches all commands that add chars
 * to a line.
 *
 *      Rev  003  20-DEC-90 10:13  GANN      GANN
 * Changed initmem to multiply MAXMEM by the first six bits of
 * the option word.  This allows us to specify HUGE memory
 * buffers for fast edits.
 *
 *      Rev  002  16-NOV-88 07:52  GANN      GANN
 * Changed malloc to mask off byte 0 when picking memory
 * pointers. This byte is randomly being set to x94 (From LEA?).
 * I couldn't catch the culprit so I changed malloc to mask
 * off the damage.
 *
 *      Rev  001  11-OCT-88 14:09  GANN      GANN
 *  Version control header added
 */

/* MYMEM
 *
 *    Memory manipulation routines.  Replaces Microsoft's
 *    The "kernel" of these routines came from BSD4.2.  They have
 *    been modified for use by a small memory program which intends
 *    on using most (all) of available memory, and makes no bones
 *    about it.  So, the maximum amount of memory is grabbed at
 *    the outset.
 *
 */

/* C storage allocator
 * circular first-fit strategy
 * Works with noncontiguous, but monotonically linked, arena.
 * Each block is preceded by a ptr to the (pointer of) the
 * next following block.
 * Blocks are exact number of words long,
 * aligned to the data type requirements of ALIGN.
 * Pointers to blocks have the BUSY bit set to 1 for busy, 0 for idle.
 * Last block of arena (pointed to by alloct) is empty and
 * has a pointer to first.
 * Idle blocks are coalesced during space search
 *
 * A different implementation may need to redefine
 * ALIGN, NALIGN, BLOCK, BUSY, INT
 * where INT is integer type to which a pointer can be cast.
 */

#include "edt.h"

#define REG1 register
#define REG2 register
#define REG3 /* static */
#define REG4 /* static */
#define REG5 /* static */

#undef malloc
#undef free
#undef realloc

#ifndef debug
#define ASSERT(p)
#else
#define for_realloc 1
#define for_free 1
#define for_malloc 1
#define for_memcpy 1
#define for_memset 1

#define ASSERT(p) if(!(p))botch("p");else
botch(s)
char *s;
{
    printf("assertion botched: %s\n",s);
    exit(1);
}
#endif

/* Alignment definitions */

#define INT int
#define ALIGN int
#define NALIGN 1
#define WORD sizeof(union store) /* MUST BE A POWER OF 2 !! */
#define BUSY 1
#define SHIFT (WORD >> 1)
#define testbusy(p) ((INT)(p)&BUSY)
#define setbusy(p) (union store *)((INT)(p)|BUSY)
#define clearbusy(p) (union store *)((INT)(p)&~BUSY)
#define adr_mask 0x00ffffff
#define get_adr(p) (union store *)((INT)(p)&adr_mask)

/* Special edt considerations */

#define DO_NADA ((byte *)1)
#define FENCE_BYTES 800 /* Num of "priority" bytes to leave around */

#ifdef ISC
#define MAXMEM (0x20000)                                         /*003*/
#endif

char *memcwd();
char *memswd();

/* The main unit of storage.  Defines a "word" */

typedef union store
{
    union store *ptr;
    char *cptr;
    ALIGN dummy[NALIGN];
}
Store;

static Store *allocx;  /* for benefit of realloc overlap */

int  mem_remaining;  /* Number of available bytes */
#define fence(call) ((mem_remaining > FENCE_BYTES) ? (call) : NULL)

Store *allocb = {
    0};          /* arena bottom */
Store *allocp;   /* search ptr */
Store *alloct;   /* arena top */

/* Called initially to -uh- initialize memory */

void initmem()

{
    int inc;
    int my_maxmem;                                               /*003*/
    int regs [8];                                                /*003*/

    mpxsvc (0x104c, regs, regs);                                 /*003*/
    my_maxmem = (((regs[7] & 0x3f) * 2) + 1) * MAXMEM;           /*003*/
/* Cap max mem for 32/27 */                                      /*006*/
    if (my_maxmem > 0x168000) my_maxmem = 0x168000;              /*006*/

    allocb = (Store *)sbrk(WORD);
    for (inc = 0; inc < my_maxmem; inc += 0x1000)
        if ((int)sbrk(0x1000) == -1)break;

    alloct = (Store *)sbrk(2 * WORD);

    allocb->ptr = alloct;
    alloct->ptr = setbusy(allocb);
    allocp = allocb;
    mem_remaining = ((char *)alloct - (char *)allocb) - (2 * WORD);

    return;
}

char *malloc(nbytes)
int  nbytes;
{
    REG1 Store *p;
    REG2 Store *q;
    REG3 int  nw;
    REG4 Store *temp;
    REG5 int pass;
	static int abregs [] = {0, 0, 0x4d49534c, 0x494e4b20, 0, 0x4d454d20, 0, 0};

    if (allocb == NULL)
        initmem();

    /* Change nbytes to be even number of WORDS.
     * nw is number of bytes offset from address
     */

    nw = (nbytes = (nbytes + WORD - 1) & -WORD) + WORD;
    ASSERT(allocp>=allocb && allocp<=alloct);
    ASSERT(for_malloc && allock());

    pass = -1;
    p = get_adr(allocp);
    while (YES)    {
        if (!testbusy(p->ptr))        {
            while (!testbusy((q = get_adr(p->ptr))->ptr))            {
                ASSERT(q>p&&q<alloct);
				if (q < allocb)				/* invalid ptr, abort */
					mpxsvc (0x1062, abregs, abregs);
                p->ptr = get_adr(q->ptr);
                mem_remaining += WORD;
            }

            /* Coerce p to "char *"
             * because nw is number of bytes, not words
             */
            if ((q >= (temp = (Store *)((char *)p + nw))) && (temp >= p))
                break;
        }

        q = p;

        if ((p = get_adr(clearbusy(p->ptr))) > q)
            continue;
        else if ((q != alloct) || (p != allocb))
            memerr("malloc", nbytes);
        else if (++pass)
        {
            allocp = allocb; /* Reset it */
            return(NULL);  /* Sorry.  Nothing in your size. */
        }
    }

    if (q > (allocp = temp)) /* Don't change if already set up */    {
        allocx = temp->ptr;  /* Preserve for realloc */
        temp->ptr = get_adr(p->ptr);  /* Add a link */
        mem_remaining -= WORD; /* Subtract some space */
    }

    p->ptr = setbusy(allocp);
    ASSERT(for_malloc && allock());

    mem_remaining -= nbytes;
    return((char *)(p + 1));
}

/* freeing strategy tuned for LIFO allocation
 */

void free(p)

REG1 Store *p;

{
    REG1 char *q = (char *)p;

    if ((p <= allocb) || (p >= alloct))
        return;

    allocp = --p;

	if ((get_adr(p->ptr) <= allocb) || (get_adr(p->ptr) >= alloct)) {
		allocp = allocb;
		return;
	}

    p->ptr = get_adr(clearbusy(p->ptr));
    mem_remaining += p->cptr - q;

    ASSERT(allock() && for_free);
    ASSERT(p->ptr > allocp && p->ptr <= alloct);
    return;
}

/* realloc(p, nbytes) reallocates a block obtained from malloc()
 * and freed since last call of malloc()
 * to have new size nbytes, and old content
 * returns new location, or 0 on failure
 */

char *realloc(p, nw)

REG1 char *p;
int  nw;

{
    REG2 char *q;
    REG4 int  onw;

    if ((Store *)p <= allocb)
        return(NULL);

/*005    current->modified = 1;    set current buffer as modified     MOD*/

    ASSERT(allock() && for_realloc);

    if(testbusy(((Store *)p)[-1].ptr))
        free(p);

    onw = ((Store *)p)[-1].cptr - p;

    if (((q = malloc(nw = (nw + WORD - 1) & -WORD)) == NULL) ||
        (q == p))
        return(q);

    if (nw < onw)
        onw = nw;

    if (onw == 0)
        return(q);

/*  memcpy(q, p, onw); */
    memcwd((int *)q, (int *)p, (onw+3)/sizeof(int));

    if ((q < p) && (q + nw >= p))
        ((Store *)(q + (q + nw - p)))->ptr = allocx;

    return(q);
}

#ifndef MEMRTNS
char *calloc(n, size)

register int  n;
int  size;

{
    register Pchar p;

    n *= size;

    if ((p = malloc(n)) != NULL)
/*      memset(p, 0, n); */
        memswd((int *)p, 0, (n+3)/sizeof(int));

    return(p);
}
#else

/* EDT interfaces to memory routines
 *
 * A pool (fenceblk) of FENCE_BYTES bytes is kept for emergency use,
 * or use by non-EDT routines.  If malloc or realloc returns NULL,
 * then this pool is freed for further emergency or non-EDT use.
 * It is re-allocated at the next available opportunity.
 */

/* MALLOC interface */

char *mymalloc(size)

int  size;

{
    if (allocb == NULL)
        initmem();
    return(fence(malloc(size)));
}

/* REALLOC interface */

char *myrealloc(oldptr, size)

REG1 byte *oldptr;
int  size;

{
    REG2 byte *ptr;

    return(((ptr = realloc(oldptr, size)) ==
        oldptr) ? ptr : fence(ptr));
}

/* Zeromem - Grab a block of memory and zero it
 *
 * Arguments:
 * size -    The number of bytes to allocate
 * priority - YES if high-priority (allocate from reserve)
 *
 * Returns:
 * A pointer to the memory block, or NULL if no memory could
 * be allocated
 */

char *Zeromem(size, priority)

REG1 int  size;
byte  priority;

{
    REG2 byte *ptr;

    if (((ptr = priority ? malloc(size) : mymalloc(size)) != NULL) &&
        (size != 0))
/*      MEMSET(ptr, 0, size); */
        memswd((int *)ptr, 0, (size+3)/sizeof(int));

    return(ptr);
}

char *strdup(ptr)

byte *ptr;

{
    REG1 byte *newptr;

    if ((newptr = MALLOC(strlen(ptr) + 1)) != NULL)
        strcpy(newptr, ptr);

    return(fence(newptr));
}

void myfree(ptr)

byte *ptr;

{
    free(ptr);

    return;
}

#endif /* EDT */

#ifdef debug
showallmem(v)
char **v;
{
    register Store *p, *q;
    int used = 0, free = 0, i;

    for (p = clearbusy(allocb); p != alloct; p = q) {
        q = clearbusy(p->ptr);
        if (v[1])
            printf("%6o %5d %s\n", p,
            ((int ) q - (int ) p),
            testbusy(p->ptr) ? "BUSY" : "FREE");
        i = ((int ) q - (int ) p);
        if (testbusy(p->ptr)) used += i;
        else free += i;
    }
    printf("\r\n%u used, %u free, %u end\n", used, free,
    clearbusy(alloct));
}
#endif

/* fast memory copy -- handles overlapped copy */
/* copies words at a time */
/* buffers must be word bounded */

char *memcwd(p1,p2,l)

register int *p1;
register int *p2;
register int l;

{
    if (p2 < p1) /* possible overlap -- copy top down */
        for (p1 += l, p2 += l; l--; ) *--p1= *--p2;
    else
        for ( ;l--; ) *p1++= *p2++;
    return(p1);
}

/* fast memory set */
/* sets words at a time */
/* buffer must be word bounded */

char *memswd(p,c,l)

register int *p;
register int c;
register int l;

{
    int *p1 = p;

    if (l)
    {
        --p;
        do
            *++p = c;
        while (--l);
    }
    return(p1);
}
