/* *********************************************************************
 *
 * $Header:  012  13-MAR-92 11:14  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)LINE.C                                      $
 * 
 *      Rev  012  13-MAR-92 11:14  GANN      GANN                       
 * Changed name of .BAK file to _BAK.                                   
 *
 *      Rev  011  30-OCT-91 10:00  GANN      GANN
 * Fixed to create output files on a VAX disk properly.
 *
 *      Rev  010  17-SEP-91 10:14  GANN      GANN
 * Changed to not reset access in getver.  This is done in EDT.C
 * and does not need to be redone.  Also fixed other problems related
 * to access problems and mode VNUMBER and a problem with the BYE
 * command.
 *
 *      Rev  009  29-JUL-91 14:47  GANN      GANN
 * Changed to use the input file name as the output file if the BYE
 * command is used (and /VNUMBER is on). This allows the user to write
 * over a specific version number.
 *
 *      Rev  008  12-JUL-91 14:41  GANN      GANN
 * Fixed last mod so that when the user specifies an output version on
 * the command line (/OUTPUT), that is the one we write to.
 * Also spotted and modified a bug with checking an incremented pointer
 * versus NULL.
 *
 *      Rev  007  02-JUL-91 19:06  GANN      GANN
 * Added BYE command which is the EXIT command except that
 * it writes over the input file (for mode VNUMBER).
 *
 *      Rev  006  09-APR-91 13:42  GANN      GANN
 * Changed quit command to prompt the user if he is quitting
 * when the main buffer has been modified.  Also changed the
 * write command to change the buffer that is being written
 * to an unmodified status.
 *
 *      Rev  005  24-JUL-89 15:19  GANN      GANN
 * Fix "DEFINE KEY GOLD FUNCTION". It was not defining the
 * golded function. Added status of "GOLD" when computing scan
 * code.
 *
 *      Rev  004  16-FEB-89 09:02  GANN      GANN
 * Corrected problem when NOFNF is set. Problem was that
 * a set of braces were needed to attach the "else" to
 * the correct if.
 *
 *      Rev  003  03-FEB-89 12:16  GANN      GANN
 * Fix problem where when an include command contains a version
 * on the file specification (such as test.for;3), the include
 * is performed but an incorrect error message is output. The
 * problem was that the semi-colon also signals the start of a new
 * command and the parser was taking everything after the ";'
 * as another whole command. Changed nextcmnd to update cmndend
 * if the command line has been parsed past that point (cmndptr).
 *
 *      Rev  002  20-JAN-89 09:31  GANN      GANN
 * Fixed EXIT command to use the output file spec for the
 * output file instead of the input file spec.
 *
 *      Rev  001  11-OCT-88 14:08  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"
#include "errno.h"
#include "types.h"
#include "stat.h"

static char filenotfound[] = {
    "File not found"};
static char invalbufname[] = {
    "Invalid buffer name"};

Bufctl  *mbp;
Pchar    bakfile    = NULL;
static int tokval;
static int cmndsiz;
static int wover;                                           /*007*/
static void defk(), scnewbuf();

extern byte *sea_buf, rpl_buf[];
extern byte qdmode;

extern int errno;
extern char noselrangeact[];
extern BUFFER incbuf;
extern long copyblok();

#ifdef OLDLINE
/* Moved to LINE.COLD so I wouldn't be looking at it all the time! */
/*006 #include LINE.COLD*/
#endif OLDLINE

#ifndef OLDLINE
/*---------------------------------------------------------------------
 * LINECMND is the main parser of line commands
 *
 * Arguments
 *
 *   siz  = length of command to be parsed
 */
linecmnd(siz)
register int       siz;
{
register Lnrec     *nk;
register Bufctl    *bp;
int                ocp;
BUFCTRL            *oldcur = current;
extern long        lines_typed;

qhit = redraw = NO;
cmndend = -1;
lines_typed = 0;
noscreen = YES;

    while (nextcmnd(siz) && (setjmp(to_here) == 0))
       {
        rgsetcur(r0);
        if (cmndbuf[cmndptr] == CTRLZ)
             if ((stdwhat == stdin) && (++threez >= 3))
                 qldone(NULL, -1);
             else
             {
                 cmndptr++;
                 goto next;
             }
        threez = 0;
        if (cmndptr == cmndend)
        {
             r0->l1 = (++r0->l0) + 1;
             r0->c0 = 1;
             outlin(stderr, r0, r0->l0, 1, 0, 0);
        }
        else
        {
        ocp = cmndptr;
        if ((bp = getbufn(-1)) != NULL)
             if (!bp->macro)
                   cmndptr = ocp;
             else
             {
                if (!morecmnd())
                    siz = qlexemac(bp);
                goto next;
             }
         tokval = -1;
         for (nk = lw; nk->kl != 0; nk++)
             if (isword(nk->kw, nk->kl) && nk->func && !(nk->sl & 0x80))
                   {
                   tokval = nk - &lw[0];
                   (*nk->func)(cmndbuf + cmndptr, tokval);
                   goto next;
                   }
         if (!isrange(r0, YES))
             {
             cmnderr("Unrecognized command");
             goto next1;
             }
         else if (!morecmnd())
             {
             outlin(stderr, r0, r0->l0, 1, 0, 0);
             r0->c0 = 1;
             }
         }
    next:
        qqgoto(r0);
    next1:
        continue;
    }
((int *)to_here)[0] = 0;
qhit = qhit || (lines_typed > 1);
cmndptr = cmndsiz;
if (qmode && (current != oldcur))
    scnewbuf();
noscreen = NO;
return(qmode);
} /* end linecmnd */
#endif OLDLINE

/*--------------------------------------------------------------------
 * NEXTCMND determines whether there is a command coming up next
 *     on this same station.
 */

int nextcmnd(siz)

register int siz;  /* Established size of cmndbuf */

{
    register Pchar p;
    char  quote;

    if (cmndend >= 0) {            /* Found a semi-colon on last call     */
        if (cmndptr > cmndend)     /* If last command went past ";"... */    /*003*/
            cmndend = cmndptr;    /* then set new end command         */  /*003*/
        if (morecmnd())    {
            cmnderr("Unexpected characters after end of command");
            return(NO);
        }
    }

    if ((cmndptr = cmndend + 1) > siz)
        return(NO);

    stpblkcd();

    /* Look for semi-colons, but ignore quoted ones */

    for (p = cmndbuf + cmndptr, quote = NO; (p = strpbrk(p, ";'\""))
            != NULL; p++)
        if (quote)   /* Quoted? */
            if (*p == quote) /* Yep.  Is this the terminator? */
                quote = NO;  /* Yes.  Keep looking for semicolon */
            else
                continue;  /* No.  Must have been other close quote */
        else if (*p != ';')  /* Was this a semi-colon? */
                quote = *p;  /* No.  Must be a quotation */
            else
                break;   /* Found a non-quoted semi-colon */

    if (p != NULL)
        cmndend = p - cmndbuf;
    else
        cmndend = siz; /* No semi-colon */

    cmndsiz = siz;
    return(YES);  /* Looks ok */
}

/*--------------------------------------------------------------------
 * QLCHANGE moves from line mode to change mode. Optionally a single
 * line range can effect cursor position
 */
qlchange()

{
    register Pchar p;
    byte  move;
    extern long lasttopl, lastmrow;
    extern short lastmcol;
    extern byte EOBonscr;

    move = isrange(r0, YES);

    redraw = YES;
    if (morecmnd())
        return;

    if (move)
        qqgoto(r0);

    qdmode = qmode = YES;
    scnewbuf();

    if (cmndbuf[cmndptr] == ';')
    {
        p = reallmem(cmndsiz - cmndptr);
        strcpy(p, cmndbuf + ++cmndptr);
        qqnokey(p, YES);
        FREE(p);
        cmndptr = cmndend = MAXLINE + 1;
        rgsetcur(r0);
    }

    return;
} /* end qlchange */

/*--------------------------------------------------------------------
 * QLCLEAR Deletes current buffer from buffer list, unless main or
 * paste specified.  If it is either of those, just clears them out.
 */
int qlclear()
{
    register Bufctl *bp;
    register int notspecial;

    stpblkcd();

    if ((bp = getbufn(-1)) == NULL)
        cmnderr(invalbufname); /* Sorry. Don't know that buffer */
    else if (!morecmnd())
    {
        initbuf((notspecial = (getbufl(bp) > 1)) ? FREEIT : REALIT, bp,
        bp->bufnam);

        if (bp == current)
        {
            if (notspecial)
                lastbuf = bp, current = maine; /* Switch to MAIN buffer */

            redraw = YES;
            rgsetcur(r0);
        }
    }

    return(NO);
}

/*---------------------------------------------------------------------
 * QLCOPY copies a block of lines to some loction
 */
qlcopy(p, iscopy)

Pchar p;
int iscopy;

{
    int iquery, idup;
    long lines;

    iscopy = iscopy == S_COPY;

    isrange(r1, NO);
    if (!isword("TO", 2))
    {
        cmnderr("Error in range specification");
        return;
    }

    isrange(r0, YES);
    isoption(S__QUERY, &iquery, S__DUPLI, &idup, 0, (int *)NULL);

    if (idup <= 0)
        idup = 1;

    if (idup > 32767)
    {
        cmnderr("Numeric value between 1 and 32767 required");
        return;
    }

    if (morecmnd())
        return;

    bbctemp->bp = initbuf(NEWIT, (BUFCTRL *)NULL, "bbc__temp");
    bbctemp->l0 = 1L;
    lines = copyblok(r1, bbctemp, !iscopy, iquery) * idup;

    for ( ; idup > 0; idup--)
    {
        bbctemp->l1 = bbctemp->bp->totlines + 1;
        copyblok(bbctemp, r0, NO, NO);
    }

    initbuf(FREEIT, bbctemp->bp, NULL);
    showlin(lines, NULL, iscopy ? "copied" : "moved");
    rgsetcur(r0);

    return;
}

qldefine()

{
    register Bufctl *bp;

    if (isword(lw[S_KEY].kw, 1))
        defk();
    else if (!isword(lw[S_MACRO].kw, 1))
        return;
    else if ((bp = getbufn(-2)) != NULL)
        bp->macro = YES;
    else
        cmnderr(invalbufname);

    return;
}

/*---------------------------------------------------------------------
 * QLDELETE sets up a range of rows to be deleted
 */
qldelete()
{
    int     iquery;

    isrange(r0, YES);
    iquery = isword(lw[S__QUERY].kw, 2);

    if (!morecmnd())
        showlin(copyblok(r0, (RANGESTR *)NULL, YES, iquery), NULL,
        "deleted");

    return;
} /* end QLDELETE */

qldos()

{
    register Pchar p;
    extern Pchar shell;

    scposcur(scmsgrow, 1);
    qhit = YES;

    if (*(p = stpblkcd()) == '\000')
        p = shell;

    bbcsys(p);
    cmndptr = cmndend = cmndsiz;

    return;
}

qlfill()

{
    if (isrange(r0, NO))
    {
        frccur(r0->bp, r0->l0, 1);
        if (r0->l1 == EOB)
            qqfill(NULL, 1, C_FILL, E_ER);
        else
            qqfill(NULL, (int)(r0->l1 - r0->l0), C_FILL, E_L);
    }
    else if (morecmnd())
        return;
    else if (current->selrow > 0)
        qqfill(NULL, 1, C_FILL, E_SR);
    else
        cmnderr(noselrangeact);

    redraw = YES;
    rgsetcur(r0);

    return;
}

qlfind()

{
    isrange(r0, YES);
    return;
}

/*------------------------------------------------------------------
 * QLHELP read the help file and types the requested information
 */
qlhelp()

{
    register Pchar p = stpblkcd();
    short rowcol, r, c;

    rowcol = scmovcur(-1, -1);
    r = rowcol >> 8;
    c = rowcol & 0xff;

    ERAEOL(scerrrow, 1);
    sprintf(tmplin, "%s %s", helpfile, *p ? p : (char *)"HELP");
    scmovcur(r, c);

    bbcsys(tmplin);

    cmndptr = cmndend;
    qhit = redraw = YES;
    return;
} /* end QLHELP */

/*-------------------------------------------------------------------
 * QLINCLUD insert a text file at given buffer position
 */
qlinclud()

{
    long  insize;
    register int more;
    register FILE *fp;
    Pchar  filename;

    if ((filename = filecmnd()) == NULL)
        return;

    if ((fp = fopen( filename, "r")) == NULL ) {
        cmnderr(filenotfound);
    }
    else
    {
        incfile = filename;
        setbuf(fp, incbuf.filebuf);

        isrange(r0, YES);
        if (morecmnd())
            return;

        qqgoto(r0);
        insize = 0;
        while ((more = fetchlin(fp)) >= 0)
        {
            insize++;
            MEMCPY(tmplin, actlin, more);
            lminsc(tmplin, more);
        }

        showlin(insize, NULL, "included");

        fclose(fp);
        rgsetcur(r0);
        incfile = NULL;
    }

    FREE(filename);
    return;
}

/*---------------------------------------------------
 * QLINREP inserts and replaces lines of text
 *
 * Arguments
 *    in_rep  :  flag either S_INSERT or S_REPLAC
 */

/*ARGSUSED*/
qlinrep(p, in_rep)

register Pchar p;  /* Just used for storage */
int  in_rep;

{
    register int n;
    register Pchar q;
    register Bufctl *ocur;

    isrange(r0, YES);

    if (morecmnd())
        return;

    if (qverify || !qmacro)
        cprintf("\r\n");

    if (in_rep == S_REPLAC)
        r0->bp->totlines -= copyblok(r0, (RANGESTR *)NULL, YES, NO);

    qqgoto(r0);

    q = cmndbuf + cmndptr;
    p = qmacro ? (Pchar)actlin : cmndbuf;

    if (*q == ';')
    {
        q++;
        lminsc(q, strlen(q));
    }
    else
        while (YES)
        {
            if (!qmacro)
                n = getcmnd(EOL);
            else if (cmndfile != NULL)
                n = fetchlin(stdwhat);
            else
            {
                ocur = frccur(mbp, ADDREL(1), 1);
                if ((n = (here == LNULL) ? -1 : here->len) >= 0)
                    p = (Pchar)here->lin;
                frccur(ocur, 0, 0);
            }

            if ((n < 0) || (*p == CTRLZ ) ||
                ((p[0] == '^') &&
                (toupper(p[1]) == 'Z') &&
                (p[2] == '\000')))
                break;

            lminsc(p, n);
            if (qverify || !qmacro)
                cprintf("\r\n");
        }

    cmndptr = cmndend = cmndsiz;
    rgsetcur(r0);
    if (qverify || !qmacro)
        outlin(stderr, r0, r0->l0, 1, 0, 0);

    redraw = YES;
    return;
}

/*------------------------------------------------------------
 * SUBSTITUTE take string pair and replace
 */
qlsub(p, tok)

Pchar p;
int tok;

{
    register int flag;
    register Range *rtmp = r1;
    int isub, iquery, itype, notype;
    int oldqseabeg = qseabeg;

    flag = (tok == S_NEXT) || isword(lw[S_NEXT].kw, 1);

    if (!fetchsea())
        return;

    if (flag)
    {
        rtmp->bp = current;
        rtmp->c1 = rtmp->c0 = (int)(rtmp->l0 = rtmp->l1 = 0);
        notype = NO;
    }
    else
    {
        flag |= !isrange(rtmp, YES);
        iquery = 0;
        itype = 10;
        isoption(S__QUERY, &iquery, S__NOTYP,
                &notype, S__BRIEF, &itype);
    }

    if (morecmnd())
        return;

    isub = 0;
    qseabeg = S_BEGIN;
    bbctemp->bp = current;
    rgsetcur(r0);

    while ((rtmp->c1 = 1), findstr(rtmp, sea_buf, '+'))
    {
        scsetcur(ABSADDR, rtmp->l0, rtmp->c0);
        qqsn(NULL, 1, -1);  /* Replace */

        bbctemp->l1 = (bbctemp->l0 = rtmp->l0) + 1;
        rtmp->l0 = absrow;
        rtmp->c0 = col;

        if (!notype)
            outlin(stderr, bbctemp, bbctemp->l0, 1, itype, 0);

        isub++;
        if (flag)
        {
            MEMCPY(r0, rtmp, sizeof(RANGESTR));
            break;
        }
    }

    if (!flag)
        showlin((long )isub, NULL, "substituted");
    qseabeg = oldqseabeg;

    redraw = YES;
    return;
}

fetchsea()

{
    register Pchar p, p1;
    Pchar  p2;
    char  delim;

    p = stpblkcd();
    if (morecmnd())
    {
        delim = *p;
        if ((p1 = strchr(++p, delim)) == NULL)
            return(NO);
        *p1 = '\000';

        if ((p2 = strchr(++p1, delim)) == NULL)
        {
            *rpl_buf = '\000';
            incptr(p1);
        }
        else
        {
            *p2 = '\000';
            incptr(++p2);
        }

        if (strlen(p) > 0)
            strcpy(sea_buf, p);

        strcpy(rpl_buf, p1);
    }

    if (p2 > (cmndbuf + cmndend))
    {    /* Must have had an imbedded semicolon */
        cmndend = cmndptr - 1; /* Pretend that this is the end */
        nextcmnd(cmndsiz);  /* And search for next semi-colon */
        /* Reset cmndptr for continued scanning */
        cmndptr = p2 - cmndbuf;
    }

    return(YES);
}

/*------------------------------------------------------------
 * ADJUST TAB allows for block indenting
 */
qltabadj()

{
    int tabs;

    if (!isword( lw[S_ADJUST].kw, 1))
        return;

    if ((tabs = (int)isnum()) == 0)
    {
        cmnderr("Indent level must be specified");
        return;
    }

    if (isrange(r0, YES))
        frccur(r0->bp, r0->l0, 1);
    else if (morecmnd() || !rangeselect(r0))
        return;

    if (morecmnd())
        return;

    dotabadj(r0, tabs);
    redraw = YES;

    return;
}

dotabadj(rp, tabs)

Range *rp;
int tabs;

{
    register int count, j;
    int  oqoverwr;
    extern int qoverwr;

    if (tabs == 0)
        return;

    oqoverwr = qoverwr;
    qoverwr = NO;

    for (absrow = rp->l0; absrow < rp->l1; absrow++)
    {
        scsetcur(ABSADDR, absrow, 1);

        if (here == NULL)
            break;

        if (here->len == 0)
            continue;

        /* Find out just how indented this line already is */

        for (j = count = 0; j < here->len; j++)
            if (here->lin[j] == '\t')
                count = (qtab ? ((count + qtab ) & -qtab)
                     : ((count + 8) & -8) );
            else if (here->lin[j] == ' ')
                count++;
            else
                break;

        if (j > 0)
            scdocdel(j, NULL); /* Delete ALL leading spaces */

        /* Calculate how many columns over to push this all.
         * If > 0 then insert the correct number of spaces and tabs.
         */

        if ((count += (tabs * (qtab ? qtab : 8))) > 0)
        {
        if (!qtabc)
            /* just use spaces for tabs */
            qqiself(count, ' ');
        else {
            qqiself(count / (qtab ? qtab : 8), '\t');
            qqiself(count % (qtab ? qtab : 8), ' ');
        }
            current->dirty0 = YES;
        }
    } /* end for each line in range */

    qoverwr = oqoverwr;

    return;
}

/*------------------------------------------------------------
 * TYPE any given range out to the screen
 */
qltype()
{
    int     itype, istay;

    istay = itype = NO;

    rgsetcur(r0);
    isrange(r1, YES);

    isoption(S__STAY, &istay, S__BRIEF, &itype, 0, (int *)NULL);

    if (morecmnd())
        return;

    /* for each line in range type line to len itype */

    outlin(stderr, r1, r1->l0, 1, itype, 0);

    if (!istay) {
        qqgoto(r1);
        rgsetcur(r0);
    }
    return;
}

/*------------------------------------------------------------
 * WRITE sends any given range to any given file
 */
/*ARGSUSED*/
qlwrite(p, outtyp)

Pchar p;
int outtyp;

{
    register Range *rtmp = r1;
    register FILE *fp;
    register Pchar filename;
    Pchar outfile;
    Pchar getrev();
    extern Pchar dclfile();
    int  ibeg;
    int orgs=4;
    int    minx=8;
    int    maxx=8;
    Bufctl    *bp = current;
    struct stat statb;

    if ((filename = filecmnd()) == NULL)
        return;

    if (!isrange(rtmp, NO))
    {
        rtmp->l0 = 1L;
        rtmp->l1 = EOB;
        rtmp->c0 = rtmp->c1 = 1;
    }

    if ((outtyp == S_WRITE))
        isoption(S__SEQUE, &ibeg, 0, (int *)NULL, 0, (int *)NULL);

    if (morecmnd())
        return;

    wover = 0;                                                   /*007*/
    if ((outfile = getrev(filename)) == NULL)
    {
        FREE(filename);
        return;
    }

    if ((bp->fname != NULL) && (stat(bp->fname, &statb) != -1)) {
        orgs = statb.st_size/768;
        if (orgs > 128) {
            orgs = orgs/16;
            minx = maxx = orgs * 2;
        }
    }
    else if ((maine->fname != NULL) && (stat(maine->fname, &statb) != -1)) {
        orgs = statb.st_size/768;
        if (orgs > 128) {
            orgs = orgs/16;
            minx = maxx = orgs * 2;
        }
    }
    setsiz(orgs, minx, maxx);    /* set default file size */

    if ((fp = fopen(outfile, "w")) == NULL)
    {
        cmnderr(filenotfound);
        FREE(filename);
        return;
    }

    setsiz(4, 8, 8);    /* set default file size */
    bakfile = NULL;

    setbuf(fp, incbuf.filebuf);
    outlin(fp, rtmp, 0L, 0, 0, (outtyp == S_PRINT));

    fzclose(fp);

    if (rtmp->l1 > rtmp->bp->totlines)
        rtmp->l1 = rtmp->bp->totlines + 1;

    showlin((rtmp->l1 - rtmp->l0), dclfile(outfile), NULL);
    FREE(filename);
    current->modified = 0; /* set current buffer not modified*/  /*006*/
    return;
}

/*------------------------------------------------------------
 *
 * EXECUTE MACRO using EDT buffer as command set
 */
int qlexemac(bp)

register BUFCTRL *bp;

{
    long  i;
    register LINE *lp;
    Pchar  cm;

    cm = strdup(cmndbuf + cmndend);
    qmacro = YES;
    for (i = 1L; i <= bp->totlines; i = bp->line1is + bp->curlin + 1)
    {
        lp = chkshft(mbp = bp, i);
        qmode = qlexem(lp->lin, lp->len);
    }

    chkshft(bp, 1L);
    bp->curchr = 1;

    qmacro = NO;

    strcpy(cmndbuf, cm);
    FREE(cm);
    cmndptr = 1;
    cmndend = 0;

    return(strlen(cmndbuf));
} /* end qlexemac */

qlexem(p, len)

register Pchar p;
register int len;

{
    int  oqmode = qmode;
    byte  old_redraw = redraw;
    byte  old_qhit = qhit;

    if ((p[0] == '^') && (toupper(p[1]) == 'Z') && (p[2] == '\0'))
    {
        p = (Pchar)"\032";
        len--;
    }

    MEMCPY(cmndbuf, p, len + 1);
    for (p = cmndbuf + len; --p != cmndbuf; )
        if (*p == '\000')
            *p = '\200';

    if (qverify)
        lmprintf("%s", cmndbuf);

    qmode = qdmode = NO;
    linecmnd(len);
    redraw |= old_redraw;
    qhit |= old_qhit;

    return(qdmode ? qmode : oqmode);
}

qldone(p, tok)

Pchar  p;
register int tok;

{
    int  doexit;
    register Bufctl **u;
    int  save, beg, n;                                           /*006*/
    Pchar getrev();
    Pchar dclfile();
    extern unsigned qchmod;

    wover = 0;                                                   /*010*/
    if (tok == S_EXECUT) {                                       /*007*/
       tok = S_EXIT;                                             /*007*/
       if (outfile != NULL) {                                    /*010*/
          FREE (outfile);                                        /*010*/
          outfile = strdup (infile);                             /*010*/
          wover = 1;                                             /*010*/
       }                                                         /*010*/
    }                                                            /*007*/

    if (tok != -1)
        isoption(S__SAVE, &save, S__SEQUE, &beg, 0, (int *)NULL);
    else    {
        save = YES;
        tok = S_QUIT;
    }

    if ((tok == S_QUIT) && qqmc) {                               /*006*/
       if (maine->modified) {                                    /*006*/
          cprintf                                                /*006*/
("\nYour main buffer has changed, do you still want to quit? "); /*006*/
          n = GETCH (YES);                                       /*006*/
          if ((cmndbuf[0] != 'Y') && (cmndbuf[0] != 'y'))        /*006*/
              return;                                            /*006*/
       }                                                         /*006*/
    }                                                            /*006*/


    if ((tok == S_EXIT) && morecmnd()) {

/* convert file name to mpx and if only filename add curr dir */

        outfile = filecmnd();                                    /*002*/

        isoption(S__SAVE, &save, S__SEQUE, &beg, 0, (int *)NULL);
        if (morecmnd())
            return;
    }

    if (stdwhat != stdin)
        return;

    doexit = tok != S_QUIT;

/* if exitting, get revision number of output file */

    if (doexit) {
        if (outfile == NULL) {                                   /*002*/
           cprintf ("\nYou must specify an output file");        /*002*/
           return;                                               /*002*/
        }                                                        /*002*/
        if (qvnum || !wover)                                     /*010*/
           if ((outfile = getrev(outfile)) == NULL) return;
    }
    offshift();
    current = NULL;

    writejou(YES);  /* Output and close journal file */

    scposcur(scrowmax, 1);
    qdcolor = qcolor;

    for (u = user + doexit; *u != NULL; )
        initbuf(QUITING + doexit, *u, "");

    if (!doexit)
        scposcur(scmsgrow, 1);
    else    {

/* Use input file prefix, on temp file if possible */

        temppref = inflpref;
        passthru(maine, YES);  /* blow out maine. */

/* get filename to output to */

        strcpy(tmplin, outfile);                                 /*002*/

        if (doexit && qsummary)
            showlin(maine->totlines, dclfile(tmplin), NULL);

        if ((!qvnum) && wover)                                   /*011*/
           if ((unlink(tmplin) == -1) && (errno == EACCES))
              bailout("Unable to overwrite original file");
        if (copydel(maine->fname, tmplin))
            bailout("Unable to rewrite original file");
        else if (qchmod != 0)
            (void)chmod(tmplin, qchmod);
    }

/*007     if (tok == S_EXECUT)*/
/*007         bbcsys(p), cprintf("\r\n");*/

    if (!save)
        blast(&jfp, &jrnlfile);

    dowork(NO);
    qcolor = 0x07;
    ERAEOL(truerow, truecol);
    ERAEOL(scerrrow, 1);
    if ((tok == S_QUIT) && maine->modified) {                    /*006*/
        cprintf ("\nQuitting with main buffer modified.");       /*006*/
    }                                                            /*006*/

    exit(0);
}

/*---------------------------------------------------------------------
 * GETREV - routine to search specified directory and get latest
 *          revision of a file or use .bak if not using versioning.
 *          the specified file is returned to the caller.
 */

Pchar getrev(file)   /* get next revision number */

Pchar file;

{

    int *xcess;
    int *getacc();
    int setacc();
    int access();
    Pchar mpxfile();
    Pchar getpath();
    struct stat statbuf;
    extern unsigned qchmod;
    int iext;
    static char tmpfile[64];
    char dirnam[64];
    int dir[768];
    int fn;
    int i, j, k, l, m;
    int * iptr;
    Pchar outfile, p, ptr, pp;
    char ext[5];
    int  vernover;   /* There is a version without a version */  /*011*/

    /* convert file name to mpx and if only filename add curr dir */

    qhit = YES;
    p = outfile = mpxfile(file);
    if (strrchr(outfile, ')') == NULL) {
        outfile = getpath(outfile);
        FREE(p);
    }

    strcpy(tmpfile, outfile);
    l = strlen(tmpfile);
    if (qvers) {       /* use versioning if not zero */
       if ((isdigit(tmpfile[l-1])) && (isdigit(tmpfile[l-2])) &&
           (isdigit(tmpfile[l-3])) && (tmpfile[l-4] == '.'))     /*008*/
          return (bakfile = outfile);                            /*008*/
    } else {            /* else test for .bak and strip */
       if ((tmpfile[l-3] == 'B') && (tmpfile[l-2] == 'A') &&
           (tmpfile[l-1] == 'K') && (tmpfile[l-4] == '_'))       /*012*/
          return (bakfile = outfile);                            /*008*/
    }


    /* get access rights of tmpfile file to use for output files */
/*010     if ((xcess = getacc(tmpfile)) > 0) { */
/*010         xcess [0] |= 0xF8400000;         */
/*010         setacc(xcess[0], xcess[1], xcess[2]);   */
/*010     }       */
/*010     else setacc(0,0,0);       */

    vernover = 0;               /* set no unversion version */   /*011*/
    if (qvers) {       /* use versioning if not zero */
        strcpy(dirnam, tmpfile);
        p = strrchr(dirnam, ')');
        p[1] = 0;
        strcat(dirnam, " BLOC=N");
        /* open directory */
        if ((fn = open(dirnam, 0)) <= NULL)
        {
            p = strrchr(dirnam, ' ');
            *p = 0;
            sprintf(actlin, "Unable to open directory %s", dirnam);
            cmnderr(actlin);
            return (NULL);
        }
        p = strrchr(tmpfile, ')');
        p++;
        ext[0] = '.';
        /* routine to log current directory */
        iext = 0;
        while ((l = readraw(fn, dir, sizeof(dir)))  > 0) {
            BKGRND;
            iptr = dir;
            m = l / (16*sizeof(int));
            for (j = 0; j < m; j++, iptr = iptr + 16) {
                if (iptr[10] & 0x80000000) {
                    ptr = (char *)iptr;
                    for (i=0; ((i < 16) && (ptr[i] != ' ')); i++);
                        ptr[i] = 0;
                    if ((i > 4) && (ptr[i-4] == '.') && (isdigit(ptr[i-3]))
                        && (isdigit(ptr[i-2])) && (isdigit(ptr[i-1])))
                    {
                        for (pp = p, k = 0; k < i-4; pp++, k++)
                            if (*pp != ptr[k])goto next;
                        k = atoi(&ptr[i-3]);
                        if (k > iext)iext = k;
                    }
                    else                                         /*011*/
                    {                                            /*011*/
                        for (pp = p, k = 0; k < i; pp++, k++)    /*011*/
                            if (*pp != ptr[k])goto next;         /*011*/
                        vernover = 1;                            /*011*/
                    }                                            /*011*/
                }
            next:;
            }
        }
        close(fn);
        sprintf(&ext[1], "%03d", ++iext);
        addext(tmpfile, ext, &outfile);
    }
    else {                                                     /*007*/
        /* use .bak file if no versioning */
        addext(tmpfile, "_BAK", &outfile);                       /*012*/
        if ((unlink(outfile) == -1) && (errno == EACCES)) {
            sprintf(actlin, "Unable to delete old %s file", outfile);
            cmnderr(actlin);
            return (NULL);
        }
    }                                                            /*007*/
    ptr = strrchr(outfile, ')');
    if ((ptr++ != NULL) && (strlen(ptr) <= 16)) {
      if ((!qvers) || (vernover)) {                               /*011*/
       if (rename(tmpfile, outfile) == -1) {
           if (stat(tmpfile, &statbuf), errno == ENOENT) {       /*004*/
               if (qvnum)                                        /*010*/
                   iext--;                                       /*010*/
               else                                              /*010*/
                   if (qfnf)cprintf("\r\nNo original file\r\n");
           }                                                     /*004*/
           else {
               sprintf(actlin, "Unable to write backup file %s", tmpfile);
               cmnderr(actlin);
               return (NULL);
           }
           bakfile = NULL;                                       /*010*/
       }                                                         /*010*/
       else                                                      /*010*/
           bakfile = outfile;                                    /*007*/
      }                                                          /*011*/
      else {                                                     /*011*/
       if (qvnum)                                                /*011*/
          iext--;                                                /*011*/
       else                                                      /*011*/
          if (qfnf)cprintf("\r\nNo original file.\r\n");         /*011*/
       bakfile = NULL;                                           /*011*/
      }                                                          /*011*/
    }
    else { /* no backup being made */
        cprintf("\r\n WARNING: No backup file generated\r\n");
        bakfile = NULL;                                          /*007*/
    }

    /* return file name to be written */
    if (qvnum) {                                                 /*007*/
       if (wover) {                                              /*010*/
           if (iext < 1) iext = 1;                               /*010*/
       }                                                         /*010*/
       else                                                      /*010*/
           iext++;                                               /*010*/
       l = strlen(tmpfile);                                      /*007*/
       tmpfile [l] = '.';                                        /*007*/
       sprintf(&tmpfile[l+1], "%03d", iext);                     /*007*/
       tmpfile [l+4] = '\0';                                     /*007*/
       l = l + 4;                                                /*007*/
    }                                                            /*007*/
    return (tmpfile);
}

/*---------------------------------------------------------------------
 * COPYBLOK deletes a range of rows(maybe) and puts them
 *  somewhere(maybe)
 */
long copyblok(rpin, rpout, dflag)

RANGESTR *rpin, *rpout;
int  dflag;

{
#ifdef QUERY
    long moved = 0, i;
    LINE *drow;

    if (qflag)
    {
        for (i = rpin->l0; i < rpin->l1; i++)
        {
            drow = chkshft(rpin->bp, (dflag) ? rpin->l0 : i);

            fwrite( drow->lin, 1, drow->len, stdout );
            cprintf("\n? ");
            winkey( NO );

            asciival = toupper(asciival);
            if (asciival == 'A')
                break;
            else if( asciival == 'Q' )return( moved );
            else if( asciival == 'Y' )
            {
                moved++;
                rgsetcur( rpin );
                delblok( rpin, rpout, dflag );
            }
            else if( asciival != 'N' )
                rpin->l0++;
        }
        if( asciival != 'A' )return( moved );
    }
#endif /* QUERY */

    return(delblok(rpin, rpout, dflag));
} /* end COPYBLOK */

int copydel(from, to)

Pchar to, from;

{
    register int i;
    register Pchar buf;
    register FILE *infp;
    register FILE *outfp;
    Bufctl     *bp    = current;
    int orgs,minx,maxx;
    struct stat statb;

    if ((i = rename(from, to)) == 0)
        return(i);

    if ((infp = fopen(from, readbin)) == NULL)
        return(i);

    if (stat(from, &statb) != -1) {
        orgs = statb.st_size/768;
        if (orgs > 128) {
            orgs = orgs/16;
            minx = maxx = orgs * 2;
        }
    }
    setsiz(orgs, minx, maxx);    /* set default file size */

    if ((outfp = fopen(to, writebin)) == NULL)
        goto e1;

    setsiz(4, 8, 8);    /* set default file size */

    if ((buf = (Pchar)MALLOC(EXBUFSIZ)) == NULL)
        goto e0;

    /* Copy the file to the other device */

    while ((i = fread(buf, sizeof(char), 2048, infp)) > 0)
    {
        BKGRND;
        if (fwrite(buf, sizeof(char), i, outfp) < (sizeof(char) * i))
        {
            FREE(buf);
            fwerr(to);
        }
    }
    i = unlink(from);  /* Remove old file */
    FREE(buf);

e0:
    fclose(outfp);
e1:
    fclose(infp);

    return(i);
}

/*------------------------------------------------------------
 * DEFK define keys
 */
static void defk()

{
    register int ind, jnd;
    register Pchar p;
    Pchar  q;

    ind = whichkey();

    if ((strnicmp (funs[ind], lw[S_FUNCTION].kw, 5)) == 0) {
        cmnderr ("Cannot redefine FUNCTION key");
        return;
    }

    if ((strnicmp (funs[ind], lw[S_ESC].kw, 3)) == 0) {
        cmnderr ("Cannot redefine ESCAPE key");
        return;
    }

    if ((strnicmp (funs[ind], lw[S_SCS].kw, 3)) == 0) {
        cmnderr ("Cannot redefine SCS key (CSI, SS3)");
        return;
    }
    if ((ind < 0x7f) && (ind >= 32)) {
        cmnderr ("That key is not definable");
        return;
    }

    if (!isword("AS", 2)) {
        cmnderr("As marker required");
        return;
    }

    if ((p = getstr()) == NULL)
        return;

    if (morecmnd())
        return;

    q = funs[ind];
    mestrcpy(&q, p);
    funs[ind] = q;

/* Here if GOLD, ESC, or FUNCTION, do lower case letter too */

    jnd = ind & 0x1ff;    /* Mask off golded bit for first two checks */
    if (((jnd >= FUNCT_OFF) && (jnd < (FUNCT_OFF+128))) ||
        ((jnd >= ESC_OFF)   && (jnd < (ESC_OFF+128)))   ||
        ((ind >= GOLD_OFF)  && (ind < (GOLD_OFF+128)))) {
        if (((ind & 0x7f) >= 'A') && ((ind & 0x7f) <= 'Z')) {
            funs[ind + 32] = funs[ind];
        }
    }

    return;
} /* end of defk */

/*------------------------------------------------------------
 * WHICHKEY maps Plain/gold/control/function qual. into key table
 */
int whichkey()

{
    int  igold, iesc, ifunct, iscs;
    register int ind;
    Pchar fnc;
    static int realKeys [] =   {496, 497, 498, 499, 500, 501, 502,
                                503, 504, 505, 465, 466, 449, 450,
                                451, 452, 494, 467, 493, 492, 464,
                                461,   0,   0,   0,   0,   0,   0};

    igold = iesc = ifunct = iscs = 0;
    if (igold = (isword(lw[S_GOLD].kw, 2) * GOLD_OFF))
        stpblkcd ();
    if (iesc = (isword(lw[S_ESC].kw, 2) * ESC_OFF))
        stpblkcd ();
    else if (ifunct = (isword(lw[S_FUNCTION].kw, 2) * FUNCT_OFF)) {
        stpblkcd ();
        if (qterm == 0) {        /* do weird vt220 stuff */
            for (ind = 0, fnc = &cmndbuf[cmndptr];
                    ((*fnc >= '0') && (*fnc <= '9'));
                    fnc = &cmndbuf[++cmndptr]) {
                ind = (ind * 10) + (*fnc - '0');
            }
            stpblkcd ();
            return (ind + SCS_OFF + igold);                      /*005*/
        }
    }
    else if (iscs = (isword(lw[S_SCS].kw, 2) * SCS_OFF))
        stpblkcd ();

    if (isword(lw[S_DELETE].kw, 2))
        ind = DEL + igold;
    else if (isword(lw[S_CONTROL].kw, 2))
    {
        stpblkcd ();
        ind = toupper(cmndbuf[cmndptr++]) - ('A' - 1) + igold;
    }
    else
    {
        ind = cmndbuf [cmndptr++];
        if (iscs == 0)
            ind = toupper (ind);
        if ((qterm == 0) && (ind >= '0') && (ind <= '9')) {
            for (ind-='0', fnc = &cmndbuf[cmndptr];
                    ((*fnc >= '0') && (*fnc <= '9'));
                    fnc = &cmndbuf[++cmndptr]) {
                ind = (ind * 10) + (*fnc - '0');
            }
            if ((ind >= 0) && (ind <= 22 ))
                ind = realKeys [ind];
            else
                ind = 0;
        }
        ind += (igold + iesc + ifunct + iscs);
    }

    stpblkcd ();
    return (ind);

} /* end of WHICHKEY */

/*--------------------------------------------------------------------
 * SCNEWBUF sets up stuff so the screen stuff is ready for a new buffer
 */

static void scnewbuf()

{
    extern long lasttopl, lastmrow;
    extern short lastmcol;
    extern byte EOBonscr;

    lastmrow = rowsel;
    lastmcol = colsel;
    lasttopl = -MAXBUFLINES;
    redraw = clrlines = YES;
    EOBonscr = NO;
    setlinmax();

    noscreen = NO;
    scsetcur(ABSADDR, r0->l0, r0->c0);
    noscreen = YES;

    return;
} /* end scnewbuf */
