/* *********************************************************************
 *
 * $Header:  003  20-DEC-90 10:00  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)FILEIO.C                                    $
 * 
 *      Rev  003  20-DEC-90 10:00  GANN      GANN                       
 * Remove some extra redundant calls.                                   
 *
 *      Rev  002  13-OCT-88 12:49  GANN      GANN
 * Removed some lines that doodn't compile. See note below.
 *
 *      Rev  001  11-OCT-88 14:07  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "errno.h"
#include "types.h"
#include "stat.h"

#define FILEBUF(f) (f->_base)
#define FILEBUFFP(f) ((FILE *)(BUFFILE(f)))[-1]
#define FILEPTR(f) (f->_ptr)
#define FILECNT(f) (f->_cnt)
#define FILEFLAG(f) (f->_flag)

extern BUFFER inbuf, outbuf, incbuf;
extern int errno;

/* BLAST - Closes and unlinks any given file pointer if the file ptr
 * is not the original input file.  Also sets the file pointer and
 * filenames to NULL.
 */

void blast(fp, fname)

register FILE **fp;
register Pchar *fname;

{
    extern int errno;

    if (*fp == NULL)
        return;

    fzclose(*fp);

    if (((*fp != maine->fp) || maine->multipas) &&
        (unlink(*fname) == -1) && (*fp != jfp))
        if (errno == ENOENT)
            cmnderr("%s does not exist", fname);
        else
            cmnderr("Unable to delete %s", fname);

    FREE(*fname);

    *fp = NULL;
    *fname = NULL;

    return;
}

/*  FETCHLIN takes a file pointer as an argument and reads data
 *      until either a newline is reached, EOF is true, or
 *      the maximum line length is hit.
 */

int fetchlin(fp)

register FILE *fp;

{
    register int m;
    int  n = MAXLINE + 1;
    int j;
    Pbyte  p = actlin;
    byte  noeol;
    extern char toobigline[];

    BKGRND;                                                      /*003*/
    if (fp == NULL)
        return(-1);

/*002  What is going on?  I can't find routine bufwrit anywhere.  I have an  */
/*002  assemble listing of fetchlin from version E.3A and it does not have   */
/*002  code for these two lines, but the C listing saved when E.3A was done, */
/*002  has these two lines in it.  How was I able to compile the fetchlin    */
/*002  for E.3A?  I have made no changes in this file since E.3. Where did   */
/*002  these lines come from?  What is going on?  I have determined that the */
/*002  objects we are running do not have this code in them.  I am going to  */
/*002  commant them out and see what happens.                                */
/*002                                                                        */
/*002     else if (fp == stdin)                                                */
/*002         bufwrit (0, 0);   /* purge screen buffer before doing read   */

    /* #ifndef ISC */
    if ((FILEBUF(fp) == incbuf.filebuf) || (FILEFLAG(fp) & _IONBF))
        ; /* Do nothing */
    else if (inbuf.fp != fp)
    {    /* Read buffer back in */
        inbuf.fp = fp;
/*003          BKGRND;              */
        if (lseek(fileno(fp), -(SEEK)BUFSIZ, 1) >= 0L)
        {
            j =  read(fileno(fp), inbuf.filebuf, BUFSIZ);
        }
        else
            lseek(fileno(fp), (SEEK)0 ,0);
    }

/*003     BKGRND;*/
    /* #endif      */

    do
        {
        if (fp->_cnt > 0)
            /* S'all right */;
        else if (_filbuf(fp) == EOF)
            break;
        else
        {
            fp->_cnt++;  /* "Push" character from _filbuf */
            fp->_ptr--;  /*  back into buffer.   */
        }

        if (noeol = (m = MEMCHR(fp->_ptr, '\n', fp->_cnt)
            - (int)fp->_ptr) < 0)
            m = fp->_cnt;  /* Remainder of buffer */
        else if (m == 0)
                        /* New line for line in previous buffer */
            p -= (p[-1] == '\r');
        else if (fp->_ptr[--m] != '\r')
            m++;   /* Terminated by CRLF */

        if (m > 0)
            MEMCPY(p, fp->_ptr, m = min(m,n));

        fp->_cnt -= m;
        fp->_ptr += m;

        n -= m;
        p += m;
    }
    while (noeol && (n > 0));

    *p = '\000';

    while (((m = getc(fp)) != '\n') && (m != EOF))
        n--;

/*003     BKGRND;*/

    if (n < -2)
        errorout(toobigline);

    if ((((m = p - actlin) == 0) ||
            ((m == 1) && (actlin[0] == CTRLZ))) && feof(fp))
        return(-1);

        if (m >qmaxcol) {
                m = qmaxcol;
                p = &actlin[qmaxcol];
                while ((*--p == ' ') && (m > 1))m--;
                *++p = NULL;
        }

    return(m);
}

/* FZCLOSE  write a control Z at EOF (maybe)
 * for stupid MSDOS convention
 */

void fzclose(fp)

register FILE *fp;

{
    extern byte qcz;

    fclose(fp);
    if (fp == inbuf.fp)
        inbuf.fp = NULL;
    else if (fp == outbuf.fp)
        outbuf.fp = NULL;

    return;
}

/* OPENTEMP opens a temporary file for writing */
void opentemp(bp)

register BUFCTRL *bp;

{
    register int iext;
    Pchar  tmpname = NULL;
    char  ext[5];
    int orgs=4;
    int    minx=8;
    int    maxx=8;
    struct stat statb;
    extern    Pchar    bakfile;

    ext[0] = '.';

    mest2cpy(&tmpname, temppref, bp->bufnam);

    BKGRND;                                                      /*003*/
    for (iext=0; bp->ofp == NULL; iext++)
    {

        addext(tmpname, itoa(iext, &ext[1], 10) - 1, &bp->ofname);

        if (access(bp->ofname, 00) == -1) {
            if ((incfile != NULL) && (stat(incfile, &statb) != -1)) {
                orgs = statb.st_size/768;
            if (((bp->fname != NULL) && (stat(bp->fname, &statb) != -1))
                || ((orgfile != NULL) && (stat(orgfile, &statb) != -1)))
                orgs = orgs + statb.st_size/768;
                if (orgs > 128) {
                    orgs = orgs/16;
                    minx = maxx = orgs * 2;
                }
            }
            else if((bp->fname != NULL) && (stat(bp->fname, &statb) != -1)) {
                goto comc;
            }
            else if(current && (bp != maine) && (maine->fname != NULL)
                && (stat(maine->fname, &statb) != -1)) {
                goto comc;
            }
            else if(current && (bp != paste) && (paste->fname != NULL)
                && (stat(paste->fname, &statb) != -1)) {
                goto comc;
            }
            else if((orgfile != NULL) && (stat(orgfile, &statb) != -1)) {
                goto comc;
            }
            else if((bakfile != NULL) && (stat(bakfile, &statb) != -1)) {
comc:            orgs = statb.st_size/768;
                if (orgs > 128) {
                    orgs = orgs/16;
                    minx = maxx = orgs * 2;
                }
            }
            else if (current) {
                minx = 0;
                maxx = 0;
                orgs = 0;
            }

            setsiz(orgs, minx, maxx);    /* set file size */

            if ((bp->ofp = fopen( bp->ofname, "w" )) == NULL )
                foerr("opentemp", bp->ofname);
#ifdef ISC
            else bp->ofp->_flag |= _IOBLKD;
#endif
            setsiz(4, 8, 8);    /* set default file size */
        }
    }

    if ((bp->ofp != outbuf.fp) || (iext > 0))
    {
        if (outbuf.fp != NULL)
            fflush(outbuf.fp);
        setbuf(outbuf.fp = bp->ofp, outbuf.filebuf);
    }

    errno = 0;
    FREE(tmpname);

    return;
}
/* end OPENTEMP */

/* outtemp - Write a newline terminated line to a temporary file.
 *
 * Arguments:
 * fp - The file pointer of the temporary file
 * buf - The line to write
 * len - The length of the input line
 */

void outtemp(fp, buf, len)

FILE  *fp;
register Pchar buf;
register int len;

{
    BKGRND;                                                      /*003*/
    buf[len++] = '\n';
    if (fwrite(buf, sizeof(char), len, fp) < len)
        fwerr("temporary");

    return;
}

#ifndef ISC
int putw(w, fp)

register int w;
FILE  *fp;

{
    return((fputc(w, fp) == EOF) ? EOF : fputc(w >> 8, fp));
}

short getw(fp)

FILE *fp;

{
    return((fgetc(fp) << 8) | fgetc(fp));
}
#endif
