         PROGRAM   _c.srt
         SPACE     1
************************************************************************
*
* _C.SRT IS THE MAIN ROUTINE FOR C PROGRAMS.  IT ESTABLISHES THE
*        STACK AND CALLS A C ROUTINE THAT READS ARGUMENTS AND INVOKES
*        THE C PROGRAM WITH THE ARGUMENTS.  IN ADDITION, IT CALCULATES
*        THE SIZE OF A MAP BLOCK AND SETS A POINTER TO THE END OF THE
*        PROGRAM'S ADDRESS SPACE.
*
************************************************************************
         SPACE     1
         DEF       _c.srt
         EXT       __mpxini
_eas     COMMON    >EAS(1)         ! POINTER TO END OF ADDRESS SPACE
_csect   COMMON    >CSECT(1)       ! STARTING CSECT ADDRESS
_blksize COMMON    >BLKSIZE(1)     ! MAP BLOCK SIZE
_bufrsio COMMON    >BUFRSIO(1)     ! START OF I/O BUFFERS
         SPACE     2
************************************************************************
* REGISTER AND CONDITION CODE EQUATES
************************************************************************
         SPACE     1
R0       EQU       0               ! REGISTER 0 EQUATE
R1       EQU       1               ! REGISTER 1 EQUATE
R2       EQU       2               ! REGISTER 2 EQUATE
R3       EQU       3               ! REGISTER 3 EQUATE
SP       EQU       3               ! REGISTER 3 EQUATE (STACK POINTER)
R4       EQU       4               ! REGISTER 4 EQUATE
R5       EQU       5               ! REGISTER 5 EQUATE
R6       EQU       6               ! REGISTER 6 EQUATE
R7       EQU       7               ! REGISTER 7 EQUATE
         SPACE     1
C.MGRAN  EQU       X'AC4'          CPU MAP GRANULARITY
STKSIZE  EQU       X'4000'         ! SIZE OF C STACK
*
         DSECT
c.flgs   DATAW     0
u.mbrk   DATAW     0
u.endstk DATAW     0
*
         CSECT
*
CC1      EQU       1               ! CONDITION CODE 1 EQUATE
         SPACE     1
ABRTCODE DATAW     C'CBUF'         ! ABORT CODE
         PAGE
_c.srt   EQU       $
         SPACE     2
************************************************************************
* ESTABLISH THE C STACK
************************************************************************
*
*        LI        R7,-3           ! GET 3 EXTENDED MAPS
*MOD          LI        R7,-1           ! GET 1 EXTENDED MAPS
M.LOOP   SVC       1,X'69'         ! GET EXTENDED MAP BLOCK
         TRR       R3,R3           ! SEE IF ERROR
         BEQ       ABORT           ! ABORT IF NO MEMORY
*        BIB       R7,M.LOOP       ! GET THE MEMORY
         SVC       1,X'65'         ! GET PROGRAM ADDRESS LIMITS
         STW       R6,>CSECT       ! SET START OF CSECT ADDRESS
         TRR       R7,R1           ! SAVE END OF EXTENDED MEMORY
         SRL       R7,5            ! FILE BOUND END
         SLL       R7,5            !  ADDRESS
         TRR       R7,R3           ! END I/O BUFFER ADDRESS
         TRR       R1,R7           ! SAVE LAST LOADED ADDRESS
         ADI       R7,1F-1B        ! ROUND UP
         SRL       R7,5            ! FILE BOUND
         SLL       R7,5            ! RESTORE FILE BOUNDED ADDRESS
         STW       R7,>EAS         ! SET END OF MEMORY ALLOCATED
*        SUI       R3,X'4000'      ! BEGINNING BUFFER ADDRESS
*        TRR       R3,R6           ! BUF ADDR
*        ADI       R6,X'20'        ! STARTING ADDRESS
*        STW       R6,>BUFRSIO     ! SET I/O BUFFER ADDRESS
         LW        R6,C.MGRAN      ! GET C. CONTAINING BLKSIZE
         STW       R6,>BLKSIZE     ! STORE IN BLKSIZE
         SUI       R6,1W           ! 1W LESS THAN MAP
         ADR       R6,R4           ! ROUND LAST LOADED ADDRESS
         TRC       R6,R6           ! MAKE A MASK
         ANR       R6,R4           ! MAP BOUND LOAD ADDRESS
         TRR       R3,R1           ! SAVE STACK ADDR
         TRR       R5,R3           ! LAST ALLOCATED MAP ADDRESS
         SUI       R4,1W           ! MAKE LAST ADDRESS
M.LOP2   SUR       R4,R3           ! CAN WE DELETE A MAP
         BLE       GOON            ! BR IF NOT (OR OF M.FE FAILED)  !MOD
         SVC       1,X'68'         ! FREE A MAP BLOCK
         BU        M.LOP2          ! TRY AGAIN
GOON     SEA                       ! EXTENDED MODE
         TRR       R1,R3           ! RESTORE STACK ADDRESS
         BL        __mpxini        ! CALL THE ARGUMENT INIT ROUTINE
* ABORT IF ANY PROBLEMS
         SPACE     1
ABORT    LW        R5,ABRTCODE
         SVC       1,X'57'
*
         END       _c.srt
