  @  H*       UNIX I/O SIMULATOR FOR MPX FILES      08-FEB-83 HEADER  UNIXIO.S H H************************************************************************ H *  !*        RESTRICTED RIGHTS LEGEND ! *  G*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE RESTRICTIONS G D*        STATED IN GOULD'S LICENSE AGREEMENT (FORM NO. 1218) OR, FOR D ,*        GOVERNMENT CUSTOMERS, DAR 7-104.9A. , *  H************************************************************************ H          SPACE     2  0         PROGRAM   UNIX.IO         FILE:  UNIXIO 0          DEF       VER.UNIO           DEF       PRG.UNIO  VER.UNIO EQU       X'A003'  PRG.UNIO EQU       X'3860'  H************************************************************************ H               @  H*                                                                      * H H*                   UNIXIO  CHANGE HISTORY                             * H H*                                                                      * H H************************************************************************ H H*   VER       DATE      BY             DESCRIPTION.                    * H H************************************************************************ H H*                                                                      * H H*  A000      02/08/83   JCB           GENERATE INITIAL MPX BLOCKED     * H H*                                     FILE SUPPORT.                    * H H*                                                                      * H    @  H*  A001      02/11/83   JCB           ADDED EOM SUPPORT AND GENERAL    * H H*                                     FIXES FROM LANGUAGES GROUP.      * H H*                                                                      * H H*  A002      02/15/83   JCB           ADDED STANDARD MPX DEVICE        * H H*                                     ASSIGNMENT SUPPORT.              * H H*                                                                      * H H*  A003      02/23/83   JCB           ADDED STANDARD MPX PARSING       * H H*                                     LOGIC FOR ASSIGNMENTS FROM TSM.  * H H*                                                                      * H H************************************************************************ H    @           SPACE      5  H************************************************************************ H H*                                                                      * H H*        G O U L D   S. E. L.   U N I X I O  S U B R O U T I N E S     * H H*                                                                      * H H*                         UNIX                                         * H H*                                                                      * H H*                     FEBRUARY 1983                                    * H H*                                                                      * H H************************************************************************ H !         LIST      ON,NOMAC,NOREP !                  @           SPACE     2  H************************************************************************ H *   UNIX I/O EMULATION ROUTINES  H************************************************************************ H          SPACE     2  H************************************************************************ H *  C*   THE UNIX I/O EMULATOR ROUTINES EMULATE THE UNIX I/O ENVIRONMENT C E*   NECESSARY TO RUN THE C COMPILER TO BE PROVIDED BY BELL LABS.  THE E F*   CALLING CONVENTIONS ARE GUESSED.  THE ARGUMENT LIST IS COPIED FROM F B*   UNIX WITH THE EXCEPTION THAT CERTAIN ARGUMENTS ARE NOT USED OR B *   ONLY PARTIALLY USED.  *  D*   THESE ROUTINES MAKE IT POSSIBLE TO READ, WRITE, SEEK, AND APPEND D                                                       @  C*   MPX-32 BLOCKED FILES.  MAXIMUM TRANSFER COUNT IS LIMITED TO 254 C G*   BYTES.  SEEK TO BOM OR EOF ARE SUPPORTED.  MPX-32 COMPRESSED SOURCE G C*   FILES ARE NOT SUPPORTED.  A LF (X'0A') IS APPENDED TO ALL LINES C C*   READ.  LF'S ARE STRIPED FROM OUTPUT BEFORE WRITING.  NULL LINES C F*   ARE WRITTEN AS ONE SPACE FOR MPX-32 COMPATABILITY.  THESE ROUTINES F C*   ASSUME THAT BLOCKED FILES CONTAIN TEXT.  READING OTHER NON-TEXT C 1*   BLOCKED FILES MAY CAUSE UNDETERMINED RESULTS. 1 *  H************************************************************************ H          SPACE     2  D*                                  PACKAGE CAN ACCESS THE FILE TABLE D          DEF       _open           DEF       _fcbadr           DEF       _close               @           DEF       _creat           DEF       _read           DEF       _write           DEF       _readraw           DEF       _writraw           DEF       _seek           DEF       _isatty           DEF       _access           DEF       _fstat           DEF       _link           DEF       _unlink  *XXX     DEF       RM.OPEN  *XXX     DEF       RM.CLSE  *XXX     DEF       RM.READ  *XXX     DEF       RM.WRIT  *XXX     DEF       RM.ADVF  *XXX     DEF       RM.ADVR  *XXX     DEF       RM.RWND  *XXX     DEF       RM.BACK           SPACE     2  H************************************************************************ H *   PROGRAM SIZING EQUATES                                                                        @  H************************************************************************ H          SPACE     1  2FILECNT  EQU       10              OPEN FILE LIMIT 2 +FCBSIZE  EQU       16W             FCB SIZE + 7PARMSIZE EQU       12W             FILE PARAMETERS SIZE 7 6PNBSIZE  EQU       18W             PATHNAME BLOCK SIZE 6 BPNBWSIZE EQU       2W              PATHNAME BLOCK VECTOR WORD SIZE B <LINESIZE EQU       768             LINE BUFFER SIZE IN BYTES < =FILESIZE EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE+LINESIZE = 8*                                  FILE TABLE ENTRY SIZE 8 %SIZER    SET       FILESIZE*FILECNT/4 % !_filtabl COMMON    >FILTABL(2400) !          SPACE     2  H************************************************************************ H         @  *   REGISTER EQUATES  H************************************************************************ H          SPACE     1  2AP       EQU       1              ARGUMENT POINTER 2 X1       EQU       1  8X2       EQU       2              GENERAL INDEX NUMBER 1 8 /SP       EQU       3              STACK POINTER / X3       EQU       3           SPACE     1  :R0       EQU       0              GENERAL REGISTER EQUATES : R1       EQU       1  R2       EQU       2  R3       EQU       3  R4       EQU       4  R5       EQU       5  R6       EQU       6  R7       EQU       7  
         PAGE 
 H************************************************************************ H H*   SYSTEM EQUATES                                                     * H    @  H************************************************************************ H C.DTTA   EQU       X'00AA0'  C.DTTN   EQU       X'00CB1'  C.TSAD   EQU       X'00A80'  C.UDTA   EQU       X'00B38'  C.UDTN   EQU       X'00C38'  DFT.STB  EQU       X'00000'  DFT.ACF  EQU       X'00001'  DFT.FLGS EQU       X'00004'  RR.ACCS  EQU       X'00008'  RR.APPND EQU       X'00004'  RR.BLK   EQU       X'00004'  RR.DATE  EQU       X'00020'  RR.DENS  EQU       X'00006'  HRR.DEV   EQU       X'00020'                                         3205 H RR.DEVC  EQU       X'00003'  RR.DT3   EQU       X'00010'  RR.EXCL  EQU       X'00011'  RR.LFC   EQU       X'00000'  RR.LFC2  EQU       X'00004'  RR.MODFY EQU       X'00002'                        @  RR.NAME1 EQU       X'00010'  RR.NBLKS EQU       X'00014'  RR.OPTS  EQU       X'0000C'  RR.PATH  EQU       X'00001'  RR.PLEN  EQU       X'00006'  RR.READ  EQU       X'00000'  RR.RID   EQU       X'00006'  RR.SBO   EQU       X'00003'  HRR.SEP   EQU       X'0000F'                                         2129 H RR.SFC   EQU       X'00008'  RR.SGO   EQU       X'00001'  RR.SHAR  EQU       X'00010'  RR.SIZE  EQU       X'00005'  RR.SLO   EQU       X'00002'  RR.SYC   EQU       X'00000'  RR.TEMP  EQU       X'00002'  RR.TYPE  EQU       X'00004'  RR.UNBLK EQU       X'00005'  RR.UNFID EQU       X'00014'  RR.UPDAT EQU       X'00003'  RR.VLNUM EQU       X'00011'  RR.WRITE EQU       X'00001'  UDT.SIZE EQU       X'00040'       @  UDT.STAT EQU       X'00004'  
         PAGE 
 H************************************************************************ H H*   DEVICE EQUATES                                                     * H H************************************************************************ H          SPACE     1  5TERMINAL EQU       -1              FILE IS A TERMINAL 5 6LINEPTR  EQU       1               FILE IS AN SLO FILE 6 /NULL     EQU       2               FILE IS NULL / /EOM      EQU       -2              FILE GOT EOM /          SPACE     4  H************************************************************************ H *   MODE EQUATES  H************************************************************************ H          SPACE     1                            @  1NOTUSED  EQU       55             FILE NOT IN USE 1 3READMODE EQU       0              FILE IN READ MODE 3 4WRITMODE EQU       1              FILE IN WRITE MODE 4 9READWRIT EQU       2              FILE IN READ/WRITE MODE 9 ARWE      EQU       7              FILE IN READ/WRITE/EXECUTE MODE A CRD.ACC   EQU       X'80'           READ ACCESS                 A001 C CUPD.ACC  EQU       X'10'           UPDATE ACCESS               A001 C          SPACE     2  H************************************************************************ H *   BLOCKED EQUATES  H************************************************************************ H          SPACE     1  5UNBLOCK  EQU       0              FILE IS NOT BLOCKED 5                                                @  1BLOCKED  EQU       1              FILE IS BLOCKED 1          SPACE     2  H************************************************************************ H *   WRITTEN, EOF EQUATES  H************************************************************************ H          SPACE     1  FALSE    EQU       0  TRUE     EQU       1           SPACE     2  H************************************************************************ H *   LOCAL MACROS  H************************************************************************ H          SPACE     1  
ENTER    DEFM 
 A         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION A G         ADI       SP,-8W          DECREMENT SP FOR CALLED ROUTINE A001 G                                                      @  H         STD       R0,2W,SP        STORE RETURN ADDR IN STACK & PREV. SP H B         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK B :         LA        AP,8W,R1        PUT ARG AREA ADDR IN AP : 4         STW       SP,SPSAVE      SAVE STACK POINTER 4 1         STW       AP,APSAVE      SAVE COPY OF AP 1 
         ENDM 
          SPACE     1  
RETURN   DEFM 
 C         LW        SP,SPSAVE      RESTORE OLD STACK PTR FROM SPSAVE C ?         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK ? >         TRR       SP,R3           RESTORE OLD STACK PTR TO R3 > <         TRSW      R2              RETURN TO CALLING ROUTINE < 
         ENDM 
          SPACE     1  FIL      DEFM      UNIT,BUFFER           DATAW     %UNIT                   @           REZ       7W           DATAW     %BUFFER           DATAW     LINESIZE           REZ       6W           DATAW     NOTUSED           REZ       PARMSIZE-1W           REZ       PNBSIZE           REZ       PNBWSIZE           REZ       LINESIZE  
         ENDM 
          SPACE     1  INDEX    DEFM      REG  6         TRR       %REG,R5         SET UP FOR MULTIPLY 6 A         MPI       R4,FILESIZE     GET OFFSET FROM START OF TABLE A          TRR       R5,%REG  8         LA        R5,>FILTABL     BASE ADDRESS OF TABLE 8 D         ADR       R5,%REG         ABSOLUTE ADDRESS OF DESIRED ENTRY D 
         ENDM 
 
         PAGE 
 H************************************************************************ H                               @  *   FILE TABLE FIELD EQUATES  *  4*   LINE           CONTAINS THE CURRENT DATA RECORD. 4 *  B*   LINPTR         CONTAINS THE BYTE POSITION FOR THE NEXT BYTE TO B 4*                  BE TRANSFERRED TO OR FROM A LINE. 4 *  B*   BLKPTR         CONTAINS THE CURRENT BLOCK POSITION IN THE FILE B 1*                  (ONLY USED IN UNBLOCKED MODE). 1 *  G*   MODE           CONTAINS THE CURRENT ACCESS MODE OF THE FILE.  WRITE G *  A*   BLOCK          CONTAINS THE INDICATION OF WHETHER THE FILE IS A B*                  BLOCKED (MPX-32 SOURCE FILE) OR UNBLOCKED (UNIX B *                  STYLE FILE).  *  ?*   EOFPTR,EOLPTR  CONTAINS THE EOF BYTE POSITION (USED BY UNIX ? C*                  STYLE FILES), OR THE END OF CURRENT LINE POINTER C          @  0*                  (USED BY MPX-32 STYLE FILES). 0 *  G*   EOF            INDICATION IF END OF FILE HAS BEEN ENCOUNTERED (USED G **                  BY MPX-32 STYLE FILES). * *  G*   DEVICE         CONTAINS INDICATION IF DEVICE CANNOT BE TREATED LIKE G *                  A DISC FILE  *  (*   FCB            CONTAINS A SHORT FCB. ( *  H************************************************************************ H          SPACE     1  FCB      EQU       0W  MODE     EQU       FCBSIZE  LINPTR   EQU       FCBSIZE+1W  BLKPTR   EQU       FCBSIZE+2W  BLOCK    EQU       FCBSIZE+3W  EOFPTR   EQU       FCBSIZE+4W  EOLPTR   EQU       EOFPTR  EOF      EQU       FCBSIZE+5W  DEVICE   EQU       FCBSIZE+6W                                     @  ?FLAGS    EQU       FCBSIZE+7W      R.M. FLAGS FOR BLOCKED FILES ? 3*        BIT 0     SET - THIS FCB USING RM ROUTINES 3 -*                  RESET - USE STANDARD SVC'C - 2*        BIT 1     SET - THIS IS A COMPRESSED FILE 2 0*                  RESET - STANDARD BLOCKED FILE 0 *  CFLOC     EQU       FCBSIZE+8W      CURRENT OFFSET INTO FILE (BYTES) C CCPTR     EQU       FCBSIZE+9W      POINTER INTO LINE FOR COMP FILES C CSECTA    EQU       FCBSIZE+10W     CURRENT SECTOR ADDRESS FOR FILES C -FREE1    EQU       FCBSIZE+11W     SPARE WORD - D*                                  BOUNDING FOR THE PNB THAT FOLLOWS D #PNB      EQU       FCBSIZE+PARMSIZE # +PNBWORD  EQU       FCBSIZE+PARMSIZE+PNBSIZE + 4LINE     EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE 4      @           SPACE     2  H************************************************************************ H *    LINE FEED TCW  H************************************************************************ H          SPACE     1           BOUND     1W           CSECT  LFCHAR   DATAB     X'20'  CACMODES  DATAB     1,4,4           ACCESS MODES FOR RRS        A001 C 
         PAGE 
 H************************************************************************ H !*   VARIOUS CONTROL BLOCK EQUATES ! H************************************************************************ H          SPACE     1  3FCB.LFC  EQU       0W             LFC OFFSET IN FCB 3 0FCB.TCW  EQU       1W             TCW LOC IN FCB 0 7FCB.GCFG EQU       2W             GENERAL CONTROL FLAGS 7    @  7FCB.CBRA EQU       5H             RANDOM ACCESS ADDRESS 7 .FCB.SFLG EQU       3W             STATUS FLAGS . /FCB.RECL EQU       4W             RECORD LENGTH / 6FCB.SPST EQU       6W             SPECIAL STATUS FLAGS 6 7FCB.ERWA EQU       8W             EXPANDED DATA ADDRESS 7 <FCB.EQTY EQU       9W             EXPANDED TRANSFER QUANTITY < 1FCB.IST1 EQU       11W            XIO STATUS WD 1 1 1FCB.IST2 EQU       12W            XIO STATUS WD 2 1 ,FCB.XCT  EQU       9W             BYTE COUNT , -FCB.XAD  EQU       8W             BUFFER ADDR - 6FCB.OPT  EQU       2W             OPTION OFFSET IN FCB 6 :FCB.RAN  EQU       4              RANDOM ACCESS OPTION BIT : EFCB.RAA  EQU       5H             RANDOM ACCESS ADDRESS OFFSET IN FCB E                           @  >FCB.STAT EQU       12B            REQUEST STATUS OFFSET IN FCB > 2FCB.ERR  EQU       1              ERROR STATUS BIT 2 0FCB.EOF  EQU       6              EOF STATUS BIT 0 0FCB.EOM  EQU       7              EOM STATUS BIT 0 >FCB.CNT  EQU       4W             TRANSFER COUNT OFFSET IN FCB > ;FCB.FAT  EQU       7W             FAT ADDRESS OFFSET IN FCB ; GFAT.BBUF EQU       10W            BLOCKING BUFFER ADDRESS OFFSET IN FAT G <RD.TYPE  EQU       15H            RESOURCE TYPE OFFSET IN RD < 9RD.PERM  EQU       10             PERMANENT FILE RESOURCE 9 4RD.FLAG  EQU       64W            RESOURCE FLAG WORD 4 6RD.BLK   EQU       31             RESOURCE BLOCKED BIT 6 1RD.USER  EQU       160W           USER AREA IN RD 1                                            @  :RD.EOF   EQU       190W           EOF POINTER OFFSET IN RD : 5CP.OPTS  EQU       2W             OPTION FLAGS IN CNP 5          SPACE     2  @NEWLINE  EQU       X'0A'          NEW LINE CHARACTER (LINE FEED) @ <CR       EQU       X'0D'           CARRIAGE RETURN CHARACTER <          SPACE     2  H************************************************************************ H *   REGISTER SAVE AREA  H************************************************************************ H          SPACE     1           BOUND     1D           SPACE     2  H************************************************************************ H *  *   PROGRAMMING CONVENTIONS  *  F*   1) THE ARGUMENT POINTER IS MAINTAINED IN REGISTER AP.  AP IS SAVED F                       @  :*   AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, SVC'S. : *  E*   2) THE FILE TABLE ENTRY ADDRESS IS TYPICALLY HELD IN REGISTER X2. E E*   X2 IS REGENERATED AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, E 
*   SVC'S. 
 *  H*   3) ALL ENTRIES INTO THIS PACKAGE ARE FUNCTIONS, THAT IS, THEY RETURN H @*   A VALUE.  THE VALUE IS RETURNED IN R0.  ERRORS ARE GENERALLY @ E*   INDICATED BY -1.  SUCCESS IS GENERALLY INDICATED BY 0.  CREAT AND E E*   OPEN RETURN THE FILE DESCRIPTOR TO SHOW SUCCESS.  WRITE RETURNS 0 E @*   TO INDICATE EOF DETECTED AND N(>0) TO INDICATE THE NUMBER OF @ $*   CHARACTERS ACTUALLY TRANSFERRED. $ *  G*   4) UTILITY SUBROUTINES EXPECT AP AND X2 TO BE PROPERLY INITIALIZED. G                                                      @  F*   RESULTS ARE RETURNED IN R7.  ERRORS ARE GENERALLY INDICATED BY -1. F (*   SUCCESS IS GENERALLY INDICATED BY 0. ( *  H************************************************************************ H 
         PAGE 
 H************************************************************************ H *   CLOSE FILE  H************************************************************************ H          SPACE     1  _close   EQU       $  9         ENTER                    SAVE REGISTERS ON STACK 9 9         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR A D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D                                                                   @  A         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? /         LW        R4,MODE,X2     GET FILE MODE / )         CI        R4,NOTUSED     IN USE? ) =         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR = 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 ,         CI        R7,NULL        NULL FILE? , 0         BEQ       CLOS.0         YES, FINISH UP 0 6         CI        R4,READMODE    ARE WE OUTPUT ACTIVE 6 1         BEQ       CLOS.X          NO, JUST CLOSE 1 ;         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER ; 4         BZ        CLOS.Y          NO, JUST CLOSE IT 4                  @  0         BL        SETTCW          YES, PURGE IT 0 *         BL        WRITLINU        WRIT IT * HCLOS.Y   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.WEOF        WEOF FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL WEOF 2 +         SVC       1,X'38'        WRITE EOF + HCLOS.X   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.CLSE        CLSE FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL CLSE 2                                                     @  1         SVC       1,X'39'         CLOSE THE FILE 1 (         ZR        R7             NO CNB ( /         SVC       2,X'53'        DEASSIGN FILE / :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 7*        TRR       R7,R7          TEST THE RETURN VALUE 7 =*        BNE       ERRETURN       NON ZERO, RETURN WITH ERROR = CLOS.0   LI        R4,NOTUSED  @         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL @ 3         ZR        R0             INDICATE NO ERROR 3 0         RETURN                   RETURN TO USER 0 
         PAGE 
 H************************************************************************ H *   GET FCB ADDRESS                                     @  H************************************************************************ H          SPACE     1  /_fcbadr  EQU       $               get fcb addr / 9         ENTER                    SAVE REGISTERS ON STACK 9 9         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR A D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D A         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > /         LW        R4,MODE,X2     GET FILE MODE / )         CI        R4,NOTUSED     IN USE? ) =         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR =                                                      @  <         TRR       R2,R0           FCB ADDR TO R0 FOR RETURN < ;         RETURN                    RETURN ADDRESS TO CALLER ; 
         PAGE 
 H************************************************************************ H *   CREATE FILE  H************************************************************************ H          SPACE     1  _creat   EQU       $  9         ENTER                    SAVE REGISTERS ON STACK 9 0         BL        PARSE          PARSE PATHNAME 0 7         TRR       R7,R7          TEST THE RETURN VALUE 7 C         BLT       ERRETURN       LESS THAN ZERO, RETURN WITH ERROR C E         BGT       CREAT.2        ZERO PATHNAME LENGTH, GET FILE DESC E A         BL        EXISTS         TEST IF THE FILE ALREADY EXISTS A                @  7         TRR       R7,R7          TEST THE RETURN VALUE 7 ;         BGE       CREAT.1        JUMP AHEAD IF FILE EXISTS ; D         LW        R1,PNBWRDX    GET PNB VECTOR WORD IN REGISTER FOR D +*                                   SERVICE + E*        ADD CODE HERE TO CREATE DIRECTORY IF PATH END WITH DIRECTORY E *  8         LA        R2,RCB          CREATE PERMANENT FILE 8          ZR        R7           SVC       2,X'20'  :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : 7         TRR       R7,R7          TEST THE RETURN VALUE 7 =         BNE       ERRETURN       NON ZERO, RETURN WITH ERROR = CREAT.1  EQU       $  5         BL        GETFD          GET FILE DESCRIPTOR 5          TRR       R7,X2                                    @  H         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR H G         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE G >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? :         LI        R4,LINESIZE    GET FULL CHARACTER COUNT : 7         BL        SETTCW         INITIALIZE TCW IN FCB 7 :         BL        PNBSAVE        TUCK PATHNAME BLOCK AWAY : $         LW        R4,FCB+FCB.LFC,X2 $ )*                                 GET LFC )          SLL       R4,8  5         SRL       R4,8           CLEAR OUT LEAD BYTE 5 1         STW       R4,RRS+RR.LFC   SET LFC IN RRS 1 4         ZMW       RRS+RR.TYPE     CLEAR PART OF RRS 4                   @  /         ZMW       RRS+RR.ACCS     CLEAR ACCESS / 0         ZMW       RRS+RR.OPTS     CLEAR OPTIONS 0 -         LI        R5,1            TYPE 1 RRS - -         STB       R5,RRS+RR.TYPE  PUT IN RRS - ?         LB        R5,PNBWRDX    GET PNB VECTOR WORD BYTE COUNT ? !         STB       R5,RRS+RR.PLEN ! @*                                 SET PATHNAME BLOCK SIZE IN RRS @ B         SRL       R5,2           DIVIDE COUNT BY 4 (TO GET WORDS) B :         ADI       R5,RR.1.SIZ    ADD LENGTH OF RRS HEADER : 6         STB       R5,RRS+RR.SIZE  SET RRS SIZE IN RRS 6 A*   FIX TO MAKE creat ASSIGN THE WITH PROPER ACCESS RIGHTS.  A001 A C         LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001 C                                                             @  C         STB       R5,RRS+RR.ACCS     IN THE RRS               A001 C 9         SBM       RR.SHAR,RRS+RR.OPTS  SET SHARED ACCESS 9 :         LA        R1,RRS           ASSIGN LFC TO RESOURCE :          ZR        R7           SVC       2,X'52'  :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 7         TRR       R7,R7          TEST THE RETURN VALUE 7 =         BNE       CR.ERR3        NON ZERO, RETURN WITH ERROR = 7         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD 7 5         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB 5 H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H 4         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE 4           @  ;         LI        R7,X'04'        SET UPDATE ACCESS IN CNP ; -         STB       R7,CNP+CP.OPTS  PUT IN CNP - 3         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED 3 4*XXX     SBM       0,FLAGS,X2      SET USING RM FLAG 4 =         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET = >         SBR       R1,1            SET CC1 FOR R/W MODE FOR RM > 3*XXX     BL        RM.OPEN         OPEN VIA REC MGR 3 /*XXX     TRR       R7,R7           ANY RM ERROR / 4*XXX     BNZ       CR.ERR2         GIVE IT TO CALLER 4 <         LA        R7,CNP         SET UPDATE ACCESS WITH CNP < +         SVC       2,X'42'        OPEN FILE + +*XXX     BL        RM.WEOF        WRITE EOF + D         SVC       1,X'38'         WRITE EOF TO FILE FOR APPEND MODE D                  @  .*XXX     BL        RM.RWND         REWIND FILE . 2         SVC       1,X'37'         REWIND THE FILE 2 ;         LW        AP,APSAVE      RESTORE ARGUMENT  POINTER ; B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 6         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE 6 B         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK B D         ZMW       EOFPTR,X2      SET EOF POINTER TO FIRST CHARACTER D E         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER E 7         ZMW       FLOC,X2        FILE POSITION IS ZERO 7 :         ZMW       CPTR,X2        NO DECOMPRESSING POINTER : 0         ZMW       SECTA,X2       NO SECTORS YET 0          LI        R4,READWRIT                                                @  8         STW       R4,MODE,X2     SET MODE TO READ/WRITE 8          LI        R4,BLOCKED  @         STW       R4,BLOCK,X2    SET FILE TYPE TO BLOCKED (MPX) @          BU        CRE.RET  *  .* ALLOCATE THIS FILE DESCRIPTOR TO NULL DEVICE . *  CREAT.2  EQU       $           BL        GETFD           TRR       R7,X2  H         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR H          STW       R7,0W,AP  >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > -         ZMW       FLAGS,X2       CLEAR FLAGS -          LI        R4,READWRIT  8         STW       R4,MODE,X2     SET MODE TO READ/WRITE 8 1         LI        R4,NULL        GET NULL DEVICE 1 7         STW       R4,DEVICE,X2   SET FILE TO NULL FILE 7     @           LI        R4,TRUE  8         STW       R4,EOF,X2      SET END OF FILE STATUS 8          LI        R4,BLOCKED  :         STW       R4,BLOCK,X2    SET FILE TO BLOCKED MODE : 8CRE.RET  LW        R0,0W,AP       RETURN FILE DESCRIPTOR 8 2         RETURN                   RETURN TO CALLER 2 HCR.ERR2  LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H (         ZR        R7             NO CNB ( /         SVC       2,X'53'        DEASSIGN FILE / :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B CR.ERR3  LI        R4,NOTUSED  @         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL @ 0         LI        R0,-1          INDICATE ERROR 0         @  0         RETURN                   RETURN TO USER 0 
         PAGE 
 H************************************************************************ H 
*   OPEN FILE 
 H************************************************************************ H          SPACE     1  _open    EQU       $  9         ENTER                    SAVE REGISTERS ON STACK 9 >         BL        CASSG          PARSE PATHNAME AND BUILD RRS > 5         BL        GETFD          GET FILE DESCRIPTOR 5 8         TRR       R7,X2          TEST THE RETURN RESULT 8 H         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR H 6         LW        AP,APSAVE       RESTORE ARG POINTER 6 G         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE G                         @  >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? :         LI        R4,LINESIZE    GET FULL CHARACTER COUNT : 7         BL        SETTCW         INITIALIZE TCW IN FCB 7 $         LW        R4,FCB+FCB.LFC,X2 $ )*                                 GET LFC )          SLL       R4,8  5         SRL       R4,8           CLEAR OUT LEAD BYTE 5 1         STW       R4,RRS+RR.LFC   SET LFC IN RRS 1 C* FIX TO MAKE open ASSIGN FILE WITH PROPER ACCESS RIGHTS.      A001 C C         LW        AP,APSAVE       RESTORE ARG POINTER         A001 C C         LW        R5,1W,AP        GET OPEN MODE               A001 C C         CI        R5,READMODE     SEE IF READ                 A001 C    @  C         BNE       OPEN.1          BR IF NOT                   A001 C C         LI        R5,RD.ACC       SET READ ACCESS BIT         A001 C 4         LI        R4,READMODE    GET READ MODE TYPE 4 C         BU        OPEN.2          MERGE CODE                  A001 C COPEN.1   LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001 C /         LI        R4,READWRIT     SET R/W MODE / COPEN.2   STB       R5,RRS+RR.ACCS  PUT IN RRS                  A001 C 6         STW       R4,MODE,X2     SET MODE TO R/W OR R 6 /         LB        R7,RRS+RR.TYPE  GET RRS TYPE / :         CI        R7,4            SEE IF TYPE 4 (LFC=LFC) : ,         BNE       $+2W            BR IF NOT , 4         ZMB       RRS+RR.ACCS     CLEAR ACCESS BYTE 4                           @  )         ZR        R7              NO CNP ) 2         LA        R1,RRS          GET ADDR OF RRS 2 2         SVC       2,X'52'         ASSIGN RESOURCE 2 ;         LW        AP,APSAVE       RESTORE ARGUMENT POINTER ; C         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY POINTER C 3         TRR       R7,R7           TEST RETURN CODE 3 4         BNE       OPEN.ERR        RETURN WITH ERROR 4 ;         LA        R7,CNP          ASSUME FILE IF READ ONLY ; 4         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE 4 1         LI        R1,BLOCKED      OPENED BLOCKED 1 3         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED 3 C         TBM       RR.UNBLK,RRS+RR.OPTS  SEE IF UNBLOCKED SPECIFIED C ,         BNS       $+3W            BR IF NOT ,                    @  >         LI        R1,UNBLOCK      ASSUME UNBLOCKED FOR MOMENT > 5         ABM       11,CNP+CP.OPTS  SET UNBLOCKED OPEN 5 0         STW       R1,BLOCK,R2     SET FOR LATER 0 7         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD 7 5         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB 5 4*XXX     CI        R1,UNBLOCK      IS FILE UNBLOCKED 4 5*XXX     BEQ       OPEN.5          USE STD I/O IF YES 5 H*XXX     LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H <*XXX                              R7 SET TO CORRECT CNP ADDR < 3*XXX     TRR       R7,R0           SAVE CNP ADDRESS 3 **XXX     LW        R4,0W,R1        GET LFC * **XXX     ANMW      R4,=X'FFFFFF'   MASK IT * ;*XXX     LA        R1,INQ.INFO     SET UP INQUIRY INFO AREA ;          @  +*XXX     ZR        R5              CLEAR R5 + )*XXX     ZR        R7              NO CNP ) ,*XXX     SVC       2,X'48'         M.INQUIRY , 2*XXX     LW        R1,INQ.INFO+3W  GET DTT ADDRESS 2 /*XXX     LB        R6,0,R1         GET DEV TYPE / /*XXX     CI        R6,3            IS IT A DISC / 1*XXX     BGT       OPEN.3          BR IF NOT DISC 1 /*XXX     LW        R1,INQ.INFO+1W  GET FAT ADDR / 3*XXX     TRR       R1,R5           SAVE FAT ADDRESS 3 A*XXX     LB        R6,DFT.ACF,R1   GET ACCESS FLAGS/SYS FILE CODE A =*XXX     ANMW      R6,=X'7'        MASK ALL BUT SYS FILE CODE = 1*XXX     CI        R6,0            IS IT SYS FILE 1 /*XXX     BNE       OPEN.3          RET IF IT IS / :*XXX     LA        R1,FCB,X2       GET FCB ADDRESS INTO R1 :         @  4*XXX     SBM       0,FLAGS,X2      SET USING RM FLAG 4 =*XXX     ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET = /*XXX     LW        R6,MODE,X2      GET MODE R/W / 2*XXX     BZ        $+2W            BR IF READ MODE 2 >*XXX     SBR       R1,1            SET CC1 FOR R/W MODE FOR RM > 3*XXX     BL        RM.OPEN         OPEN VIA REC MGR 3 6*XXX     STW       R5,FCB+FCB.FAT,X2  SAVE FAT ADDRESS 6 /*XXX     TRR       R7,R7           ANY RM ERROR / 4*XXX     BNZ       OPEN.ERR        GIVE IT TO CALLER 4 ;*XXX     BU        OPEN.4          CONTINUE PROCESSING OPEN ; :*XXXOPEN.3   TRR       R0,R7           RESTORE CNP ADDRESS : :OPEN.5   LA        R1,FCB,X2       GET FCB ADDRESS INTO R1 :                                                                 @  =         ZBM       0,FLAGS,X2      NOT USING RM FOR THIS FILE = =         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET = +OPEN.6   SVC       2,X'42'        OPEN FILE + ;OPEN.4   LW        AP,APSAVE      RESTORE ARGUMENT  POINTER ; B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 6         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE 6 ;         LW        R3,FCB+FCB.FAT,X2  GET FAT ADDR FROM FCB ; :         LI        R4,NULL         SET DEVICE TYPE TO NULL : 5         TBM       3,DFT.FLGS,X3   SEE IF NULL DEVICE 5 ,         BS        OPEN.P          BR IF YES , >         LI        R4,TERMINAL     SET DEVICE TYPE TO TERMINAL > 2         TBM       7,DFT.STB,X3    SEE IF TERMINAL 2                                              @  ,         BS        OPEN.P          BR IF YES , 6         TBM       RR.SLO,RRS+RR.OPTS  SEE IF SLO FILE 6 ;         BS        OPEN.P          TREAT AS TERMINAL IF YES ; 5         ZR        R4              INDICATE IT'S FILE 5 +OPEN.P   STW       R4,DEVICE,R2    SET TYPE + B         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK B D         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER D E         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER E 7         ZMW       FLOC,X2        FILE POSITION IS ZERO 7 :         ZMW       CPTR,X2        NO DECOMPRESSING POINTER : 0         ZMW       SECTA,X2       NO SECTORS YET 0          LI        R4,FALSE  7         STW       R4,EOF,X2      SET EOF FLAG TO FALSE 7             @  8         LW        R0,0W,AP       RETURN FILE DESCRIPTOR 8 2         RETURN                   RETURN TO CALLER 2 *  1OPEN.ERR LI        R0,-1           SET ERROR CODE 1 ?         LI        R4,NOTUSED      SET FILE DESCRIPTOR NOT USED ? 9         STW       R4,MODE,X2      PUT IN MODE IDENTIFIER 9 7         RETURN                    RETURN TO SENDER.... 7 H************************************************************************ H E*   CHECK IF FILE EXISTS AND ITS ACCESS - READ, WRITE, AND/OR EXECUTE E H************************************************************************ H          SPACE     1  _access  EQU       $  :         ENTER                     SAVE REGISTERS ON STACK : 1         BL        PARSE           PARSE PATHNAME 1                 @  4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON ZERO, RETURN WITH ERROR > B         BL        EXISTS          TEST IF THE FILE ALREADY EXISTS B 5         TRR       R7,R7           TEST RETURN RESULT 5 =         BLT       ACC.RET         RETURN -1 IF DOESN'T EXIST = H         LI        R7,RWE          LOAD ACCESS CODE INTO R7 IF IT EXISTS H ACC.RET  EQU       $  8         TRR       R7,R0           RETURN VALUE IN REG 0 8          RETURN  
         PAGE 
 H************************************************************************ H -*   RETRIEVE FILE STATUS (FILE SIZE IN BYTES) - H************************************************************************ H          SPACE     1  _fstat   EQU       $      @           ENTER  ;         LW        X2,0W,AP        RETRIEVE FILE DESCRIPTOR ; 4         BLT       ERRETURN        CHECK IF VALID FD 4 6         CI        X2,FILECNT      IS FD WITHIN RANGE? 6 <         BGE       ERRETURN        IF NOT, RETURN WITH ERROR < B         INDEX     X2              X2 IS FILE TABLE INDEX REGISTER B A         STW       X2,FTESAVE      STORE FILE TABLE ENTRY ADDRESS A =         LW        R1,PNBWORD,X2   GET PATHNAME BLOCK ADDRESS = ?         LA        R6,RD           RETRIEVE RESOURCE DESCRIPTOR ?          ZR        R7           SVC       2,X'2C'  4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR >                                                         @  ;         LW        AP,APSAVE       RESTORE ARGUMENT POINTER ; C         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY ADDRESS C <         LW        R1,1W,AP        GET STATUS BUFFER ADDRESS < C         LW        R5,RD+RD.EOF     GET FILESIZE FROM RESOURCE DESC C <         BNZ       $+2W            USE NEW COUNT IF NOT ZERO < C         LW        R5,RD+RD.USER   OTHERWISE USE OLD COUNT LOCATION C E         STW       R5,16B,R1       STUFF FILE SIZE INTO STATUS BUFFER E .         ZR        R0              O.K. RETURN . 3         RETURN                    RETURN TO CALLER 3 
         PAGE 
 H************************************************************************ H *   LINK A NEW FILE                                                                   @  H************************************************************************ H          SPACE     1  _link    EQU       $           ENTER  7         BL        PARSE           PARSE FIRST PATHNAME 7 4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR > 7         BL        EXISTS          CHECK IF FILE EXISTS 7 4         TRR       R7,R7           TEST RETURN VALUE 4 >         BLT       ERRETURN        NON-ZERO, RETURN WITH ERROR > <         LA        R2,PNBX         LOAD REG WITH ADDR OF PNB < G         LA        R3,PNB1         LOAD REG WITH ADDR OF PNB FOR 1ST PN G >         LNB       R7,PNBWRDX     GET NEGATIVE PATHNAME LENGTH >                                                       @  BL.LOOP   LB        R5,0B,R2        PERFORM BYTE-BY-BYTE COPY OF PN B C         STB       R5,0B,R3        STORED TO PNB FOR FIRST PATHNAME C 7         ABR       R2,31           INCREMENT ADDR IN R2 7 7         ABR       R3,31           INCREMENT ADDR IN R3 7 D         BIB       R7,L.LOOP       GET NEXT BYTE; DROP OUT WHEN DONE D 8         LA        R7,PNB1         GET ADDR OF FIRST PNB 8 >         LB        R5,PNBWRDX     GET LENGTH OF FIRST PATHNAME > >         STW       R7,PNBWRD1     STUFF ADDR INTO PNB1 POINTER > @         STB       R5,PNBWRD1     STUFF LENGTH INTO PNB1 POINTER @ B         LA        AP,1W,AP        SET ARG POINTER TO 2ND PATHNAME B 5         BL        PARSE           PARSE 2ND PATHNAME 5                                              @  4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR > 2         LW        R1,PNBWRD1     GET OLD PATHNAME 2 2         LW        R2,PNBWRDX     GET NEW PATHNAME 2          ZR        R7  9         SVC       2,X'2D'         LINK (RENAME) RESOURCE 9 ;         LW        AP,APSAVE       RESTORE ARGUMENT POINTER ; 4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR > .         ZR        R0              O.K. RETURN . 3         RETURN                    RETURN TO CALLER 3 
         PAGE 
 H************************************************************************ H *   UNLINK A FILE                                             @  H************************************************************************ H          SPACE     1  _unlink  EQU       $           ENTER  1         BL        PARSE           PARSE PATHNAME 1 4         TRR       R7,R7           TEST RETURN VALUE 4 >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR > 7         BL        EXISTS          CHECK IF FILE EXISTS 7 4         TRR       R7,R7           TEST RETURN VALUE 4 @         BLT       ERRETURN        LESS THAN ZERO, DOESN'T EXIST @ A         LW        R1,PNBWRDX     GET PNB VECTOR WORD FOR SERVICE A 2         ZR        R7              DELETE RESOURCE 2          SVC       2,X'24'  4         TRR       R7,R7           TEST RETURN VALUE 4                                                       @  >         BNE       ERRETURN        NON-ZERO, RETURN WITH ERROR > .         ZR        R0              O.K. RETURN . 3         RETURN                    RETURN TO CALLER 3 
         PAGE 
 H************************************************************************ H **   READ A SET OF CHARACTERS FROM THE FILE * H************************************************************************ H          SPACE     1  9_readraw EQU       $               READ UNBUFFERED RECORD 9          ENTER  /         SBM       0,RAW           SET RAW FLAG / -         BU        READC           MERGE CODE -          SPACE     2  _read    EQU       $  9         ENTER                    SAVE REGISTERS ON STACK 9 9         ZBM       0,RAW           SJOW STD READ, NOT RAW 9     @  9READC    LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR A D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D A         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? /         LW        R7,MODE,X2     GET FILE MODE / )         CI        R7,NOTUSED     IN USE? ) =         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR = 5         CI        R7,WRITMODE    FILE IN WRITE MODE? 5 B         BEQ       ERRETURN       IN WRITE MODE, RETURN WITH ERROR B 5         TBM       0,RAW           ARE WE IN RAW MODE 5               @  ,         BNS       RN.RAW          BR IF NOT , ;         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO ; /         BNZ       ERRETURN        ERROR IF NOT / 5         LW        R4,2W,AP        GET TRANSFER COUNT 5 0         BZ        ERRETURN        ERROR IF ZERO 0 1         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB 1 5         LW        R7,1W,AP        GET BUFFER ADDRESS 5 1         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB 1 H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL READ 2                                               @  -         SVC       1,X'31'        READ RECORD - :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 0         LI        R7,LINESIZE     GET LINE SIZE 0 1         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB 1 0         LA        R4,LINE,X2   GET LINE ADDRESS 0 1         STW       R4,FCB+FCB.XAD,X2 STUFF IN FCB 1 *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        ERRETURN       YES, RETURN WITH ERROR 8 $         LW        R0,FCB+FCB.CNT,X2 $ 5*                                 GET CHARACTER COUNT 5 *         TBM       FCB.EOF,FCB+FCB.STAT,X2 * 6*                                 WAS EOF ENCOUNTERED? 6      @  6         BNS       READ.15        YES, RETURN WITH EOF 6 <         LI        R4,TRUE         SET EOF IND FOR NEXT TIME < (         STW       R7,EOF,X2       DO IT ( 7READ.15  ZMW       LINPTR,X2       SHOW NOTHING IN LINE 7 6         ARMW      R0,FLOC,X2     UPDATE FILE LOCATION 6          RETURN  *  <RN.RAW   LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4 < @         ZR        R5             CLEAR THE TRANSFER COUNT IN R5 @ =         LW        R6,2W,AP       GET THE REQUEST COUNT IN R6 = 3         LA        R7,LINE,X2  GET THE LINE ADDRESS 3 E         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER E @         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY @ 8         LW        R7,1W,AP       GET THE BUFFER ADDRESS 8    @  B         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY B .         LW        R7,EOF,X2      GET EOF FLAG . )         CI        R7,FALSE       NO EOF? ) 4         BEQ       READ.1         NO EOF, SKIP AHEAD 4 <         ZR        R0             SET EOF IN RESULT REGISTER < 1         RETURN                   RETURN WITH EOF 1 CREAD.1   CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST C ?         BGE       READ.4         REQUEST SATISFIED, SKIP AHEAD ? -         TRR       R4,R4          LINE EMPTY? - 0         BGT       READ.3         NO, SKIP AHEAD 0          LW        R7,EOF,X2  .         CI        R7,TRUE        EOF REACHED? . 0         BEQ       READ.4         YES, FINISH UP 0                                                     @  H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL READ 2 -         SVC       1,X'31'        READ RECORD - :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        ERRETURN       YES, RETURN WITH ERROR 8 *         TBM       FCB.EOF,FCB+FCB.STAT,X2 * 6*                                 WAS EOF ENCOUNTERED? 6                              @  6         BS        READ.EOF       YES, RETURN WITH EOF 6 2         ABM       31,SECTA,X2    SHOW RECORD READ 2 $         LW        R7,FCB+FCB.CNT,X2 $ 5*                                 GET CHARACTER COUNT 5 5         LA        X3,LINE,X2  GET LINE ADDRESS IN X3 5 C         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE C 7         ADR       R7,X3          OFFSET TO END OF LINE 7 G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 3         LW        R1,BLOCK,X2     ARE WE UNBLOCKED 3 ,         BZ        RDB.2           BR IF YES , +RDB.0    TRR       R3,R1          COPY ADDR + 3         TRR       R7,R7          TEST IF ANY CHARS 3 0         BLE       RDB.1          BR IF NON LEFT 0                                    @  9         SUI       R1,1           BACK UP 1 CHAR POSITION 9 ,         LB        R1,0B,R1       GET A CHAR , /         CI        R1,X'20'       IS IT A SPACE / =         BNE       RDB.1          BR IF NON SPACE ENCOUNTERED = ?         SUI       R3,1           BACK UP END OF BUFFER POINTER ? 8         SUI       R7,1           BACK UP TRANSFER COUNT 8 :         BU        RDB.0          LOOP TIL FIRST NON SPACE : @RDB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT @ G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 8         LI        R7,NEWLINE     GET NEW LINE CHARACTER 8 4         STB       R7,0B,X3       PUT AT END OF LINE 4 2RDB.2    LW        R7,DEVICE,X2    GET DEVICE TYPE 2                                     @  ,         CI        R7,TERMINAL     TERMINAL? , 3         BNE       RDB.NOT         NO, BRANCH AHEAD 3 6         LA        R7,LFCHAR       GET ADDR OF 1 SPACE 6 1         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB 1 0         LI        R7,1            BYTE CNT OF 1 0 1         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB 1 2         LA        R1,FCB,X2       GET FCB ADDRESS 2 2         SVC       1,X'32'         WRITE LINE FEED 2 ;         LW        AP,APSAVE       RESTORE ARGUMENT POINTER ; C         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY ADDRESS C 0         LI        R7,LINESIZE     GET LINE SIZE 0 1         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB 1 0         LA        X3,LINE,X2   GET LINE ADDRESS 0                                              @  1         STW       R3,FCB+FCB.XAD,X2 STUFF IN FCB 1 /RDB.NOT  LA        R7,LINE,X2  GET LINE ADDRESS / :         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS : READ.3   EQU       $  3         LW        R3,LINADRS      GET LINE ADDRESS 3 4         LB        R7,0B,R3       GET BYTE FROM LINE 4 5         LW        R3,BUFADRS      GET BUFFER ADDRESS 5 ;         STB       R7,0B,R3       STORE BYTE TO USER BUFFER ; :         ADI       R5,1           INCREMENT TRANSFER COUNT : :         ABM       31,BUFADRS     INCREMENT BUFFER ADDRESS : 8         ADI       R4,1           INCREMENT LINE POINTER 8 8         ABM       31,LINADRS     INCREMENT LINE ADDRESS 8 E         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE E                          @  C         BLT       READ.1         LINE NOT EMPTY, DO NEXT CHARACTER C 9         ZR        R4             INITIALIZE LINE POINTER 9 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 3         CI        R7,TERMINAL    IS IT A TERMINAL? 3 /         BEQ       READ.4         YES FINISH UP / :         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER : 3         BU        READ.1         DO NEXT CHARACTER 3 READ.EOF LI        R7,TRUE  .         STW       R7,EOF,X2      SET EOF FLAG . READ.4   EQU       $  5         STW       R4,LINPTR,X2   ADJUST LINE POINTER 5 >         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION > H         TRR       R5,R0          MOVE TRANSFER COUNT IN RESULT REGISTER H                                                     @  2         RETURN                   RETURN TO CALLER 2 
         PAGE 
 H************************************************************************ H )*   WRITE A SET OF CHARACTERS TO THE FILE ) H************************************************************************ H          SPACE     1  3_writraw EQU       $               WRITE RAW RECORD 3          ENTER  +         SBM       0,RAW           SET FLAG + -         BU        WRIT.1          MERGE CODE -          SPACE     1  _write   EQU       $  9         ENTER                    SAVE REGISTERS ON STACK 9 3         ZBM       0,RAW           SHOW NOT RAW I/O 3 9WRIT.1   LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR A         @  D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D A         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? *         LW        R7,MODE,X2     GET MODE * .         CI        R7,NOTUSED     FILE IN USE? . B         BEQ       ERRETURN       FILE NOT USED, RETURN WITH ERROR B 4         CI        R7,READMODE    FILE IN READ MODE? 4 A         BEQ       ERRETURN       IN READ MODE, RETURN WITH ERROR A 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 ,         CI        R7,NULL        NULL FILE? , 0         BEQ       WRITE.5        YES, FINISH UP 0                                              @  5         TBM       0,RAW           ARE WE IN RAW MODE 5 ,         BNS       WR.RAW          BR IF NOT , ;         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO ; /         BNZ       ERRETURN        ERROR IF NOT / 5         LW        R4,2W,AP        GET TRANSFER COUNT 5 0         BZ        ERRETURN        ERROR IF ZERO 0 1         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB 1 5         LW        R7,1W,AP        GET BUFFER ADDRESS 5 1         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB 1 H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.WRIT        WRIT FILE USING RM 4                                            @  2*XXX     BU        $+2W           SKIP NORMAL WRIT 2 /         SVC       1,X'32'         WRITE RECORD / :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        ERRETURN       YES, RETURN WITH ERROR 8 $         LW        R0,FCB+FCB.CNT,X2 $ 5*                                 GET CHARACTER COUNT 5 6         ARMW      R0,FLOC,X2     UPDATE FILE POSITION 6 5         ABM       31,SECTA,X2    UPDATE RECORD COUNT 5 *         TBM       FCB.EOF,FCB+FCB.STAT,X2 * 6*                                 WAS EOF ENCOUNTERED? 6                                             @  6         BNS       WRIT.2         YES, RETURN WITH EOF 6 <         LI        R4,TRUE         SET EOF IND FOR NEXT TIME < (         STW       R4,EOF,X2       DO IT ( *WRIT.2   TBM       FCB.EOM,FCB+FCB.STAT,X2 * 6*                                 WAS EOM ENCOUNTERED? 6 ;         BNS       WRIT.3         NO, RETURN TRANSFER COUNT ; 9         LI        R0,EOM          SET EOM IND FOR RETURN 9 7WRIT.3   ZMW       LINPTR,X2       SHOW NOTHING IN LINE 7 ,         RETURN                    GO RETURN , *  2WR.RAW   LW        R4,LINPTR,X2   GET LINE POINTER 2 6         ZR        R5             CLEAR TRANSFER COUNT 6 3         LA        R7,LINE,X2  GET THE LINE ADDRESS 3 E         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER E                  @  @         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY @ 8         LW        R7,1W,AP       GET THE BUFFER ADDRESS 8 B         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY B 0WRIT.BLK TRR       R4,R4          IS LINE EMPTY? 0 0         BNE       WRITE.6        NO, SKIP AHEAD 0 6         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED 6 ,         BZ        WRITE.6         BR IF YES , 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 9         BEQ       WRITE.6        NOT SPECIAL, SKIP AHEAD 9 2         LW        R3,BUFADRS      GET BUFFER ADDR 2 7         LB        R7,0B,R3       GET CHARACTER OF LINE 7 6         CI        R7,X'0C'       SEE IF FORMFEED CHAR 6 -         BNE       WRITE.4        SKIP IF NOT -                      @  7         LI        R7,G'1'        GET A 1 FOR TOF ON LP 7 0         ABM       31,BUFADRS     SKIP OVER CHAR 0 6         ADI       R5,1           UPDATE REQUEST COUNT 6 -         BU        WRITE.41        MERGE CODE - AWRITE.4  LW        R7,=G' '       GET BLANK FOR SLO FORMS CONTROL A 2WRITE.41 LW        R3,LINADRS     GET LINE ADDRESS 2 G         STB       R7,0B,R3       STUFF FORMS CONTROL CHARACTER IN LINE G 5         ABM       31,LINADRS     UPDATE LINE ADDRESS 5 7         ADI       R4,1           UPDATE TRANSFER COUNT 7 WRITE.6  EQU       $  C         CAMW      R5,2W,AP       COMPARE TRANSFER COUNT TO REQUEST C 1         BGE       WRITE.9        DONE, FINISH UP 1 5         LW        R3,BUFADRS      GET BUFFER ADDRESS 5                           @  /         LB        R7,0B,R3       GET CHARACTER / 7         ABM       31,BUFADRS     UPDATE BUFFER ADDRESS 7 6         ADI       R5,1           UPDATE REQUEST COUNT 6 6         LW        R0,BLOCK,X2   SEE IF FILE UNBLOCKED 6 ,         BZ        WRITE.61        BR IF YES , 5         CI        R7,NEWLINE     NEW LINE CHARACTER? 5 1         BEQ       WRITE.7        YES, FLUSH LINE 1 /WRITE.61 LW        R3,LINADRS     GET LINE ADDR / 9         STB       R7,0B,R3       STORE CHARACTER IN LINE 9 5         ABM       31,LINADRS     UPDATE LINE ADDRESS 5 7         ADI       R4,1           UPDATE TRANSFER COUNT 7 6         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED 6 ,         BNZ       WRITE.62        BR IF NOT ,                                              @  5         CI        R4,LINESIZE     SEE IF BUFFER FULL 5 ,         BLT       WRITE.6         BR IF NOT , 2         BU        WRITE.7         GO PURGE BUFFER 2 <WRITE.62 CI        R4,254          MAX BLOCKED RECORD LENGTH < 3         BLT       WRITE.6         BR IF STILL O.K. 3 WRITE.7  EQU       $  8         BL        SETTCW         SET THE TCW IN THE FCB 8 0         BL        WRITLINU       WRITE THE LINE 0 8         TRR       R7,R7          TEST THE RETURN RESULT 8 =         BNE       ACC.RET        NON ZERO, RETURN WITH ERROR = /         LA        R7,LINE,X2  GET LINE ADDRESS / :         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS : 9         ZR        R4             INITIALIZE LINE POINTER 9 -         BU        WRIT.BLK       START AGAIN -  @  WRITE.9  EQU       $  3         STW       R4,LINPTR,X2   SAVE LINE POINTER 3 ;WRITE.5  LW        R0,2W,AP       SET OD IN RESULT REGISTER ; 2         RETURN                   RETURN TO CALLER 2 
         PAGE 
 H************************************************************************ H "*   SEEK TO A POSITION IN THE FILE " H************************************************************************ H          SPACE     1  _seek    EQU       $  =         ENTER                    SAVE THE REGISTERS ON STACK = 9         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR A D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D                                              @  A         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > ?         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS ? *         LW        R4,MODE,X2     GET MODE * 9         CI        R4,NOTUSED     FILE DESCRIPTOR IN USE? 9 ?         BEQ       ERRETURN       NOT IN USE, RETURN WITH ERROR ? 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 ,         CI        R7,NULL        NULL FILE? , 0         BEQ       SEEK.5         YES, FINISH UP 0 6         CI        R4,READMODE    ARE WE OUTPUT ACTIVE 6 0         BEQ       SEEK.1          NO, JUST SEEK 0 ;         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER ; 4         BZ        SEEK.1          NO, JUST CLOSE IT 4      @  0         BL        SETTCW          YES, PURGE IT 0 *         BL        WRITLINU        WRIT IT * 3*        OFFSET=0  OFFSET I.D.=0   ---> REWIND FILE 3 2*        OFFSET=0  OFFSET I.D.=2   ---> SET TO EOF 2 !*        OTHERS .EQ. ERROR RETURN ! ,SEEK.1   CI        R7,TERMINAL     IS IT TTY , 3         BEQ       SEEK.5          JUST EXIT IF YES 3 0         LW        R7,1W,AP       GET THE OFFSET 0 <         BNE       SEEK.6         NOT ZERO, OFFSET SPECIFIED < ;         LW        R6,2W,AP       GET THE OFFSET IDENTIFIER ; =         BNE       SEEK.3         NOT ZERO, SEE IF ADV TO EOF = H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H *         LW        R4,MODE,X2     GET MODE *                                                   @  6         CI        R4,READMODE    ARE WE OUTPUT ACTIVE 6 2         BEQ       SEEK.2          NO, JUST REWIND 2 .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.WEOF        WEOF FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL WEOF 2 +         SVC       1,X'38'        WRITE EOF + .SEEK.2   TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.RWND        RWND FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL RWND 2 -         SVC       1,X'37'        REWIND FILE - /         ZMW       FLOC,X2        NO BYTE COUNT / 3         ZMW       SECTA,X2       NO RECORDS EITHER 3                                    @  5         ZMW       CPTR,X2        NO COMPRESS POINTER 5 -         BU        SEEK.4          MERGE CODE - <SEEK.3   CI        R6,1            0 OFFSET TO CURR POSITION < 3         BEQ       SEEK.5          JUST RETURN O.K. 3 5         CI        R6,2            SEE IF SEEK TO EOF 5 /         BNE       ERRETURN        ERROR IF NOT / /         LA        R1,FCB,R2       GET FCB ADDR / 6*        LW        R4,BLOCK,X2     SEE IF FILE BLOCKED 6 ,*        BNZ       SEEK.35         BR IF YES , .SEEK.32  TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL READ 2 6         SVC       1,X'31'         READ UNBLOCKED FILE 6         @  6         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR 6 ,         BS        SEEK.37         BR IF YES , 6         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF 6 ,         BS        SEEK.37         BR IF YES , 5         ABM       31,SECTA,X2    ANOTHER RECORD READ 5 4         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT 4 6         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION 6 6         BU        SEEK.32         GO READ NEXT RECORD 6 .SEEK.35  TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.ADVF        ADVF FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL ADVF 2 /         SVC       1,X'34'         ADVANCE FILE / .SEEK.37  TBM       0,FLAGS,X2     IS RM IN USE .               @  +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.BACK        BACK FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL BACK 2 3         SVC       1,X'35'         BACKSPACE RECORD 3 :SEEK.4   LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B B         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK B D         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER D E         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER E          LI        R4,FALSE  7         STW       R4,EOF,X2      SET EOF FLAG TO FALSE 7 ;SEEK.5   LW        R0,FLOC,X2     SET OK IN RESULT REGISTER ;                                                    @  2         RETURN                   RETURN TO CALLER 2 *  *  OFFSET SPECIFIED  *  0SEEK.6   BLT       SEEK.9          BACKWARK SEEK 0 * FORWARD SEEK SPECIFIED  0         LW        R6,2W,AP        GET SEEK BASE 0 ?         BZ        SEEK.71         BR IF FROM BEGINNING OF FILE ? 9         CI        R6,1            IS IT TO CURR POSITION 9 8         BNE       ERRETURN        BR IF FROM EOF, ERROR 8 :SEEK.70  ADMW      R7,FLOC,X2      ADD IN CURRENT POSITION : =         BLT       ERRETURN        IF NEG, SEEK TO BEFORE BOF = -         BU        SEEK.71         MERGE CODE - 0SEEK.9   LW        R6,2W,AP        GET SEEK BASE 0 6         BZ        ERRETURN       NO BACKWARD FROM BOF 6 0         CI        R6,1            CURR POSITION 0                   @  ,         BEQ       SEEK.70         BR IF YES , +         CI        R6,2            FROM EOF + 3         BNE       ERRETURN        BR IF NOT, ERROR 3 *  * MUST SEEK TO EOF FIRST  *  /         LA        R1,FCB,R2       GET FCB ADDR / .SEEK.92  TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL READ 2 6         SVC       1,X'31'         READ UNBLOCKED FILE 6 6         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR 6 ,         BS        SEEK.97         BR IF YES , 6         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF 6 ,         BS        SEEK.97         BR IF YES ,                                                @  5         ABM       31,SECTA,X2    ANOTHER RECORD READ 5 4         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT 4 6         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION 6 6         BU        SEEK.92         GO READ NEXT RECORD 6 .SEEK.97  TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.BACK        BACK FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL BACK 2 3         SVC       1,X'35'         BACKSPACE RECORD 3 :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B B         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK B                                                                       @  D         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER D E         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER E          LI        R4,FALSE  7         STW       R4,EOF,X2      SET EOF FLAG TO FALSE 7 :         LW        R7,FLOC,X2     GET CURRENT EOF POSITION : 5         LW        AP,APSAVE      RESTORE ARG POINTER 5 5         ADMW      R7,1W,AP       GET ABSOLUTE OFFSET 5 -         BU        SEEK.71         MERGE CODE - *   * R7 = ABSOLUTE OFFSET INTO FILE   *  7SEEK.71  LW        R6,FLOC,X2      GET CURRENT POSITION 7 9         TRR       R7,R5           SAVE ABSOLUTE POSITION 9 5         SUR       R6,R7           REQ - CURR = DELTA 5 =         BGT       SEEK.80         BR IF SEEK FORWARD IN FILE =                @  0         BZ        SEEK.5          IF THERE EXIT 0 *  5* MUST SEEK BACKWARDS IN FILE - R7 = NEG NUM OF BYTES 5 *  <         LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4 < @         ZR        R5             CLEAR THE TRANSFER COUNT IN R5 @ =         TRN       R7,R6          GET THE REQUEST COUNT IN R6 = CSEEK.701 CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST C ?         BGE       SEEK.74        REQUEST SATISFIED, SKIP AHEAD ? -         TRR       R4,R4          LINE EMPTY? - 0         BGT       SEEK.73        NO, SKIP AHEAD 0 H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+5W           BR IF NOT +                                    @  7*XXX     BL        RM.BACK        BACKSPACE TO CURR REC 7 7*XXX     BL        RM.BACK        BACKSPACE TO PREV REC 7 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+4W           SKIP NORMAL READ 2 2         SVC       1,X'35'        BACKSPACE RECORD 2 2         SVC       1,X'35'        BACKSPACE RECORD 2 -         SVC       1,X'31'        READ RECORD - :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        ERRETURN       YES, RETURN WITH ERROR 8 4         LI        R7,-1           DECR RECORD COUNT 4 ;         ARMW      R7,SECTA,X2    SHOW RECORD READ BACKWARD ;                                @  $         LW        R7,FCB+FCB.CNT,X2 $ 5*                                 GET CHARACTER COUNT 5 5         LA        X3,LINE,X2  GET LINE ADDRESS IN X3 5 C         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE C 7         ADR       R7,X3          OFFSET TO END OF LINE 7 G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 3         LW        R1,BLOCK,X2     ARE WE UNBLOCKED 3 ,         BZ        SKA.2           BR IF YES , +SKA.0    TRR       R3,R1          COPY ADDR + 3         TRR       R7,R7          TEST IF ANY CHARS 3 0         BLE       SKA.1          BR IF NON LEFT 0 9         SUI       R1,1           BACK UP 1 CHAR POSITION 9 ,         LB        R1,0B,R1       GET A CHAR ,                                       @  /         CI        R1,X'20'       IS IT A SPACE / =         BNE       SKA.1          BR IF NON SPACE ENCOUNTERED = ?         SUI       R3,1           BACK UP END OF BUFFER POINTER ? 8         SUI       R7,1           BACK UP TRANSFER COUNT 8 :         BU        SKA.0          LOOP TIL FIRST NON SPACE : @SKA.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT @ G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 8         LI        R7,NEWLINE     GET NEW LINE CHARACTER 8 4         STB       R7,0B,X3       PUT AT END OF LINE 4 0SKA.2    LW        R4,EOLPTR,X2   GET LINE COUNT 0 :SEEK.73  ADI       R5,1           INCREMENT TRANSFER COUNT : 8         SUI       R4,1           DECREMENT LINE POINTER 8                          @  ?         BGE       SEEK.701        LINE NOT EMPTY, DO NEXT CHAR ? 9         ZR        R4             INITIALIZE LINE POINTER 9 ,         LI        R7,-1          DECR COUNT , :         ARMW      R7,BLKPTR,X2   NO, UPDATE BLOCK POINTER : 3         BU        SEEK.701       DO NEXT CHARACTER 3 SEEK.74  EQU       $  5         STW       R4,LINPTR,X2   ADJUST LINE POINTER 5 3         LW        R4,FLOC,X2     GET BYTE POSITION 3 .         SUR       R5,R4          NEW POSITION . H         TRR       R4,R0          MOVE CURRENT POSITION  RESULT REGISTER H 2         RETURN                   RETURN TO CALLER 2 *  2* MUST SEEK FORWARD IN FILE - R7 = NUMBER OF BYTES 2 *  <SEEK.80  LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4 <                           @  @         ZR        R5             CLEAR THE TRANSFER COUNT IN R5 @ ;         TRR       R7,R6          GET THE DELTA COUNT IN R6 ; .         LW        R7,EOF,X2      GET EOF FLAG . )         CI        R7,FALSE       NO EOF? ) 4         BEQ       SEEK.81        NO EOF, SKIP AHEAD 4 <SEEK.84  LI        R0,-1          SET EOF IN RESULT REGISTER <          LI        R7,TRUE  .         STW       R7,EOF,X2      SET EOF FLAG . 1         RETURN                   RETURN WITH EOF 1 CSEEK.81  CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST C ?         BGE       SEEK.90        REQUEST SATISFIED, SKIP AHEAD ? -         TRR       R4,R4          LINE EMPTY? - 0         BGT       SEEK.83        NO, SKIP AHEAD 0          LW        R7,EOF,X2               @  .         CI        R7,TRUE        EOF REACHED? . 0         BEQ       SEEK.84        YES, FINISH UP 0 H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.READ        READ FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL READ 2 -         SVC       1,X'31'        READ RECORD - :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        ERRETURN       YES, RETURN WITH ERROR 8 *         TBM       FCB.EOF,FCB+FCB.STAT,X2 *                                                        @  6*                                 WAS EOF ENCOUNTERED? 6 6         BS        SEEK.84        YES, RETURN WITH EOF 6 2         ABM       31,SECTA,X2    SHOW RECORD READ 2 $         LW        R7,FCB+FCB.CNT,X2 $ 5*                                 GET CHARACTER COUNT 5 5         LA        X3,LINE,X2  GET LINE ADDRESS IN X3 5 C         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE C 7         ADR       R7,X3          OFFSET TO END OF LINE 7 G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 3         LW        R1,BLOCK,X2     ARE WE UNBLOCKED 3 ,         BZ        SEEK.83         BR IF YES , +SKB.0    TRR       R3,R1          COPY ADDR + 3         TRR       R7,R7          TEST IF ANY CHARS 3                              @  0         BLE       SKB.1          BR IF NON LEFT 0 9         SUI       R1,1           BACK UP 1 CHAR POSITION 9 ,         LB        R1,0B,R1       GET A CHAR , /         CI        R1,X'20'       IS IT A SPACE / =         BNE       SKB.1          BR IF NON SPACE ENCOUNTERED = ?         SUI       R3,1           BACK UP END OF BUFFER POINTER ? 8         SUI       R7,1           BACK UP TRANSFER COUNT 8 :         BU        SKB.0          LOOP TIL FIRST NON SPACE : @SKB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT @ G         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE G 8         LI        R7,NEWLINE     GET NEW LINE CHARACTER 8 4         STB       R7,0B,X3       PUT AT END OF LINE 4                                       @  :SEEK.83  ADI       R5,1           INCREMENT TRANSFER COUNT : 8         ADI       R4,1           INCREMENT LINE POINTER 8 E         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE E C         BLT       SEEK.81        LINE NOT EMPTY, DO NEXT CHARACTER C 9         ZR        R4             INITIALIZE LINE POINTER 9 :         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER : 3         BU        SEEK.81        DO NEXT CHARACTER 3 .*        RETURN     CURRENT POSITION TO CALLER . 5SEEK.90  STW       R4,LINPTR,X2   ADJUST LINE POINTER 5 >         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION > H         LW        R0,FLOC,X2     MOVE TRANSFER COUNT IN RESULT REGISTER H 2         RETURN                   RETURN TO CALLER 2                 @  
         PAGE 
 H************************************************************************ H *   IS THE FILE A TERMINAL?  H************************************************************************ H          SPACE     1  _isatty  EQU       $  =         ENTER                    SAVE THE REGISTERS ON STACK = 9         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR 9 A         BLT       TTY.NO         FD TOO SMALL, RETURN WITH ERROR A D         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR D A         BGE       TTY.NO         FD TOO LARGE, RETURN WITH ERROR A >         INDEX     X2             GET FILE TABLE ENTRY ADDRESS > *         LW        R7,MODE,X2     GET MODE * 9         CI        R7,NOTUSED     FILE DESCRIPTOR IN USE? 9       @  ?         BEQ       TTY.NO         NOT IN USE, RETURN WITH ERROR ? 1         LW        R7,DEVICE,X2   GET DEVICE TYPE 1 +         CI        R7,TERMINAL    TERMINAL? + 1         BEQ       TTY.YES        YES, SKIP AHEAD 1 9TTY.NO   ZR        R0             NO, SET RETURN TO FALSE 9          BU        TTY.RET  TTY.YES  LI        R0,1  TTY.RET  RETURN           SPACE     2  H************************************************************************ H *   RETURN WITH AN ERROR  H************************************************************************ H          SPACE     1           BOUND     1W  ERRETURN EQU       $  2*        SVC       1,X'63'         ATTACH DEBUGGER 2 C         LI        R0,-1          SET ERROR CODE IN RESULT REGISTER C     @  2         RETURN                   RETURN TO CALLER 2 
         PAGE 
 H************************************************************************ H *   GET A FILE DESCRIPTOR  *  (*   SEARCH SEQUENTIALLY BEGINNING TO END ( B*   R7 RETURNED AS FILE TABLE ENTRY #   OR   -1 FOR NONE AVAILABLE B *  H************************************************************************ H          SPACE     1  GETFD    EQU       $  3         LI        X2,-FILECNT    SET UP LOOP COUNT 3 GET.LOOP EQU       $           TRR       X2,X3           ADI       X3,FILECNT  >         INDEX     X3             GET FILE TABLE ENTRY ADDRESS > *         LW        R7,MODE,X3     GET MODE * )         CI        R7,NOTUSED     IN USE? )                                           @  /         BEQ       GET.FND        NO, FOUND ONE / :         BIB       X2,GET.LOOP    TRY NEXT FILE DESCRIPTOR : @         LI        R7,-1          NONE AVAILABLE, SET ERROR CODE @ (         BU        GET.RET        RETURN ( GET.FND  EQU       $           TRR       X2,R7  9         ADI       R7,FILECNT     RECOVER FILE DESCRIPTOR 9 GET.RET  EQU       $  (         TRSW      R0             RETURN (          SPACE     2  H************************************************************************ H '*   PARSE FILE NAME INTO PATHNAME BLOCK ' H************************************************************************ H          SPACE     1  PARSE    EQU       $  :         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS :                             @  B*                                 *** ASSUMED TO BE A WORD ADDRESS B 3         TRR       X2,X3          MAKE ANOTHER COPY 3 PAR.LOOP EQU       $  8         LB        R4,0B,X3       GET PATHNAME CHARACTER 8 A         BEQ       PAR.NULL       STRING TERMINATOR FOUND, BRANCH A 4         BIB       X3,PAR.LOOP    TRY NEXT CHARACTER 4 PAR.NULL EQU       $  5         SUR       X2,X3          GET PATHNAME LENGTH 5 9         CI        X3,0           SEE IF PATHNAME IS ZERO 9          BLE       PAR.ZER  ;         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH ; <         BGT       PAR.ERR        TOO BIG, RETURN WITH ERROR < 1         SLL       X3,24          MOVE COUNT LEFT 1 @         ORR       X3,X2          CONSTRUCT PATHNAME VECTOR WORD @          @  =         TRR       X2,R1          PUT IN REGISTER FOR SERVICE = G         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER G (         ZR        R7             NO CNP ( D         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK D :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : 8         TRR       R7,R7          TEST THE RETURN RESULT 8 ?         BNE       PAR.ERR        DIDNT WORK, RETURN WITH ERROR ? @         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD @ ;         ZR        R7             SET OK IN RESULT REGISTER ; 2         BU        PAR.RET        RETURN TO CALLER 2 PAR.ZER  EQU       $  +         LI        R7,1           RETURN +1 +          BU        PAR.RET  PAR.ERR  EQU       $          @  >         LI        R7,-1          SET ERROR IN RESULT REGISTER > PAR.RET  EQU       $  2         TRSW      R0             RETURN TO CALLER 2          SPACE     2  H************************************************************************ H *   SEE IF A FILE EXISTS  H************************************************************************ H          SPACE     1           BOUND     1W  EXISTS   EQU       $  D         LW        R1,PNBWRDX    GET PNB VECTOR WORD IN REGISTER FOR D +*                                   SERVICE + ?         LA        R6,RD           RETRIEVE RESOURCE DESCRIPTOR ?          ZR        R7           SVC       2,X'2C'  6         TRR       R7,R7          TEST THE RETURN CODE 6                                            @  :         BNE       EXI.ERR        NO RD, RETURN WITH ERROR : 3         LH        R7,RD+RD.TYPE  GET RESOURCE TYPE 3 9         CI        R7,RD.PERM     IS IT A PERMANENT FILE? 9 7         BNE       EXI.ERR        NO, RETURN WITH ERROR 7 $         TBM       RD.BLK,RD+RD.FLAG $ :*                                 CHECK IF FILE IS BLOCKED : 5         BS        EXI.BLK        BLOCKED, SKIP AHEAD 5 B         LI        R7,UNBLOCK     SET UNBLOCKED IN RESULT REGISTER B 2         BU        EXI.RET        RETURN TO SENDER 2 EXI.BLK  EQU       $  @         LI        R7,BLOCKED     SET BLOCKED IN RESULT REGISTER @ 2         BU        EXI.RET        RETURN TO SENDER 2 EXI.ERR  EQU       $  >         LI        R7,-1          SET ERROR IN RESULT REGISTER >        @  EXI.RET  EQU       $  :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : 2         TRSW      R0             RETURN TO CALLER 2          SPACE     2  H************************************************************************ H +*   SAVE PATHNAME BLOCK IN FILE TABLE ENTRY + H************************************************************************ H          SPACE     1           BOUND     1W  PNBSAVE  EQU       $  <         LA        X3,PNB,X2      GET PATHNAME BLOCK ADDRESS < 6         LI        X2,-18W        GET PNB LENGTH IN X2 6 PNBLOOP  EQU       $  1         LW        R5,PNBX+18W,X2 GET PART OF PNB 1 :         STW       R5,0,X3        SAVE IN FILE TABLE ENTRY :                                                                   @  A         ABR       X3,29          CHANGE FILE TABLE ENTRY POINTER A 0         BIW       X2,PNBLOOP     MOVE NEXT WORD 0 B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B 1         LA        R5,PNB,X2      GET PNB ADDRESS 1 C         STW       R5,PNBWORD,X2  STUFF IN LAST PART OF VECTOR WORD C .         LB        R5,PNBWRDX    GET PNB COUNT . D         STB       R5,PNBWORD,X2  STUFF IN FIRST PART OF VECTOR WORD D          TRSW      R0           SPACE     2  H************************************************************************ H "*   WRITE CURRENT LINE   (BLOCKED) " H************************************************************************ H          SPACE     1           BOUND     1W  WRITLINU EQU       $                @  6         STW       R0,WRTL.RET     SAVE RETURN ADDRESS 6 B         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS B H         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC H .*XXX     TBM       0,FLAGS,X2     IS RM IN USE . +*XXX     BNS       $+3W           BR IF NOT + 4*XXX     BL        RM.WRIT        WRIT FILE USING RM 4 2*XXX     BU        $+2W           SKIP NORMAL WRIT 2 .         SVC       1,X'32'        WRITE RECORD . :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER : *         TBM       FCB.ERR,FCB+FCB.STAT,X2 * 8*                                 WAS ERROR ENCOUNTERED? 8 8         BS        WTU.ERR        YES, RETURN WITH ERROR 8 *         TBM       FCB.EOF,FCB+FCB.STAT,X2 *                             @  6*                                 WAS EOF ENCOUNTERED? 6 8         BS        WTU.ERR        YES, RETURN WITH ERROR 8 C         TBM       FCB.EOM,FCB+FCB.STAT,X2                     A001 C C*                                 WAS EOM ENCOUNTERED?         A001 C C         BS        WTU.EOM        YES, RETURN WITH ERROR       A001 C 7         ZR        R7             CLEAR RESULT REGISTER 7 5         ABM       31,SECTA,X2    UPDATE RECORD COUNT 5 6         LW        R0,FCB+FCB.CNT,X2  GET TRANSFER CNT 6 3         ARMW      R0,FLOC,X2     UPDATE BYTE COUNT 3 2         BU        WTU.RET        RETURN TO CALLER 2 CWTU.EOM  LI        R7,-2          SET ERROR IN RESULT REGISTER A001 C C         ZMW       LINPTR,X2       RESET LINE POINTER          A001 C        @  C*                                    THAT THE BUFFER IS EMPTY  A001 C C         BU        WTU.RET        RETURN TO CALLER             A001 C WTU.ERR  EQU       $  >         LI        R7,-1          SET ERROR IN RESULT REGISTER > WTU.RET  EQU       $  8         LW        R0,WRTL.RET     RESTORE RTURN ADDRESS 8 2         TRSW      R0             RETURN TO CALLER 2          SPACE     2  H************************************************************************ H *   SET TCW IN FCB  H************************************************************************ H          SPACE     1           BOUND     1W  SETTCW   EQU       $  5         TRR       R4,R4           ANYTHING TO GO OUT 5 ,         BNZ       SET.1           BR IF YES ,                  @  6         LA        R7,LFCHAR       GET ADDR OF 1 BLANK 6 4         LI        R4,1            GET CNT OF 1 BYTE 4 0         BU        SET.2           GO PUT IN TCW 0 0SET.1    LA        R7,LINE,X2   GET LINE ADDRESS 0 1SET.2    STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB 1 8         STW       R4,FCB+FCB.XCT,X2 TRANSFER CNT TO FCB 8 3         TRSW      R0              RETURN TO CALLER 3 H************************************************************************ H *   FILE TABLE  H************************************************************************ H          SPACE     1           REL           ORG       >FILTABL           REPT      FILECNT  $         FIL       G'UX0'+$$$-1,LINE $ 
         ENDR 
          SPACE     2                           @  H************************************************************************ H 3*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK 3 H************************************************************************ H          SPACE     1           REL           BOUND     1D  /RRS      RES       1W             LFC GOES HERE / ,         DATAB     1,0,0,0        TYPE 1 RRS , B         DATAW     X'D0008000'    ALLOW FOR UPDATE EXPLICIT SHARED B          DATAW     0  3PNBX     EQU       $               PNB FOR PATHNAME 3          RES       18W  PNB1     EQU       $  G         RES       18W             PNB FOR 1ST  PATHNAME IF 2 ARE REQ'D G :PNLENGTH EQU       52              MAXIMUM PATHNAME LENGTH : #PNBVCTOR GEN       8/18W,24/W(PNBX) #                  @  8*                                  EMPTY PNB VECTOR WORD 8          SPACE     2  H************************************************************************ H *   CNP  FOR OPENS  H************************************************************************ H          SPACE     1  4CNP      DATAW     0               WAIT FOR RESOURCE 4 6         DATAW     W(ERRETURN)    ERROR RETURN ADDRESS 6 7         DATAW     X'00000000'    OPEN FOR READ BLOCKED 7          REZ       2W           SPACE     2  H************************************************************************ H *   VARIOUS SCRATCH BUFFERS  H************************************************************************ H          SPACE     1           BOUND     1D                             @  <RD       RES       192W           RESOURCE DESCRIPTOR BUFFER <          SPACE     2  
         PAGE 
 H************************************************************************ H *   RESOURCE CREATE BLOCK  H************************************************************************ H          SPACE     1           BOUND     1D  RCB      EQU       $           REZ       7W  C         DATAW     X'00000000'     ZERO FILE   WAS X'100'      A001 C C         DATAW     32             MAXIMUM EXTENSION            A001 C C         DATAW     16             MINIMUM EXTENSION            A001 C          REZ       1W  /         DATAW     8              ORIGINAL SIZE /          REZ       4W           SPACE     2                                           @  H************************************************************************ H 3*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK 3 H************************************************************************ H          SPACE     1           BOUND     1D  SPSAVE   DATAW     0  APSAVE   DATAW     0  FTESAVE  DATAW     0  ;BLKSAVE  DATAW     0               BLOCKED STATUS SAVE AREA ; <FDSAVE   DATAW     0               FILE DESCRIPTOR SAVE AREA < CPTRSAVE  DATAD     0               LINE AND BLOCK POINTER SAVE AREA C >PNBWRD1  DATAW     0               PATHNAME WORD FOR FIRST ARG > FPNBWRDX  DATAW     0               PATHNAME WORD FOR SINGLE OR 2ND ARG F 5LINADRS  DATAW     0               LOCAL LINE ADDRESS 5                                         @  <BUFADRS  DATAW     0               LOCAL USER BUFFER ADDRESS < <RAW      DATAW     0               BIT ZERO SET WHEN RAW I/O < *  #* SIZES OF FIXED LENGTH RRS ENTRIES # *  :RR.9.SIZ EQU       10              MOUNT DEVICE - 10 WORDS : :RR.4.SIZ EQU       4               LFC          -  4 WORDS : BRR.2.SIZ EQU       4               TEMP         -  4 WORDS (+ VOL) B :RR.3.SIZ EQU       6               DEVICE       -  6 WORDS : CRR.1.SIZ EQU       4               PATHNAME     -  4 WORDS (+ PATH) C :RR.6.SIZ EQU       12              RID          - 12 WORDS : HRR.D.SIZ EQU       10              EXTENDED SLO - 10 WORDS          3206 H *  ** SIZE IN WORDS OF REFORMATTED RRS ENTRIES * *  +CASSA.NW EQU       4               ASSIGN 1 +                   @  +CASSB.NW EQU       4               ASSIGN 2 + BCASSC.D1 EQU       4               ASSIGN 3 (TEMP FILE ANY DEVICE) B ACASSC.D2 EQU       8               ASSIGN 3 (TEMP FILE SPEC. DEV) A 4CASSC.DV EQU       6               ASSIGN 3 (DEVICE) 4 +CASSD.NW EQU       4               ASSIGN 4 + *  H*  TERMINAL LINE BUFFER EQUATES                                     210D H *  ATLB.LARG EQU       0D              ORIGIN OF LAST ARGUEMENT FOUND A 5TLB.BUFL EQU       4W+0B           LINE BUFFER LENGTH 5 /TLB.CIND EQU       4W+1B           CURSOR INDEX / 2TLB.FDLM EQU       4W+2B           FIELD DELIMITER 2 -TLB.FSIZ EQU       4W+3B           FIELD SIZE - <RRS.SIZE DATAW     0               SIZE OF CURRENT RRS ENTRY < COPT90   RES       1F                     @  CDEV90   RES       1F  *  G*  SCRATCH DOUBLE WORD TO COUNT CHARACTERS IN DEVICE MNEMONIC  REV20100 G *  CDEV.WRK DATAD     0  GCDEV.CNT RES       1B              DEV MNEMONIC CHAR COUNT     REV20100 G *  G*  CDEV91 IS USED TO CONSTRUCT THE DEV-TYPE/CHAN/SUBCH WORD    REV20100 G *  %*  BYTE 0: BIT 0    = CHANNEL PRESENT % !*          BITS 1-7 = DEVICE TYPE ! (*  BYTE 2: BIT 0    = SUBCHANNEL PRESENT ( *          BITS 1-7 = CHANNEL   *  BYTE 3: BITS 0-7 = SUBCHANNEL   *  CDEV91   RES       1W  SAVER0   RES       1F           BOUND     1W  CHARPOS  REZ       1W  6BLNKS    REZ       1W              LEADING BLANKS FLAG 6 
         PAGE 
 DCCENT    RES       2D              LEFT JUSTIFIED FILED FROM SCANNER D                           @  9CCSTRT   RES       1W              START OF CURRENT FILED 9 >CCDLIM   RES       1B              LAST DELIMITTER ENCOUNTERED > @CCHRS    RES       1B              NUMBER OF CHARACTERS IN FIELD @ 2CCFLD    RES       1B              NUMBER OF FIELD 2 BMDBUF    RES       1W              ADDRESS OF CURRENT INPUT RECORD B 9WRTL.RET RES       1W              WRITLIN RETURN ADDRESS 9 ;CAS.REGS RES       1F              REG SAVE AREA FOR ASSIGN ; 8INQ.INFO RES       1F              8W FOR M.INQUIRY INFO 8          CSECT           TITLE  ASSIGN COMMANDS  G*********************************************************************** G G*                                                                     * G                                                          @  G*                  CASSG                                              * G G*                                                                     * G G*********************************************************************** G G*                                                                     * G G*        PROCESS GENERAL ASSIGN DIRECTIVE                             * G G*                                                                     * G G*********************************************************************** G ,CASSG    STF       R0,CAS.REGS     SAVE REGS , *  *  ZERO MAXIMUM SIZE RRS  *  G         LI        R6,12           12 WORDS MAX                REV20094 G G         LA        R3,RRS          START OF NEXT RRS           REV20094 G   @  G         TRN       R6,R6           NEGATE LOOP COUNTER         REV20094 G GCASSG.05 ZMW       0W,R3           CLEAR RRS WORD              REV20094 G G         ABR       R3,29           BUMP POINTER                REV20094 G G         BIB       R6,CASSG.05     DO NEXT WORD                REV20094 G *  4         ZMW       CHARPOS         CLEAR PARSER FLAG 4 *  /         LA        R3,RRS          GET RRS ADDR / *  ?* NOW GET THE MAIN PART OF THE ASSIGN. THIS WILL ALSO DETERMINE ? 8* THE TYPE OF RRS BEING PRODUCED AND THEREFORE THE SPACE 8 * REQUIREMENT IN THE RRS TABLE.  *  >         BL        STRING          GET THE PRIMARY ASSIGN TYPE > 8         LB        R5,CCHRS        CHECK FOR BLANK FIELD 8                                                 @  8         BZ        ERRETURN        BRANCH IF BLANK FIELD 8 @         LB        R4,CCDLIM       SEE IF DELIMITER IS '=' ..... @ @         CI        R4,G'='         ..... AND IF SO GO AND  ..... @ =         BEQ       CASSG.5         ..... IDENTIFY THE KEYWORD = *  -         CAMW      R6,=C'SYC '     SEE IF SYC - 0         BEQ       CASS.SYC        BRANCH IF SYC 0 *  -         CAMW      R6,=C'SGO '     SEE IF SGO - 0         BEQ       CASS.SGO        BRANCH IF SGO 0 *  -         CAMW      R6,=C'SBO '     SEE IF SBO - 0         BEQ       CASS.SBO        BRANCH IF SBO 0 *  -         CAMW      R6,=C'SLO '     SEE IF SLO - 0         BEQ       CASS.SLO        BRANCH IF SLO 0 *  =*ISC     CAMW      R6,=C'TEMP'     SEE IF TEMP WITH NO VOLUME =         @  H*ISC     BNE       CASSG.6         BRANCH IF NOT                    2104 H H*ISC     CI        R5,4            4 CHARS ONLY THIS NAME           2104 H H*ISC     BEQ       CASS.TP5        YES.  DEFINATELY A TEMP ASSIGN   2104 H *  -* KEYWORD NOT RECOGNIZED SO ASSUME A PATHNAME - *  @* THIS FORMS A TYPE 1 RRS WHOS LENGTH IS 4 WORDS PLUS THE NUMBER @ %* OF WORDS CONSTITUTING THE PATHNAME. % *  CASSG.6  EQU       $  2         LW        AP,APSAVE       GET ARG POINTER 2 :         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS : B*                                 *** ASSUMED TO BE A WORD ADDRESS B 3         TRR       X2,X3          MAKE ANOTHER COPY 3 8         LA        R1,PNB1         GET ADDR OF TEMP AREA 8 PAR.L    EQU       $               @  8         LB        R4,0B,X3       GET PATHNAME CHARACTER 8 A         BEQ       PAR.N          STRING TERMINATOR FOUND, BRANCH A -         CI        R4,X'61'        SEE IF L/C - ,         BLT       PAR.X           BR IF NOT , -         CI        R4,X'7A'        SEE IF L/C - ,         BGT       PAR.X           BR IF NOT , +         SUI       R4,X'20'        MAKE U/C + /PAR.X    CI        R4,G' '         SEE IF SPACE / .         BEQ       PAR.N           TERM IF YES . 5         STB       R4,0B,R1        PUT IN TEMP BUFFER 5 +         ADI       R1,1B           BUMP ADR + 4         BIB       X3,PAR.L       TRY NEXT CHARACTER 4 PAR.N    EQU       $  5         SUR       X2,X3          GET PATHNAME LENGTH 5                                                    @  9         CI        X3,0           SEE IF PATHNAME IS ZERO 9          BLE       ERRETURN  ;         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH ; <         BGT       ERRETURN       TOO BIG, RETURN WITH ERROR < B         STW       R3,CHARPOS     SET STRING POINTER PAST PATHNAME B 1         SLL       X3,24          MOVE COUNT LEFT 1 @         LA        R1,PNB1        CONSTRUCT PATHNAME VECTOR WORD @ =         ORR       X3,R1          PUT IN REGISTER FOR SERVICE = G         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER G (         ZR        R7             NO CNP ( D         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK D :         LW        AP,APSAVE      RESTORE ARGUMENT POINTER :                                    @  8         TRR       R7,R7          TEST THE RETURN RESULT 8 ?         BNE       ERRETURN       DIDNT WORK, RETURN WITH ERROR ? @         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD @ 6         LB        R4,PNBWRDX      GET PATHNAME LENGTH 6 <         TRR       R4,R7           SETUP FOR WORD ADJUSTMENT < ;         SRL       R7,2            EVALUATE NUMBER OF WORDS ; <CASS.PA1 ADI       R7,RR.1.SIZ     IN PATHNAME PLUS OVERHEAD < D         STW       R7,RRS.SIZE     SAVE FOR RRS POINTER UPDATE LATER D *  * BUILD THE RRS ENTRY  *  2         LA        R3,RRS          GET ADDR OF RRS 2 1         LI        R6,RR.PATH      RRS TYPE ..... 1 1         STB       R6,RR.TYPE,R3   ..... INTO RRS 1 *                                                 @  2         STB       R4,RR.PLEN,R3   PATHNAME LENGTH 2 *  ;         TRN       R4,R4           LOOP COPYING NAME TO RRS ; 5         TRR       R3,R1           START OF RRS ENTRY 5 :         LA        R2,PNBX         START OF PATHNAME BLOCK : ;CASS.PA2 LB        R7,0B,R2        NEXT PATHNAME BYTE ..... ; 1         STB       R7,RR.NAME1,R1  ..... INTO RRS 1 1         ABR       R1,31           NEXT RRS ENTRY 1 2         ABR       R2,31           NEXT INPUT BYTE 2 +         BIB       R4,CASS.PA2     AND LOOP + *  D* ALL DONE, GET ANY OPTIONS AND THEN FINALLY UPDATE THE RRS POINTERS D *  ?* THE OPTIONS ARE THE SAME AS FOR ASSIGNING TO A TEMPORARY FILE ? * SO UTILISE THE SAME CODE  *           BU        CASS.TP2  *                                  @  "* CHECK TO SEE IF A VALID KEYWORD. " ;* IF NOT FOUND IN THE KEYWORD TABLE ASSUME WE ARE ASSIGNING ; A* TO A PATHNAME BECAUSE '=' COULD APPEAR IN A PATHNAME IN QUOTES. A *  ACASSG.5  ZR        R1              INDEX INTO LOCAL KEYWORD TABLE A >         LI        R2,-CASSNK1     NUMBER OF KEYWORDS IN TABLE > 4CASSG.1  CAMD      R6,CASSKEY1,R1  CHECK FOR A MATCH 4 6         BEQ       CASSG.2         BRANCH IF ONE FOUND 6 >         ABR       R1,28           MOVE TO NEXT ENTRY IN TABLE > 4         BIB       R2,CASSG.1      AND LOOP FOR NEXT 4 B         BU        CASSG.6         NOT THERE, GO TREAT AS PATHNAME B *  >* KEYWORD FOUND SO SPLIT TO A SEPARATE ACTION ROUTINE FOR EACH > *  BCASSG.2  SRL       R1,1            FORM WORD INDE TO ADDRESS TABLE B  @  @         BU        *CASSACT1,R1    AND GO TO EACH ACTION ROUTINE @ *  * ASSIGNMENT TO SYC.  *  7* BUILD A TYPE 2 RRS WITH BIT 0 SET IN THE OPTION WORD. 7 8* THE CODE FOR THIS IS THE SAME AS FOR ASSIGNMENT TO SGO 8 * SO UTILISE COMMON CODE.  *  ;CASS.SYC ZR        R7              SET UP OPTION WORD ..... ; .         SBR       R7,RR.SYC       ..... IN R7 . 2         BU        CASS.SG1        COMMON WITH SGO 2 *  * ASSIGNMENT TO SGO.  *  7* BUILD A TYPE 2 RRS WITH BIT 1 SET IN THE OPTION WORD. 7 5* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC. 5 *  ;CASS.SGO ZR        R7              SET UP OPTION WORD ..... ; .         SBR       R7,RR.SGO       ..... IN R7 . 5         BU        CASS.SG1        COMMON MERGE POINT 5 *             @  * ASSIGNMENT TO SBO.  *  7* BUILD A TYPE 2 RRS WITH BIT 3 SET IN THE OPTION WORD. 7 5* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC. 5 *  ;CASS.SBO ZR        R7              SET UP OPTION WORD ..... ; .         SBR       R7,RR.SBO       ..... IN R7 . 5         BU        CASS.SG1        COMMON MERGE POINT 5 *  * ASSIGNMENT TO SLO.  *  7* BUILD A TYPE 2 RRS WITH BIT 2 SET IN THE OPTION WORD. 7 5* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC. 5 *  ;CASS.SLO ZR        R7              SET UP OPTION WORD ..... ; .         SBR       R7,RR.SLO       ..... IN R7 . 6CASS.SG1 EQU       $               COMMON SLO/SYC CODE 6 ;         LI        R6,RR.2.SIZ     MAKE SURE THERE IS ..... ; +         STB       R6,RR.SIZE,R3   RRS SIZE +        @  5         STW       R7,RR.OPTS,R3   OPTION WORD TO RRS 5 +         LI        R6,RR.TEMP      RRS TYPE +           STB       R6,RR.TYPE,R3   *  H*        CHECK FOR 'DEVICE=' DIRECTIVE FOR SLO FILES                3206 H *  H         TBR       R7,RR.SLO       IS IT SLO ?                      3206 H H         BNS       CASS.SG2        NO, CONTINUE                     3206 H H         BL        STRING          YES, IS THERE A DEVICE DIRECTIVE 3206 H H         LB        R4,CCHRS                                         3206 H H         BZ        CASS.SG2        NO, CONTINUE                     3206 H H         LB        R4,CCDLIM       GET DELIMITER                    3206 H H         CI        R4,G'='         IS IT '=' ?                      3206 H      @  H         BNE       ERRETURN        NO, THEN ERROR                   3206 H H         CAMW      R6,=C'DEVI'     IS IT DEVICE= ?                  3206 H H         BNE       ERRETURN        NO, THEN ERROR                   3206 H H         BL        STRING          GET MNEMONIC                     3206 H H         LI        R5,29           ERROR CODE                       3206 H H         CAMW      R7,=C'    '     CHANNEL SPECIFIED ?              3206 H H         BEQ       ERRETURN        NO, THEN ERROR                   3206 H H         TRR       R6,R4           SAVE IN R4,R5                    3206 H H         TRR       R7,R5                                            3206 H H         BL        CDEV            VALIDATE MNEMONIC                3206 H    @  H         BS        ERRETURN        BRANCH IF ERROR                  3206 H H         LI        R6,RR.D.SIZ     GET EXTENDED RRS SIZE            3206 H @         STB       R6,RR.SIZE,R3   SAVE NEW SIZE IN RRS     3206 @ H         STD       R4,RR.DEV,R3    YES, THEN SAVE DEVICE MNEMONIC   3206 H H         BU        CASSG.8                                          3206 H *  * UPDATE THE RRS TABLE POINTERS  *  4* FINALLY MAKE SURE THERE ARE NO OPTIONS ON THE LINE 4 *  HCASS.SG2 LI        R6,RR.2.SIZ     SIZE OF ENTRY (FIXED PART ONLY US3206 H *  <CASSG.8  BL        STRING          GET OPTION FIELD (IF ANY) < 0         LB        R5,CCHRS        ANY OPTIONS?? 0 A         BNZ       ERRETURN        BRANCH TO ERROR IF ANY OPTIONS A                    @  .         BU        CASSG.7         COMMON EXIT . 
         PAGE 
 *  &* ASSIGNMENT TO ANOTHER LFC RECOGNIZED & *  -* THE LFC MUST BE BETWEEN 1 AND 3 CHARACTERS. - *  * FORM A TYPE 4 RRS.  *  CASS.LFC EQU       $  /         BL        STRING          GET LFC NAME / 9         LB        R5,CCHRS        NUMBER OF CHARS IN LFC 9 <         BZ        ERRETURN        BRANCH TO ERROR IF NO LFC < 5         CI        R5,3            CHECK IF < 3 CHARS 5 ?         BGT       ERRETURN        BRANCH TO ERROR IF > 3 CHARS ? 9         SRL       R6,8            FORM FIRST WORD OF RRS 9 *  ?         LI        R4,RR.4.SIZ     MAKE SURETHERE IS ROOM ..... ? *  /         STW       R6,RR.SFC,R3    LFC INTO RRS / +         STB       R4,RR.SIZE,R3   RRS SIZE +  @  +         LI        R6,RR.LFC2      RRS TYPE +           STB       R6,RR.TYPE,R3   9         LI        R6,RR.4.SIZ     SIZE OF ENTRY IN WORDS 9 G         BU        CASSG.8         UPDATE RRS PTRS AND CHECK NO OPTIONS G 
         PAGE 
 *  * ASSIGNMENT TO RID  *  CASS.RID EQU       $  @         LI        R4,RR.6.SIZ     MAKE SURE THERE IS ROOM ..... @ ?         STW       R4,RRS.SIZE     SAVE FOR COMMON UPDATE LATER ? *  3         LI        R4,RR.RID       SET UP RRS ..... 3 -         STB       R4,RR.TYPE,R3   ..... TYPE - *  2         BL        STRING          GET VOLUME NAME 2 E         LB        R5,CCHRS        CHECK BETWEEN 1 AND 16 CHARS ..... E 3         BZ        ERRETURN        ..... ELSE ERROR 3                                        @  (         CI        R5,16           ..... ( 2         BGT       ERRETURN        ..... AND AGAIN 2 *  ;         STD       R6,RR.NAME1,R3  STORE 16 CHAR NAME ..... ; -         LD        R6,CCENT+1D          ..... - 6         STD       R6,RR.NAME1+1D,R3    ..... INTO RRS 6 *  B* LOOP OF 4 OBTAINING BINARY DATE, TIME, BLOCK NUMBER AND RES TYPE B *  E         TRR       R3,R2           RRS PTR (GETS UPDATED IN THE LOOP) E -         LI        R4,-4           LOOP COUNT - 1CASS.RD1 BL        STRING          GET NEXT FIELD 1 D         LB        R5,CCHRS        CHECK BETWEEN 1 AND 8 CHARS ..... D 9         BZ        ERRETURN        ..... ELSE ERROR ..... 9 (         CI        R5,8            ..... ( 2         BGT       ERRETURN        ..... AND AGAIN 2     @  8         SVC       1,X'29'         CONVERT HEX TO BINARY 8 E         CI        R6,0            CHECK FOR ILLEGAL CHARACTERS ..... E <         BZ        ERRETURN        ..... AND BRANCH IF FOUND < :         STW       R7,RR.DATE,R2   SAVE FIELD IN RRS ..... : ;         ABR       R2,29           ..... AND UPDATE RRS PTR ; 6         BIB       R4,CASS.RD1     LOOP FOR NEXT FIELD 6 *  * ALL DONE, GO GET OPTIONS  *           BU        CASS.TP2  
         PAGE 
 *  * ASSIGNMENT TO TEMP  *  =* BUILD A TYPE 2 RRS WITH OPTIONAL VOLUME NAME IN PARENTHESES = *  '* FORMAT IS:       TEMP[=(VOL)] OPTIONS ' *             OR  *                  TEMP OPTIONS  *  =* ENTRY POINT CASS.TMP IS USED FOR THE FIRST AND CASS.TP5 FOR = 
* THE SECOND. 
 *   @  =CASS.TP5 EQU       $               TEMP [OPTIONS] ENTRY POINT = <         LI        R6,RR.2.SIZ     SET UP DEFAULT SIZE ..... < @         STW       R6,RRS.SIZE     ..... FOR RRS POINTER UPDATES @ 5         BU        CASS.TP3        GO PROCESS OPTIONS 5 *  ACASS.TMP EQU       $               TEMP=(VOL) OPTIONS ENTRY POINT A *  <         BL        STRING          GET OPTIONAL VOLUME FIELD < ?         LB        R5,CCHRS        MUST BE 0 WITH '(' DELIMITER ? :         BNZ       ERRETURN        BRANCH IF FIELD PRESENT : *  =         LB        R4,CCDLIM       MAKE SURE DELIMITER IS '(' =          CI        R4,G'('  9         BNE       ERRETURN        BRANCH IF FORMAT ERROR 9 *  2         BL        STRING          GET VOLUME NAME 2                  @  ;         LB        R5,CCHRS        CHECK FOR VOLUME PRESENT ; 8         BZ        CASS.TP4        BRANCH IF NOT PRESENT 8          CI        R5,16  6         BGT       ERRETURN        BRANCH IF TOO LARGE 6 *  @         LI        R4,RR.2.SIZ+4   MAKE SURE THERE IS ROOM ..... @ ?         BGT       ERRETURN        ..... BRANCH TO ERROR IF NOT ? *  A         STW       R4,RRS.SIZE     SAVE RRS SIZE FOR UPDATE LATER A *  1         STW       R6,RR.NAME1,R3  PUT NAME ..... 1 -         STW       R7,RR.NAME1+1W,R3    ..... -          LD        R6,CCENT+1D  -         STW       R6,RR.NAME1+2W,R3    ..... - 6         STW       R7,RR.NAME1+3W,R3    ..... INTO RRS 6 *  <CASS.TP4 LB        R4,CCDLIM       MAKE SURE DELIMITER ..... <                        @  0         CI        R4,G')'         ..... WAS ')' 0 4         BNE       ERRETURN        BRANCH IF NOT ')' 4 *  ** NOW GO AND SEE IF THERE WERE ANY OPTIONS * *  =* SET UP RRS TYPE FIRST OF ALL BECAUSE THE OPTION HANDLING IS = $* USED BY OTHER TYPES OF ASSIGN ALSO $ *  1CASS.TP3 LI        R6,RR.TEMP      RRS TYPE ..... 1 1         STB       R6,RR.TYPE,R3   ..... INTO RRS 1 *  2CASS.TP2 BL        STRING          GET ANY OPTIONS 2 7         LB        R5,CCHRS        CHECK FOR NONE ..... 7 ;         BNZ       CASS.TP1        ..... AND BRANCH IF SOME ; *  4CASS.TP6 LW        R6,RRS.SIZE     SIZE OF RRS ENTRY 4 +         STB       R6,RR.SIZE,R3   INTO RRS + *  .         BU        CASSG.7         COMMON EXIT . *                                    @  7* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN 7 &* CC1 IS SET IF IF OPTION IS DETECTED. & )* THE RRS WILL HAVE BEEN UPDATED ALREADY. ) ,* NO RETURN IS MADE IF AN ERROR IS DETECTED. , *  ECASS.TP1 BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED ..... E 5         BS        CASS.TP2        ..... BRANCH IF SO 5 7         BL        CAS.OPT2        SEE IF SLO/SBO ..... 7 5         BS        CASS.TP2        ..... BRANCH IF SO 5 >         BU        ERRETURN        ELSE ILLEGAL OPTION - ERROR > 
         PAGE 
 *  * ASSIGNMENT TO DEVICE  *  CASS.DEV EQU       $  ;         LI        R4,RR.3.SIZ     MAKE SURE THERE IS ..... ; >         BL        STRING          GET DEVICE ASSIGNMENT ..... >                                               @  8         BL        CDEV            ..... AND VALIDATE IT 8 G         BS        ERRETURN        BRANCH IF ERROR             REV20100 G *  !* ALL IS O.K. SO SET UP RRS ENTRY ! *  A         STW       R7,RR.DT3,R3    DEVICE TYPE/CHAN/SUB-CHAN WORD A +         STB       R4,RR.SIZE,R3   RRS SIZE + *  1         LI        R6,RR.DEVC      RRS TYPE ..... 1 1         STB       R6,RR.TYPE,R3   ..... INTO RRS 1 *  * SEE IF ANY OPTIONS  *  :CASSG.10 BL        STRING          GET FIRST OPTION STRING : 7         LB        R5,CCHRS        CHECK FOR NONE ..... 7 ;         BNZ       CASSG.9         ..... AND BRANCH IF SOME ; *  <CASSG.11 LI        R6,RR.3.SIZ     UPDATE RRS POINTERS ..... < +         BU        CASSG.7         AND EXIT + *                 @  8* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN. 8 #* CC1 IS SET IF OPTION IS DETECTED. # )* THE RRS WILL HAVE BEEN UPDATED ALREADY. ) ,* NO RETURN IS MADE IF AN ERROR IS DETECTED. , *  ECASSG.9  BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED ..... E 5         BS        CASSG.10        ..... BRANCH IF SO 5 C         BL        CAS.OPT3        SEE IF DENSITY/MULTIVOL/ID ..... C 5         BS        CASSG.10        ..... BRANCH IF SO 5 A         BU        ERRETURN        ELSE AN ILLEGAL OPTION - ERROR A 
         PAGE 
 *  ;* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7 ; * IS ONE OF THE SET:  *  )*                  SIZE   = DECIMAL VALUE ) *                  SHARED = Y/N  '*                  ACCESS = (R,W,M,U,A) '   @  *                  BLOCKED= Y/N  *  >* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY > * AND CC1 IS SET ON EXIT.  *  0* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT. 0 *  ;* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN ; 0* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER. 0 *  ,CAS.OPT1 ZBR       R0,1            CLEAR CC1 , /         STF       R0,COPT90       SAVE CONTEXT / ;         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER ;          CI        R4,G'='  B         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT B *  <         CAMW      R6,=C'SIZE'     SEE IF SIZE SPECIFICATION < 7         BNE       CAS.1.0         BRANCH IF NOT 'SIZE' 7 *  +         BL        STRING          GET SIZE +     @  4         SVC       1,X'28'         CONVERT TO BINARY 4 :         TRR       R6,R6           NON DECIMAL CHARACTERS? : 6         BZ        ERRETURN        YES, ILLEGAL FORMAT 6 1         LB        R6,RR.TYPE,R3   CHECK RRS TYPE 1 6         CI        R6,RR.TEMP      IS THIS A TEMP FILE 6 5         BNE       ERRETURN        NO, ILLEGAL OPTION 5 6         STH       R7,RR.PLEN,R3   ELSE, SAVE THE SIZE 6 .         BU        CAS.1.3         COMMON EXIT . CAS.1.0  EQU       $  7         CAMW      R6,=C'SHAR'     SEE IF SHARED OPTION 7 9         BNE       CAS.1.1         BRANCH IF NOT 'SHARED' 9 *  1         BL        STRING          GET 'Y' OR 'N' 1 8         LB        R5,CCHRS        CHECK FOR BLANK FIELD 8                                                  @  A         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR A :         LB        R4,CCENT        GET FIRST CHAR OF FIELD : +         CI        R4,G'Y'         'YES' ?? + 4         BNE       CAS.1.2         BRANCH IF NOT 'Y' 4 @         SBM       RR.SHAR,RR.ACCS,R3      SET SHARED BIT IN RRS @ .         BU        CAS.1.3         COMMON EXIT . *  *CAS.1.2  CI        R4,G'N'         'NO' ?? * D         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR D C         SBM       RR.EXCL,RR.ACCS,R3      SET EXCLUSIVE BIT IN RRS C .         BU        CAS.1.3         COMMON EXIT . *  * CHECK FOR 'BLOCKED' OPTION  *  8CAS.1.1  CAMW      R6,=C'BLOC'     SEE IF BLOCKED OPTION 8 :         BNE       CAS.1.4         BRANCH IF NOT 'BLOCKED' :    @  *  1         BL        STRING          GET 'Y' OR 'N' 1 8         LB        R5,CCHRS        CHECK FOR BLANK FIELD 8 A         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR A :         LB        R4,CCENT        GET FIRST CHAR OF FIELD : +         CI        R4,G'Y'         'YES' ?? + 4         BNE       CAS.1.5         BRANCH IF NOT 'Y' 4 A         SBM       RR.BLK,RR.OPTS,R3       SET BLOCKED BIT IN RRS A .         BU        CAS.1.3         COMMON EXIT . *  *CAS.1.5  CI        R4,G'N'         'NO' ?? * D         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR D C         SBM       RR.UNBLK,RR.OPTS,R3     SET UNBLOCKED BIT IN RRS C .         BU        CAS.1.3         COMMON EXIT . *  * CHECK FOR ACCESS OPTION  *           @  CAS.1.4  CAMW      R6,=C'ACCE'  =         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT = *  *         BL        STRING          GET '(' * 9         LB        R5,CCHRS        SHOULD BE A ZERO COUNT 9 E         BNZ       ERRETURN        BRANCH IF FIELD NOT EMPTY TO ERROR E :         LB        R4,CCDLIM       CHECK FOR DELIMITER '(' :          CI        R4,G'('  =         BNE       ERRETURN        BRANCH IF NOT '(' TO ERROR = *  9CAS.1.10 BL        STRING          GET NEXT ACCESS OPTION 9 4         LB        R5,CCHRS        CHECK IF LAST ONE 4 @         BNZ       CAS.1.7         BRANCH IF A FIELD TO LOOK FOR @ >         LB        R4,CCDLIM       MAKE SURE DELIMITER WAS ')' >          CI        R4,G')'                                      @  =         BNZ       ERRETURN        BRANCH TO ERROR IF NOT ')' = .         BU        CAS.1.3         COMMON EXIT . *  ;CAS.1.7  ZR        R1              SCAN ACCESS OPTION TABLE ; =         LI        R2,-CASSNK2     NUMBER OF ENTRIES IN TABLE = ;         LB        R6,CCENT        GET FIRST CHAR OF OPTION ; 4CAS.1.8  CAMB      R6,CASSKEY2,R1  CHECK FOR A MATCH 4 4         BEQ       CAS.1.9         BRANCH IF A MATCH 4 6         ABR       R1,31           NEXT ENTRY IN TABLE 6 *         BIB       R2,CAS.1.8      ANDLOOP * 3         BU        ERRETURN        OPTION NOT LEGAL 3 *  -CAS.1.9  SLL       R1,2            WORD INDEX - A         EXM       CASSACT2,R1     SET THE APPROPRIATE BIT IN RRS A                                                           @  =         LB        R4,CCDLIM       IF DELIMETER WAS ')' ..... = (         CI        R4,G')'         ..... ( B         BEQ       CAS.1.3         ..... THE EXIT, OPTION FINISHED B <         BU        CAS.1.10        ..... LOOP FOR NEXT FIELD < *  (* COMMON EXIT TO CALLER WHEN ALL IS O.K. ( *  *CAS.1.3  SBM       1,COPT90        SET CC1 * *  ** COMMON EXIT WHEN KEYWORD NOT RECOGNIZED. * *  CAS.1.6  LF        R0,COPT90           TRSW      R0  
         PAGE 
 *  ;* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7 ; * IS ONE OF THE SET:  *  *                  PRINT  *                  PUNCH  *  >* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY > * AND CC1 IS SET ON EXIT.  *                                  @  0* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT. 0 *  ;* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN ; 0* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER. 0 *  ,CAS.OPT2 ZBR       R0,1            CLEAR CC1 , /         STF       R0,COPT90       SAVE CONTEXT / )         CAMW      R6,=C'PRIN'     SLO ?? ) 4         BNE       CAS.2.1         BRANCH IF NOT SLO 4 :         SBM       RR.SLO,RR.OPTS,R3    SET SLO BIT IN RRS : H         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111 H .         BU        CAS.1.3         COMMON EXIT . *  )CAS.2.1  CAMW      R6,=C'PUNC'     SBO ?? ) >         BNE       CAS.1.6         KEYWORD NOT RECOGNIZED EXIT > :         SBM       RR.SBO,RR.OPTS,R3    SET SBO BIT IN RRS :                     @  H         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111 H .         BU        CAS.1.3         COMMON EXIT . 
         PAGE 
 *  ;* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7 ; * IS ONE OF THE SET:  *  0*                  DENSITY = N/P/G/800/1600/6250 0 #*                  MULTIV  = NUMBER # *                  ID      = ID  *  >* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY > * AND CC1 IS SET ON EXIT.  *  0* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT. 0 *  ;* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN ; 0* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER. 0 *  ,CAS.OPT3 ZBR       R0,1            CLEAR CC1 , /         STF       R0,COPT90       SAVE CONTEXT /                 @  ;         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER ;          CI        R4,G'='  B         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT B *  * CHECK FOR 'DENSITY' OPTION  *  8         CAMW      R6,=C'DENS'     SEE IF DENSITY OPTION 8 :         BNE       CAS.3.1         BRANCH IF NOT 'DENSITY' : *  4         BL        STRING          GET DENSITY VALUE 4 8         LB        R5,CCHRS        CHECK FOR BLANK FIELD 8 ;         BZ        ERRETURN        BRANCH IF BLANK TO ERROR ; *  <         ZR        R1              SCAN DENSITY OPTION TABLE < =         LI        R2,-CASSNK3     NUMBER OF ENTRIES IN TABLE = 4CAS.3.3  CAMW      R6,CASSKEY3,R1  CHECK FOR A MATCH 4 4         BEQ       CAS.3.4         BRANCH IF A MATCH 4       @  6         ABR       R1,29           NEXT ENTRY IN TABLE 6 +         BIB       R2,CAS.3.3      AND LOOP + 3         BU        ERRETURN        OPTION NOT LEGAL 3 *  2CAS.3.4  SRL       R1,2            FORM BYTE INDEX 2 B         LB        R7,CASSACT3,R1  GET DENSITY BIT VALUE AND ..... B 7         STB       R7,RR.DENS,R3   ..... STORE INTO RRS 7 .         BU        CAS.1.3         COMMON EXIT . *  * CHECK FOR 'MULTIVOL' OPTION  *  9CAS.3.1  CAMW      R6,=C'MULT'     SEE IF MULTIVOL OPTION 9 ;         BNE       CAS.3.2         BRANCH IF NOT 'MULTIVOL' ; *  4         BL        STRING          GET VOLUME NUMBER 4 5         LB        R5,CCHRS        CHECK FOR NO FIELD 5 8         BZ        ERRETURN        BRANCH IF BLANK FIELD 8                     @  >         SVC       1,X'28'         CONVERT ASCII DEC TO BINARY > 2         TRR       R6,R6           CHECK FOR ERROR 2 =         BEQ       ERRETURN        BRANCH IF CONVERSION ERROR = >         CI        R7,255          MAKE SURE IT FITS IN A BYTE > 6         BGT       ERRETURN        BRANCH IF TOO LARGE 6 +         STB       R7,RR.VLNUM,R3  INTO RRS + .         BU        CAS.1.3         COMMON EXIT . *  * CHECK FOR 'ID' OPTION  *  3CAS.3.2  CAMW      R6,=C'ID  '     SEE IF ID OPTION 3 =         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT = *  )         BL        STRING          GET ID ) A         LB        R5,CCHRS        MAKE SURE BETWEEN 1 AND 4 CHAR A 7         BZ        ERRETURN        BRANC IF BLANK FIELD 7                       @           CI        R5,4  5         BGT       ERRETURN        BRANCH IF >4 CHARS 5 4         STW       R6,RR.UNFID,R3  ID INTO RRS ENTRY 4 .         BU        CAS.1.3         COMMON EXIT . *  '* COMMON EXIT FOR END OF ASSIGN COMMAND ' *  +CASSG.7  LF        R0,CAS.REGS     GET REGS + )         TRSW      R0              RETURN ) *  /* TABLE FOR RECOGNIZING PRIMARY ASSIGN KEYWORDS / *  CASSKEY1 DATAD     C'LFC     '           DATAD     C'DEV     '           DATAD     C'TEMP    '           DATAD     C'RID     '  4CASSNK1  EQU       $-CASSKEY1/1D   NUMBER OF ENTRIES 4 *  /* TABLE OF ACTION ROUTINES FOR PRIMARY KEYWORDS / *  CASSACT1 EQU       $  '         ACH       CASS.LFC        LFC= ' '         ACH       CASS.DEV        DEV= '     @  (         ACH       CASS.TMP        TEMP= ( '         ACH       CASS.RID        RID= ' *  .* TABLE FOR RECOGNIZING ACCESS RIGHTS KEYBYTES . *  ?CASSKEY2 DATAB     C'RWMUA'        READ/WRITE/MOD/UPDATE/APPEND ? 4CASSNK2  EQU       $-CASSKEY2      NUMBER OF ENTRIES 4          BOUND     1W  %CASSACT2 SBM       RR.READ,RR.ACCS,R3 % &         SBM       RR.WRITE,RR.ACCS,R3 & &         SBM       RR.MODFY,RR.ACCS,R3 & &         SBM       RR.UPDAT,RR.ACCS,R3 & &         SBM       RR.APPND,RR.ACCS,R3 & *  (* TABLE FOR RECOGNIZING DENSITY KEYWORDS ( *  &CASSKEY3 DATAW     C'N   '         800 & '         DATAW     C'P   '         1600 ' '         DATAW     C'G   '         6250 ' &         DATAW     C'800 '         800 &                                    @  '         DATAW     C'1600'         1600 ' '         DATAW     C'6250'         6250 ' 4CASSNK3  EQU       $-CASSKEY3/1W   NUMBER OF ENTRIES 4 &CASSACT3 DATAB     X'80'           800 & '         DATAB     X'40'           1600 ' '         DATAB     X'02'           6250 ' &         DATAB     X'80'           800 & '         DATAB     X'40'           1600 ' '         DATAB     X'02'           6250 '          BOUND     1W  *  
         PAGE 
 H************************************************************************ H H*                                                                      * H H*                  CDEV                                                * H H*                                                                      * H               @  H************************************************************************ H H*                                                                      * H H*        PRODUCE A DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD                * H H*        FROM AN INPUT DEVICE MNEMONIC (DEVMNC)                        * H H*                                                                      * H H*        INPUT:    R6/R7 = DEVMNC GIVEN BY USER                        * H H*                                                                      * H H*        OUTPUT:   R2 = ADDRESS OF DTT ENTRY FOR DEVICE                * H H*                  R7 = DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD           * H H*                                                                      * H    @  H*        ERRORS:   RETURN TO USER WITH CC1 SET AND R5 = CCERR          * H H*                  MESSAGE ID FOR THE FOLLOWING ERRORS:                * H H*                                                              (R5)    * H H*                  (1) INPUT DEVMNC IS NOT 2/4/6 CHARS LONG    (29)    * H H*                  (2) DEVICE IS NOT IN DTT TABLE              (06)    * H H*                  (3) NON HEX CHANNEL/SUB-CHANNEL SPECIFIED   (29)    * H H*                  (4) DEVICE NOT CONFIGURED IN SYSTEM         (28)    * H H*                                                                      * H H*        A RETURN IS NOT MADE TO THE CALLER IF ERROR DETECTED          * H H*                                                                      * H    @  H************************************************************************ H CDEV     STF       R0,CDEV90  H         ZBM       1,CDEV90        CLEAR CC1 (ERROR RETURN FLAG)REV20100 H 8         ZMW       CDEV91          TO BUILD OUTPUT R7 IN 8 *  G*  COUNT THE CHARACTERS IN THE DEVICE MNEMONIC                 REV20100 G *  G         STD       R6,CDEV.WRK     SAVE MNEMONIC               REV20100 G G         LI        R5,-8           LOOP COUNTER                REV20100 G G         LA        R3,CDEV.WRK+7B  SCAN FROM END OF MNEMONIC   REV20100 G G         LI        R4,G' '         SCAN FOR FIRST NON-BLANK    REV20100 G GCDEV.05  CAMB      R4,0B,R3        BLANK?                      REV20100 G                                                            @  G         BNE       CDEV.06         NO.  EXIT.                  REV20100 G G         SUI       R3,1B           BACK TO PREVIOUS CHARACTER  REV20100 G G         BIB       R5,CDEV.05      CHECK IT.                   REV20100 G *  GCDEV.06  TRN       R5,R5           R5 HOLDS NON BLANK COUNT    REV20100 G G         STB       R5,CDEV.CNT     SAVE LOCALLY                REV20100 G G         LD        R6,CDEV.WRK     RESTORE MNEMONIC TO REGS    REV20100 G          CI        R5,2           BEQ       CDEV.0           CI        R5,4           BEQ       CDEV.0           CI        R5,6  G         BEQ       CDEV.0                                      REV20100 G G         LI        R5,29           INVALID DEVICE SPECIFIED    REV20100 G                    @  G         BU        CDEV.ERR        TAKE ERROR EXIT             REV20100 G *  * PROCESS DEVICE MNEMONIC FIRST  *  CDEV.0   TRR       R6,R4  B         SRL       R4,16           DEVICE MNEMONIC IN BOTTOM OF R4 B 7         LW        R2,C.DTTA       DEVICE TABLE ADDRESS 7 9         LNB       R5,C.DTTN       TOTAL ENTRIES IN TABLE 9 4CDEV.1   CAMH      R4,3H,R2        LOOK FOR MNEMONIC 4 2         BEQ       CDEV.2          BRANCH IF FOUND 2 ?         ABR       R2,28           MOVE TO NEXT ENTRY (2 WORDS) ? 6         BIB       R5,CDEV.1       LOOP FOR NEXT ENTRY 6 ;         LI        R5,6            ERROR - INVALID MNEMONIC ; G         BU        CDEV.ERR        TAKE ERROR RETURN.          REV20100 G *                                                 @  4* MNEMONIC FOUND, PROCESS CHANNEL/SUB-CHANNEL IF ANY 4 *  ACDEV.2   STW       R2,CDEV90+2W    RETURN ENTRY ADDRESS TO CALLER A =         LB        R5,0B,R2        GET DEVICE TYPE FROM TABLE = 3         STB       R5,CDEV91       INTO RESULT WORD 3 A         LB        R5,CDEV.CNT     SEE IF ANY CHANNEL/SUB-CHANNEL A          CI        R5,2  =         BEQ       CDEV.3          BRANCH IF NO CHAN/SUB-CHAN = ;         SBM       0,CDEV91        INDICATE CHANNEL PRESENT ; *  >         SLLD      R6,16           CHANNEL/SUB-CHANNEL INTO R6 > 3         ADI       R7,G'  '        ALL SPACES IN R7 3 ?         SVC       1,X'29'         CONVERT CHAN/SUB-CHAN TO HEX ? 9         TRR       R6,R6           CHECK FOR NON HEX DATA 9                                    @  G         BNZ       CDEV.25         BRANCH IF CONVERSION OK.    REV20100 G G         LI        R5,29           INVALID DEVICE SPECIFIED.   REV20100 G G         BU        CDEV.ERR        TAKE ERROR RETURN           REV20100 G *  :* SET UP THE LOW HALFWORD OF RESULT TO CONTAIN THE CHANNEL : ,* NUMBER AND THE SUB-CHANNEL NUMBER, IF ANY. , A* THE TOP BIT OF THE CHANNEL NUMBER FIELD IS SET IF A SUB-CHANNEL A 	* EXISTS. 	 *  8CDEV.25  LB        R5,CDEV.CNT     CHECK FOR SUB-CHANNEL 8          CI        R5,6  9         BNE       CDEV.4          BRANCH IF CHANNEL ONLY 9 >         SBR       R7,16           SET SUB-CHANNEL PRESENT BIT > .         BU        CDEV.5          COMMON EXIT .                                                                         @  FCDEV.4   SLL       R7,8            CHANNEL NUMBER TO TOP BYTE OF ..... F 1*                                  ..... HALFWORD 1 2CDEV.5   STH       R7,CDEV91+1H    STORE IN RESULT 2 *  G*  VERIFY DEVICE CONFIGURED ON SYSTEM                          REV20091 G *  GCDEV.3   ZR        R4              CLEAR COMPARE MASK REGISTER REV20100 G *  =*  IF DEVICE TYPE CODE IS A GENERIC (DC, MT, CD) THEN COMPARE = +*  MASK WILL BE BUILT TO IGNORE DTC IN UDT. + *  G         LB        R7,CDEV91       CHECK THE DTC FOR GENERIC   REV20100 G G         ZBR       R7,24           REMOVE CHAN FLAG IF PRESENT REV20100 G G         CI        R7,X'01'        DC?                         REV20100 G                                                                            @  G         BEQ       CDEV.302        YES.  MASK = 0              REV20100 G G         CI        R7,X'04'        MT?                         REV20100 G G         BEQ       CDEV.302        YES.                        REV20100 G G         CI        R7,X'07'        CD?                         REV20100 G G         BEQ       CDEV.302        YES.                        REV20100 G G         LW        R4,=X'007F0000' SET MASK TO CHECK DTC       REV20100 G *  8*  MASK IS NOW SET FOR DTC.  PROCEED WITH CHAN AND SUBCH 8 *  GCDEV.302 TBM       0,CDEV91        CHANNEL SPECIFIED?          REV20100 G G         BNS       CDEV.31         NO.  CHECK DTC ONLY.        REV20100 G G         ADI       R4,X'7F00'      ADD MASK FOR CHANNEL        REV20100 G                   @  G         TBM       16,CDEV91       SUB CHAN SPECIFIED?         REV20091 G G         BNS       CDEV.31         NO.  VERIFY CHAN ONLY       REV20091 G G         ADI       R4,X'00FF'      ADD MASK FOR SUBCHANNEL     REV20100 G *  G*  LOOP THRU UDT'S FOR SPECIFIED DEVICE                        REV20091 G *  GCDEV.31  LW        R1,C.UDTA       START OF UDT'S              REV20091 G G         LNH       R5,C.UDTN       NEG NUMBER OF UDT'S         REV20091 G G         LB        R7,CDEV91       DTC TO R7                   REV20100 G G         SLL       R7,16           TO BYTE 1 FOR UDT COMPARE   REV20100 G G         ORMH      R7,CDEV91+1H    OR IN CHANNEL AND SUBCH     REV20100 G *                                                                           @  GCDEV.32  CMMW      R7,UDT.STAT,X1  DEVICE MATCH?               REV20091 G G         BEQ       CDEV.33         YES.                        REV20091 G G         ADI       R1,UDT.SIZE     BUMP X1 TO NEXT UDT         REV20091 G G         BIB       R5,CDEV.32      AND COMPARE IF MORE         REV20091 G *  G         LI        R5,28           DEVICE NOT CONFIGURED       REV20091 G *  **  CDEV.ERR - TAKE ERROR RETURN TO CALLER. * G*  SET CC1, RETURN WITH R5 = CCERR MESSAGE INDEX               REV20100 G *  GCDEV.ERR SBM       1,CDEV90        SET CC1 BIT IN R0           REV20100 G G         STW       R5,CDEV90+5W    SAVE R5 FOR LOAD FILE       REV20100 G *  CDEV.33  LF        R0,CDEV90                                                                   @  A         LW        R7,CDEV91       RETURN TYPE/CHAN/SUB-CHAN WORD A          TRSW      R0  
         PAGE 
 H************************************************************************ H H*                                                                      * H H*        STRING  - SYNTAX SCANNER FOR CATALOGER COMPATABILITY          * H H*                                                                      * H H************************************************************************ H *  STRING   EQU       $  ,         STF       R0,SAVER0       SAVE GPRS , 2         LW        AP,APSAVE       GET ARG POINTER 2 2         LD        R6,BLANKS       GET SOME BLANKS 2 3         STD       R6,CCENT        CLEAR TOKEN AREA 3                                 @           STD       R6,CCENT+1D  6         LI        R7,16B          TOKEN BUFFER LENGTH 6 7         LW        R1,0W,AP        GET LINE BUFFER ADDR 7 ?         LA        R6,CCENT        PICK UP TOKEN BUFFER ADDRESS ? :SCANNER  TRR       R1,R0           SAVE LINEBUFFER ADDRESS : H         LI        R4,CR           DUMMY TERMINATOR FOR E.O.B   24OCT80A H 6         ZR        R5              STRING COUNTER FLAG 6 6         TRR       R1,R2           SET UP BUFFER INDEX 6 -         BZ        STR.3           DO NOTHING - ;         ZBM       31,BLNKS        CLEAR BLANKS ACTIVE FLAG ; 8         TRR       R6,R3           SET UP OUTPUT ADDRESS 8 .         ZBR       R3,12           CLEAR F BIT . .         LW        R6,CHARPOS      GET CHARPOS .                    @  :         BNE       STRING0         INITIALIZED, SKIP AHEAD : :         ZMW       CHARPOS         INITIALIZE CHAR POINTER : HSTRING0  LI        R6,-2047        GET NEGATIVE LENGTH OF LBUF  01JAN81A H C         ADMW      R6,CHARPOS      COMPUTE NEG REMAINING BYTE COUNT C +         BGE       STRING4         DONE ... + 6         ADMW      R2,CHARPOS      ADD CURSOR POSITION 6 STRING1  LI        R1,0  <         LB        R4,0B,R2        GET BYTE FROM LINE BUFFER < /         BZ        STRING4         IF EOL, DONE / -         CI        R4,X'61'        SEE IF L/C - ,         BLT       STRING1A        BR IF NOT , -         CI        R4,X'7A'        SEE IF L/C - ,         BGT       STRING1A        BR IF NOT , +         SUI       R4,X'20'        MAKE U/C +     @  STRING1A EQU       $  =         CAMB      R4,DELIMS,R1    CHECK AGAINST KNOWN DELIMS = %         BNE       STRING1B        OK % 3         SLL       R1,2            WORD ALIGN INDEX 3 3         BU        *ACTIONS,R1     DISPATCH ROUTINE 3 STRING1B EQU       $           ADI       R1,1  )         CI        R1,DELIM#       AT END ) *         BLT       STRING1A        NOT YET * <STRING1C CAR       R7,R5           AMASSED ENTIRE STRING YET < &         BGE       NEXTCHAR        YES & 6         STB       R4,0B,R3        MOVE TO WORK BUFFER 6 C         SBM       31,BLNKS        SET BLANKS NO LONGER ACTIVE FLAG C <         ABR       R2,31           INPUT STRING BYTE ADDRESS < =         ABR       R3,31           OUTPUT STRING BYTE ADDRESS =                  @  ;         ABR       R5,31           BUMP THIS STRING COUNTER ; 3NEXTCHAR BIB       R6,STRING1      SCAN TILL E.O.B. 3 STRING2  EQU       $  @         TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER @ 6         ADI       R2,1B           BUMP PAST DELIMITER 6 4         SUR       R1,R2           DISTANCE TRAVELED 4 9STR.2    STW       R2,CHARPOS      AND SAVE AS CURSOR NOW 9 >STR.3    STB       R4,CCDLIM       REMEMBER CURRENT DELIMITTER > 6         STB       R5,CCHRS        REMEMBER FIELD SIZE 6 <         LD        R6,CCENT        GET FIRST 8 CHAR OF TOKEN < 1         LD        R0,SAVER0       RESTORE R0, R1 1 1         LD        R2,SAVER0+1D    RESTORE R2, R3 1 )         LW        R4,SAVER0+2D    POP R4 )                                        @  )         TRSW      R0              RETURN ) *  *  *        SKIP LEADING BLANKS  *  STRING3  EQU       $  H         TBM       31,BLNKS        ARE WE TRAVELING ACROSS LEAD BLANKS ? H ;         BS        STRING2         NOPE-> THATS A DELIMITER ; 8         ADI       R2,1B           YES--> BUMP OVER THEM 8 8         BIB       R6,STRING1      KEEP SCANNING TIL EOB 8 .         BU        STRING2         DONE AT EOB . *  @STRING4  TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER @ D         LI        R2,2047         FORCE END OF MEDIUM FOR NEXT CALL D 5         BU        STR.2           TAKE NORMAL RETURN 5 *  STRING6  EQU       $  =         TRR       R0,R1           RESTORE LINEBUFFER ADDRESS =                                           @  >         LB        R1,CHARPOS      GET INITIAL CURSOR POSITION > :         CI        R1,5W           IS THIS THE FIRST FIELD : @         BEQ       STRING5         IF SO, TREAT LIKE DOLLAR SIGN @ =         BU        STRING4         ELSE, TREAT AS END OF LINE = *  ;STRING5  CI        R5,0            FIRST CHARACTER IN FIELD ; %         BNZ       STRING1C        NO % 6         STB       R4,0B,R3        SAVE THIS CHARACTER 6 ;         ABR       R5,31           BUMP CHARACTERS IN FIELD ; .         BU        STRING2         COMMON EXIT . 
         PAGE 
 *  )BLANKS   DATAD     C'        '     BLANKS ) *  *        DELIMITER WIDGETS  *           BOUND     1W  DELIMS   EQU       $  2         DATAB     X'20'           00 - BLANK CHAR 2             @  3         DATAB     C','            02 - COMMAN CHAR 3 7         DATAB     CR              04 - CARRAIGE RETURN 7 2         DATAB     C'='            03 - EQUAL SIGN 2 0         DATAB     NEWLINE         05 - NEW LINE 0 2         DATAB     C'('            06 - LEFT PAREN 2 3         DATAB     C')'            07 - RIGHT PAREN 3 2         DATAB     C'";'           08 - SEMI-COLON 2 9         DATAB     C'!'            09 - EXCLAMATION POINT 9 /         DATAB     C'"%'           10 - PERCENT / 3         DATAB     C'$'            11 - DOLLAR SIGN 3 1DELIM#   EQU       $-DELIMS        COUNT IN TABLE 1          BOUND     1W  *  -*        ROUTINES TO HANDLER ABOVE DELIMITERS - *  ACTIONS  EQU       $  .         ACH       STRING3         00 - BLANKS .   @  .         ACH       STRING2         02 - COMMAS . 8         ACH       STRING4         04 - CARRAIGE RETURNS 8 3         ACH       STRING2         03 - EQUAL SIGNS 3 1         ACH       STRING2         05 - NEW LINES 1 2         ACH       STRING2         06 - LEFT PAREN 2 3         ACH       STRING2         07 - RIGHT PAREN 3 2         ACH       STRING2         08 - SEMI-COLON 2 9         ACH       STRING6         09 - EXCLAMATION POINT 9 /         ACH       STRING2         10 - PERCENT / 3         ACH       STRING5         11 - DOLLAR SIGN 3 H************************************************************************ H          END                                                                                                                            @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @   *        ERRORS:   RETURN TO USER WITH CC1 SET AND R5 = CCERR          * H H*                  MESSAGE ID FOR THE FOLLOWING ERRORS:                * H H*                                                              (R5)    * H H*                  (1) INPUT DEVMNC IS NOT 2/4/6 CHARS LONG    (29)    * H H*                  (2) DEVICE IS NOT IN DTT TABLE              (06)    * H H*                  (3) NON HEX CHANNEL/SUB-CHANNEL SPECIFIED   (29)    * H H*                  (4) DEVICE NOT CONFIGURED IN SYSTEM         (28)    * H H*                                                                      * H H*        A RETURN IS NOT MADE TO THE CALLER IF ERROR DETECTED          * H H*                                                                      * H  