  @  /*~!flsbuf.c*/  */* Name:  flsbuf.c Part No.: _______-____r *  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:flsbuf.c	1.1"                @  #include <stdio.h>  #include "stdiom.h"  #include <sys/errno.h>     #undef _cleanup     extern void free();  -extern int errno, write(), close(), isatty(); - extern char *malloc();  extern FILE *_lastbuf;     &/* extern unsigned char *_stdbuf[]; */ & (extern unsigned char _sibuf[], _sobuf[]; (    'extern unsigned char _smbuf[][_SBFSIZ]; '    /*   * Flush buffers on exit   */     void  
_cleanup() 
 {  	register FILE *iop;     '	for(iop = _iob; iop < _lastbuf; iop++) ' 		(void) fclose(iop);  }  /*  9	fclose() will flush (output) buffers for a buffered open 9 8	FILE and then issue a system close on the _fileno.  The 8 8	_base field will be reset to NULL for any but stdin and 8                                  @  9	stdout, the _ptr field will be set the same as the _base 9 5	field. The _flags and the _cnt field will be zeroed. 5 :	If buffers had been obtained via malloc(), the space will : 9	be free()'d.  In case the FILE was not open, or fflush() 9 :	or close() failed, an EOF will be returned, otherwise the : 	return value is 0.   */     int  fclose(iop)  register FILE *iop;  {  	register int rtn=EOF;     	if(iop == NULL)  		return(rtn);  .	if(iop->_flag & (_IOREAD | _IOWRT | _IORW)) { . .		rtn = (iop->_flag & _IONBF)? 0: fflush(iop); . 		if(close(fileno(iop)) < 0) {  
			rtn = EOF; 
 			errno = ENOENT;  		}  	}  	if(iop->_flag & _IOMYBUF) {  		free((char*)iop->_base);  		iop->_base = NULL;  	}  	iop->_flag = 0;          @  	iop->_cnt = 0;  	iop->_ptr = iop->_base;  
	return(rtn); 
 }     /*  3	The fflush() routine must take care because of the 3 5	possibility for recursion. The calling program might 5 5	do IO in an interupt catching routine that is likely 5 -	to interupt the write() call within fflush() -  */     int  fflush(iop)  register FILE *iop;  {  	if (!(iop->_flag & _IOWRT)) {  		iop->_cnt = 0;  		return(0);  	}  9	while(!(iop->_flag & _IONBF) && (iop->_flag & _IOWRT) && 9 5			(iop->_base != NULL) && (iop->_ptr > iop->_base) ) 5 		(void) _xflsbuf(iop);  	return(ferror(iop) ? EOF : 0);  }     K/* The routine _flsbuf may or may not actually flush the output buffer.  If K                                                           @  H * the file is line-buffered, the fact that iop->_cnt has run below zero H K * is meaningless: it is always kept below zero so that invocations of putc K L * will consistently give control to _flsbuf, even if the buffer is far from L M * full.  _flsbuf, on seeing the "line-buffered" flag, determines whether the M N * buffer is actually full by comparing iop->_ptr to the end-of-buffer pointer N J * _bufend(iop).  If it is full, or if an output line is completed (with a J M * newline), the buffer is flushed.  (Note: the character argument to _flsbuf M J * is not flushed with the current buffer if the buffer is actually full-- J + * it goes into the buffer after flushing.) +  */     int  _flsbuf(c, iop)  unsigned char c;                         @  register FILE *iop;  {      unsigned char c1;         do {  9	/* check for linebuffered with write perm, but no EOF */ 9 H	if ( (iop->_flag & (_IOLBF | _IOWRT | _IOEOF)) == (_IOLBF | _IOWRT) ) { H 9		if ( iop->_ptr >= _bufend(iop) )  /* if buffer full, */ 9 2			break;		    /* exit do-while, and flush buf. */ 2 #		if ( (*iop->_ptr++ = c) != '\n' ) # 
			return(c); 
 )		return(_xflsbuf(iop) == EOF ? EOF : c); ) 	}  C	/* write out an unbuffered file, if have write perm, but no EOF */ C H	if ( (iop->_flag & (_IONBF | _IOWRT | _IOEOF)) == (_IONBF | _IOWRT) ) { H 			c1 = c; 	 		iop->_cnt = 0;  /		if (write(fileno(iop), (char *) &c1, 1) == 1) / 
			return(c); 
 		iop->_flag |= _IOERR;  		return(EOF);  	}                                     @  H	/* The _wrtchk call is here rather than at the top of _flsbuf to re- */ H G	/* duce overhead for line-buffered I/O under normal circumstances.  */ G    1	if (_WRTCHK(iop))			/* is writing legitimate? */ 1 		return(EOF);  1    } while ( (iop->_flag & (_IONBF | _IOLBF)) ); 1       <    (void) _xflsbuf(iop);   /* full buffer:  flush buffer */ < H    (void) putc((char) c, iop);  /* then put "c" in newly emptied buf */ H 6			/* (which, because of signals, may NOT be empty) */ 6 #    return( ferror(iop) ? EOF : c); # }     F/* The function _xflsbuf writes out the current contents of the output F 0 * buffer delimited by iop->_base and iop->_ptr. 0 G * iop->_cnt is reset appropriately, but its value on entry to _xflsbuf G  * is ignored.   *   @  F * The following code is not strictly correct.  If a signal is raised, F H * invoking a signal-handler which generates output into the same buffer H E * being flushed, a peculiar output sequence may result (for example, E D * the output generated by the signal-handler may appear twice).  At D H * present no means has been found to guarantee correct behavior without H K * resorting to the disabling of signals, a means considered too expensive. K D * For now the code has been written with the intent of reducing the D G * probability of strange effects and, when they do occur, of confining G G * the damage.  Except under extremely pathological circumstances, this G H * code should be expected to respect buffer boundaries even in the face H                @  # * of interrupts and other signals. #  */     int  
_xflsbuf(iop) 
 register FILE *iop;  {  	register unsigned char *base;  	register int n;     %	n = iop->_ptr - (base = iop->_base); % 	iop->_ptr = base;  @	iop->_cnt = (iop->_flag &(_IONBF | _IOLBF)) ? 0 : _bufsiz(iop); @ 	_BUFSYNC(iop);  B	if (n > 0 && n != write(fileno(iop),(char*)base,(unsigned)n) )  { B 		iop->_flag |= _IOERR;  		return(EOF);  	}  	return(0);  }     G/* The function _wrtchk checks to see whether it is legitimate to write G K * to the specified device.  If it is, _wrtchk sets flags in iop->_flag for K K * writing, assures presence of a buffer, and returns 0.  If writing is not K  * legitimate, EOF is returned.   */     int  _wrtchk(iop)    @  register FILE *iop;  {  4	if ( (iop->_flag & (_IOWRT | _IOEOF)) != _IOWRT ) { 4 '		if (!(iop->_flag & (_IOWRT | _IORW))) ' 1			return(EOF);  /* bogus call--read-only file */ 1 =		iop->_flag = iop->_flag & ~_IOEOF | _IOWRT; /* fix flags */ = 	}  G	if (iop->_base == NULL)    /* this is first I/O to file--get buffer */ G 		_findbuf(iop);  F	if (iop->_ptr == iop->_base && !(iop->_flag & (_IONBF | _IOLBF)) )  { F A		iop->_cnt = _bufsiz(iop); /* first write since seek--set cnt */ A 		_BUFSYNC(iop);  	}  	return(0);  }     /*  M * _findbuf, called only when iop->_base == NULL, locates a predefined buffer M L * or allocates a buffer using malloc.  If a buffer is obtained from malloc, L * * the _IOMYBUF flag is set in iop->_flag. *  */     @     
_findbuf(iop) 
 register FILE *iop;  {  2	register int fno = fileno(iop); /* file number */ 2    @	/* allocate a small block for unbuffered, large for buffered */ @ 	if (iop->_flag & _IONBF)  {  6		_bufend(iop) = (iop->_base = _smbuf[fno]) + _SBFSIZ; 6 	}  else  {  9		if (fno < 2)  /* use existing bufs for stdin, stdout */ 9 G			_bufend(iop) = (iop->_base = (fno == 0 ? _sibuf : _sobuf)) + BUFSIZ; G 		else  B		if ((iop->_base = (unsigned char *) malloc(BUFSIZ+8)) != NULL) { B 			/* if  we got a buffer */  			iop->_flag |= _IOMYBUF;  &			_bufend(iop) = iop->_base + BUFSIZ; & 		} else  0			/* if no room for buffer, use small buffer */ 0 7			_bufend(iop) = (iop->_base = _smbuf[fno]) + _SBFSIZ; 7 	}  	iop->_ptr = iop->_base;      @  -	if ( isatty(fno) && !(iop->_flag & _IONBF) ) - 		iop->_flag |= _IOLBF;  }     G/* The function _bufsync is called because interrupts and other signals G L * which occur in between the decrementing of iop->_cnt and the incrementing L L * of iop->_ptr, or in other contexts as well, may upset the synchronization L G * of iop->_cnt and iop->ptr.  If this happens, calling _bufsync should G J * resynchronize the two quantities (this is not always possible).  Resyn- J F * chronization guarantees that putc invocations will not write beyond F F * the end of the buffer.  Note that signals during _bufsync can cause F C * _bufsync to do the wrong thing, but usually with benign effects. C  */     
_bufsync(iop) 
 register FILE *iop;  {                @  	register int spaceleft;     0	if ((spaceleft = _bufend(iop) - iop->_ptr) < 0) 0 		iop->_ptr = _bufend(iop);   	else if (spaceleft < iop->_cnt)   		iop->_cnt = spaceleft;  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                