  @  /*~!exec.c*/  (/* Name:  exec.c Part No.: _______-____r (  *  - * Copyright 1990 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:exec.c	1.0"                     @   #include <mosde.h>				/* !MOD */   #include <psb.h>  #include <errno.h>  #include <string.h>  #include <limits.h>  #ifndef NULL  #define NULL 0  #endif     ;extern  char** environ;  /* current environment pointers */ ; /extern int curwdir[];	/* defined in mpxini.c */ /    /*  5 * this routine simulates the fork/exec pair of UNIX. 5 : * up to 768 bytes of parameters/environment can be passed :  * to the receiving task.   *  C * the buffer is layed out as a series of strings, null terminated. C A * the end of the args is represented by two null chars in a row. A C * the environment is likewise a series of null terminated strings. C = * the end of the environment is signified by two null bytes. =                                    @  F * if three null bytes are at the end of the arguments, no environment F  * is present.   *   * arg0 [null]   * arg1 [null]   * .   * argn [null]  	 * [null] 	 , * env0 [null]  or [null] if no environment. ,  * env1 [null]   * .   * envn [null]  	 * [null] 	  *   */     %int   vexecl (path, arg0, arg1, argn) % 0char *path;   /* pathname of task to activate */ 0 *char *arg0;   /* 1st of n args in stack */ * *char *arg1;   /* 2nd of n args in stack */ * =char *argn;   /* this must be null to indicate end of args */ = {  +  /* pass address of parameters in stack */ + :  return (vexecv (path, &arg0));   /* activate the task */ : }     #ifdef MPX1X						/* MAC */  4asm(" bound 1d");	/* must be dw bounded */	/* MAC */ 4       @  Istatic struct psb psb;   /* this must be double word bounded */ /* MAC */ I 3static char buf[768];  /* send buffer */		/* MAC */ 3 #endif							/* MAC */     0/* activate the task, returns following codes */ 0 !/*  0 - task ran to completion */ ! /*  1 - task aborted */  7/* -1 - activation error, errno contains error value */ 7    int   vexecv (path, args)  0char *path;   /* pathname of task to activate */ 0 Jchar **args;  /* array of char pointer of args to pass. NULL terminated */ J {  #ifndef MPX1X						/* MAC */  C  struct psb psb;   /* this must be double word bounded *//* MAC */ C /  char buf[768];  /* send buffer */			/* MAC */ / #endif  
  int reg[8]; 
   char filename [PATH_MAX];  $  char *p;        /* temp pointer */ $     @  3  char *np;       /* filename pointer */	/* !MOD */ 3 0  char *pp;       /* temp pointer */		/* !MOD */ 0   char *arg;  /* current arg */  ,  char **ep;  /* temp environment pointer */ ,   int numbytes;    int i;					/* !MOD */     $  errno = 0;  /* clear error code */ $    if (path == 0 || *path == 0) {   4    errno = ENOENT;   /* set file not found error */ 4 .    return (-1);      /* error return value */ .   }  ;  strcpy (filename, path);  /* copy file to local buffer */ ; 9  unix2mpx(filename);       /* convert to u/c mpx name */ 9    
  p = buf; 
 #ifdef MPX1X  -  /* we must set the current username here */ - -  getcwvd();		/* get current username info */ - /  pp = (char *)curwdir;	/* point to username */ /                          @  6  for (i=0; i<8; i++)*p++ = pp[i];	/* copy username */ 6 #endif     if (args == 0 || *args == 0) {   .    /* copy program name as first parameter */ . '    if (arg = strrchr(filename, ')')) { ' )      /* arg points to ')' in pathname */ )       arg++;        while (*p++ = *arg++);      } else {        arg = filename;        while (*p++ = *arg++);      }    }       numbytes = strlen(buf);       /* now copy args to buffer */    for (; arg = *args++; ) {        numbytes += strlen(arg);        if (numbytes >= 768) {          errno = ENOEXEC;          return (-1);        }        while (*p++ = *arg++);    }  7  *p++ = NULL;  /* mark end of args with double null */ 7      if (++numbytes >= 768) {                   @      errno = ENOEXEC;      return (-1);    }     )  /* copy environment to buffer if any */ ) -  ep = environ;;    /* current environment */ - )  if (ep == 0 || *ep == 0 || **ep == 0) { )     /* no environment */  3    *p++ = (char )NULL;    /* end of environment */ 3 
  } else { 
 $    /* copy environment to buffer */ $     for (; arg = *ep++; ) {        numbytes += strlen(arg);        if (numbytes >= 768) {          errno = ENOEXEC;          return (-1);        }        while (*p++ = *arg++);      }  ,    *p++ = NULL;    /* end of environment */ ,   }       if (++numbytes > 768) {      errno = ENOEXEC;      return (-1);    }     L  reg[2] = (int)&psb.lmn;  /* parameter send block addr in reg 2 for call */ L      @  *  reg[6] = 0;         /* clear for call */ * *  reg[7] = 0;         /* clear for call */ * #ifdef MPX1X  ,  psb.lmn = 0x20202020;		/* set to blanks */ , ,  psb.pnv = 0x20202020;		/* set to blanks */ , $  if (np = strrchr(filename, ')')) { $ &    /* np points to ')' in pathname */ & 	    np++; 	 
  } else { 
     np = filename;    }  ;  pp = (char *)&psb.lmn;	/* point to where filename goes */ ; @  for (i=0; i<8 && np[i]; i++)pp[i] = np[i];	/* copy filename */ @ #else  ,  psb.lmn = 0;  /* run req will be by pnv */ , .  psb.pnv = (int)filename;  /* set filename */ . 6  psb.pnv |= (strlen(filename) << 24);  /* make pnv */ 6 #endif  #  psb.pri = 0;    /* no priority */ # -  psb.squa = p - buf;   /* number of bytes */ -                            @  )  psb.sba = (int*)buf;  /* send buffer */ ) 5  psb.rpbl = sizeof (buf); /* ret param buf length */ 5 2  psb.acrp = 0;         /* nothing returned yet */ 2 6  psb.rba = (int*)buf;  /* send is also receive buf */ 6 0  psb.eaa = 0;          /* no end action addr */ 0 @  psb.cst = psb.ist = psb.ust = psb.opt = 0; /* no status yet */ @    4  mpxsvc (0x106d, reg, reg);  /* m.srunr svc call */ 4 6                              /* r6 & r7 has status */ 6 2  if (reg[6]) {     /* we have an initial error */ 2     switch (reg[6]) {  
      case 2: 
 
      case 9: 
         errno = ENOENT;          break;  
      case 4: 
         errno = ENOEXEC;          break;  
      case 5: 
       case 15:          errno = EAGAIN;          break;           @  
      case 6: 
 
      case 7: 
       case 10:        case 11:        case 12:        case 13:        case 16:        default:          errno = EFAULT;          break;  
      case 8: 
       case 14:          errno = ENOMEM;          break;        }  1      return (-1);  /* return error indication */ 1 ?  } else {          /* good run request, see if task aborted */ ? *    if (psb.cst)    /* we have an abort */ *       return(1);      return (0);     /* aok */    }  }     1/* following are dummy unix system call entries * 1 )/* they will return an error if called */ )    'int execl(path, arg0, arg1, argn, zero) '  char *path, *arg0, *arg1, *argn;   int zero;	/* just a 0 */  {                                    @  $	errno = EFAULT;	/* show bad path */ $ 	return(-1);	/* error return */  }     int execv(path, argv)  char *path, **argv;  {  $	errno = EFAULT;	/* show bad path */ $ 	return(-1);	/* error return */  }     .int execle(path, arg0, arg1, argn, zero, envp) . (char *path, *arg0, *arg1, *argn, **envp; ( int zero;	/* just a 0 */  {  $	errno = EFAULT;	/* show bad path */ $ 	return(-1);	/* error return */  }     int execve(path, argv, envp)  char *path, **argv, **envp;  {  $	errno = EFAULT;	/* show bad path */ $ 	return(-1);	/* error return */  }     (int execlp(file, arg0, arg1, argn, zero) (  char *file, *arg0, *arg1, *argn;   int zero;	/* just a 0 */  {  $	errno = EFAULT;	/* show bad path */ $                        @  	return(-1);	/* error return */  }     int execvp(file, argv)  char *file, **argv;  {  $	errno = EFAULT;	/* show bad path */ $ 	return(-1);	/* error return */  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      